/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.cryptomanager.controller;

import io.mosip.kernel.core.http.RequestWrapper;
import io.mosip.kernel.core.http.ResponseFilter;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.mosip.kernel.cryptomanager.dto.Argon2GenerateHashRequestDto;
import io.mosip.kernel.cryptomanager.dto.Argon2GenerateHashResponseDto;
import io.mosip.kernel.cryptomanager.dto.CryptoWithPinRequestDto;
import io.mosip.kernel.cryptomanager.dto.CryptoWithPinResponseDto;
import io.mosip.kernel.cryptomanager.dto.CryptomanagerRequestDto;
import io.mosip.kernel.cryptomanager.dto.CryptomanagerResponseDto;
import io.mosip.kernel.cryptomanager.dto.JWTCipherResponseDto;
import io.mosip.kernel.cryptomanager.dto.JWTDecryptRequestDto;
import io.mosip.kernel.cryptomanager.dto.JWTEncryptRequestDto;
import io.mosip.kernel.cryptomanager.service.CryptomanagerService;
import io.swagger.annotations.ApiParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
@Tag(name="cryptomanager", description="Operation related to Encryption and Decryption")
public class CryptomanagerController {
    @Autowired
    private CryptomanagerService cryptomanagerService;

    @Operation(summary="Encrypt the data", description="Encrypt the data", tags={"cryptomanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    @PreAuthorize(value="hasAnyRole(@cryptoManagerAuthRoles.getPostencrypt())")
    @ResponseFilter
    @PostMapping(value={"/encrypt"}, produces={"application/json"})
    public ResponseWrapper<CryptomanagerResponseDto> encrypt(@ApiParam(value="Salt and Data to encrypt in BASE64 encoding with meta-data") @RequestBody @Valid RequestWrapper<CryptomanagerRequestDto> cryptomanagerRequestDto) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.cryptomanagerService.encrypt((CryptomanagerRequestDto)cryptomanagerRequestDto.getRequest()));
        return response;
    }

    @Operation(summary="Decrypt the data", description="Decrypt the data", tags={"cryptomanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    @ResponseFilter
    @PreAuthorize(value="hasAnyRole(@cryptoManagerAuthRoles.getPostdecrypt())")
    @PostMapping(value={"/decrypt"}, produces={"application/json"})
    public ResponseWrapper<CryptomanagerResponseDto> decrypt(@ApiParam(value="Salt and Data to decrypt in BASE64 encoding with meta-data") @RequestBody @Valid RequestWrapper<CryptomanagerRequestDto> cryptomanagerRequestDto) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.cryptomanagerService.decrypt((CryptomanagerRequestDto)cryptomanagerRequestDto.getRequest()));
        return response;
    }

    @Operation(summary="Encrypt the data with pin", description="Encrypt the data with pin", tags={"cryptomanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    @ResponseFilter
    @PreAuthorize(value="hasAnyRole(@cryptoManagerAuthRoles.getPostencryptwithpin())")
    @PostMapping(value={"/encryptWithPin"}, produces={"application/json"})
    public ResponseWrapper<CryptoWithPinResponseDto> encryptWithPin(@ApiParam(value="Pin and Data to encrypt") @RequestBody @Valid RequestWrapper<CryptoWithPinRequestDto> requestDto) {
        ResponseWrapper responseDto = new ResponseWrapper();
        responseDto.setResponse((Object)this.cryptomanagerService.encryptWithPin((CryptoWithPinRequestDto)requestDto.getRequest()));
        return responseDto;
    }

    @Operation(summary="Decrypt the data with pin", description="Decrypt the data with pin", tags={"cryptomanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    @ResponseFilter
    @PreAuthorize(value="hasAnyRole(@cryptoManagerAuthRoles.getPostdecryptwithpin())")
    @PostMapping(value={"/decryptWithPin"}, produces={"application/json"})
    public ResponseWrapper<CryptoWithPinResponseDto> decryptWithPin(@ApiParam(value="Pin and Data to decrypt") @RequestBody @Valid RequestWrapper<CryptoWithPinRequestDto> requestDto) {
        ResponseWrapper responseDto = new ResponseWrapper();
        responseDto.setResponse((Object)this.cryptomanagerService.decryptWithPin((CryptoWithPinRequestDto)requestDto.getRequest()));
        return responseDto;
    }

    @Operation(summary="JWE Data Encryption", description="Performs JSON Web Encrypt for the given data", tags={"cryptomanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    @PreAuthorize(value="hasAnyRole(@cryptoManagerAuthRoles.getPostjwtencrypt())")
    @ResponseFilter
    @PostMapping(value={"/jwtEncrypt"}, produces={"application/json"})
    public ResponseWrapper<JWTCipherResponseDto> jwtEncrypt(@ApiParam(value="Data to encrypt in BASE64 encoding with meta-data") @RequestBody @Valid RequestWrapper<JWTEncryptRequestDto> jwtCipherRequestDto) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.cryptomanagerService.jwtEncrypt((JWTEncryptRequestDto)jwtCipherRequestDto.getRequest()));
        return response;
    }

    @Operation(summary="JWE Data Decryption", description="Performs JSON Web Decrypt for the given encrypted data", tags={"cryptomanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    @ResponseFilter
    @PreAuthorize(value="hasAnyRole(@cryptoManagerAuthRoles.getPostjwtdecrypt())")
    @PostMapping(value={"/jwtDecrypt"}, produces={"application/json"})
    public ResponseWrapper<JWTCipherResponseDto> jwtDecrypt(@ApiParam(value="Data to decrypt in BASE64 encoding with meta-data") @RequestBody @Valid RequestWrapper<JWTDecryptRequestDto> jwtCipherRequestDto) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.cryptomanagerService.jwtDecrypt((JWTDecryptRequestDto)jwtCipherRequestDto.getRequest()));
        return response;
    }

    @Operation(summary="Argon2 hash generation", description="Performs Hash generation using Argon2 algorithm", tags={"cryptomanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    @PreAuthorize(value="hasAnyRole(@cryptoManagerAuthRoles.getPostgenerateargon2hash())")
    @ResponseFilter
    @PostMapping(value={"/generateArgon2Hash"}, produces={"application/json"})
    public ResponseWrapper<Argon2GenerateHashResponseDto> generateArgon2Hash(@ApiParam(value="Data to generate Argon2 ") @RequestBody @Valid RequestWrapper<Argon2GenerateHashRequestDto> argon2GenHashRequestDto) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.cryptomanagerService.generateArgon2Hash((Argon2GenerateHashRequestDto)argon2GenHashRequestDto.getRequest()));
        return response;
    }
}

