/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.clientcrypto.service.impl;

import io.mosip.kernel.clientcrypto.constant.ClientCryptoErrorConstants;
import io.mosip.kernel.clientcrypto.constant.ClientType;
import io.mosip.kernel.clientcrypto.exception.ClientCryptoException;
import io.mosip.kernel.clientcrypto.service.impl.AndroidClientCryptoServiceImpl;
import io.mosip.kernel.clientcrypto.service.impl.LocalClientCryptoServiceImpl;
import io.mosip.kernel.clientcrypto.service.impl.TPMClientCryptoServiceImpl;
import io.mosip.kernel.clientcrypto.service.spi.ClientCryptoService;
import io.mosip.kernel.core.crypto.spi.CryptoCoreSpec;
import io.mosip.kernel.core.exception.ExceptionUtils;
import io.mosip.kernel.core.logger.spi.Logger;
import io.mosip.kernel.keymanagerservice.logger.KeymanagerLogger;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Objects;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import tss.tpm.TPMT_PUBLIC;

@Component
public class ClientCryptoFacade {
    private static final Logger LOGGER = KeymanagerLogger.getLogger(ClientCryptoFacade.class);
    private static SecureRandom secureRandom = null;
    private static ClientCryptoService clientCryptoService = null;
    @Autowired
    private CryptoCoreSpec<byte[], byte[], SecretKey, PublicKey, PrivateKey, String> cryptoCore;
    @Autowired
    private Environment environment;
    @Autowired
    private ApplicationContext applicationContext;
    @Value(value="${mosip.kernel.client.crypto.use-resident-service-module-key:false}")
    private Boolean useResidentServiceModuleKey;
    @Value(value="${mosip.kernel.client.crypto.resident-service-app-id:RESIDENT}")
    private String residentServiceAppId;
    @Value(value="${mosip.kernel.client.crypto.iv-length:12}")
    private int ivLength;
    @Value(value="${mosip.kernel.client.crypto.aad-length:32}")
    private int aadLength;
    @Value(value="${mosip.kernel.client.crypto.sym-key-length:256}")
    private int symmetricKeyLength;

    @Deprecated
    public static void setIsTPMRequired(boolean flag) {
    }

    private void initializeClientSecurity() {
        LOGGER.debug("ccSessionID", "INITIALIZATION", "", "initializeClientSecurity >>> started");
        try {
            clientCryptoService = new TPMClientCryptoServiceImpl();
        }
        catch (Throwable e) {
            LOGGER.debug("ccSessionID", "INITIALIZATION", "", ExceptionUtils.getStackTrace((Throwable)e));
        }
        if (clientCryptoService == null) {
            try {
                LOGGER.warn("ccSessionID", "INITIALIZATION", "", "USING LOCAL CLIENT SECURITY INITIALIZED, IGNORE IF THIS IS NON-PROD ENV");
                clientCryptoService = new LocalClientCryptoServiceImpl(this.cryptoCore, this.applicationContext, this.useResidentServiceModuleKey, this.residentServiceAppId);
            }
            catch (Throwable ex) {
                LOGGER.error("ccSessionID", "INITIALIZATION", "", ExceptionUtils.getStackTrace((Throwable)ex));
            }
        }
        if (clientCryptoService == null) {
            LOGGER.error("ccSessionID", "INITIALIZATION", "", "Failed to get client security instance.");
            throw new ClientCryptoException(ClientCryptoErrorConstants.INITIALIZATION_ERROR.getErrorCode(), ClientCryptoErrorConstants.INITIALIZATION_ERROR.getErrorMessage());
        }
        LOGGER.debug("ccSessionID", "INITIALIZATION", "", "initializeClientSecurity >>> Completed");
    }

    public ClientCryptoService getClientSecurity() {
        if (clientCryptoService == null) {
            this.initializeClientSecurity();
        }
        return clientCryptoService;
    }

    public boolean validateSignature(byte[] publicKey, byte[] signature, byte[] actualData) {
        return this.validateSignature(ClientType.LOCAL, publicKey, signature, actualData);
    }

    public byte[] encrypt(byte[] publicKey, byte[] dataToEncrypt) {
        return this.encrypt(ClientType.LOCAL, publicKey, dataToEncrypt);
    }

    public boolean validateSignature(ClientType clientType, byte[] publicKey, byte[] signature, byte[] actualData) {
        ClientType clientType2 = clientType = this.isTPMKey(publicKey) ? ClientType.TPM : clientType;
        switch (clientType == null ? ClientType.LOCAL : clientType) {
            case TPM: {
                return TPMClientCryptoServiceImpl.validateSignature(publicKey, signature, actualData);
            }
            case ANDROID: {
                return AndroidClientCryptoServiceImpl.validateSignature(publicKey, signature, actualData);
            }
        }
        LOGGER.warn("USING LOCAL CLIENT SECURITY USED TO SIGN DATA, IGNORE IF THIS IS NON-PROD ENV");
        return LocalClientCryptoServiceImpl.validateSignature(publicKey, signature, actualData);
    }

    public byte[] encrypt(ClientType clientType, byte[] publicKey, byte[] dataToEncrypt) {
        clientType = this.isTPMKey(publicKey) ? ClientType.TPM : clientType;
        SecretKey secretKey = ClientCryptoFacade.getSecretKey();
        byte[] iv = ClientCryptoFacade.generateRandomBytes(this.ivLength);
        byte[] aad = ClientCryptoFacade.generateRandomBytes(this.aadLength);
        byte[] cipher = (byte[])this.cryptoCore.symmetricEncrypt((Object)secretKey, (Object)dataToEncrypt, (Object)iv, (Object)aad);
        byte[] encryptedSecretKey = null;
        switch (clientType == null ? ClientType.LOCAL : clientType) {
            case TPM: {
                encryptedSecretKey = TPMClientCryptoServiceImpl.asymmetricEncrypt(publicKey, secretKey.getEncoded());
                break;
            }
            case ANDROID: {
                encryptedSecretKey = AndroidClientCryptoServiceImpl.asymmetricEncrypt(publicKey, secretKey.getEncoded());
                break;
            }
            default: {
                LOGGER.warn("USING LOCAL CLIENT SECURITY USED TO ENCRYPT DATA, IGNORE IF THIS IS NON-PROD ENV");
                LocalClientCryptoServiceImpl.cryptoCore = this.cryptoCore;
                encryptedSecretKey = LocalClientCryptoServiceImpl.asymmetricEncrypt(publicKey, secretKey.getEncoded());
            }
        }
        Objects.requireNonNull(encryptedSecretKey);
        byte[] processedData = new byte[cipher.length + encryptedSecretKey.length + iv.length + aad.length];
        System.arraycopy(encryptedSecretKey, 0, processedData, 0, encryptedSecretKey.length);
        System.arraycopy(iv, 0, processedData, encryptedSecretKey.length, iv.length);
        System.arraycopy(aad, 0, processedData, encryptedSecretKey.length + iv.length, aad.length);
        System.arraycopy(cipher, 0, processedData, encryptedSecretKey.length + iv.length + aad.length, cipher.length);
        return processedData;
    }

    public byte[] decrypt(byte[] dataToDecrypt) {
        byte[] encryptedSecretKey = Arrays.copyOfRange(dataToDecrypt, 0, this.symmetricKeyLength);
        byte[] secretKeyBytes = Objects.requireNonNull(this.getClientSecurity()).asymmetricDecrypt(encryptedSecretKey);
        SecretKeySpec secretKey = new SecretKeySpec(secretKeyBytes, "AES");
        try {
            byte[] iv = Arrays.copyOfRange(dataToDecrypt, this.symmetricKeyLength, this.symmetricKeyLength + this.ivLength);
            byte[] aad = Arrays.copyOfRange(dataToDecrypt, this.symmetricKeyLength + this.ivLength, this.symmetricKeyLength + this.ivLength + this.aadLength);
            byte[] cipher = Arrays.copyOfRange(dataToDecrypt, this.symmetricKeyLength + this.ivLength + this.aadLength, dataToDecrypt.length);
            return (byte[])this.cryptoCore.symmetricDecrypt((Object)secretKey, (Object)cipher, (Object)iv, (Object)aad);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to decrypt the data due to : ", new Object[]{t.getMessage()});
            byte[] iv = Arrays.copyOfRange(dataToDecrypt, this.symmetricKeyLength, this.symmetricKeyLength + 16);
            byte[] aad = Arrays.copyOfRange(dataToDecrypt, this.symmetricKeyLength + 16, this.symmetricKeyLength + 16 + 12);
            byte[] cipher = Arrays.copyOfRange(dataToDecrypt, this.symmetricKeyLength + 16 + 12, dataToDecrypt.length);
            return (byte[])this.cryptoCore.symmetricDecrypt((Object)secretKey, (Object)cipher, (Object)iv, (Object)aad);
        }
    }

    public static byte[] generateRandomBytes(int length) {
        if (secureRandom == null) {
            secureRandom = new SecureRandom();
        }
        byte[] bytes = new byte[length];
        secureRandom.nextBytes(bytes);
        return bytes;
    }

    private static SecretKey getSecretKey() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(256);
            return keyGenerator.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.info("ccSessionID", "Client Security FACADE", "", "Failed to generate secret key " + ExceptionUtils.getStackTrace((Throwable)e));
            throw new ClientCryptoException(ClientCryptoErrorConstants.NOT_ABLE_GENERATE_KEY.getErrorCode(), ClientCryptoErrorConstants.NOT_ABLE_GENERATE_KEY.getErrorMessage());
        }
    }

    private boolean isTPMKey(byte[] publicKey) {
        try {
            TPMT_PUBLIC tpmPublic = TPMT_PUBLIC.fromTpm((byte[])publicKey);
            Objects.requireNonNull(tpmPublic);
            return true;
        }
        catch (Throwable t) {
            LOGGER.debug("*** INVALID TPM KEY **** ", new Object[]{t});
            return false;
        }
    }
}

