/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.tokenidgenerator.controller;

import io.mosip.kernel.core.http.ResponseFilter;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.mosip.kernel.tokenidgenerator.dto.TokenIDResponseDto;
import io.mosip.kernel.tokenidgenerator.service.TokenIDGeneratorService;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TokenIDGeneratorController {
    @Autowired
    private TokenIDGeneratorService tokenIDGeneratorService;

    @ResponseFilter
    @GetMapping(value={"/{uin}/{partnercode}"})
    @PreAuthorize(value="hasAnyRole('ZONAL_ADMIN','GLOBAL_ADMIN','ID_AUTHENTICATION','RESIDENT')")
    public ResponseWrapper<TokenIDResponseDto> generateTokenID(@ApiParam(value="uin of user") @PathVariable(value="uin") String uin, @ApiParam(value="Partner Code") @PathVariable(value="partnercode") String partnerCode) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.tokenIDGeneratorService.generateTokenID(uin.trim(), partnerCode.trim()));
        return response;
    }
}

