/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.signature.service.impl;

import io.mosip.kernel.core.crypto.spi.CryptoCoreSpec;
import io.mosip.kernel.core.logger.spi.Logger;
import io.mosip.kernel.core.pdfgenerator.model.Rectangle;
import io.mosip.kernel.core.pdfgenerator.spi.PDFGenerator;
import io.mosip.kernel.core.signatureutil.model.SignatureResponse;
import io.mosip.kernel.core.util.CryptoUtil;
import io.mosip.kernel.core.util.DateUtils;
import io.mosip.kernel.core.util.JsonUtils;
import io.mosip.kernel.core.util.exception.JsonMappingException;
import io.mosip.kernel.core.util.exception.JsonParseException;
import io.mosip.kernel.keymanagerservice.constant.KeymanagerErrorConstant;
import io.mosip.kernel.keymanagerservice.dto.KeyPairGenerateResponseDto;
import io.mosip.kernel.keymanagerservice.dto.PublicKeyResponse;
import io.mosip.kernel.keymanagerservice.dto.SignatureCertificate;
import io.mosip.kernel.keymanagerservice.exception.KeymanagerServiceException;
import io.mosip.kernel.keymanagerservice.logger.KeymanagerLogger;
import io.mosip.kernel.keymanagerservice.service.KeymanagerService;
import io.mosip.kernel.keymanagerservice.util.KeymanagerUtil;
import io.mosip.kernel.partnercertservice.dto.CertificateTrustRequestDto;
import io.mosip.kernel.partnercertservice.dto.CertificateTrustResponeDto;
import io.mosip.kernel.partnercertservice.service.spi.PartnerCertificateManagerService;
import io.mosip.kernel.signature.constant.SignatureErrorCode;
import io.mosip.kernel.signature.dto.JWTSignatureRequestDto;
import io.mosip.kernel.signature.dto.JWTSignatureResponseDto;
import io.mosip.kernel.signature.dto.JWTSignatureVerifyRequestDto;
import io.mosip.kernel.signature.dto.JWTSignatureVerifyResponseDto;
import io.mosip.kernel.signature.dto.PDFSignatureRequestDto;
import io.mosip.kernel.signature.dto.SignRequestDto;
import io.mosip.kernel.signature.dto.SignatureRequestDto;
import io.mosip.kernel.signature.dto.SignatureResponseDto;
import io.mosip.kernel.signature.dto.TimestampRequestDto;
import io.mosip.kernel.signature.dto.ValidatorResponseDto;
import io.mosip.kernel.signature.exception.CertificateNotValidException;
import io.mosip.kernel.signature.exception.PublicKeyParseException;
import io.mosip.kernel.signature.exception.RequestException;
import io.mosip.kernel.signature.exception.SignatureFailureException;
import io.mosip.kernel.signature.service.SignatureService;
import io.mosip.kernel.signature.util.SignatureUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.crypto.SecretKey;
import org.apache.commons.codec.binary.Base64;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwx.CompactSerializer;
import org.jose4j.lang.JoseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SignatureServiceImpl
implements SignatureService {
    private static final Logger LOGGER = KeymanagerLogger.getLogger(SignatureServiceImpl.class);
    @Autowired
    private KeymanagerService keymanagerService;
    @Autowired
    private CryptoCoreSpec<byte[], byte[], SecretKey, PublicKey, PrivateKey, String> cryptoCore;
    @Value(value="${mosip.kernel.keygenerator.asymmetric-algorithm-name}")
    private String asymmetricAlgorithmName;
    @Value(value="${mosip.sign.applicationid:KERNEL}")
    private String signApplicationid;
    @Value(value="${mosip.sign.refid:SIGN}")
    private String signRefid;
    @Value(value="${mosip.kernel.crypto.sign-algorithm-name:RS256}")
    private String signAlgorithm;
    @Autowired
    KeymanagerUtil keymanagerUtil;
    @Autowired
    private PDFGenerator pdfGenerator;
    @Autowired
    PartnerCertificateManagerService partnerCertManagerService;

    @Override
    public SignatureResponse sign(SignRequestDto signRequestDto) {
        SignatureRequestDto signatureRequestDto = new SignatureRequestDto();
        signatureRequestDto.setApplicationId(this.signApplicationid);
        signatureRequestDto.setReferenceId(this.signRefid);
        signatureRequestDto.setData(signRequestDto.getData());
        String timestamp = DateUtils.getUTCCurrentDateTimeString();
        signatureRequestDto.setTimeStamp(timestamp);
        SignatureResponseDto signatureResponseDTO = this.sign(signatureRequestDto);
        return new SignatureResponse(signatureResponseDTO.getData(), DateUtils.convertUTCToLocalDateTime((String)timestamp));
    }

    private SignatureResponseDto sign(SignatureRequestDto signatureRequestDto) {
        SignatureCertificate certificateResponse = this.keymanagerService.getSignatureCertificate(signatureRequestDto.getApplicationId(), Optional.of(signatureRequestDto.getReferenceId()), signatureRequestDto.getTimeStamp());
        this.keymanagerUtil.isCertificateValid(certificateResponse.getCertificateEntry(), DateUtils.parseUTCToDate((String)signatureRequestDto.getTimeStamp()));
        String encryptedSignedData = null;
        if (certificateResponse.getCertificateEntry() != null) {
            encryptedSignedData = (String)this.cryptoCore.sign((Object)signatureRequestDto.getData().getBytes(), (Object)((PrivateKey)certificateResponse.getCertificateEntry().getPrivateKey()));
        }
        return new SignatureResponseDto(encryptedSignedData);
    }

    @Override
    public ValidatorResponseDto validate(TimestampRequestDto timestampRequestDto) {
        boolean status;
        PublicKeyResponse<String> publicKeyResponse = this.keymanagerService.getSignPublicKey(this.signApplicationid, DateUtils.formatToISOString((LocalDateTime)timestampRequestDto.getTimestamp()), Optional.of(this.signRefid));
        try {
            PublicKey publicKey = KeyFactory.getInstance(this.asymmetricAlgorithmName).generatePublic(new X509EncodedKeySpec(CryptoUtil.decodeBase64((String)publicKeyResponse.getPublicKey())));
            status = this.cryptoCore.verifySignature((Object)timestampRequestDto.getData().getBytes(), (Object)timestampRequestDto.getSignature(), (Object)publicKey);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException exception) {
            throw new PublicKeyParseException(SignatureErrorCode.INTERNAL_SERVER_ERROR.getErrorCode(), exception.getMessage(), exception);
        }
        if (status) {
            ValidatorResponseDto response = new ValidatorResponseDto();
            response.setMessage("Validation Successful");
            response.setStatus("success");
            return response;
        }
        throw new SignatureFailureException(SignatureErrorCode.NOT_VALID.getErrorCode(), SignatureErrorCode.NOT_VALID.getErrorMessage(), null);
    }

    @Override
    public SignatureResponseDto signPDF(PDFSignatureRequestDto request) {
        OutputStream outputStream;
        SignatureCertificate signatureCertificate = this.keymanagerService.getSignatureCertificate(request.getApplicationId(), Optional.of(request.getReferenceId()), request.getTimeStamp());
        LOGGER.debug("sessionId", "sessionId", "sessionId", "Signature fetched from hsm " + signatureCertificate);
        Rectangle rectangle = new Rectangle((float)request.getLowerLeftX(), (float)request.getLowerLeftY(), (float)request.getUpperRightX(), (float)request.getUpperRightY());
        try {
            String providerName = signatureCertificate.getProviderName();
            LOGGER.info("sessionId", "sessionId", "sessionId", " Keystore Provider Name found: " + providerName);
            Arrays.stream(Security.getProviders()).forEach(x -> {
                LOGGER.info("sessionId", "sessionId", "sessionId", "provider name " + x.getName());
                LOGGER.info("sessionId", "sessionId", "sessionId", "provider info " + x.getInfo());
            });
            LOGGER.info("sessionId", "sessionId", "sessionId", "all providers ");
            outputStream = this.pdfGenerator.signAndEncryptPDF(CryptoUtil.decodeBase64((String)request.getData()), rectangle, request.getReason(), request.getPageNumber(), Security.getProvider(providerName), signatureCertificate.getCertificateEntry(), request.getPassword());
        }
        catch (IOException | GeneralSecurityException e) {
            throw new KeymanagerServiceException(KeymanagerErrorConstant.INTERNAL_SERVER_ERROR.getErrorCode(), KeymanagerErrorConstant.INTERNAL_SERVER_ERROR.getErrorMessage() + " " + e.getMessage());
        }
        SignatureResponseDto signatureResponseDto = new SignatureResponseDto();
        signatureResponseDto.setData(CryptoUtil.encodeBase64((byte[])((ByteArrayOutputStream)outputStream).toByteArray()));
        return signatureResponseDto;
    }

    @Override
    public JWTSignatureResponseDto jwtSign(JWTSignatureRequestDto jwtSignRequestDto) {
        LOGGER.info("SignatureSessionId", "JWTSignature", "", "JWT Signature Request.");
        String reqDataToSign = jwtSignRequestDto.getDataToSign();
        if (!SignatureUtil.isDataValid(reqDataToSign)) {
            LOGGER.error("SignatureSessionId", "JWTSignature", "", "Provided Data to sign value is invalid.");
            throw new RequestException(SignatureErrorCode.INVALID_INPUT.getErrorCode(), SignatureErrorCode.INVALID_INPUT.getErrorMessage());
        }
        String decodedDataToSign = new String(CryptoUtil.decodeBase64((String)reqDataToSign));
        if (!SignatureUtil.isJsonValid(decodedDataToSign)) {
            LOGGER.error("SignatureSessionId", "JWTSignature", "", "Provided Data to sign value is invalid JSON.");
            throw new RequestException(SignatureErrorCode.INVALID_JSON.getErrorCode(), SignatureErrorCode.INVALID_JSON.getErrorMessage());
        }
        String timestamp = DateUtils.getUTCCurrentDateTimeString();
        String applicationId = jwtSignRequestDto.getApplicationId();
        String referenceId = jwtSignRequestDto.getReferenceId();
        if (!this.keymanagerUtil.isValidApplicationId(applicationId)) {
            applicationId = this.signApplicationid;
            referenceId = this.signRefid;
        }
        boolean includePayload = SignatureUtil.isIncludeAttrsValid(jwtSignRequestDto.getIncludePayload());
        boolean includeCertificate = SignatureUtil.isIncludeAttrsValid(jwtSignRequestDto.getIncludeCertificate());
        boolean includeCertHash = SignatureUtil.isIncludeAttrsValid(jwtSignRequestDto.getIncludeCertHash());
        String certificateUrl = SignatureUtil.isDataValid(jwtSignRequestDto.getCertificateUrl()) ? jwtSignRequestDto.getCertificateUrl() : null;
        SignatureCertificate certificateResponse = this.keymanagerService.getSignatureCertificate(applicationId, Optional.of(referenceId), timestamp);
        this.keymanagerUtil.isCertificateValid(certificateResponse.getCertificateEntry(), DateUtils.parseUTCToDate((String)timestamp));
        String signedData = this.sign(decodedDataToSign, certificateResponse, includePayload, includeCertificate, includeCertHash, certificateUrl);
        JWTSignatureResponseDto responseDto = new JWTSignatureResponseDto();
        responseDto.setJwtSignedData(signedData);
        responseDto.setTimestamp(DateUtils.getUTCCurrentDateTime());
        return responseDto;
    }

    private String sign(String dataToSign, SignatureCertificate certificateResponse, boolean includePayload, boolean includeCertificate, boolean includeCertHash, String certificateUrl) {
        JsonWebSignature jwSign = new JsonWebSignature();
        PrivateKey privateKey = (PrivateKey)certificateResponse.getCertificateEntry().getPrivateKey();
        X509Certificate x509Certificate = ((X509Certificate[])certificateResponse.getCertificateEntry().getChain())[0];
        if (includeCertificate) {
            jwSign.setCertificateChainHeaderValue(new X509Certificate[]{x509Certificate});
        }
        if (includeCertHash) {
            jwSign.setX509CertSha256ThumbprintHeaderValue(x509Certificate);
        }
        if (Objects.nonNull(certificateUrl)) {
            jwSign.setHeader("x5u", certificateUrl);
        }
        jwSign.setPayload(dataToSign);
        jwSign.setAlgorithmHeaderValue(this.signAlgorithm);
        jwSign.setKey((Key)privateKey);
        jwSign.setDoKeyValidation(false);
        try {
            if (includePayload) {
                return jwSign.getCompactSerialization();
            }
            return jwSign.getDetachedContentCompactSerialization();
        }
        catch (JoseException e) {
            LOGGER.error("SignatureSessionId", "JWTSignature", "", "Error occurred while Signing Data.");
            throw new SignatureFailureException(SignatureErrorCode.SIGN_ERROR.getErrorCode(), SignatureErrorCode.SIGN_ERROR.getErrorMessage(), e);
        }
    }

    @Override
    public JWTSignatureVerifyResponseDto jwtVerify(JWTSignatureVerifyRequestDto jwtVerifyRequestDto) {
        String signedData = jwtVerifyRequestDto.getJwtSignatureData();
        if (!SignatureUtil.isDataValid(signedData)) {
            LOGGER.error("SignatureSessionId", "JWTSignature", "", "Provided Signed Data value is invalid.");
            throw new RequestException(SignatureErrorCode.INVALID_INPUT.getErrorCode(), SignatureErrorCode.INVALID_INPUT.getErrorMessage());
        }
        String encodedActualData = SignatureUtil.isDataValid(jwtVerifyRequestDto.getActualData()) ? jwtVerifyRequestDto.getActualData() : null;
        String reqCertData = SignatureUtil.isDataValid(jwtVerifyRequestDto.getCertificateData()) ? jwtVerifyRequestDto.getCertificateData() : null;
        String applicationId = jwtVerifyRequestDto.getApplicationId();
        String referenceId = jwtVerifyRequestDto.getReferenceId();
        if (!this.keymanagerUtil.isValidApplicationId(applicationId)) {
            applicationId = this.signApplicationid;
            referenceId = this.signRefid;
        }
        String[] jwtTokens = signedData.split("\\.", -1);
        boolean signatureValid = false;
        Certificate certToVerify = this.certificateExistsInHeader(jwtTokens[0]);
        if (Objects.nonNull(certToVerify)) {
            signatureValid = this.verifySignature(jwtTokens, encodedActualData, certToVerify);
        } else {
            Certificate reqCertToVerify = this.getCertificateToVerify(reqCertData, applicationId, referenceId);
            signatureValid = this.verifySignature(jwtTokens, encodedActualData, reqCertToVerify);
        }
        JWTSignatureVerifyResponseDto responseDto = new JWTSignatureVerifyResponseDto();
        responseDto.setSignatureValid(signatureValid);
        responseDto.setMessage(signatureValid ? "Validation Successful" : "Validation Failed");
        responseDto.setTrustValid(this.validateTrust(jwtVerifyRequestDto, certToVerify, reqCertData));
        return responseDto;
    }

    private Certificate getCertificateToVerify(String reqCertData, String applicationId, String referenceId) {
        if (reqCertData != null) {
            return this.keymanagerUtil.convertToCertificate(reqCertData);
        }
        KeyPairGenerateResponseDto certificateResponse = this.keymanagerService.getCertificate(applicationId, Optional.of(referenceId));
        return this.keymanagerUtil.convertToCertificate(certificateResponse.getCertificate());
    }

    private Certificate certificateExistsInHeader(String jwtHeader) {
        String jwtTokenHeader = new String(CryptoUtil.decodeBase64((String)jwtHeader));
        Map jwtTokenHeadersMap = null;
        try {
            jwtTokenHeadersMap = JsonUtils.jsonStringToJavaMap((String)jwtTokenHeader);
        }
        catch (io.mosip.kernel.core.exception.IOException | JsonMappingException | JsonParseException e) {
            LOGGER.error("SignatureSessionId", "JWTSignature", "", "Provided Signed Data value is invalid.");
            throw new RequestException(SignatureErrorCode.INVALID_VERIFY_INPUT.getErrorCode(), SignatureErrorCode.INVALID_VERIFY_INPUT.getErrorMessage());
        }
        if (jwtTokenHeadersMap.containsKey("x5c")) {
            LOGGER.info("SignatureSessionId", "JWTSignature", "", "Certificate found in JWT Header.");
            List certList = (List)jwtTokenHeadersMap.get("x5c");
            return this.keymanagerUtil.convertToCertificate(Base64.decodeBase64((String)((String)certList.get(0))));
        }
        LOGGER.info("SignatureSessionId", "JWTSignature", "", "Certificate not found in JWT Header.");
        return null;
    }

    private boolean verifySignature(String[] jwtTokens, String actualData, Certificate certToVerify) {
        JsonWebSignature jws = new JsonWebSignature();
        try {
            boolean validCert = SignatureUtil.isCertificateDatesValid((X509Certificate)certToVerify);
            if (!validCert) {
                LOGGER.error("SignatureSessionId", "JWTSignature", "", "Error certificate dates are not valid.");
                throw new CertificateNotValidException(SignatureErrorCode.CERT_NOT_VALID.getErrorCode(), SignatureErrorCode.CERT_NOT_VALID.getErrorMessage());
            }
            PublicKey publicKey = certToVerify.getPublicKey();
            if (Objects.nonNull(actualData)) {
                jwtTokens[1] = actualData;
            }
            jws.setCompactSerialization(CompactSerializer.serialize((String[])jwtTokens));
            if (Objects.nonNull(publicKey)) {
                jws.setKey((Key)publicKey);
            }
            return jws.verifySignature();
        }
        catch (ArrayIndexOutOfBoundsException | JoseException e) {
            LOGGER.error("SignatureSessionId", "JWTSignature", "", "Provided Signed Data value is invalid.");
            throw new SignatureFailureException(SignatureErrorCode.VERIFY_ERROR.getErrorCode(), SignatureErrorCode.VERIFY_ERROR.getErrorMessage(), e);
        }
    }

    private String validateTrust(JWTSignatureVerifyRequestDto jwtVerifyRequestDto, Certificate headerCertificate, String reqCertData) {
        String trustCertData;
        boolean validateTrust = SignatureUtil.isIncludeAttrsValid(jwtVerifyRequestDto.getValidateTrust());
        if (!validateTrust) {
            return "TRUST_NOT_VERIFIED";
        }
        String domain = jwtVerifyRequestDto.getDomain();
        if (!SignatureUtil.isDataValid(domain)) {
            return "TRUST_NOT_VERIFIED_NO_DOMAIN";
        }
        String certData = null;
        if (Objects.nonNull(headerCertificate)) {
            certData = this.keymanagerUtil.getPEMFormatedData(headerCertificate);
        }
        String string = trustCertData = certData == null ? reqCertData : certData;
        if (trustCertData == null) {
            return "TRUST_NOT_VERIFIED";
        }
        CertificateTrustRequestDto trustRequestDto = new CertificateTrustRequestDto();
        trustRequestDto.setCertificateData(trustCertData);
        trustRequestDto.setPartnerDomain(domain);
        CertificateTrustResponeDto responseDto = this.partnerCertManagerService.verifyCertificateTrust(trustRequestDto);
        if (responseDto.getStatus().booleanValue()) {
            return "TRUST_CERT_PATH_VALID";
        }
        return "TRUST_CERT_PATH_NOT_VALID";
    }
}

