/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.keymigrate.controller;

import io.mosip.kernel.core.http.RequestWrapper;
import io.mosip.kernel.core.http.ResponseFilter;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.mosip.kernel.keymigrate.dto.KeyMigrateBaseKeyRequestDto;
import io.mosip.kernel.keymigrate.dto.KeyMigrateBaseKeyResponseDto;
import io.mosip.kernel.keymigrate.dto.ZKKeyMigrateCertficateResponseDto;
import io.mosip.kernel.keymigrate.dto.ZKKeyMigrateRequestDto;
import io.mosip.kernel.keymigrate.dto.ZKKeyMigrateResponseDto;
import io.mosip.kernel.keymigrate.service.spi.KeyMigratorService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiParam;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Lazy
@CrossOrigin
@RestController
@Api(value="Operation related to Key Migration from one HSM to another HSM.", tags={"keymigrator"})
public class KeyMigratorController {
    @Autowired
    KeyMigratorService keyMigratorService;

    @PreAuthorize(value="hasAnyRole('KEY_MIGRATION_ADMIN')")
    @ResponseFilter
    @PostMapping(value={"/migrateBaseKey"}, produces={"application/json"})
    public ResponseWrapper<KeyMigrateBaseKeyResponseDto> migrateBaseKey(@ApiParam(value="Base Key Migrate Attributes.") @RequestBody @Valid RequestWrapper<KeyMigrateBaseKeyRequestDto> migrateBaseKeyRequestDto) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.keyMigratorService.migrateBaseKey((KeyMigrateBaseKeyRequestDto)migrateBaseKeyRequestDto.getRequest()));
        return response;
    }

    @PreAuthorize(value="hasAnyRole('KEY_MIGRATION_ADMIN')")
    @ResponseFilter
    @GetMapping(value={"/getZKTempCertificate"}, produces={"application/json"})
    public ResponseWrapper<ZKKeyMigrateCertficateResponseDto> getZKTempCertificate() {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.keyMigratorService.getZKTempCertificate());
        return response;
    }

    @PreAuthorize(value="hasAnyRole('KEY_MIGRATION_ADMIN')")
    @ResponseFilter
    @PostMapping(value={"/migrateZKKeys"}, produces={"application/json"})
    public ResponseWrapper<ZKKeyMigrateResponseDto> migrateZKKeys(@ApiParam(value="ZK Keys Migrate Attributes.") @RequestBody @Valid RequestWrapper<ZKKeyMigrateRequestDto> migrateZKKeysRequestDto) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.keyMigratorService.migrateZKKeys((ZKKeyMigrateRequestDto)migrateZKKeysRequestDto.getRequest()));
        return response;
    }
}

