/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.keymanagerservice.exception;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.mosip.kernel.core.crypto.exception.InvalidDataException;
import io.mosip.kernel.core.crypto.exception.InvalidKeyException;
import io.mosip.kernel.core.crypto.exception.NullDataException;
import io.mosip.kernel.core.exception.BaseUncheckedException;
import io.mosip.kernel.core.exception.ExceptionUtils;
import io.mosip.kernel.core.exception.NoSuchAlgorithmException;
import io.mosip.kernel.core.exception.ServiceError;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.mosip.kernel.core.idgenerator.exception.TokenIdGeneratorException;
import io.mosip.kernel.core.keymanager.exception.KeystoreProcessingException;
import io.mosip.kernel.core.signatureutil.exception.ParseResponseException;
import io.mosip.kernel.core.signatureutil.exception.SignatureUtilClientException;
import io.mosip.kernel.core.signatureutil.exception.SignatureUtilException;
import io.mosip.kernel.core.util.EmptyCheckUtils;
import io.mosip.kernel.cryptomanager.constant.CryptomanagerErrorCode;
import io.mosip.kernel.cryptomanager.exception.CryptoManagerSerivceException;
import io.mosip.kernel.keymanagerservice.constant.KeymanagerErrorConstant;
import io.mosip.kernel.keymanagerservice.exception.CryptoException;
import io.mosip.kernel.keymanagerservice.exception.InvalidApplicationIdException;
import io.mosip.kernel.keymanagerservice.exception.KeymanagerServiceException;
import io.mosip.kernel.keymanagerservice.exception.NoUniqueAliasException;
import io.mosip.kernel.lkeymanager.exception.InvalidArgumentsException;
import io.mosip.kernel.lkeymanager.exception.LicenseKeyServiceException;
import io.mosip.kernel.partnercertservice.exception.PartnerCertManagerException;
import io.mosip.kernel.signature.exception.RequestException;
import io.mosip.kernel.signature.exception.SignatureFailureException;
import io.mosip.kernel.zkcryptoservice.exception.ZKCryptoException;
import io.mosip.kernel.zkcryptoservice.exception.ZKKeyDerivationException;
import io.mosip.kernel.zkcryptoservice.exception.ZKRandomKeyDecryptionException;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.util.ContentCachingRequestWrapper;

@RestControllerAdvice
public class KeymanagerExceptionHandler {
    @Autowired
    private ObjectMapper objectMapper;

    @ExceptionHandler(value={NullDataException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> nullDataException(HttpServletRequest httpServletRequest, NullDataException e) throws IOException {
        ExceptionUtils.logRootCause((Throwable)e);
        return new ResponseEntity(this.getErrorResponse(httpServletRequest, e.getErrorCode(), e.getErrorText(), HttpStatus.OK), HttpStatus.OK);
    }

    @ExceptionHandler(value={InvalidKeyException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> invalidKeyException(HttpServletRequest httpServletRequest, InvalidKeyException e) throws IOException {
        ExceptionUtils.logRootCause((Throwable)e);
        return new ResponseEntity(this.getErrorResponse(httpServletRequest, e.getErrorCode(), e.getErrorText(), HttpStatus.OK), HttpStatus.OK);
    }

    @ExceptionHandler(value={NoSuchAlgorithmException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> noSuchAlgorithmException(HttpServletRequest httpServletRequest, NoSuchAlgorithmException e) throws IOException {
        ExceptionUtils.logRootCause((Throwable)e);
        return new ResponseEntity(this.getErrorResponse(httpServletRequest, e.getErrorCode(), e.getErrorText(), HttpStatus.OK), HttpStatus.OK);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> illegalArgumentException(HttpServletRequest httpServletRequest, IllegalArgumentException e) throws IOException {
        return new ResponseEntity(this.getErrorResponse(httpServletRequest, CryptomanagerErrorCode.INVALID_DATA_WITHOUT_KEY_BREAKER.getErrorCode(), CryptomanagerErrorCode.INVALID_DATA_WITHOUT_KEY_BREAKER.getErrorMessage(), HttpStatus.OK), HttpStatus.OK);
    }

    @ExceptionHandler(value={InvalidFormatException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> invalidFormatException(HttpServletRequest httpServletRequest, InvalidFormatException e) throws IOException {
        return new ResponseEntity(this.getErrorResponse(httpServletRequest, KeymanagerErrorConstant.DATE_TIME_PARSE_EXCEPTION.getErrorCode(), e.getMessage() + " " + KeymanagerErrorConstant.DATE_TIME_PARSE_EXCEPTION.getErrorMessage(), HttpStatus.OK), HttpStatus.OK);
    }

    @ExceptionHandler(value={DateTimeParseException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> dateTimeParseException(HttpServletRequest httpServletRequest, DateTimeParseException e) throws IOException {
        return new ResponseEntity(this.getErrorResponse(httpServletRequest, KeymanagerErrorConstant.DATE_TIME_PARSE_EXCEPTION.getErrorCode(), e.getMessage() + " " + KeymanagerErrorConstant.DATE_TIME_PARSE_EXCEPTION.getErrorMessage(), HttpStatus.OK), HttpStatus.OK);
    }

    @ExceptionHandler(value={InvalidDataException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> invalidDataException(HttpServletRequest httpServletRequest, InvalidDataException e) throws IOException {
        ExceptionUtils.logRootCause((Throwable)e);
        return new ResponseEntity(this.getErrorResponse(httpServletRequest, e.getErrorCode(), e.getErrorText(), HttpStatus.OK), HttpStatus.OK);
    }

    @ExceptionHandler(value={NoUniqueAliasException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> noUniqueAliasException(HttpServletRequest httpServletRequest, NoUniqueAliasException e) throws IOException {
        ExceptionUtils.logRootCause((Throwable)((Object)e));
        return new ResponseEntity(this.getErrorResponse(httpServletRequest, e.getErrorCode(), e.getErrorText(), HttpStatus.OK), HttpStatus.OK);
    }

    @ExceptionHandler(value={CryptoException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> cryptoException(HttpServletRequest httpServletRequest, CryptoException e) throws IOException {
        ExceptionUtils.logRootCause((Throwable)((Object)e));
        return new ResponseEntity(this.getErrorResponse(httpServletRequest, e.getErrorCode(), e.getErrorText(), HttpStatus.OK), HttpStatus.OK);
    }

    @ExceptionHandler(value={KeymanagerServiceException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> keymanagerServiceException(HttpServletRequest httpServletRequest, KeymanagerServiceException e) throws IOException {
        ExceptionUtils.logRootCause((Throwable)((Object)e));
        return new ResponseEntity(this.getErrorResponse(httpServletRequest, e.getErrorCode(), e.getErrorText(), HttpStatus.OK), HttpStatus.OK);
    }

    @ExceptionHandler(value={CryptoManagerSerivceException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> cryptoManagerServieException(HttpServletRequest httpServletRequest, CryptoManagerSerivceException e) throws IOException {
        ExceptionUtils.logRootCause((Throwable)((Object)e));
        return new ResponseEntity(this.getErrorResponse(httpServletRequest, e.getErrorCode(), e.getErrorText(), HttpStatus.OK), HttpStatus.OK);
    }

    @ExceptionHandler(value={InvalidApplicationIdException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> invalidApplicationIdException(HttpServletRequest httpServletRequest, InvalidApplicationIdException e) throws IOException {
        ExceptionUtils.logRootCause((Throwable)((Object)e));
        return new ResponseEntity(this.getErrorResponse(httpServletRequest, e.getErrorCode(), e.getErrorText(), HttpStatus.OK), HttpStatus.OK);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> methodArgumentNotValidException(HttpServletRequest httpServletRequest, MethodArgumentNotValidException e) throws IOException {
        ResponseWrapper<ServiceError> errorResponse = this.setErrors(httpServletRequest);
        List fieldErrors = e.getBindingResult().getFieldErrors();
        fieldErrors.forEach(x -> {
            ServiceError error = new ServiceError(KeymanagerErrorConstant.INVALID_REQUEST.getErrorCode(), x.getField() + " " + x.getDefaultMessage());
            errorResponse.getErrors().add(error);
        });
        return new ResponseEntity(errorResponse, HttpStatus.OK);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> onHttpMessageNotReadable(HttpServletRequest httpServletRequest, HttpMessageNotReadableException e) throws IOException {
        ResponseWrapper<ServiceError> errorResponse = this.setErrors(httpServletRequest);
        ServiceError error = new ServiceError(KeymanagerErrorConstant.INVALID_REQUEST.getErrorCode(), e.getMessage());
        errorResponse.getErrors().add(error);
        return new ResponseEntity(errorResponse, HttpStatus.OK);
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> onMissingServletRequestParameterException(HttpServletRequest httpServletRequest, MissingServletRequestParameterException e) throws IOException {
        ResponseWrapper<ServiceError> errorResponse = this.setErrors(httpServletRequest);
        ServiceError error = new ServiceError(KeymanagerErrorConstant.INVALID_REQUEST.getErrorCode(), e.getMessage());
        errorResponse.getErrors().add(error);
        return new ResponseEntity(errorResponse, HttpStatus.OK);
    }

    @ExceptionHandler(value={TokenIdGeneratorException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> emptyLengthException(HttpServletRequest httpServletRequest, TokenIdGeneratorException e) throws IOException {
        ResponseWrapper<ServiceError> responseWrapper = this.setErrors(httpServletRequest);
        ServiceError error = new ServiceError(e.getErrorCode(), e.getErrorText());
        responseWrapper.getErrors().add(error);
        return new ResponseEntity(responseWrapper, HttpStatus.OK);
    }

    @ExceptionHandler(value={ZKCryptoException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> zkCryptoException(HttpServletRequest httpServletRequest, ZKCryptoException e) throws IOException {
        ExceptionUtils.logRootCause((Throwable)((Object)e));
        return new ResponseEntity(this.getErrorResponse(httpServletRequest, e.getErrorCode(), e.getErrorText(), HttpStatus.OK), HttpStatus.OK);
    }

    @ExceptionHandler(value={ZKKeyDerivationException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> zkKeyDerivationException(HttpServletRequest httpServletRequest, ZKKeyDerivationException e) throws IOException {
        ExceptionUtils.logRootCause((Throwable)((Object)e));
        return new ResponseEntity(this.getErrorResponse(httpServletRequest, e.getErrorCode(), e.getErrorText(), HttpStatus.OK), HttpStatus.OK);
    }

    @ExceptionHandler(value={ZKRandomKeyDecryptionException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> zkRandomKeyDecryptionException(HttpServletRequest httpServletRequest, ZKRandomKeyDecryptionException e) throws IOException {
        ExceptionUtils.logRootCause((Throwable)((Object)e));
        return new ResponseEntity(this.getErrorResponse(httpServletRequest, e.getErrorCode(), e.getErrorText(), HttpStatus.OK), HttpStatus.OK);
    }

    @ExceptionHandler(value={PartnerCertManagerException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> partnerCertManagerException(HttpServletRequest httpServletRequest, PartnerCertManagerException e) throws IOException {
        ExceptionUtils.logRootCause((Throwable)((Object)e));
        return new ResponseEntity(this.getErrorResponse(httpServletRequest, e.getErrorCode(), e.getErrorText(), HttpStatus.OK), HttpStatus.OK);
    }

    @ExceptionHandler(value={KeystoreProcessingException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> keystoreProcessingException(HttpServletRequest httpServletRequest, KeystoreProcessingException e) throws IOException {
        ExceptionUtils.logRootCause((Throwable)e);
        return new ResponseEntity(this.getErrorResponse(httpServletRequest, e.getErrorCode(), e.getErrorText(), HttpStatus.OK), HttpStatus.OK);
    }

    @ExceptionHandler(value={InvalidArgumentsException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> validateInputArguments(HttpServletRequest httpServletRequest, InvalidArgumentsException exception) throws IOException {
        ResponseWrapper<ServiceError> errorResponse = this.setErrors(httpServletRequest);
        errorResponse.getErrors().addAll(exception.getList());
        return new ResponseEntity(errorResponse, HttpStatus.OK);
    }

    @ExceptionHandler(value={LicenseKeyServiceException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> handleServiceException(HttpServletRequest httpServletRequest, LicenseKeyServiceException exception) throws IOException {
        ResponseWrapper<ServiceError> errorResponse = this.setErrors(httpServletRequest);
        errorResponse.getErrors().addAll(exception.getList());
        return new ResponseEntity(errorResponse, HttpStatus.OK);
    }

    @ExceptionHandler(value={RequestException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> controlRequestException(HttpServletRequest httpServletRequest, RequestException e) throws IOException {
        ExceptionUtils.logRootCause((Throwable)((Object)e));
        return this.getErrorResponseEntity(e, HttpStatus.OK, httpServletRequest);
    }

    @ExceptionHandler(value={SignatureFailureException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> signatureFailureException(HttpServletRequest httpServletRequest, SignatureFailureException e) throws IOException {
        ExceptionUtils.logRootCause((Throwable)((Object)e));
        return this.getErrorResponseEntity(e, HttpStatus.OK, httpServletRequest);
    }

    @ExceptionHandler(value={SignatureUtilClientException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> signatureUtilClientException(HttpServletRequest httpServletRequest, SignatureUtilClientException e) throws IOException {
        ResponseWrapper<ServiceError> responseWrapper = this.setErrors(httpServletRequest);
        responseWrapper.getErrors().addAll(e.getList());
        ExceptionUtils.logRootCause((Throwable)e);
        return new ResponseEntity(responseWrapper, HttpStatus.OK);
    }

    @ExceptionHandler(value={SignatureUtilException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> signatureUtilException(HttpServletRequest httpServletRequest, SignatureUtilException e) throws IOException {
        ExceptionUtils.logRootCause((Throwable)e);
        return this.getErrorResponseEntity((BaseUncheckedException)e, HttpStatus.OK, httpServletRequest);
    }

    @ExceptionHandler(value={ParseResponseException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> parseResponseException(HttpServletRequest httpServletRequest, ParseResponseException e) throws IOException {
        ExceptionUtils.logRootCause((Throwable)e);
        return this.getErrorResponseEntity((BaseUncheckedException)e, HttpStatus.OK, httpServletRequest);
    }

    @ExceptionHandler(value={Exception.class, RuntimeException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> defaultErrorHandler(HttpServletRequest httpServletRequest, Exception e) throws IOException {
        ResponseWrapper<ServiceError> errorResponse = this.setErrors(httpServletRequest);
        ServiceError error = new ServiceError(KeymanagerErrorConstant.INTERNAL_SERVER_ERROR.getErrorCode(), e.getMessage());
        errorResponse.getErrors().add(error);
        ExceptionUtils.logRootCause((Throwable)e);
        return new ResponseEntity(errorResponse, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    private ResponseWrapper<ServiceError> getErrorResponse(HttpServletRequest httpServletRequest, String errorCode, String errorMessage, HttpStatus httpStatus) throws IOException {
        ResponseWrapper<ServiceError> errorResponse = this.setErrors(httpServletRequest);
        ServiceError error = new ServiceError(errorCode, errorMessage);
        errorResponse.getErrors().add(error);
        return errorResponse;
    }

    private ResponseWrapper<ServiceError> setErrors(HttpServletRequest httpServletRequest) throws IOException {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        responseWrapper.setResponsetime(LocalDateTime.now(ZoneId.of("UTC")));
        String requestBody = null;
        if (httpServletRequest instanceof ContentCachingRequestWrapper) {
            requestBody = new String(((ContentCachingRequestWrapper)httpServletRequest).getContentAsByteArray());
        }
        if (EmptyCheckUtils.isNullEmpty(requestBody)) {
            return responseWrapper;
        }
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        JsonNode reqNode = this.objectMapper.readTree(requestBody);
        responseWrapper.setId(reqNode.path("id").asText());
        responseWrapper.setVersion(reqNode.path("version").asText());
        return responseWrapper;
    }

    private ResponseEntity<ResponseWrapper<ServiceError>> getErrorResponseEntity(BaseUncheckedException e, HttpStatus httpStatus, HttpServletRequest httpServletRequest) throws IOException {
        ResponseWrapper<ServiceError> responseWrapper = this.setErrors(httpServletRequest);
        ServiceError error = new ServiceError(e.getErrorCode(), e.getErrorText());
        responseWrapper.getErrors().add(error);
        return new ResponseEntity(responseWrapper, httpStatus);
    }
}

