/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.keymanagerservice.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDateTime;
import lombok.Generated;

@ApiModel(description="Class representing a KeyPair Generator Response")
public class KeyPairGenerateResponseDto {
    @ApiModelProperty(notes="X509 self-signed certificate", required=false)
    private String certificate;
    @ApiModelProperty(notes="Certificate Signing Request Data", required=false)
    private String certSignRequest;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    @ApiModelProperty(notes="Timestamp of issuance of certificate", required=true)
    private LocalDateTime issuedAt;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    @ApiModelProperty(notes="Timestamp of expiry of certificate", required=true)
    private LocalDateTime expiryAt;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    @ApiModelProperty(notes="Timestamp of public key", required=true)
    private LocalDateTime timestamp;

    @Generated
    public String getCertificate() {
        return this.certificate;
    }

    @Generated
    public String getCertSignRequest() {
        return this.certSignRequest;
    }

    @Generated
    public LocalDateTime getIssuedAt() {
        return this.issuedAt;
    }

    @Generated
    public LocalDateTime getExpiryAt() {
        return this.expiryAt;
    }

    @Generated
    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public void setCertificate(String certificate) {
        this.certificate = certificate;
    }

    @Generated
    public void setCertSignRequest(String certSignRequest) {
        this.certSignRequest = certSignRequest;
    }

    @Generated
    public void setIssuedAt(LocalDateTime issuedAt) {
        this.issuedAt = issuedAt;
    }

    @Generated
    public void setExpiryAt(LocalDateTime expiryAt) {
        this.expiryAt = expiryAt;
    }

    @Generated
    public void setTimestamp(LocalDateTime timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyPairGenerateResponseDto)) {
            return false;
        }
        KeyPairGenerateResponseDto other = (KeyPairGenerateResponseDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$certificate = this.getCertificate();
        String other$certificate = other.getCertificate();
        if (this$certificate == null ? other$certificate != null : !this$certificate.equals(other$certificate)) {
            return false;
        }
        String this$certSignRequest = this.getCertSignRequest();
        String other$certSignRequest = other.getCertSignRequest();
        if (this$certSignRequest == null ? other$certSignRequest != null : !this$certSignRequest.equals(other$certSignRequest)) {
            return false;
        }
        LocalDateTime this$issuedAt = this.getIssuedAt();
        LocalDateTime other$issuedAt = other.getIssuedAt();
        if (this$issuedAt == null ? other$issuedAt != null : !((Object)this$issuedAt).equals(other$issuedAt)) {
            return false;
        }
        LocalDateTime this$expiryAt = this.getExpiryAt();
        LocalDateTime other$expiryAt = other.getExpiryAt();
        if (this$expiryAt == null ? other$expiryAt != null : !((Object)this$expiryAt).equals(other$expiryAt)) {
            return false;
        }
        LocalDateTime this$timestamp = this.getTimestamp();
        LocalDateTime other$timestamp = other.getTimestamp();
        return !(this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KeyPairGenerateResponseDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $certificate = this.getCertificate();
        result = result * 59 + ($certificate == null ? 43 : $certificate.hashCode());
        String $certSignRequest = this.getCertSignRequest();
        result = result * 59 + ($certSignRequest == null ? 43 : $certSignRequest.hashCode());
        LocalDateTime $issuedAt = this.getIssuedAt();
        result = result * 59 + ($issuedAt == null ? 43 : ((Object)$issuedAt).hashCode());
        LocalDateTime $expiryAt = this.getExpiryAt();
        result = result * 59 + ($expiryAt == null ? 43 : ((Object)$expiryAt).hashCode());
        LocalDateTime $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "KeyPairGenerateResponseDto(certificate=" + this.getCertificate() + ", certSignRequest=" + this.getCertSignRequest() + ", issuedAt=" + this.getIssuedAt() + ", expiryAt=" + this.getExpiryAt() + ", timestamp=" + this.getTimestamp() + ")";
    }

    @Generated
    public KeyPairGenerateResponseDto(String certificate, String certSignRequest, LocalDateTime issuedAt, LocalDateTime expiryAt, LocalDateTime timestamp) {
        this.certificate = certificate;
        this.certSignRequest = certSignRequest;
        this.issuedAt = issuedAt;
        this.expiryAt = expiryAt;
        this.timestamp = timestamp;
    }

    @Generated
    public KeyPairGenerateResponseDto() {
    }
}

