/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.cryptomanager.controller;

import io.mosip.kernel.core.http.RequestWrapper;
import io.mosip.kernel.core.http.ResponseFilter;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.mosip.kernel.cryptomanager.dto.CryptoWithPinRequestDto;
import io.mosip.kernel.cryptomanager.dto.CryptoWithPinResponseDto;
import io.mosip.kernel.cryptomanager.dto.CryptomanagerRequestDto;
import io.mosip.kernel.cryptomanager.dto.CryptomanagerResponseDto;
import io.mosip.kernel.cryptomanager.service.CryptomanagerService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiParam;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
@Api(value="Operation related to Encryption and Decryption", tags={"cryptomanager"})
public class CryptomanagerController {
    @Autowired
    private CryptomanagerService cryptomanagerService;

    @PreAuthorize(value="hasAnyRole('ZONAL_ADMIN','GLOBAL_ADMIN','INDIVIDUAL','ID_AUTHENTICATION','TEST', 'REGISTRATION_ADMIN', 'REGISTRATION_SUPERVISOR', 'REGISTRATION_OFFICER', 'REGISTRATION_PROCESSOR','PRE_REGISTRATION_ADMIN','RESIDENT')")
    @ResponseFilter
    @PostMapping(value={"/encrypt"}, produces={"application/json"})
    public ResponseWrapper<CryptomanagerResponseDto> encrypt(@ApiParam(value="Salt and Data to encrypt in BASE64 encoding with meta-data") @RequestBody @Valid RequestWrapper<CryptomanagerRequestDto> cryptomanagerRequestDto) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.cryptomanagerService.encrypt((CryptomanagerRequestDto)cryptomanagerRequestDto.getRequest()));
        return response;
    }

    @PreAuthorize(value="hasAnyRole('ZONAL_ADMIN','GLOBAL_ADMIN','INDIVIDUAL','ID_AUTHENTICATION', 'TEST', 'REGISTRATION_ADMIN', 'REGISTRATION_SUPERVISOR', 'REGISTRATION_OFFICER', 'REGISTRATION_PROCESSOR','PRE_REGISTRATION_ADMIN','RESIDENT')")
    @ResponseFilter
    @PostMapping(value={"/decrypt"}, produces={"application/json"})
    public ResponseWrapper<CryptomanagerResponseDto> decrypt(@ApiParam(value="Salt and Data to decrypt in BASE64 encoding with meta-data") @RequestBody @Valid RequestWrapper<CryptomanagerRequestDto> cryptomanagerRequestDto) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.cryptomanagerService.decrypt((CryptomanagerRequestDto)cryptomanagerRequestDto.getRequest()));
        return response;
    }

    @PreAuthorize(value="hasAnyRole('ZONAL_ADMIN','GLOBAL_ADMIN','INDIVIDUAL','ID_AUTHENTICATION','TEST', 'REGISTRATION_ADMIN', 'REGISTRATION_SUPERVISOR', 'REGISTRATION_OFFICER', 'REGISTRATION_PROCESSOR','PRE_REGISTRATION_ADMIN','RESIDENT')")
    @ResponseFilter
    @PostMapping(value={"/encryptWithPin"}, produces={"application/json"})
    public ResponseWrapper<CryptoWithPinResponseDto> encryptWithPin(@ApiParam(value="Pin and Data to encrypt") @RequestBody @Valid RequestWrapper<CryptoWithPinRequestDto> requestDto) {
        ResponseWrapper responseDto = new ResponseWrapper();
        responseDto.setResponse((Object)this.cryptomanagerService.encryptWithPin((CryptoWithPinRequestDto)requestDto.getRequest()));
        return responseDto;
    }

    @PreAuthorize(value="hasAnyRole('ZONAL_ADMIN','GLOBAL_ADMIN','INDIVIDUAL','ID_AUTHENTICATION', 'TEST', 'REGISTRATION_ADMIN', 'REGISTRATION_SUPERVISOR', 'REGISTRATION_OFFICER', 'REGISTRATION_PROCESSOR','PRE_REGISTRATION_ADMIN','RESIDENT')")
    @ResponseFilter
    @PostMapping(value={"/decryptWithPin"}, produces={"application/json"})
    public ResponseWrapper<CryptoWithPinResponseDto> decryptWithPin(@ApiParam(value="Pin and Data to decrypt") @RequestBody @Valid RequestWrapper<CryptoWithPinRequestDto> requestDto) {
        ResponseWrapper responseDto = new ResponseWrapper();
        responseDto.setResponse((Object)this.cryptomanagerService.decryptWithPin((CryptoWithPinRequestDto)requestDto.getRequest()));
        return responseDto;
    }

    @PreAuthorize(value="hasAnyRole('ZONAL_ADMIN','GLOBAL_ADMIN','INDIVIDUAL','ID_AUTHENTICATION','TEST', 'REGISTRATION_ADMIN', 'REGISTRATION_SUPERVISOR', 'REGISTRATION_OFFICER', 'REGISTRATION_PROCESSOR','PRE_REGISTRATION_ADMIN','RESIDENT')")
    @ResponseFilter
    @PostMapping(value={"/encryptDt"}, produces={"application/json"})
    public ResponseWrapper<CryptomanagerResponseDto> encryptDt(@ApiParam(value="Salt and Data to encrypt in BASE64 encoding with meta-data") @RequestBody @Valid RequestWrapper<CryptomanagerRequestDto> cryptomanagerRequestDto) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.cryptomanagerService.encrypt((CryptomanagerRequestDto)cryptomanagerRequestDto.getRequest()));
        return response;
    }

    @PreAuthorize(value="hasAnyRole('ZONAL_ADMIN','GLOBAL_ADMIN','INDIVIDUAL','ID_AUTHENTICATION', 'TEST', 'REGISTRATION_ADMIN', 'REGISTRATION_SUPERVISOR', 'REGISTRATION_OFFICER', 'REGISTRATION_PROCESSOR','PRE_REGISTRATION_ADMIN','RESIDENT')")
    @ResponseFilter
    @PostMapping(value={"/decryptDt"}, produces={"application/json"})
    public ResponseWrapper<CryptomanagerResponseDto> decryptDt(@ApiParam(value="Salt and Data to decrypt in BASE64 encoding with meta-data") @RequestBody @Valid RequestWrapper<CryptomanagerRequestDto> cryptomanagerRequestDto) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.cryptomanagerService.decrypt((CryptomanagerRequestDto)cryptomanagerRequestDto.getRequest()));
        return response;
    }
}

