/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.clientcrypto.service.impl;

import io.mosip.kernel.clientcrypto.constant.ClientCryptoErrorConstants;
import io.mosip.kernel.clientcrypto.constant.ClientCryptoManagerConstant;
import io.mosip.kernel.clientcrypto.exception.ClientCryptoException;
import io.mosip.kernel.clientcrypto.service.spi.ClientCryptoService;
import io.mosip.kernel.core.crypto.spi.CryptoCoreSpec;
import io.mosip.kernel.core.logger.spi.Logger;
import io.mosip.kernel.core.util.CryptoUtil;
import io.mosip.kernel.keymanagerservice.logger.KeymanagerLogger;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Objects;
import javax.crypto.SecretKey;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.FileUtils;

class LocalClientCryptoServiceImpl
implements ClientCryptoService {
    private static final Logger LOGGER = KeymanagerLogger.getLogger(LocalClientCryptoServiceImpl.class);
    private static final String ALGORITHM = "RSA";
    private static final int KEY_LENGTH = 2048;
    private static final String SIGN_ALGORITHM = "SHA256withRSA";
    private static final String PRIVATE_KEY = "reg.key";
    private static final String PUBLIC_KEY = "reg.pub";
    private static final String README = "readme.txt";
    private static SecureRandom secureRandom = null;
    protected static CryptoCoreSpec<byte[], byte[], SecretKey, PublicKey, PrivateKey, String> cryptoCore;

    LocalClientCryptoServiceImpl(@NotNull CryptoCoreSpec<byte[], byte[], SecretKey, PublicKey, PrivateKey, String> cryptoCoreImpl) throws Throwable {
        LOGGER.info("ccSessionID", "NON-TPM", "", "Getting the instance of NON_TPM Security");
        this.backwardCompatibilityFix();
        if (!this.doesKeysExists()) {
            this.setupKeysDir();
            KeyPairGenerator keyGenerator = KeyPairGenerator.getInstance(ALGORITHM);
            keyGenerator.initialize(2048, new SecureRandom());
            KeyPair keypair = keyGenerator.generateKeyPair();
            this.createKeyFile(PRIVATE_KEY, keypair.getPrivate().getEncoded());
            this.createKeyFile(PUBLIC_KEY, keypair.getPublic().getEncoded());
            this.createReadMe(keypair.getPublic());
            LOGGER.info("ccSessionID", "NON-TPM", "", "TPM NOT AVAILABLE - GENERATED NEW KEY PAIR SUCCESSFULLY.");
        }
        LOGGER.info("ccSessionID", "NON-TPM", "", "Completed initializing Local Security Impl");
        LOGGER.info("ccSessionID", "NON-TPM", "", "Check this file for publicKey and KeyIndex : " + this.getKeysDirPath() + File.separator + README);
        cryptoCore = cryptoCoreImpl;
    }

    @Override
    public byte[] signData(@NotNull byte[] dataToSign) throws ClientCryptoException {
        byte[] byArray;
        Signature sign = Signature.getInstance(SIGN_ALGORITHM);
        sign.initSign(this.getPrivateKey());
        ByteArrayInputStream in = new ByteArrayInputStream(dataToSign);
        try {
            byte[] buffer = new byte[2048];
            int len = 0;
            while ((len = in.read(buffer)) != -1) {
                sign.update(buffer, 0, len);
            }
            byArray = sign.sign();
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                throw new ClientCryptoException(ClientCryptoErrorConstants.CRYPTO_FAILED.getErrorCode(), ClientCryptoErrorConstants.CRYPTO_FAILED.getErrorMessage(), ex);
            }
        }
        in.close();
        return byArray;
    }

    @Override
    public boolean validateSignature(@NotNull byte[] signature, @NotNull byte[] actualData) throws ClientCryptoException {
        try {
            return LocalClientCryptoServiceImpl.validateSignature(this.getPublicKey(), signature, actualData);
        }
        catch (Exception ex) {
            throw new ClientCryptoException(ClientCryptoErrorConstants.CRYPTO_FAILED.getErrorCode(), ClientCryptoErrorConstants.CRYPTO_FAILED.getErrorMessage(), ex);
        }
    }

    @Override
    public byte[] asymmetricEncrypt(@NotNull byte[] dataToEncrypt) throws ClientCryptoException {
        try {
            return (byte[])cryptoCore.asymmetricEncrypt((Object)this.getPublicKey(), (Object)dataToEncrypt);
        }
        catch (Exception ex) {
            throw new ClientCryptoException(ClientCryptoErrorConstants.CRYPTO_FAILED.getErrorCode(), ClientCryptoErrorConstants.CRYPTO_FAILED.getErrorMessage(), ex);
        }
    }

    @Override
    public byte[] asymmetricDecrypt(@NotNull byte[] dataToDecrypt) throws ClientCryptoException {
        try {
            return (byte[])cryptoCore.asymmetricDecrypt((Object)this.getPrivateKey(), (Object)dataToDecrypt);
        }
        catch (Exception ex) {
            throw new ClientCryptoException(ClientCryptoErrorConstants.CRYPTO_FAILED.getErrorCode(), ClientCryptoErrorConstants.CRYPTO_FAILED.getErrorMessage(), ex);
        }
    }

    @Override
    public byte[] getSigningPublicPart() throws ClientCryptoException {
        try {
            return this.getPublicKey().getEncoded();
        }
        catch (Exception ex) {
            throw new ClientCryptoException(ClientCryptoErrorConstants.CRYPTO_FAILED.getErrorCode(), ClientCryptoErrorConstants.CRYPTO_FAILED.getErrorMessage(), ex);
        }
    }

    @Override
    public void closeSecurityInstance() throws ClientCryptoException {
        LOGGER.info("ccSessionID", "NON-TPM", "", "Nothing to do, as Local NON-TPM Security Impl is in use");
    }

    @Override
    public boolean isTPMInstance() {
        return false;
    }

    public static byte[] generateRandomBytes(int length) {
        if (secureRandom == null) {
            secureRandom = new SecureRandom();
        }
        byte[] bytes = new byte[length];
        secureRandom.nextBytes(bytes);
        return bytes;
    }

    @Override
    public byte[] getEncryptionPublicPart() {
        try {
            return this.getPublicKey().getEncoded();
        }
        catch (Exception ex) {
            throw new ClientCryptoException(ClientCryptoErrorConstants.CRYPTO_FAILED.getErrorCode(), ClientCryptoErrorConstants.CRYPTO_FAILED.getErrorMessage(), ex);
        }
    }

    public static boolean validateSignature(@NotNull byte[] publicKey, @NotNull byte[] signature, @NotNull byte[] actualData) throws ClientCryptoException {
        try {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKey);
            KeyFactory kf = KeyFactory.getInstance(ALGORITHM);
            return LocalClientCryptoServiceImpl.validateSignature(kf.generatePublic(keySpec), signature, actualData);
        }
        catch (Exception ex) {
            throw new ClientCryptoException(ClientCryptoErrorConstants.CRYPTO_FAILED.getErrorCode(), ClientCryptoErrorConstants.CRYPTO_FAILED.getErrorMessage(), ex);
        }
    }

    public static byte[] asymmetricEncrypt(byte[] publicKey, byte[] dataToEncrypt) throws ClientCryptoException {
        LOGGER.info("ccSessionID", "NON-TPM", "", "LocalClientSecurity Asymmetric encrypt");
        try {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKey);
            KeyFactory kf = KeyFactory.getInstance(ALGORITHM);
            return (byte[])cryptoCore.asymmetricEncrypt((Object)kf.generatePublic(keySpec), (Object)dataToEncrypt);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException ex) {
            throw new ClientCryptoException(ClientCryptoErrorConstants.CRYPTO_FAILED.getErrorCode(), ClientCryptoErrorConstants.CRYPTO_FAILED.getErrorMessage(), ex);
        }
    }

    private static boolean validateSignature(PublicKey publicKey, byte[] signature, byte[] actualData) throws ClientCryptoException {
        boolean bl;
        Signature sign = Signature.getInstance(SIGN_ALGORITHM);
        sign.initVerify(publicKey);
        ByteArrayInputStream in = new ByteArrayInputStream(actualData);
        try {
            byte[] buffer = new byte[2048];
            int len = 0;
            while ((len = in.read(buffer)) != -1) {
                sign.update(buffer, 0, len);
            }
            bl = sign.verify(signature);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                throw new ClientCryptoException(ClientCryptoErrorConstants.CRYPTO_FAILED.getErrorCode(), ClientCryptoErrorConstants.CRYPTO_FAILED.getErrorMessage(), ex);
            }
        }
        in.close();
        return bl;
    }

    private void setupKeysDir() {
        File keysDir = new File(this.getKeysDirPath());
        keysDir.mkdirs();
    }

    private boolean doesKeysExists() {
        File keysDir = new File(this.getKeysDirPath());
        return keysDir.exists() && Objects.requireNonNull(keysDir.list()).length >= 2;
    }

    private void backwardCompatibilityFix() {
        Path targetPrivateKey = Paths.get(ClientCryptoManagerConstant.KEY_PATH, ".mosipkeys", PRIVATE_KEY);
        if (targetPrivateKey.toFile().exists()) {
            LOGGER.info("Backward compatibility fix not applicable");
            return;
        }
        Path target = Paths.get(ClientCryptoManagerConstant.KEY_PATH, ".mosipkeys");
        File existingKeysDir = new File(System.getProperty("user.home") + File.separator + ".mosipkeys");
        if (existingKeysDir.exists() && Objects.requireNonNull(existingKeysDir.list()).length >= 2) {
            try {
                FileUtils.copyDirectory((File)existingKeysDir, (File)target.toFile());
                LOGGER.info("Successfully performed backward compatible fix. Copied {} to {}", new Object[]{existingKeysDir, target});
            }
            catch (IOException e) {
                LOGGER.error("Failed to perform backward compatible fix. Failed to copy {} to {} due to {}", new Object[]{existingKeysDir, target, e});
            }
        }
    }

    private String getKeysDirPath() {
        return ClientCryptoManagerConstant.KEY_PATH + File.separator + ".mosipkeys";
    }

    private void createKeyFile(String fileName, byte[] key) throws IOException {
        try (FileOutputStream os = new FileOutputStream(this.getKeysDirPath() + File.separator + fileName);){
            os.write(key);
        }
    }

    private PrivateKey getPrivateKey() throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] key = Files.readAllBytes(Paths.get(this.getKeysDirPath() + File.separator + PRIVATE_KEY, new String[0]));
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(key);
        KeyFactory kf = KeyFactory.getInstance(ALGORITHM);
        return kf.generatePrivate(keySpec);
    }

    private PublicKey getPublicKey() throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] key = Files.readAllBytes(Paths.get(this.getKeysDirPath() + File.separator + PUBLIC_KEY, new String[0]));
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(key);
        KeyFactory kf = KeyFactory.getInstance(ALGORITHM);
        return kf.generatePublic(keySpec);
    }

    private void createReadMe(PublicKey publicKey) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append("MachineName: ");
        builder.append(InetAddress.getLocalHost().getHostName().toLowerCase());
        builder.append("\r\n");
        builder.append("PublicKey: ");
        builder.append(CryptoUtil.encodeBase64String((byte[])publicKey.getEncoded()));
        builder.append("\r\n");
        builder.append("KeyIndex: ");
        builder.append(CryptoUtil.computeFingerPrint((byte[])publicKey.getEncoded(), null).toLowerCase());
        builder.append("\r\n");
        builder.append("Note : Use the above public key and client/machine name to create client machine using admin API");
        builder.append("\r\n");
        builder.append("Note : If the keys are lost/deleted, keys are regenerated on next instantiation of this instance. Corresponding client mappings need to be recreated once again.");
        builder.append("\r\n");
        Files.write(Paths.get(this.getKeysDirPath() + File.separator + README, new String[0]), builder.toString().getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE);
    }
}

