/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.signature.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.util.Base64;
import com.nimbusds.jose.util.Base64URL;
import io.mosip.kernel.core.logger.spi.Logger;
import io.mosip.kernel.keymanagerservice.logger.KeymanagerLogger;
import io.mosip.kernel.signature.constant.SignatureConstant;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import org.apache.commons.codec.digest.DigestUtils;

public class SignatureUtil {
    private static final Logger LOGGER = KeymanagerLogger.getLogger(SignatureUtil.class);

    public static boolean isDataValid(String anyData) {
        return anyData != null && !anyData.trim().isEmpty();
    }

    public static boolean isJsonValid(String jsonInString) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.readTree(jsonInString);
            return true;
        }
        catch (IOException e) {
            LOGGER.error("SignatureSessionId", "JWTSignature", "", "Provided JSON Data to sign value is invalid.");
            return false;
        }
    }

    public static boolean isIncludeAttrsValid(Boolean includes) {
        if (Objects.isNull(includes)) {
            return SignatureConstant.DEFAULT_INCLUDES;
        }
        return includes;
    }

    public static JWSHeader getJWSHeader(String signAlgorithm, boolean b64JWSHeaderParam, boolean includeCertificate, boolean includeCertHash, String certificateUrl, X509Certificate x509Certificate) {
        JWSAlgorithm jwsAlgorithm;
        switch (signAlgorithm) {
            case "RS256": {
                jwsAlgorithm = JWSAlgorithm.RS256;
                break;
            }
            case "PS256": {
                jwsAlgorithm = JWSAlgorithm.PS256;
                break;
            }
            default: {
                jwsAlgorithm = JWSAlgorithm.PS256;
            }
        }
        JWSHeader.Builder jwsHeaderBuilder = new JWSHeader.Builder(jwsAlgorithm);
        if (!b64JWSHeaderParam) {
            jwsHeaderBuilder = jwsHeaderBuilder.base64URLEncodePayload(false).criticalParams(Collections.singleton("b64"));
        }
        if (includeCertificate) {
            try {
                Base64 signCert = Base64.encode((byte[])x509Certificate.getEncoded());
                ArrayList<Base64> x5c = new ArrayList<Base64>();
                x5c.add(signCert);
                jwsHeaderBuilder = jwsHeaderBuilder.x509CertChain(x5c);
            }
            catch (CertificateEncodingException e) {
                LOGGER.warn("SignatureSessionId", "JWSSignature", "", "Warning thrown when certificate not able to parse while adding to jws header.");
            }
        }
        if (includeCertHash) {
            try {
                jwsHeaderBuilder = jwsHeaderBuilder.x509CertSHA256Thumbprint(Base64URL.encode((byte[])DigestUtils.sha256((byte[])x509Certificate.getEncoded())));
            }
            catch (CertificateEncodingException e) {
                LOGGER.warn("SignatureSessionId", "JWSSignature", "", "Warning thrown when certificate not able to parse while adding to jws header.");
            }
        }
        if (Objects.nonNull(certificateUrl)) {
            try {
                jwsHeaderBuilder.x509CertURL(new URI(certificateUrl));
            }
            catch (URISyntaxException e) {
                LOGGER.warn("SignatureSessionId", "JWSSignature", "", "Warning thrown when certificate URI not able to parse while adding to jws header.");
            }
        }
        return jwsHeaderBuilder.build();
    }

    public static byte[] buildSignData(JWSHeader jwsHeader, byte[] actualDataToSign) {
        byte[] jwsHeaderBytes = jwsHeader.toBase64URL().toString().getBytes(StandardCharsets.UTF_8);
        byte[] jwsSignData = new byte[jwsHeaderBytes.length + actualDataToSign.length + 1];
        System.arraycopy(jwsHeaderBytes, 0, jwsSignData, 0, jwsHeaderBytes.length);
        jwsSignData[jwsHeaderBytes.length] = 46;
        System.arraycopy(actualDataToSign, 0, jwsSignData, jwsHeaderBytes.length + 1, actualDataToSign.length);
        return jwsSignData;
    }
}

