/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.signature.service.impl;

import io.mosip.kernel.core.logger.spi.Logger;
import io.mosip.kernel.core.util.CryptoUtil;
import io.mosip.kernel.keymanagerservice.logger.KeymanagerLogger;
import io.mosip.kernel.signature.constant.SignatureErrorCode;
import io.mosip.kernel.signature.exception.SignatureFailureException;
import io.mosip.kernel.signature.service.SignatureProvider;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;

public class RS256SignatureProviderImpl
implements SignatureProvider {
    private static final Logger LOGGER = KeymanagerLogger.getLogger(RS256SignatureProviderImpl.class);

    @Override
    public String sign(PrivateKey privateKey, byte[] signData, String providerName) {
        try {
            Signature signatureObj = Signature.getInstance("SHA256withRSA");
            signatureObj.initSign(privateKey);
            signatureObj.update(signData);
            return CryptoUtil.encodeBase64((byte[])signatureObj.sign());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            LOGGER.error("SignatureSessionId", "JWSSignature", "", "Error while signing the data.");
            throw new SignatureFailureException(SignatureErrorCode.SIGN_ERROR.getErrorCode(), SignatureErrorCode.SIGN_ERROR.getErrorMessage(), e);
        }
    }
}

