/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.partnercertservice.service.impl;

import io.mosip.kernel.core.keymanager.model.CertificateParameters;
import io.mosip.kernel.core.keymanager.spi.KeyStore;
import io.mosip.kernel.core.logger.spi.Logger;
import io.mosip.kernel.core.util.DateUtils;
import io.mosip.kernel.keymanager.hsm.util.CertificateUtility;
import io.mosip.kernel.keymanagerservice.dto.SignatureCertificate;
import io.mosip.kernel.keymanagerservice.entity.PartnerCertificateStore;
import io.mosip.kernel.keymanagerservice.logger.KeymanagerLogger;
import io.mosip.kernel.keymanagerservice.service.KeymanagerService;
import io.mosip.kernel.keymanagerservice.util.KeymanagerUtil;
import io.mosip.kernel.partnercertservice.constant.PartnerCertManagerErrorConstants;
import io.mosip.kernel.partnercertservice.dto.CACertificateRequestDto;
import io.mosip.kernel.partnercertservice.dto.CACertificateResponseDto;
import io.mosip.kernel.partnercertservice.dto.CertificateTrustRequestDto;
import io.mosip.kernel.partnercertservice.dto.CertificateTrustResponeDto;
import io.mosip.kernel.partnercertservice.dto.PartnerCertDownloadRequestDto;
import io.mosip.kernel.partnercertservice.dto.PartnerCertDownloadResponeDto;
import io.mosip.kernel.partnercertservice.dto.PartnerCertificateRequestDto;
import io.mosip.kernel.partnercertservice.dto.PartnerCertificateResponseDto;
import io.mosip.kernel.partnercertservice.exception.PartnerCertManagerException;
import io.mosip.kernel.partnercertservice.helper.PartnerCertManagerDBHelper;
import io.mosip.kernel.partnercertservice.service.spi.PartnerCertificateManagerService;
import io.mosip.kernel.partnercertservice.util.PartnerCertificateManagerUtil;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.security.auth.x500.X500Principal;
import org.cache2k.Cache;
import org.cache2k.Cache2kBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PartnerCertificateManagerServiceImpl
implements PartnerCertificateManagerService {
    private static final Logger LOGGER = KeymanagerLogger.getLogger(PartnerCertificateManagerServiceImpl.class);
    @Value(value="${mosip.kernel.partner.sign.masterkey.application.id}")
    private String masterSignKeyAppId;
    @Value(value="${mosip.kernel.partner.allowed.domains}")
    private String partnerAllowedDomains;
    @Value(value="${mosip.kernel.certificate.sign.algorithm:SHA256withRSA}")
    private String signAlgorithm;
    @Value(value="${mosip.kernel.partner.issuer.certificate.duration.years:1}")
    private int issuerCertDuration;
    @Value(value="${mosip.kernel.partner.truststore.cache.expire.inMins:120}")
    private long cacheExpireInMins;
    @Value(value="${mosip.kernel.partner.issuer.certificate.allowed.grace.duration:30}")
    private int gracePeriod;
    @Autowired
    KeymanagerUtil keymanagerUtil;
    @Autowired
    PartnerCertManagerDBHelper certDBHelper;
    @Autowired
    private KeyStore keyStore;
    @Autowired
    private KeymanagerService keymanagerService;
    private Cache<String, Object> caCertTrustStore = null;

    @PostConstruct
    public void init() {
        this.caCertTrustStore = new Cache2kBuilder<String, Object>(){}.name("caCertTrustStore-" + this.hashCode()).expireAfterWrite(this.cacheExpireInMins, TimeUnit.MINUTES).entryCapacity(10L).refreshAhead(true).loaderThreadCount(1).loader(partnerDomain -> {
            LOGGER.info("pcSessionId", "", "", "Loading CA TrustStore Cache for partnerDomain: " + partnerDomain);
            return this.certDBHelper.getTrustAnchors((String)partnerDomain);
        }).build();
    }

    @Override
    public CACertificateResponseDto uploadCACertificate(CACertificateRequestDto caCertRequestDto) {
        LOGGER.info("pcSessionId", "UploadCACertificate", "", "Uploading CA/Sub-CA Certificate.");
        String certificateData = caCertRequestDto.getCertificateData();
        if (!this.keymanagerUtil.isValidCertificateData(certificateData)) {
            LOGGER.error("pcSessionId", "UploadCACertificate", "", "Invalid Certificate Data provided to upload the ca/sub-ca certificate.");
            throw new PartnerCertManagerException(PartnerCertManagerErrorConstants.INVALID_CERTIFICATE.getErrorCode(), PartnerCertManagerErrorConstants.INVALID_CERTIFICATE.getErrorMessage());
        }
        X509Certificate reqX509Cert = (X509Certificate)this.keymanagerUtil.convertToCertificate(certificateData);
        String certThumbprint = PartnerCertificateManagerUtil.getCertificateThumbprint(reqX509Cert);
        String partnerDomain = this.validateAllowedDomains(caCertRequestDto.getPartnerDomain());
        this.validateBasicCACertParams(reqX509Cert, certThumbprint, partnerDomain);
        String certSubject = PartnerCertificateManagerUtil.formatCertificateDN(reqX509Cert.getSubjectX500Principal().getName());
        String certIssuer = PartnerCertificateManagerUtil.formatCertificateDN(reqX509Cert.getIssuerX500Principal().getName());
        boolean selfSigned = PartnerCertificateManagerUtil.isSelfSignedCertificate(reqX509Cert);
        if (selfSigned) {
            LOGGER.info("pcSessionId", "UploadCACertificate", "", "Adding Self-signed Certificate in store.");
            String certId = UUID.randomUUID().toString();
            this.certDBHelper.storeCACertificate(certId, certSubject, certIssuer, certId, reqX509Cert, certThumbprint, partnerDomain);
        } else {
            LOGGER.info("pcSessionId", "UploadCACertificate", "", "Adding Intermediate Certificates in store.");
            boolean certValid = this.validateCertificatePath(reqX509Cert, partnerDomain);
            if (!certValid) {
                LOGGER.error("pcSessionId", "UploadCACertificate", "", "Sub-CA Certificate not allowed to upload as root CA is not available.");
                throw new PartnerCertManagerException(PartnerCertManagerErrorConstants.ROOT_CA_NOT_FOUND.getErrorCode(), PartnerCertManagerErrorConstants.ROOT_CA_NOT_FOUND.getErrorMessage());
            }
            String issuerId = this.certDBHelper.getIssuerCertId(certIssuer);
            String certId = UUID.randomUUID().toString();
            this.certDBHelper.storeCACertificate(certId, certSubject, certIssuer, issuerId, reqX509Cert, certThumbprint, partnerDomain);
        }
        this.caCertTrustStore.expireAt((Object)partnerDomain, 0L);
        CACertificateResponseDto responseDto = new CACertificateResponseDto();
        responseDto.setStatus("Upload Success.");
        responseDto.setTimestamp(DateUtils.getUTCCurrentDateTime());
        return responseDto;
    }

    private void validateBasicCACertParams(X509Certificate reqX509Cert, String certThumbprint, String partnerDomain) {
        boolean certExist = this.certDBHelper.isCertificateExist(certThumbprint, partnerDomain);
        if (certExist) {
            LOGGER.error("pcSessionId", "UploadCACertificate", "", "CA/sub-CA certificate already exists in Store.");
            throw new PartnerCertManagerException(PartnerCertManagerErrorConstants.CERTIFICATE_EXIST_ERROR.getErrorCode(), PartnerCertManagerErrorConstants.CERTIFICATE_EXIST_ERROR.getErrorMessage());
        }
        boolean validDates = PartnerCertificateManagerUtil.isCertificateDatesValid(reqX509Cert);
        if (!validDates) {
            LOGGER.error("pcSessionId", "UploadCACertificate", "", "Certificate Dates are not valid.");
            throw new PartnerCertManagerException(PartnerCertManagerErrorConstants.CERTIFICATE_DATES_NOT_VALID.getErrorCode(), PartnerCertManagerErrorConstants.CERTIFICATE_DATES_NOT_VALID.getErrorMessage());
        }
    }

    private String validateAllowedDomains(String partnerDomain) {
        String validPartnerDomain = Stream.of(this.partnerAllowedDomains.split(",")).map(String::trim).filter(allowedDomain -> allowedDomain.equalsIgnoreCase(partnerDomain)).findFirst().orElseThrow(() -> new PartnerCertManagerException(PartnerCertManagerErrorConstants.INVALID_PARTNER_DOMAIN.getErrorCode(), PartnerCertManagerErrorConstants.INVALID_PARTNER_DOMAIN.getErrorMessage()));
        return validPartnerDomain.toUpperCase();
    }

    private boolean validateCertificatePath(X509Certificate reqX509Cert, String partnerDomain) {
        try {
            Map trustStoreMap = (Map)this.caCertTrustStore.get((Object)partnerDomain);
            Set rootTrustAnchors = (Set)trustStoreMap.get("TrustRoot");
            Set interCerts = (Set)trustStoreMap.get("TrustInter");
            X509CertSelector certToVerify = new X509CertSelector();
            certToVerify.setCertificate(reqX509Cert);
            PKIXBuilderParameters pkixBuilderParams = new PKIXBuilderParameters(rootTrustAnchors, (CertSelector)certToVerify);
            pkixBuilderParams.setRevocationEnabled(false);
            CertStore interCertStore = CertStore.getInstance("Collection", new CollectionCertStoreParameters(interCerts));
            pkixBuilderParams.addCertStore(interCertStore);
            CertPathBuilder certPathBuilder = CertPathBuilder.getInstance("PKIX");
            certPathBuilder.build(pkixBuilderParams);
            return true;
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | CertPathBuilderException exp) {
            LOGGER.info("pcSessionId", "UploadCACertificate", "", "Ignore this exception, the exception thrown when trust validation failed.");
            return false;
        }
    }

    @Override
    public PartnerCertificateResponseDto uploadPartnerCertificate(PartnerCertificateRequestDto partnerCertRequesteDto) {
        String certificateData = partnerCertRequesteDto.getCertificateData();
        if (!this.keymanagerUtil.isValidCertificateData(certificateData)) {
            LOGGER.error("pcSessionId", "UploadPartnerCertificate", "", "Invalid Certificate Data provided to upload the partner certificate.");
            throw new PartnerCertManagerException(PartnerCertManagerErrorConstants.INVALID_CERTIFICATE.getErrorCode(), PartnerCertManagerErrorConstants.INVALID_CERTIFICATE.getErrorMessage());
        }
        X509Certificate reqX509Cert = (X509Certificate)this.keymanagerUtil.convertToCertificate(certificateData);
        String certThumbprint = PartnerCertificateManagerUtil.getCertificateThumbprint(reqX509Cert);
        String reqOrgName = partnerCertRequesteDto.getOrganizationName();
        String partnerDomain = this.validateAllowedDomains(partnerCertRequesteDto.getPartnerDomain());
        this.validateBasicPartnerCertParams(reqX509Cert, certThumbprint, reqOrgName, partnerDomain);
        String certSubject = PartnerCertificateManagerUtil.formatCertificateDN(reqX509Cert.getSubjectX500Principal().getName());
        String certIssuer = PartnerCertificateManagerUtil.formatCertificateDN(reqX509Cert.getIssuerX500Principal().getName());
        String issuerId = this.certDBHelper.getIssuerCertId(certIssuer);
        String certId = UUID.randomUUID().toString();
        X509Certificate resignedCert = this.reSignPartnerKey(reqX509Cert);
        String signedCertData = this.keymanagerUtil.getPEMFormatedData(resignedCert);
        this.certDBHelper.storePartnerCertificate(certId, certSubject, certIssuer, issuerId, reqX509Cert, certThumbprint, reqOrgName, partnerDomain, signedCertData);
        PartnerCertificateResponseDto responseDto = new PartnerCertificateResponseDto();
        responseDto.setCertificateId(certId);
        responseDto.setSignedCertificateData(signedCertData);
        responseDto.setTimestamp(DateUtils.getUTCCurrentDateTime());
        return responseDto;
    }

    private void validateBasicPartnerCertParams(X509Certificate reqX509Cert, String certThumbprint, String reqOrgName, String partnerDomain) {
        int keySize;
        boolean validDates;
        boolean certExist = this.certDBHelper.isPartnerCertificateExist(certThumbprint, partnerDomain);
        if (certExist) {
            LOGGER.error("pcSessionId", "UploadPartnerCertificate", "", "Partner certificate already exists in Store.");
        }
        if (!(validDates = PartnerCertificateManagerUtil.isCertificateDatesValid(reqX509Cert))) {
            LOGGER.error("pcSessionId", "UploadPartnerCertificate", "", "Certificate Dates are not valid.");
            throw new PartnerCertManagerException(PartnerCertManagerErrorConstants.CERTIFICATE_DATES_NOT_VALID.getErrorCode(), PartnerCertManagerErrorConstants.CERTIFICATE_DATES_NOT_VALID.getErrorMessage());
        }
        boolean validDuration = PartnerCertificateManagerUtil.isCertificateValidForDuration(reqX509Cert, this.issuerCertDuration, this.gracePeriod);
        if (!validDuration) {
            LOGGER.error("pcSessionId", "UploadPartnerCertificate", "", "Certificate Dates are not in allowed range.");
            throw new PartnerCertManagerException(PartnerCertManagerErrorConstants.CERTIFICATE_DATES_NOT_VALID.getErrorCode(), PartnerCertManagerErrorConstants.CERTIFICATE_DATES_NOT_VALID.getErrorMessage());
        }
        boolean certValid = this.validateCertificatePath(reqX509Cert, partnerDomain);
        if (!certValid) {
            LOGGER.error("pcSessionId", "UploadPartnerCertificate", "", "Partner Certificate not allowed to upload as root CA/Intermediate CAs are not available.");
            throw new PartnerCertManagerException(PartnerCertManagerErrorConstants.ROOT_INTER_CA_NOT_FOUND.getErrorCode(), PartnerCertManagerErrorConstants.ROOT_INTER_CA_NOT_FOUND.getErrorMessage());
        }
        int certVersion = reqX509Cert.getVersion();
        if (certVersion != 3) {
            LOGGER.error("pcSessionId", "UploadPartnerCertificate", "", "Partner Certificate version not valid, the version has to be V3");
            throw new PartnerCertManagerException(PartnerCertManagerErrorConstants.INVALID_CERT_VERSION.getErrorCode(), PartnerCertManagerErrorConstants.INVALID_CERT_VERSION.getErrorMessage());
        }
        String certOrgName = PartnerCertificateManagerUtil.getCertificateOrgName(reqX509Cert.getSubjectX500Principal());
        if (!certOrgName.equals(reqOrgName)) {
            LOGGER.error("pcSessionId", "UploadPartnerCertificate", "", "Partner Certificate Organization and Partner Organization Name not matching.");
            throw new PartnerCertManagerException(PartnerCertManagerErrorConstants.PARTNER_ORG_NOT_MATCH.getErrorCode(), PartnerCertManagerErrorConstants.PARTNER_ORG_NOT_MATCH.getErrorMessage());
        }
        String keyAlgorithm = reqX509Cert.getPublicKey().getAlgorithm();
        if (keyAlgorithm.equalsIgnoreCase("RSA") && (keySize = ((RSAPublicKey)reqX509Cert.getPublicKey()).getModulus().bitLength()) < 2048) {
            LOGGER.error("pcSessionId", "UploadPartnerCertificate", "", "Partner Certificate key is less than allowed size.");
            throw new PartnerCertManagerException(PartnerCertManagerErrorConstants.CERT_KEY_NOT_ALLOWED.getErrorCode(), PartnerCertManagerErrorConstants.CERT_KEY_NOT_ALLOWED.getErrorMessage());
        }
        String signatureAlgorithm = reqX509Cert.getSigAlgName();
        if (!signatureAlgorithm.toUpperCase().startsWith("SHA2")) {
            LOGGER.error("pcSessionId", "UploadPartnerCertificate", "", "Signature Algorithm not supported.");
            throw new PartnerCertManagerException(PartnerCertManagerErrorConstants.CERT_SIGNATURE_ALGO_NOT_ALLOWED.getErrorCode(), PartnerCertManagerErrorConstants.CERT_SIGNATURE_ALGO_NOT_ALLOWED.getErrorMessage());
        }
    }

    private X509Certificate reSignPartnerKey(X509Certificate reqX509Cert) {
        String timestamp = DateUtils.getUTCCurrentDateTimeString();
        SignatureCertificate certificateResponse = this.keymanagerService.getSignatureCertificate(this.masterSignKeyAppId, Optional.of(""), timestamp);
        LOGGER.info("pcSessionId", "UploadPartnerCertificate", "KeyAlias", "Found Master Key Alias: " + certificateResponse.getAlias());
        PrivateKey signPrivateKey = (PrivateKey)certificateResponse.getCertificateEntry().getPrivateKey();
        X509Certificate signCert = ((X509Certificate[])certificateResponse.getCertificateEntry().getChain())[0];
        X500Principal signerPrincipal = signCert.getSubjectX500Principal();
        X500Principal subjectPrincipal = reqX509Cert.getSubjectX500Principal();
        PublicKey partnerPublicKey = reqX509Cert.getPublicKey();
        int noOfDays = 365 * this.issuerCertDuration;
        LOGGER.info("pcSessionId", "UploadPartnerCertificate", "Cert Duration", "Calculated Signed Certficiate Number of Days for expire: " + noOfDays);
        LocalDateTime notBeforeDate = DateUtils.getUTCCurrentDateTime();
        LocalDateTime notAfterDate = notBeforeDate.plus(noOfDays, ChronoUnit.DAYS);
        CertificateParameters certParams = PartnerCertificateManagerUtil.getCertificateParameters(subjectPrincipal, notBeforeDate, notAfterDate);
        return CertificateUtility.generateX509Certificate(signPrivateKey, partnerPublicKey, certParams, signerPrincipal, this.signAlgorithm, this.keyStore.getKeystoreProviderName());
    }

    @Override
    public PartnerCertDownloadResponeDto getPartnerCertificate(PartnerCertDownloadRequestDto certDownloadRequestDto) {
        String partnetCertId = certDownloadRequestDto.getPartnerCertId();
        if (!PartnerCertificateManagerUtil.isValidCertificateID(partnetCertId)) {
            LOGGER.error("pcSessionId", "UploadPartnerCertificate", "", "Invalid Certificate ID provided to get the partner certificate.");
            throw new PartnerCertManagerException(PartnerCertManagerErrorConstants.INVALID_CERTIFICATE_ID.getErrorCode(), PartnerCertManagerErrorConstants.INVALID_CERTIFICATE_ID.getErrorMessage());
        }
        PartnerCertificateStore partnerCertStore = this.certDBHelper.getPartnetCert(partnetCertId);
        if (Objects.isNull(partnerCertStore)) {
            LOGGER.error("pcSessionId", "UploadPartnerCertificate", "", "Partner Certificate ID not found.");
            throw new PartnerCertManagerException(PartnerCertManagerErrorConstants.PARTNER_CERT_ID_NOT_FOUND.getErrorCode(), PartnerCertManagerErrorConstants.PARTNER_CERT_ID_NOT_FOUND.getErrorMessage());
        }
        PartnerCertDownloadResponeDto responseDto = new PartnerCertDownloadResponeDto();
        responseDto.setCertificateData(partnerCertStore.getSignedCertData());
        responseDto.setTimestamp(DateUtils.getUTCCurrentDateTime());
        return responseDto;
    }

    @Override
    public CertificateTrustResponeDto verifyCertificateTrust(CertificateTrustRequestDto certificateTrustRequestDto) {
        String certificateData = certificateTrustRequestDto.getCertificateData();
        if (!this.keymanagerUtil.isValidCertificateData(certificateData)) {
            LOGGER.error("pcSessionId", "UploadPartnerCertificate", "", "Invalid Certificate Data provided to verify partner certificate trust.");
            throw new PartnerCertManagerException(PartnerCertManagerErrorConstants.INVALID_CERTIFICATE.getErrorCode(), PartnerCertManagerErrorConstants.INVALID_CERTIFICATE.getErrorMessage());
        }
        X509Certificate reqX509Cert = (X509Certificate)this.keymanagerUtil.convertToCertificate(certificateData);
        String partnerDomain = this.validateAllowedDomains(certificateTrustRequestDto.getPartnerDomain());
        boolean certValid = this.validateCertificatePath(reqX509Cert, partnerDomain);
        CertificateTrustResponeDto responseDto = new CertificateTrustResponeDto();
        responseDto.setStatus(certValid);
        return responseDto;
    }
}

