/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.keymanagerservice.config;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Tag;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
public class SwaggerConfig {
    private static final Logger logger = LoggerFactory.getLogger(SwaggerConfig.class);
    private static final String KEYMANAGER_SERVICE_VERSION = "1.0";
    private static final String TITLE = "Key Manager Service";
    private static final String DISCRIPTION = "Key Manager Service for Security";
    @Value(value="${application.env.local:false}")
    private Boolean localEnv;
    @Value(value="${swagger.base-url:#{null}}")
    private String swaggerBaseUrl;
    @Value(value="${server.port:8080}")
    private int serverPort;
    String proto = "http";
    String host = "localhost";
    int port = -1;
    String hostWithPort = "localhost:8080";

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(TITLE).description(DISCRIPTION).version(KEYMANAGER_SERVICE_VERSION).build();
    }

    @Bean
    public Docket api() {
        boolean swaggerBaseUrlSet = false;
        if (!this.localEnv.booleanValue() && this.swaggerBaseUrl != null && !this.swaggerBaseUrl.isEmpty()) {
            try {
                this.proto = new URL(this.swaggerBaseUrl).getProtocol();
                this.host = new URL(this.swaggerBaseUrl).getHost();
                this.port = new URL(this.swaggerBaseUrl).getPort();
                this.hostWithPort = this.port == -1 ? this.host : this.host + ":" + this.port;
                swaggerBaseUrlSet = true;
            }
            catch (MalformedURLException e) {
                logger.error("SwaggerUrlException: ", (Throwable)e);
            }
        }
        Docket docket = new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).tags(new Tag("keymanager", "Operations related to keymanagement and interaction with Softhsm/real HSM for Key Generation."), new Tag[0]).groupName(TITLE).select().apis(RequestHandlerSelectors.any()).paths(PathSelectors.regex((String)"(?!/(error).*).*")).build();
        if (swaggerBaseUrlSet) {
            docket.protocols(this.protocols()).host(this.hostWithPort);
            logger.info("Swagger Base URL: {}://{}", (Object)this.proto, (Object)this.hostWithPort);
        }
        return docket;
    }

    private Set<String> protocols() {
        HashSet<String> protocols = new HashSet<String>();
        protocols.add(this.proto);
        return protocols;
    }
}

