/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.keymanager.hsm.health;

import io.mosip.kernel.core.keymanager.spi.KeyStore;
import io.mosip.kernel.core.logger.spi.Logger;
import io.mosip.kernel.core.util.CryptoUtil;
import io.mosip.kernel.core.util.DateUtils;
import io.mosip.kernel.keymanagerservice.entity.KeyAlias;
import io.mosip.kernel.keymanagerservice.helper.KeymanagerDBHelper;
import io.mosip.kernel.keymanagerservice.logger.KeymanagerLogger;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.ReactiveHealthIndicator;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component(value="HSMHealth")
public class HSMHealthCheck
implements ReactiveHealthIndicator {
    private static final Logger LOGGER = KeymanagerLogger.getLogger(HSMHealthCheck.class);
    private static final String READ_KEY_SUCCESS = "READ_KEY_SUCCESS";
    private static final String ENCRYPT_OPS_SUCCESS = "ENCRYPT_OPS_SUCCESS";
    private static final String NO_UNIQUE_KEY_ALIAS_FOUND = "NO_UNIQUE_KEY_ALIAS_FOUND";
    private static final String HEALTH_CHECK_NOT_ENABLED = "HEALTH_CHECK_NOT_ENABLED";
    private static final String EMPTY_STR = "";
    private static final String SAMPLE_DATA = "Tk8tU0VDRVJULUFWQUlMQUJMRS1URU1QLUZJWElORy0";
    @Value(value="${mosip.kernel.keymgr.hsm.health.check.enabled:true}")
    private boolean healthCheckEnabled;
    @Value(value="${mosip.kernel.keymgr.hsm.health.check.encrypt:false}")
    private boolean healthCheckEncryptEnabled;
    @Value(value="${mosip.kernel.keymgr.hsm.health.key.app-id:KERNEL}")
    private String healthCheckDefaultAppId;
    @Value(value="${mosip.kernel.keymgr.hsm.healthkey.ref-id:IDENTITY_CACHE}")
    private String healthCheckDefaultRefId;
    @Value(value="${mosip.kernel.keymgr.hsm.health.check.algorithm-name:AES/ECB/NoPadding}")
    private String aesECBTransformation;
    private String cachedKeyAlias;
    @Autowired
    private KeymanagerDBHelper dbHelper;
    @Autowired
    private KeyStore keyStore;

    public Mono<Health> health() {
        return Mono.fromCallable(() -> this.checkHSMHealth()).map(result -> {
            if (HEALTH_CHECK_NOT_ENABLED.equals(result)) {
                return Health.up().withDetail("Info: ", result).build();
            }
            if (!READ_KEY_SUCCESS.equals(result) && !ENCRYPT_OPS_SUCCESS.equals(result)) {
                return Health.down().withDetail("Error: ", result).build();
            }
            return Health.up().withDetail("Info: ", result).build();
        });
    }

    private String checkHSMHealth() {
        try {
            if (!this.healthCheckEnabled) {
                return HEALTH_CHECK_NOT_ENABLED;
            }
            String keyAlias = this.getHealthCheckKeyAlias();
            if (keyAlias.equals(EMPTY_STR)) {
                return NO_UNIQUE_KEY_ALIAS_FOUND;
            }
            SecretKey key = this.keyStore.getSymmetricKey(keyAlias);
            if (!this.healthCheckEncryptEnabled) {
                LOGGER.info("sessionId", EMPTY_STR, "healthCheck", "READ_KEY_SUCCESS, Key Algorithm: " + key.getAlgorithm());
                return READ_KEY_SUCCESS;
            }
            Cipher cipher = Cipher.getInstance(this.aesECBTransformation);
            byte[] secretDataBytes = CryptoUtil.decodeBase64((String)SAMPLE_DATA);
            cipher.init(1, key);
            cipher.doFinal(secretDataBytes, 0, secretDataBytes.length);
            LOGGER.info("sessionId", EMPTY_STR, "healthCheck", "ENCRYPT_OPS_SUCCESS, Key Algorithm: " + key.getAlgorithm());
            return ENCRYPT_OPS_SUCCESS;
        }
        catch (Throwable th) {
            return th.getMessage();
        }
    }

    private String getHealthCheckKeyAlias() {
        if (this.cachedKeyAlias != null) {
            return this.cachedKeyAlias;
        }
        Map<String, List<KeyAlias>> keyAliasMap = this.dbHelper.getKeyAliases(this.healthCheckDefaultAppId, this.healthCheckDefaultRefId, DateUtils.getUTCCurrentDateTime());
        List<KeyAlias> currentKeyAliases = keyAliasMap.get("currentKeyAlias");
        if (currentKeyAliases.isEmpty() || currentKeyAliases.size() > 1) {
            return EMPTY_STR;
        }
        this.cachedKeyAlias = currentKeyAliases.get(0).getAlias();
        return this.cachedKeyAlias;
    }
}

