/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.cryptomanager.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDateTime;
import lombok.Generated;

@ApiModel(description="Class representing a Public Key Response")
public class PublicKeyResponse {
    @JsonIgnore
    private String alias;
    @ApiModelProperty(notes="Public key in BASE64 encoding format", required=true)
    private String publicKey;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    @ApiModelProperty(notes="Timestamp of issuance of public key", required=true)
    private LocalDateTime issuedAt;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    @ApiModelProperty(notes="Timestamp of expiry of public key", required=true)
    private LocalDateTime expiryAt;

    @Generated
    public String getAlias() {
        return this.alias;
    }

    @Generated
    public String getPublicKey() {
        return this.publicKey;
    }

    @Generated
    public LocalDateTime getIssuedAt() {
        return this.issuedAt;
    }

    @Generated
    public LocalDateTime getExpiryAt() {
        return this.expiryAt;
    }

    @Generated
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Generated
    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    @Generated
    public void setIssuedAt(LocalDateTime issuedAt) {
        this.issuedAt = issuedAt;
    }

    @Generated
    public void setExpiryAt(LocalDateTime expiryAt) {
        this.expiryAt = expiryAt;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PublicKeyResponse)) {
            return false;
        }
        PublicKeyResponse other = (PublicKeyResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        String this$publicKey = this.getPublicKey();
        String other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
            return false;
        }
        LocalDateTime this$issuedAt = this.getIssuedAt();
        LocalDateTime other$issuedAt = other.getIssuedAt();
        if (this$issuedAt == null ? other$issuedAt != null : !((Object)this$issuedAt).equals(other$issuedAt)) {
            return false;
        }
        LocalDateTime this$expiryAt = this.getExpiryAt();
        LocalDateTime other$expiryAt = other.getExpiryAt();
        return !(this$expiryAt == null ? other$expiryAt != null : !((Object)this$expiryAt).equals(other$expiryAt));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PublicKeyResponse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        String $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        LocalDateTime $issuedAt = this.getIssuedAt();
        result = result * 59 + ($issuedAt == null ? 43 : ((Object)$issuedAt).hashCode());
        LocalDateTime $expiryAt = this.getExpiryAt();
        result = result * 59 + ($expiryAt == null ? 43 : ((Object)$expiryAt).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PublicKeyResponse(alias=" + this.getAlias() + ", publicKey=" + this.getPublicKey() + ", issuedAt=" + this.getIssuedAt() + ", expiryAt=" + this.getExpiryAt() + ")";
    }

    @Generated
    public PublicKeyResponse(String alias, String publicKey, LocalDateTime issuedAt, LocalDateTime expiryAt) {
        this.alias = alias;
        this.publicKey = publicKey;
        this.issuedAt = issuedAt;
        this.expiryAt = expiryAt;
    }

    @Generated
    public PublicKeyResponse() {
    }
}

