/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.clientcrypto.dto;

import io.mosip.kernel.clientcrypto.constant.ClientType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotBlank;
import lombok.Generated;

@ApiModel(description="Model representing request for signature verification")
public class TpmSignVerifyRequestDto {
    @ApiModelProperty(notes="Data corresponding to signature", required=true)
    @NotBlank(message="should not be null or empty")
    private @NotBlank(message="should not be null or empty") String data;
    @ApiModelProperty(notes="Signature", required=true)
    @NotBlank(message="should not be null or empty")
    private @NotBlank(message="should not be null or empty") String signature;
    @ApiModelProperty(notes="Signing public key", required=true)
    @NotBlank(message="should not be null or empty")
    private @NotBlank(message="should not be null or empty") String publicKey;
    @ApiModelProperty(notes="Defaults to TPM, set to false for non-tpm based verification", required=false)
    @Deprecated(since="1.2.1")
    private boolean isTpm;
    @ApiModelProperty(notes="Default verifies based on public key to identify TPM Implementation,For non-TPM instances set this value explicitly", required=false)
    private ClientType clientType;

    @Generated
    public String getData() {
        return this.data;
    }

    @Generated
    public String getSignature() {
        return this.signature;
    }

    @Generated
    public String getPublicKey() {
        return this.publicKey;
    }

    @Deprecated
    @Generated
    public boolean isTpm() {
        return this.isTpm;
    }

    @Generated
    public ClientType getClientType() {
        return this.clientType;
    }

    @Generated
    public void setData(String data) {
        this.data = data;
    }

    @Generated
    public void setSignature(String signature) {
        this.signature = signature;
    }

    @Generated
    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    @Deprecated
    @Generated
    public void setTpm(boolean isTpm) {
        this.isTpm = isTpm;
    }

    @Generated
    public void setClientType(ClientType clientType) {
        this.clientType = clientType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TpmSignVerifyRequestDto)) {
            return false;
        }
        TpmSignVerifyRequestDto other = (TpmSignVerifyRequestDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$data = this.getData();
        String other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$signature = this.getSignature();
        String other$signature = other.getSignature();
        if (this$signature == null ? other$signature != null : !this$signature.equals(other$signature)) {
            return false;
        }
        String this$publicKey = this.getPublicKey();
        String other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
            return false;
        }
        if (this.isTpm() != other.isTpm()) {
            return false;
        }
        ClientType this$clientType = this.getClientType();
        ClientType other$clientType = other.getClientType();
        return !(this$clientType == null ? other$clientType != null : !((Object)((Object)this$clientType)).equals((Object)other$clientType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TpmSignVerifyRequestDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
        String $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        result = result * 59 + (this.isTpm() ? 79 : 97);
        ClientType $clientType = this.getClientType();
        result = result * 59 + ($clientType == null ? 43 : ((Object)((Object)$clientType)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TpmSignVerifyRequestDto(data=" + this.getData() + ", signature=" + this.getSignature() + ", publicKey=" + this.getPublicKey() + ", isTpm=" + this.isTpm() + ", clientType=" + this.getClientType() + ")";
    }

    @Generated
    public TpmSignVerifyRequestDto(String data, String signature, String publicKey, boolean isTpm, ClientType clientType) {
        this.data = data;
        this.signature = signature;
        this.publicKey = publicKey;
        this.isTpm = isTpm;
        this.clientType = clientType;
    }

    @Generated
    public TpmSignVerifyRequestDto() {
    }
}

