/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.keymanager.hsm.impl.pkcs;

import io.mosip.kernel.core.exception.NoSuchAlgorithmException;
import io.mosip.kernel.core.keymanager.exception.KeystoreProcessingException;
import io.mosip.kernel.core.keymanager.exception.NoSuchSecurityProviderException;
import io.mosip.kernel.core.keymanager.model.CertificateParameters;
import io.mosip.kernel.core.logger.spi.Logger;
import io.mosip.kernel.keygenerator.bouncycastle.constant.KeyGeneratorExceptionConstant;
import io.mosip.kernel.keymanager.hsm.constant.KeymanagerErrorCode;
import io.mosip.kernel.keymanager.hsm.util.CertificateUtility;
import io.mosip.kernel.keymanagerservice.logger.KeymanagerLogger;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class PKCS12KeyStoreImpl
implements io.mosip.kernel.core.keymanager.spi.KeyStore {
    private static final Logger LOGGER = KeymanagerLogger.getLogger(PKCS12KeyStoreImpl.class);
    private String keystoreType = "PKCS12";
    private String p12FilePath;
    private String keystorePass;
    private String symmetricKeyAlgorithm;
    private int symmetricKeyLength;
    private String asymmetricKeyAlgorithm;
    private int asymmetricKeyLength;
    private String signAlgorithm;
    private KeyStore keyStore;
    private Provider provider = null;
    private char[] keystorePwdCharArr = null;
    private Map<String, KeyStore.PrivateKeyEntry> cachePrivateKeyEntries = new ConcurrentHashMap();

    public PKCS12KeyStoreImpl(Map<String, String> params) throws Exception {
        this.p12FilePath = params.get("CONFIG_FILE_PATH");
        this.keystorePass = params.get("PKCS11_KEYSTORE_PASSWORD");
        this.symmetricKeyAlgorithm = params.get("SYM_KEY_ALGORITHM");
        this.symmetricKeyLength = Integer.valueOf(params.get("SYM_KEY_SIZE"));
        this.asymmetricKeyAlgorithm = params.get("ASYM_KEY_ALGORITHM");
        this.asymmetricKeyLength = Integer.valueOf(params.get("ASYM_KEY_SIZE"));
        this.signAlgorithm = params.get("CERT_SIGN_ALGORITHM");
        this.initKeystore();
    }

    private void initKeystore() {
        this.keystorePwdCharArr = this.getKeystorePwd();
        this.provider = this.setupProvider();
        this.addProvider(this.provider);
        this.keyStore = this.getKeystoreInstance(this.keystoreType, this.p12FilePath, this.provider);
    }

    private char[] getKeystorePwd() {
        if (this.keystorePass.trim().length() == 0) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.NOT_VALID_STORE_PASSWORD.getErrorCode(), KeymanagerErrorCode.NOT_VALID_STORE_PASSWORD.getErrorMessage());
        }
        return this.keystorePass.toCharArray();
    }

    private Provider setupProvider() {
        return new BouncyCastleProvider();
    }

    private void addProvider(Provider provider) {
        Security.removeProvider(provider.getName());
        if (-1 == Security.addProvider(provider)) {
            throw new NoSuchSecurityProviderException(KeymanagerErrorCode.NO_SUCH_SECURITY_PROVIDER.getErrorCode(), KeymanagerErrorCode.NO_SUCH_SECURITY_PROVIDER.getErrorMessage());
        }
    }

    private KeyStore getKeystoreInstance(String keystoreType, String p12FilePath, Provider provider) {
        KeyStore mosipKeyStore = null;
        try {
            mosipKeyStore = KeyStore.getInstance(keystoreType);
            Path path = Paths.get(p12FilePath, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                mosipKeyStore.load(null, this.keystorePwdCharArr);
            } else {
                FileInputStream p12FileStream = new FileInputStream(p12FilePath);
                mosipKeyStore.load(p12FileStream, this.keystorePwdCharArr);
            }
            return mosipKeyStore;
        }
        catch (IOException | KeyStoreException | java.security.NoSuchAlgorithmException | CertificateException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + e.getMessage(), (Throwable)e);
        }
    }

    public List<String> getAllAlias() {
        Enumeration<String> enumeration = null;
        try {
            enumeration = this.keyStore.aliases();
        }
        catch (KeyStoreException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + e.getMessage(), (Throwable)e);
        }
        return Collections.list(enumeration);
    }

    public Key getKey(String alias) {
        Key key = null;
        try {
            key = this.keyStore.getKey(alias, this.keystorePwdCharArr);
        }
        catch (KeyStoreException | java.security.NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + e.getMessage(), (Throwable)e);
        }
        return key;
    }

    public KeyStore.PrivateKeyEntry getAsymmetricKey(String alias) {
        try {
            KeyStore.PrivateKeyEntry privateKeyEntry = this.cachePrivateKeyEntries.getOrDefault(alias, null);
            if (Objects.nonNull(privateKeyEntry)) {
                return privateKeyEntry;
            }
            if (this.keyStore.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class)) {
                LOGGER.debug("sessionId", "KeyStoreImpl", "getAsymmetricKey", "alias is instanceof keystore");
                KeyStore.PasswordProtection password = this.getPasswordProtection();
                privateKeyEntry = (KeyStore.PrivateKeyEntry)this.keyStore.getEntry(alias, password);
                this.cachePrivateKeyEntries.put(alias, privateKeyEntry);
                LOGGER.info("Key added in cache, key alias: " + alias);
                return privateKeyEntry;
            }
            throw new NoSuchSecurityProviderException(KeymanagerErrorCode.NO_SUCH_ALIAS.getErrorCode(), KeymanagerErrorCode.NO_SUCH_ALIAS.getErrorMessage() + alias);
        }
        catch (KeyStoreException | java.security.NoSuchAlgorithmException | UnrecoverableEntryException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + e.getMessage(), (Throwable)e);
        }
    }

    public PrivateKey getPrivateKey(String alias) {
        KeyStore.PrivateKeyEntry privateKeyEntry = this.getAsymmetricKey(alias);
        return privateKeyEntry.getPrivateKey();
    }

    public PublicKey getPublicKey(String alias) {
        KeyStore.PrivateKeyEntry privateKeyEntry = this.getAsymmetricKey(alias);
        Certificate[] certificates = privateKeyEntry.getCertificateChain();
        return certificates[0].getPublicKey();
    }

    public X509Certificate getCertificate(String alias) {
        KeyStore.PrivateKeyEntry privateKeyEntry = this.getAsymmetricKey(alias);
        X509Certificate[] certificates = (X509Certificate[])privateKeyEntry.getCertificateChain();
        return certificates[0];
    }

    public SecretKey getSymmetricKey(String alias) {
        try {
            if (this.keyStore.entryInstanceOf(alias, KeyStore.SecretKeyEntry.class)) {
                KeyStore.PasswordProtection password = this.getPasswordProtection();
                KeyStore.SecretKeyEntry retrivedSecret = (KeyStore.SecretKeyEntry)this.keyStore.getEntry(alias, password);
                return retrivedSecret.getSecretKey();
            }
            throw new NoSuchSecurityProviderException(KeymanagerErrorCode.NO_SUCH_ALIAS.getErrorCode(), KeymanagerErrorCode.NO_SUCH_ALIAS.getErrorMessage() + alias);
        }
        catch (KeyStoreException | java.security.NoSuchAlgorithmException | UnrecoverableEntryException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + e.getMessage(), (Throwable)e);
        }
    }

    public void deleteKey(String alias) {
        try {
            this.keyStore.deleteEntry(alias);
        }
        catch (KeyStoreException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + e.getMessage(), (Throwable)e);
        }
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public void generateAndStoreAsymmetricKey(String alias, String signKeyAlias, CertificateParameters certParams) {
        KeyPair keyPair = null;
        PrivateKey signPrivateKey = null;
        X500Principal signerPrincipal = null;
        if (Objects.nonNull(signKeyAlias)) {
            KeyStore.PrivateKeyEntry signKeyEntry = this.getAsymmetricKey(signKeyAlias);
            signPrivateKey = signKeyEntry.getPrivateKey();
            X509Certificate signCert = (X509Certificate)signKeyEntry.getCertificate();
            signerPrincipal = signCert.getSubjectX500Principal();
            keyPair = this.generateKeyPair();
        } else {
            keyPair = this.generateKeyPair();
            signPrivateKey = keyPair.getPrivate();
        }
        X509Certificate x509Cert = CertificateUtility.generateX509Certificate((PrivateKey)signPrivateKey, (PublicKey)keyPair.getPublic(), (CertificateParameters)certParams, (X500Principal)signerPrincipal, (String)this.signAlgorithm, (String)this.provider.getName());
        Certificate[] chain = new X509Certificate[]{x509Cert};
        this.storeCertificate(alias, chain, keyPair.getPrivate());
    }

    private void storeCertificate(String alias, Certificate[] chain, PrivateKey privateKey) {
        KeyStore.PrivateKeyEntry privateKeyEntry = new KeyStore.PrivateKeyEntry(privateKey, chain);
        KeyStore.PasswordProtection password = this.getPasswordProtection();
        try {
            this.keyStore.setEntry(alias, privateKeyEntry, password);
            this.storeKeyInFile();
        }
        catch (KeyStoreException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + e.getMessage());
        }
    }

    public void generateAndStoreSymmetricKey(String alias) {
        SecretKey secretKey = this.generateSymmetricKey();
        KeyStore.SecretKeyEntry secret = new KeyStore.SecretKeyEntry(secretKey);
        KeyStore.PasswordProtection password = this.getPasswordProtection();
        try {
            this.keyStore.setEntry(alias, secret, password);
            this.storeKeyInFile();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + e.getMessage(), (Throwable)e);
        }
    }

    private KeyPair generateKeyPair() {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance(this.asymmetricKeyAlgorithm);
            SecureRandom random = new SecureRandom();
            generator.initialize(this.asymmetricKeyLength, random);
            return generator.generateKeyPair();
        }
        catch (java.security.NoSuchAlgorithmException e) {
            throw new NoSuchAlgorithmException(KeyGeneratorExceptionConstant.MOSIP_NO_SUCH_ALGORITHM_EXCEPTION.getErrorCode(), KeyGeneratorExceptionConstant.MOSIP_NO_SUCH_ALGORITHM_EXCEPTION.getErrorMessage(), (Throwable)e);
        }
    }

    private SecretKey generateSymmetricKey() {
        try {
            KeyGenerator generator = KeyGenerator.getInstance(this.symmetricKeyAlgorithm, this.provider);
            SecureRandom random = new SecureRandom();
            generator.init(this.symmetricKeyLength, random);
            return generator.generateKey();
        }
        catch (java.security.NoSuchAlgorithmException e) {
            throw new NoSuchAlgorithmException(KeyGeneratorExceptionConstant.MOSIP_NO_SUCH_ALGORITHM_EXCEPTION.getErrorCode(), KeyGeneratorExceptionConstant.MOSIP_NO_SUCH_ALGORITHM_EXCEPTION.getErrorMessage(), (Throwable)e);
        }
    }

    public void storeCertificate(String alias, PrivateKey privateKey, Certificate certificate) {
        try {
            KeyStore.PrivateKeyEntry privateKeyEntry = new KeyStore.PrivateKeyEntry(privateKey, new Certificate[]{certificate});
            KeyStore.PasswordProtection password = this.getPasswordProtection();
            this.keyStore.setEntry(alias, privateKeyEntry, password);
            this.storeKeyInFile();
        }
        catch (KeyStoreException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + e.getMessage(), (Throwable)e);
        }
    }

    public String getKeystoreProviderName() {
        if (Objects.nonNull(this.keyStore)) {
            return this.provider.getName();
        }
        throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_NOT_INSTANTIATED.getErrorCode(), KeymanagerErrorCode.KEYSTORE_NOT_INSTANTIATED.getErrorMessage());
    }

    private KeyStore.PasswordProtection getPasswordProtection() {
        if (this.keystorePwdCharArr == null) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.NOT_VALID_STORE_PASSWORD.getErrorCode(), KeymanagerErrorCode.NOT_VALID_STORE_PASSWORD.getErrorMessage());
        }
        return new KeyStore.PasswordProtection(this.keystorePwdCharArr);
    }

    private void storeKeyInFile() {
        try {
            Path parentPath = Paths.get(this.p12FilePath, new String[0]).getParent();
            if (parentPath != null && !Files.exists(parentPath, new LinkOption[0])) {
                Files.createDirectories(parentPath, new FileAttribute[0]);
            }
            FileOutputStream outputStream = null;
            if (this.keyStore.getType().equals("PKCS12")) {
                outputStream = new FileOutputStream(this.p12FilePath);
            }
            this.keyStore.store(outputStream, this.keystorePwdCharArr);
        }
        catch (IOException | KeyStoreException | java.security.NoSuchAlgorithmException | CertificateException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + e.getMessage(), (Throwable)e);
        }
    }
}

