/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.keymanagerservice.helper;

import io.mosip.kernel.core.crypto.exception.InvalidDataException;
import io.mosip.kernel.core.crypto.exception.InvalidKeyException;
import io.mosip.kernel.core.crypto.exception.NullDataException;
import io.mosip.kernel.core.crypto.exception.NullKeyException;
import io.mosip.kernel.core.crypto.exception.NullMethodException;
import io.mosip.kernel.core.crypto.spi.CryptoCoreSpec;
import io.mosip.kernel.core.keymanager.spi.KeyStore;
import io.mosip.kernel.core.logger.spi.Logger;
import io.mosip.kernel.core.util.CryptoUtil;
import io.mosip.kernel.core.util.DateUtils;
import io.mosip.kernel.cryptomanager.util.CryptomanagerUtils;
import io.mosip.kernel.keymanagerservice.constant.KeymanagerErrorConstant;
import io.mosip.kernel.keymanagerservice.dto.SymmetricKeyRequestDto;
import io.mosip.kernel.keymanagerservice.dto.SymmetricKeyResponseDto;
import io.mosip.kernel.keymanagerservice.entity.KeyAlias;
import io.mosip.kernel.keymanagerservice.exception.CryptoException;
import io.mosip.kernel.keymanagerservice.exception.KeymanagerServiceException;
import io.mosip.kernel.keymanagerservice.exception.NoUniqueAliasException;
import io.mosip.kernel.keymanagerservice.helper.KeymanagerDBHelper;
import io.mosip.kernel.keymanagerservice.logger.KeymanagerLogger;
import io.mosip.kernel.keymanagerservice.util.KeymanagerUtil;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.SecretKey;
import org.bouncycastle.util.encoders.Hex;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SessionKeyDecrytorHelper {
    private static final Logger LOGGER = KeymanagerLogger.getLogger(SessionKeyDecrytorHelper.class);
    @Value(value="${mosip.kernel.keymanager.113nothumbprint.support:false}")
    private boolean noThumbprint;
    @Autowired
    private CryptoCoreSpec<byte[], byte[], SecretKey, PublicKey, PrivateKey, String> cryptoCore;
    @Autowired
    KeymanagerUtil keymanagerUtil;
    @Autowired
    private KeymanagerDBHelper dbHelper;
    @Autowired
    CryptomanagerUtils cryptomanagerUtil;
    @Autowired
    private KeyStore keyStore;
    private Map<String, io.mosip.kernel.keymanagerservice.entity.KeyStore> cacheKeyStore = new ConcurrentHashMap<String, io.mosip.kernel.keymanagerservice.entity.KeyStore>();
    private Map<String, String> cacheReferenceIds = new ConcurrentHashMap<String, String>();

    public SymmetricKeyResponseDto decryptSessionKey(SymmetricKeyRequestDto symmetricKeyRequestDto) {
        LocalDateTime localDateTimeStamp = DateUtils.getUTCCurrentDateTime();
        String applicationId = symmetricKeyRequestDto.getApplicationId();
        String referenceId = symmetricKeyRequestDto.getReferenceId();
        LOGGER.info("sessionId", "symmetricKeyRequestDto", symmetricKeyRequestDto.getApplicationId(), "Request Application Id: " + applicationId);
        LOGGER.info("sessionId", "symmetricKeyRequestDto", symmetricKeyRequestDto.getApplicationId(), "Request Reference Id: " + referenceId);
        Boolean reqPrependThumbprint = symmetricKeyRequestDto.getPrependThumbprint();
        LOGGER.info("sessionId", "symmetricKeyRequestDto", symmetricKeyRequestDto.getApplicationId(), "prependThumbprint Value(Request): " + reqPrependThumbprint);
        boolean prependThumbprint = reqPrependThumbprint == null ? false : symmetricKeyRequestDto.getPrependThumbprint();
        LOGGER.info("sessionId", "symmetricKeyRequestDto", symmetricKeyRequestDto.getApplicationId(), "prependThumbprint Value: " + prependThumbprint);
        LOGGER.info("sessionId", "symmetricKeyRequestDto", symmetricKeyRequestDto.getApplicationId(), "1.1.3 Thumbprint support property flag: " + this.noThumbprint);
        byte[] encryptedData = CryptoUtil.decodeBase64((String)symmetricKeyRequestDto.getEncryptedSymmetricKey());
        if (this.noThumbprint) {
            return this.decryptSymmetricKeyNoKeyIdentifier(applicationId, referenceId, encryptedData, localDateTimeStamp);
        }
        return this.decryptSymmetricKeyWithKeyIdentifier(applicationId, referenceId, encryptedData, localDateTimeStamp);
    }

    private SymmetricKeyResponseDto decryptSymmetricKeyWithKeyIdentifier(String applicationId, String referenceId, byte[] encryptedData, LocalDateTime localDateTimeStamp) {
        String cachedRefId;
        byte[] certThumbprint = Arrays.copyOfRange(encryptedData, 0, 32);
        byte[] encryptedSymmetricKey = Arrays.copyOfRange(encryptedData, 32, encryptedData.length);
        String certThumbprintHex = Hex.toHexString((byte[])certThumbprint).toUpperCase();
        io.mosip.kernel.keymanagerservice.entity.KeyStore dbKeyStore = this.cacheKeyStore.getOrDefault(certThumbprintHex, null);
        String appIdRefIdKey = applicationId + "-" + referenceId;
        String compMasterKeyRefId = applicationId + "-COMP_MASTER";
        if (Objects.isNull(dbKeyStore)) {
            dbKeyStore = this.dbHelper.getKeyAlias(certThumbprintHex, appIdRefIdKey);
            this.cacheKeyStore.put(certThumbprintHex, dbKeyStore);
            if (Objects.isNull(dbKeyStore.getPrivateKey())) {
                this.cacheReferenceIds.put(certThumbprintHex, compMasterKeyRefId);
            } else {
                this.cacheReferenceIds.put(certThumbprintHex, appIdRefIdKey);
            }
        }
        if (!appIdRefIdKey.equals(cachedRefId = (String)this.cacheReferenceIds.getOrDefault(certThumbprintHex, null)) && !compMasterKeyRefId.equals(cachedRefId)) {
            LOGGER.error("sessionId", "", "", "Application Id & Reference ID not matching with the input thumbprint value(decrypt).");
            throw new KeymanagerServiceException(KeymanagerErrorConstant.APP_ID_REFERENCE_ID_NOT_MATCHING.getErrorCode(), KeymanagerErrorConstant.APP_ID_REFERENCE_ID_NOT_MATCHING.getErrorMessage());
        }
        SymmetricKeyResponseDto keyResponseDto = new SymmetricKeyResponseDto();
        byte[] decryptedSymmetricKey = this.decryptSessionKeyWithCertificateThumbprint(dbKeyStore, encryptedSymmetricKey, referenceId);
        keyResponseDto.setSymmetricKey(CryptoUtil.encodeBase64((byte[])decryptedSymmetricKey));
        return keyResponseDto;
    }

    private byte[] decryptSessionKeyWithCertificateThumbprint(io.mosip.kernel.keymanagerservice.entity.KeyStore dbKeyStore, byte[] encryptedSymmetricKey, String referenceId) {
        Object[] keys = this.getKeyObjects(dbKeyStore);
        PrivateKey privateKey = (PrivateKey)keys[0];
        PublicKey publicKey = ((Certificate)keys[1]).getPublicKey();
        try {
            byte[] decryptedSessionKey = (byte[])this.cryptoCore.asymmetricDecrypt((Object)privateKey, (Object)publicKey, (Object)encryptedSymmetricKey);
            if (this.keymanagerUtil.isValidReferenceId(referenceId)) {
                this.keymanagerUtil.destoryKey(privateKey);
            }
            return decryptedSessionKey;
        }
        catch (InvalidKeyException keyExp) {
            LOGGER.error("sessionId", "applicationId", "referenceId", "Error occurred because of mismatch with keys. Try with keys for decryption.");
            throw new CryptoException(KeymanagerErrorConstant.SYMMETRIC_KEY_DECRYPTION_FAILED.getErrorCode(), KeymanagerErrorConstant.SYMMETRIC_KEY_DECRYPTION_FAILED.getErrorMessage() + keyExp.getMessage(), keyExp);
        }
    }

    private Object[] getKeyObjects(io.mosip.kernel.keymanagerservice.entity.KeyStore dbKeyStore) {
        String ksAlias = dbKeyStore.getAlias();
        String privateKeyObj = dbKeyStore.getPrivateKey();
        if (Objects.isNull(privateKeyObj)) {
            LOGGER.info("sessionId", "", "", "Private not found in key store. Getting private key from HSM.");
            KeyStore.PrivateKeyEntry masterKeyEntry = this.keyStore.getAsymmetricKey(ksAlias);
            PrivateKey masterPrivateKey = masterKeyEntry.getPrivateKey();
            Certificate masterCert = masterKeyEntry.getCertificate();
            return new Object[]{masterPrivateKey, masterCert};
        }
        String masterKeyAlias = dbKeyStore.getMasterAlias();
        if (ksAlias.equals(masterKeyAlias) || privateKeyObj.equals("NA")) {
            LOGGER.error("sessionId", "applicationId", null, "Not Allowed to perform decryption with other domain key.");
            throw new KeymanagerServiceException(KeymanagerErrorConstant.DECRYPTION_NOT_ALLOWED.getErrorCode(), KeymanagerErrorConstant.DECRYPTION_NOT_ALLOWED.getErrorMessage());
        }
        KeyStore.PrivateKeyEntry masterKeyEntry = this.keyStore.getAsymmetricKey(dbKeyStore.getMasterAlias());
        PrivateKey masterPrivateKey = masterKeyEntry.getPrivateKey();
        PublicKey masterPublicKey = masterKeyEntry.getCertificate().getPublicKey();
        try {
            byte[] decryptedPrivateKey = this.keymanagerUtil.decryptKey(CryptoUtil.decodeBase64((String)dbKeyStore.getPrivateKey()), masterPrivateKey, masterPublicKey);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(decryptedPrivateKey));
            Certificate certificate = this.keymanagerUtil.convertToCertificate(dbKeyStore.getCertificateData());
            return new Object[]{privateKey, certificate};
        }
        catch (InvalidDataException | InvalidKeyException | NullDataException | NullKeyException | NullMethodException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new CryptoException(KeymanagerErrorConstant.CRYPTO_EXCEPTION.getErrorCode(), KeymanagerErrorConstant.CRYPTO_EXCEPTION.getErrorMessage() + e.getMessage(), e);
        }
    }

    private Object[] getKeyObjects(List<KeyAlias> keyAlias, List<KeyAlias> currentKeyAlias, LocalDateTime timeStamp, String referenceId, byte[] reqCertThumbprint, String applicationId) {
        if (currentKeyAlias.size() == 1) {
            LOGGER.info("sessionId", "currentKeyAlias", currentKeyAlias.get(0).getAlias(), "CurrentKeyAlias size is one. Will decrypt symmetric key with this alias after thumbprint matches.");
            KeyAlias fetchedKeyAlias = currentKeyAlias.get(0);
            Object[] keys = this.getPrivateKey(referenceId, fetchedKeyAlias);
            if (reqCertThumbprint == null) {
                return keys;
            }
            Certificate certificate = (Certificate)keys[1];
            byte[] certThumbprint = this.cryptomanagerUtil.getCertificateThumbprint(certificate);
            if (Arrays.equals(reqCertThumbprint, certThumbprint)) {
                return keys;
            }
        }
        if ((keyAlias.isEmpty() || currentKeyAlias.size() > 1) && reqCertThumbprint == null) {
            LOGGER.error("sessionId", "currentKeyAlias", String.valueOf(currentKeyAlias.size()), "KeyAlias is empty or current key alias is not unique & certificate thumbprint is null. Throwing exception");
            throw new NoUniqueAliasException(KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorCode(), KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorMessage());
        }
        LOGGER.info("sessionId", "keyAlias", "", "CurrentKeyAlias size is zero or thumbprint not matched now checking other expired key aliases to compare thumbprint.");
        for (KeyAlias otherAlias : keyAlias) {
            Object[] keys = this.getPrivateKey(referenceId, otherAlias);
            Certificate certificate = (Certificate)keys[1];
            byte[] certThumbprint = this.cryptomanagerUtil.getCertificateThumbprint(certificate);
            if (!Arrays.equals(reqCertThumbprint, certThumbprint)) continue;
            return keys;
        }
        LOGGER.info("sessionId", "keyAlias", "", "Base key certificate thumbprint did not matched with thumbprint in encrypted data, Checking thumbprint match with master key.");
        Map<String, List<KeyAlias>> keyAliasMap = this.dbHelper.getKeyAliases(applicationId, "", timeStamp);
        List<KeyAlias> masterKeyAlias = keyAliasMap.get("keyAlias");
        for (KeyAlias masterAlias : masterKeyAlias) {
            Object[] keys = this.getPrivateKey("", masterAlias);
            Certificate certificate = (Certificate)keys[1];
            byte[] certThumbprint = this.cryptomanagerUtil.getCertificateThumbprint(certificate);
            if (!Arrays.equals(reqCertThumbprint, certThumbprint)) continue;
            return keys;
        }
        LOGGER.error("sessionId", "keyAlias", "", "No Key Alias for the thumbprint provided (After comparing all thumbprints), Throwing exception");
        throw new NoUniqueAliasException(KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorCode(), KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorMessage());
    }

    private Object[] getPrivateKey(String referenceId, KeyAlias fetchedKeyAlias) {
        LOGGER.info("sessionId", "referenceId", referenceId, "Getting private key");
        LOGGER.info("sessionId", "fetchedKeyAlias", fetchedKeyAlias.getAlias(), "Getting private key");
        if (!this.keymanagerUtil.isValidReferenceId(referenceId)) {
            LOGGER.info("sessionId", "", "", "Not valid reference Id. Getting private key from HSM.");
            KeyStore.PrivateKeyEntry masterKeyEntry = this.keyStore.getAsymmetricKey(fetchedKeyAlias.getAlias());
            PrivateKey masterPrivateKey = masterKeyEntry.getPrivateKey();
            Certificate masterCert = masterKeyEntry.getCertificate();
            return new Object[]{masterPrivateKey, masterCert};
        }
        LOGGER.info("sessionId", "", "", "Valid reference Id. Getting private key from DB Store");
        String ksAlias = fetchedKeyAlias.getAlias();
        Optional<io.mosip.kernel.keymanagerservice.entity.KeyStore> dbKeyStore = this.dbHelper.getKeyStoreFromDB(ksAlias);
        if (!dbKeyStore.isPresent()) {
            LOGGER.error("sessionId", "keyFromDBStore", dbKeyStore.toString(), "Key in DBStore does not exist for this alias. Throwing exception");
            throw new NoUniqueAliasException(KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorCode(), KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorMessage());
        }
        String masterKeyAlias = dbKeyStore.get().getMasterAlias();
        String privateKeyObj = dbKeyStore.get().getPrivateKey();
        if (ksAlias.equals(masterKeyAlias) || privateKeyObj.equals("NA")) {
            LOGGER.error("sessionId", "applicationId", null, "Not Allowed to perform decryption with other domain key.");
            throw new KeymanagerServiceException(KeymanagerErrorConstant.DECRYPTION_NOT_ALLOWED.getErrorCode(), KeymanagerErrorConstant.DECRYPTION_NOT_ALLOWED.getErrorMessage());
        }
        KeyStore.PrivateKeyEntry masterKeyEntry = this.keyStore.getAsymmetricKey(dbKeyStore.get().getMasterAlias());
        PrivateKey masterPrivateKey = masterKeyEntry.getPrivateKey();
        PublicKey masterPublicKey = masterKeyEntry.getCertificate().getPublicKey();
        try {
            byte[] decryptedPrivateKey = this.keymanagerUtil.decryptKey(CryptoUtil.decodeBase64((String)dbKeyStore.get().getPrivateKey()), masterPrivateKey, masterPublicKey);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(decryptedPrivateKey));
            Certificate certificate = this.keymanagerUtil.convertToCertificate(dbKeyStore.get().getCertificateData());
            return new Object[]{privateKey, certificate};
        }
        catch (InvalidDataException | InvalidKeyException | NullDataException | NullKeyException | NullMethodException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new CryptoException(KeymanagerErrorConstant.CRYPTO_EXCEPTION.getErrorCode(), KeymanagerErrorConstant.CRYPTO_EXCEPTION.getErrorMessage() + e.getMessage(), e);
        }
    }

    private SymmetricKeyResponseDto decryptSymmetricKeyNoKeyIdentifier(String applicationId, String referenceId, byte[] encryptedData, LocalDateTime localDateTimeStamp) {
        byte[] certThumbprint = null;
        byte[] encryptedSymmetricKey = null;
        boolean prependThumbprint = false;
        if (encryptedData.length == 288) {
            return this.decryptSymmetricKeyWithKeyIdentifier(applicationId, referenceId, encryptedData, localDateTimeStamp);
        }
        encryptedSymmetricKey = encryptedData;
        SymmetricKeyResponseDto keyResponseDto = new SymmetricKeyResponseDto();
        byte[] decryptedSymmetricKey = this.decryptSessionKeyNoKeyIdentifier(applicationId, referenceId, localDateTimeStamp, encryptedSymmetricKey, certThumbprint, prependThumbprint);
        keyResponseDto.setSymmetricKey(CryptoUtil.encodeBase64((byte[])decryptedSymmetricKey));
        return keyResponseDto;
    }

    private byte[] decryptSessionKeyNoKeyIdentifier(String applicationId, String referenceId, LocalDateTime localDateTimeStamp, byte[] encryptedSymmetricKey, byte[] certThumbprint, boolean packetTPFlag) {
        Map<String, List<KeyAlias>> keyAliasMap;
        if (!this.keymanagerUtil.isValidReferenceId(referenceId)) {
            LOGGER.info("sessionId", "", "", "Not a valid reference Id. Getting key alias without referenceId");
            keyAliasMap = this.dbHelper.getKeyAliases(applicationId, "", localDateTimeStamp);
        } else {
            LOGGER.info("sessionId", "", "", "Valid reference Id. Getting key alias with referenceId");
            keyAliasMap = this.dbHelper.getKeyAliases(applicationId, referenceId, localDateTimeStamp);
        }
        List<KeyAlias> keyAlias = keyAliasMap.get("keyAlias");
        List<KeyAlias> currentKeyAlias = keyAliasMap.get("currentKeyAlias");
        InvalidKeyException keyException = null;
        InvalidDataException dataException = null;
        Object[] keys = this.getPrivateKeyNoKeyIdentifier(keyAlias, currentKeyAlias, localDateTimeStamp, referenceId, certThumbprint, packetTPFlag, applicationId);
        PrivateKey privateKey = (PrivateKey)keys[0];
        PublicKey publicKey = ((Certificate)keys[1]).getPublicKey();
        try {
            byte[] decryptedSessionKey = (byte[])this.cryptoCore.asymmetricDecrypt((Object)privateKey, (Object)publicKey, (Object)encryptedSymmetricKey);
            return decryptedSessionKey;
        }
        catch (InvalidKeyException keyExp) {
            LOGGER.error("sessionId", "applicationId", "referenceId", "Error occurred because of mismatch with keys. Try with keys for decryption.");
            keyException = keyExp;
        }
        catch (InvalidDataException dataExp) {
            LOGGER.error("sessionId", "applicationId", "referenceId", "Error occurred because of mismatch with keys. Try with other current key for decryption.");
            dataException = dataExp;
        }
        LOGGER.info("sessionId", "applicationId", "referenceId", "Unable to decrypt session key with all the other validations, trying the keys available for provided AppId & RefId.");
        try {
            return this.decryptWithKeyAlias(keyAlias, referenceId, encryptedSymmetricKey);
        }
        catch (InvalidKeyException keyExp) {
            keyException = keyExp;
        }
        catch (InvalidDataException dataExp) {
            dataException = dataExp;
        }
        LOGGER.info("sessionId", "applicationId", "referenceId", "Unable to decrypt session key with all the base keys, trying with master keys available for provided AppId.");
        Map<String, List<KeyAlias>> masterKeyAliasMap = this.dbHelper.getKeyAliases(applicationId, "", localDateTimeStamp);
        List<KeyAlias> masterKeyAlias = masterKeyAliasMap.get("keyAlias");
        try {
            return this.decryptWithKeyAlias(masterKeyAlias, "", encryptedSymmetricKey);
        }
        catch (InvalidKeyException keyExp) {
            keyException = keyExp;
        }
        catch (InvalidDataException dataExp) {
            dataException = dataExp;
        }
        if (keyException == null) {
            throw dataException;
        }
        throw keyException;
    }

    private Object[] getPrivateKeyNoKeyIdentifier(List<KeyAlias> keyAlias, List<KeyAlias> currentKeyAlias, LocalDateTime timeStamp, String referenceId, byte[] reqCertThumbprint, boolean packetTPFlag, String applicationId) {
        List<KeyAlias> keyAliasCp = keyAlias;
        List<KeyAlias> currentKeyAliasCp = currentKeyAlias;
        if (keyAlias.isEmpty()) {
            Map<String, List<KeyAlias>> keyAliasMap = this.dbHelper.getKeyAliases(applicationId, "", timeStamp);
            keyAliasCp = keyAliasMap.get("keyAlias");
            currentKeyAliasCp = keyAliasMap.get("currentKeyAlias");
            if (keyAliasCp.isEmpty()) {
                LOGGER.error("sessionId", "keyAlias", String.valueOf(keyAlias.size()), "KeyAlias is empty(no Key Identifier) Throwing exception");
                throw new NoUniqueAliasException(KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorCode(), KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorMessage());
            }
            if (this.keymanagerUtil.isValidReferenceId(referenceId)) {
                referenceId = "";
            }
        }
        if (Objects.isNull(reqCertThumbprint) && !packetTPFlag) {
            LOGGER.info("sessionId", "currentKeyAlias", keyAliasCp.get(0).getAlias(), "Thumbprint is value is null and packet Thumbprint Flag is false.");
            KeyAlias fetchedKeyAlias = keyAliasCp.get(0);
            return this.getPrivateKey(referenceId, fetchedKeyAlias);
        }
        return this.getKeyObjects(keyAliasCp, currentKeyAliasCp, timeStamp, referenceId, reqCertThumbprint, applicationId);
    }

    private byte[] decryptWithKeyAlias(List<KeyAlias> keyAlias, String referenceId, byte[] encryptedSymmetricKey) {
        InvalidKeyException keyException = null;
        InvalidDataException dataException = null;
        for (KeyAlias alias : keyAlias) {
            Object[] dbKeys = this.getPrivateKey(referenceId, alias);
            PrivateKey dbPrivateKey = (PrivateKey)dbKeys[0];
            PublicKey dbPublicKey = ((Certificate)dbKeys[1]).getPublicKey();
            try {
                byte[] decryptedSessionKey = (byte[])this.cryptoCore.asymmetricDecrypt((Object)dbPrivateKey, (Object)dbPublicKey, (Object)encryptedSymmetricKey);
                if (this.keymanagerUtil.isValidReferenceId(referenceId)) {
                    this.keymanagerUtil.destoryKey(dbPrivateKey);
                }
                return decryptedSessionKey;
            }
            catch (InvalidKeyException keyExp) {
                LOGGER.error("sessionId", "applicationId", "referenceId", "Error occurred because of mismatch with keys. Try with other current key for decryption. key Alias: " + alias);
                keyException = keyExp;
            }
            catch (InvalidDataException dataExp) {
                LOGGER.error("sessionId", "applicationId", "referenceId", "Error occurred because of mismatch with keys. Try with other current key for decryption. key Alias: " + alias);
                dataException = dataExp;
            }
        }
        if (keyException == null) {
            throw dataException;
        }
        throw keyException;
    }
}

