/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.keymanagerservice.helper;

import io.mosip.kernel.core.keymanager.spi.KeyStore;
import io.mosip.kernel.core.logger.spi.Logger;
import io.mosip.kernel.cryptomanager.util.CryptomanagerUtils;
import io.mosip.kernel.keymanagerservice.constant.KeymanagerErrorConstant;
import io.mosip.kernel.keymanagerservice.entity.KeyAlias;
import io.mosip.kernel.keymanagerservice.entity.KeyPolicy;
import io.mosip.kernel.keymanagerservice.exception.InvalidApplicationIdException;
import io.mosip.kernel.keymanagerservice.exception.KeymanagerServiceException;
import io.mosip.kernel.keymanagerservice.logger.KeymanagerLogger;
import io.mosip.kernel.keymanagerservice.repository.KeyAliasRepository;
import io.mosip.kernel.keymanagerservice.repository.KeyPolicyRepository;
import io.mosip.kernel.keymanagerservice.repository.KeyStoreRepository;
import io.mosip.kernel.keymanagerservice.util.KeymanagerUtil;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class KeymanagerDBHelper {
    private static final Logger LOGGER = KeymanagerLogger.getLogger(KeymanagerDBHelper.class);
    @Value(value="${mosip.sign-certificate-refid:SIGN}")
    private String signRefId;
    @Autowired
    KeyAliasRepository keyAliasRepository;
    @Autowired
    KeyPolicyRepository keyPolicyRepository;
    @Autowired
    KeyStoreRepository keyStoreRepository;
    @Autowired
    KeymanagerUtil keymanagerUtil;
    @Autowired
    KeyStore keyStore;
    @Autowired
    CryptomanagerUtils cryptomanagerUtil;

    public void storeKeyInAlias(String applicationId, LocalDateTime timeStamp, String referenceId, String alias, LocalDateTime expiryDateTime, String certThumbprint) {
        LOGGER.info("sessionId", "", "", "Storing key in KeyAlias");
        KeyAlias keyAlias = new KeyAlias();
        keyAlias.setAlias(alias);
        keyAlias.setApplicationId(applicationId);
        keyAlias.setReferenceId(referenceId);
        keyAlias.setKeyGenerationTime(timeStamp);
        keyAlias.setKeyExpiryTime(expiryDateTime);
        keyAlias.setCertThumbprint(certThumbprint);
        this.keyAliasRepository.saveAndFlush(this.keymanagerUtil.setMetaData(keyAlias));
    }

    public void storeKeyInDBStore(String alias, String masterAlias, String certificateData, String encryptedPrivateKey) {
        io.mosip.kernel.keymanagerservice.entity.KeyStore dbKeyStore = new io.mosip.kernel.keymanagerservice.entity.KeyStore();
        LOGGER.info("sessionId", "", "", "Storing key in dbKeyStore");
        dbKeyStore.setAlias(alias);
        dbKeyStore.setMasterAlias(masterAlias);
        dbKeyStore.setCertificateData(certificateData);
        dbKeyStore.setPrivateKey(encryptedPrivateKey);
        this.keyStoreRepository.saveAndFlush(this.keymanagerUtil.setMetaData(dbKeyStore));
    }

    public Map<String, List<KeyAlias>> getKeyAliases(String applicationId, String referenceId, LocalDateTime timeStamp) {
        LOGGER.info("sessionId", "", "", "Getting key alias");
        HashMap<String, List<KeyAlias>> hashmap = new HashMap<String, List<KeyAlias>>();
        List keyAliases = this.keyAliasRepository.findByApplicationIdAndReferenceId(applicationId, referenceId).stream().sorted((alias1, alias2) -> alias1.getKeyGenerationTime().compareTo(alias2.getKeyGenerationTime())).collect(Collectors.toList());
        List currentKeyAliases = keyAliases.stream().filter(keyAlias -> this.keymanagerUtil.isValidTimestamp(timeStamp, (KeyAlias)keyAlias)).collect(Collectors.toList());
        LOGGER.info("sessionId", "keyAlias", Arrays.toString(keyAliases.toArray()), "keyAlias");
        LOGGER.info("sessionId", "currentKeyAlias", Arrays.toString(currentKeyAliases.toArray()), "currentKeyAlias");
        hashmap.put("keyAlias", keyAliases);
        hashmap.put("currentKeyAlias", currentKeyAliases);
        return hashmap;
    }

    public LocalDateTime getExpiryPolicy(String applicationId, LocalDateTime timeStamp, List<KeyAlias> keyAlias) {
        LOGGER.info("sessionId", "applicationId", applicationId, "Getting expiry policy");
        Optional<KeyPolicy> keyPolicy = this.keyPolicyRepository.findByApplicationId(applicationId);
        if (!keyPolicy.isPresent()) {
            LOGGER.info("sessionId", "keyPolicy", keyPolicy.toString(), "Key Policy not found for this application Id. Throwing exception");
            throw new InvalidApplicationIdException(KeymanagerErrorConstant.APPLICATIONID_NOT_VALID.getErrorCode(), KeymanagerErrorConstant.APPLICATIONID_NOT_VALID.getErrorMessage());
        }
        LocalDateTime policyExpiryTime = timeStamp.plusDays(keyPolicy.get().getValidityInDays());
        if (!keyAlias.isEmpty()) {
            LOGGER.info("sessionId", "keyAlias", String.valueOf(keyAlias.size()), "Getting expiry policy. KeyAlias exists");
            for (KeyAlias alias : keyAlias) {
                if (!this.keymanagerUtil.isOverlapping(timeStamp, policyExpiryTime, alias.getKeyGenerationTime(), alias.getKeyExpiryTime())) continue;
                LOGGER.info("sessionId", "", "", "Overlapping timestamp found. Changing policyExpiryTime");
                policyExpiryTime = alias.getKeyGenerationTime().minusSeconds(1L);
                break;
            }
        }
        return policyExpiryTime;
    }

    public Optional<io.mosip.kernel.keymanagerservice.entity.KeyStore> getKeyStoreFromDB(String keyAlias) {
        Optional<io.mosip.kernel.keymanagerservice.entity.KeyStore> dbKeyStore = this.keyStoreRepository.findByAlias(keyAlias);
        return dbKeyStore;
    }

    public Optional<KeyPolicy> getKeyPolicy(String applicationId) {
        Optional<KeyPolicy> keyPolicy = this.keyPolicyRepository.findByApplicationIdAndIsActive(applicationId, true);
        if (!keyPolicy.isPresent()) {
            LOGGER.error("sessionId", "keyPolicy", keyPolicy.toString(), "Key Policy not found for this application Id.");
            throw new InvalidApplicationIdException(KeymanagerErrorConstant.APPLICATIONID_NOT_VALID.getErrorCode(), KeymanagerErrorConstant.APPLICATIONID_NOT_VALID.getErrorMessage());
        }
        return keyPolicy;
    }

    public io.mosip.kernel.keymanagerservice.entity.KeyStore getKeyAlias(String certThumbprint, String appIdRefIdKey) {
        List<KeyAlias> keyAliases = this.keyAliasRepository.findByCertThumbprint(certThumbprint);
        if (keyAliases.isEmpty()) {
            LOGGER.info("sessionId", "", "", "key alias not found for the provided thumbprint, may be cert thumbprint is not updated. Adding thumbprint(s) now.");
            this.addCertificateThumbprints();
            keyAliases = this.keyAliasRepository.findByCertThumbprint(certThumbprint);
        }
        if (keyAliases.size() > 1) {
            LOGGER.error("sessionId", "", "", "More than one key alias found for the provided thumbprint.");
            throw new KeymanagerServiceException(KeymanagerErrorConstant.MORE_THAN_ONE_KEY_FOUND.getErrorCode(), KeymanagerErrorConstant.MORE_THAN_ONE_KEY_FOUND.getErrorMessage());
        }
        String idKey = keyAliases.get(0).getApplicationId() + "-" + keyAliases.get(0).getReferenceId();
        String idCompMasterKey = keyAliases.get(0).getApplicationId() + "-";
        if (!idKey.equals(appIdRefIdKey) && !idCompMasterKey.equals(idKey)) {
            LOGGER.error("sessionId", "", "", "AppId & Reference Id not matching with the input thumbprint value(helper).");
            throw new KeymanagerServiceException(KeymanagerErrorConstant.APP_ID_REFERENCE_ID_NOT_MATCHING.getErrorCode(), KeymanagerErrorConstant.APP_ID_REFERENCE_ID_NOT_MATCHING.getErrorMessage());
        }
        Optional<io.mosip.kernel.keymanagerservice.entity.KeyStore> keyFromDBStore = this.getKeyStoreFromDB(keyAliases.get(0).getAlias());
        if (!keyFromDBStore.isPresent()) {
            LOGGER.info("sessionId", "", "", "Key not found in key store for the matched thumbprint. Might has used master key during encryption.");
            return new io.mosip.kernel.keymanagerservice.entity.KeyStore(keyAliases.get(0).getAlias(), null, null, null);
        }
        return keyFromDBStore.get();
    }

    private synchronized void addCertificateThumbprints() {
        List allKeyAliases = this.keyAliasRepository.findAll();
        allKeyAliases.stream().filter(keyAlias -> (Objects.isNull(keyAlias.getCertThumbprint()) || keyAlias.getCertThumbprint().equals("")) && !keyAlias.getApplicationId().equals("KERNEL") && !keyAlias.getReferenceId().equals("IDENTITY_CACHE")).forEach(keyAlias -> {
            Optional<io.mosip.kernel.keymanagerservice.entity.KeyStore> keyFromDBStore;
            if (keyAlias.getReferenceId().isEmpty() || keyAlias.getApplicationId().equals("KERNEL") && keyAlias.getReferenceId().equals(this.signRefId)) {
                X509Certificate x509Cert = (X509Certificate)this.keyStore.getCertificate(keyAlias.getAlias());
                String certThumbprint = this.cryptomanagerUtil.getCertificateThumbprintInHex(x509Cert);
                this.storeKeyInAlias(keyAlias.getApplicationId(), keyAlias.getKeyGenerationTime(), keyAlias.getReferenceId(), keyAlias.getAlias(), keyAlias.getKeyExpiryTime(), certThumbprint);
            }
            if (!keyAlias.getReferenceId().isEmpty() && (keyFromDBStore = this.getKeyStoreFromDB(keyAlias.getAlias())).isPresent()) {
                String certificateData = keyFromDBStore.get().getCertificateData();
                X509Certificate x509Cert = (X509Certificate)this.keymanagerUtil.convertToCertificate(certificateData);
                String certThumbprint = this.cryptomanagerUtil.getCertificateThumbprintInHex(x509Cert);
                this.storeKeyInAlias(keyAlias.getApplicationId(), keyAlias.getKeyGenerationTime(), keyAlias.getReferenceId(), keyAlias.getAlias(), keyAlias.getKeyExpiryTime(), certThumbprint);
            }
            LOGGER.info("sessionId", "", "", "Thumbprint added for the key alias: " + keyAlias.getAlias());
        });
    }
}

