/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.keymanager.hsm.impl;

import io.mosip.kernel.core.keymanager.exception.KeystoreProcessingException;
import io.mosip.kernel.core.keymanager.model.CertificateParameters;
import io.mosip.kernel.core.keymanager.spi.KeyStore;
import io.mosip.kernel.core.logger.spi.Logger;
import io.mosip.kernel.keymanager.hsm.constant.KeymanagerErrorCode;
import io.mosip.kernel.keymanagerservice.logger.KeymanagerLogger;
import java.lang.reflect.Constructor;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.crypto.SecretKey;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.stereotype.Component;

@ConfigurationProperties(prefix="mosip.kernel.keymanager.hsm")
@Component
public class KeyStoreImpl
implements KeyStore,
InitializingBean {
    private static final Logger LOGGER = KeymanagerLogger.getLogger(KeyStoreImpl.class);
    private static final Map<String, String> DEFAULT_KS_IMPL_CLASSES = new HashMap<String, String>();
    @Value(value="${mosip.kernel.keymanager.hsm.keystore-type:PKCS11}")
    private String keystoreType;
    @Value(value="${mosip.kernel.keymanager.hsm.config-path:\"\"}")
    private String configPath;
    @Value(value="${mosip.kernel.keymanager.hsm.keystore-pass:\"\"}")
    private String keystorePass;
    @Value(value="${mosip.kernel.keygenerator.symmetric-algorithm-name:AES}")
    private String symmetricKeyAlgorithm;
    @Value(value="${mosip.kernel.keygenerator.symmetric-key-length:256}")
    private int symmetricKeyLength;
    @Value(value="${mosip.kernel.keygenerator.asymmetric-algorithm-name:RSA}")
    private String asymmetricKeyAlgorithm;
    @Value(value="${mosip.kernel.keygenerator.asymmetric-key-length:2048}")
    private int asymmetricKeyLength;
    @Value(value="${mosip.kernel.certificate.sign.algorithm:SHA256withRSA}")
    private String signAlgorithm;
    @Value(value="${mosip.kernel.keymanager.keystore.keyreference.enable.cache:true}")
    private boolean enableKeyReferenceCache;
    private Map<String, String> jceParams = new HashMap<String, String>();
    private Map<String, String> keystoreParams = new HashMap<String, String>();
    private KeyStore keyStore = null;

    public void afterPropertiesSet() throws Exception {
        this.setAlgorithmProperties();
        String clazzName = DEFAULT_KS_IMPL_CLASSES.get(this.keystoreType);
        if (Objects.isNull(clazzName)) {
            clazzName = this.jceParams.get("className");
            this.mergeJceParams();
        } else {
            this.addPKCSParams();
        }
        if (Objects.isNull(clazzName)) {
            LOGGER.info("ksSessionId", "KeyStoreImpl-Main", "KeyStoreImpl", "No Clazz Found to load for Keystore Impl, So loading default offline clazz.");
            clazzName = DEFAULT_KS_IMPL_CLASSES.get("io.mosip.kernel.keymanager.hsm.impl.offline.OLKeyStoreImpl");
        }
        LOGGER.info("ksSessionId", "KeyStoreImpl-Main", "KeyStoreImpl", "Found Clazz to load for Keystore Impl: " + clazzName);
        Class<?> object = Class.forName(clazzName);
        Optional resConstructor = ReflectionUtils.findConstructor(object, (Object[])new Object[]{this.keystoreParams});
        if (!resConstructor.isPresent()) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_NO_CONSTRUCTOR_FOUND.getErrorCode(), KeymanagerErrorCode.KEYSTORE_NO_CONSTRUCTOR_FOUND.getErrorMessage());
        }
        Constructor constructor = (Constructor)resConstructor.get();
        constructor.setAccessible(true);
        this.keyStore = (KeyStore)constructor.newInstance(this.keystoreParams);
        LOGGER.info("ksSessionId", "KeyStoreImpl-Main", "KeyStoreImpl", "Successfully loaded Clazz for Keystore Impl: " + clazzName);
    }

    private void setAlgorithmProperties() {
        this.keystoreParams.put("SYM_KEY_ALGORITHM", this.symmetricKeyAlgorithm);
        this.keystoreParams.put("SYM_KEY_SIZE", Integer.toString(this.symmetricKeyLength));
        this.keystoreParams.put("ASYM_KEY_ALGORITHM", this.asymmetricKeyAlgorithm);
        this.keystoreParams.put("ASYM_KEY_SIZE", Integer.toString(this.asymmetricKeyLength));
        this.keystoreParams.put("CERT_SIGN_ALGORITHM", this.signAlgorithm);
        this.keystoreParams.put("FLAG_KEY_REF_CACHE", Boolean.toString(this.enableKeyReferenceCache));
    }

    private void addPKCSParams() {
        this.keystoreParams.put("CONFIG_FILE_PATH", this.configPath);
        this.keystoreParams.put("PKCS11_KEYSTORE_PASSWORD", this.keystorePass);
    }

    private void mergeJceParams() {
        this.jceParams.forEach((key, value) -> {
            if (!key.equals("className")) {
                this.keystoreParams.put((String)key, (String)value);
            }
        });
    }

    public List<String> getAllAlias() {
        return this.keyStore.getAllAlias();
    }

    public Key getKey(String alias) {
        return this.keyStore.getKey(alias);
    }

    public KeyStore.PrivateKeyEntry getAsymmetricKey(String alias) {
        return this.keyStore.getAsymmetricKey(alias);
    }

    public PrivateKey getPrivateKey(String alias) {
        return this.keyStore.getPrivateKey(alias);
    }

    public PublicKey getPublicKey(String alias) {
        return this.keyStore.getPublicKey(alias);
    }

    public X509Certificate getCertificate(String alias) {
        return (X509Certificate)this.keyStore.getCertificate(alias);
    }

    public SecretKey getSymmetricKey(String alias) {
        return this.keyStore.getSymmetricKey(alias);
    }

    public void deleteKey(String alias) {
        this.keyStore.deleteKey(alias);
    }

    public void generateAndStoreAsymmetricKey(String alias, String signKeyAlias, CertificateParameters certParams) {
        this.keyStore.generateAndStoreAsymmetricKey(alias, signKeyAlias, certParams);
    }

    public void generateAndStoreSymmetricKey(String alias) {
        this.keyStore.generateAndStoreSymmetricKey(alias);
    }

    public void storeCertificate(String alias, PrivateKey privateKey, Certificate certificate) {
        this.keyStore.storeCertificate(alias, privateKey, certificate);
    }

    public String getKeystoreProviderName() {
        return this.keyStore.getKeystoreProviderName();
    }

    public void setJce(Map<String, String> jce) {
        this.jceParams = jce;
    }

    static {
        DEFAULT_KS_IMPL_CLASSES.put("PKCS11", "io.mosip.kernel.keymanager.hsm.impl.pkcs.PKCS11KeyStoreImpl");
        DEFAULT_KS_IMPL_CLASSES.put("PKCS12", "io.mosip.kernel.keymanager.hsm.impl.pkcs.PKCS12KeyStoreImpl");
        DEFAULT_KS_IMPL_CLASSES.put("OFFLINE", "io.mosip.kernel.keymanager.hsm.impl.offline.OLKeyStoreImpl");
    }
}

