/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.clientcrypto.dto;

import io.mosip.kernel.clientcrypto.constant.ClientType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotBlank;
import lombok.Generated;

@ApiModel(description="Model representing a data for encrypt/decrypt")
public class TpmCryptoRequestDto {
    @ApiModelProperty(notes="Data to Encrypt/Decrypt", example="Any String", required=true)
    @NotBlank(message="should not be null or empty")
    private @NotBlank(message="should not be null or empty") String value;
    @ApiModelProperty(notes="encrypting public key", required=true)
    @NotBlank(message="should not be null or empty")
    private @NotBlank(message="should not be null or empty") String publicKey;
    @ApiModelProperty(notes="Defaults to TPM, set to false for non-tpm based verification", required=false)
    @Deprecated(since="1.2.1")
    private boolean isTpm;
    @ApiModelProperty(notes="Default verifies based on public key to identify TPM Implementation,For non-TPM instances set this value explicitly", required=false)
    private ClientType clientType;

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public String getPublicKey() {
        return this.publicKey;
    }

    @Deprecated
    @Generated
    public boolean isTpm() {
        return this.isTpm;
    }

    @Generated
    public ClientType getClientType() {
        return this.clientType;
    }

    @Generated
    public void setValue(String value) {
        this.value = value;
    }

    @Generated
    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    @Deprecated
    @Generated
    public void setTpm(boolean isTpm) {
        this.isTpm = isTpm;
    }

    @Generated
    public void setClientType(ClientType clientType) {
        this.clientType = clientType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TpmCryptoRequestDto)) {
            return false;
        }
        TpmCryptoRequestDto other = (TpmCryptoRequestDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$publicKey = this.getPublicKey();
        String other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
            return false;
        }
        if (this.isTpm() != other.isTpm()) {
            return false;
        }
        ClientType this$clientType = this.getClientType();
        ClientType other$clientType = other.getClientType();
        return !(this$clientType == null ? other$clientType != null : !((Object)((Object)this$clientType)).equals((Object)other$clientType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TpmCryptoRequestDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        result = result * 59 + (this.isTpm() ? 79 : 97);
        ClientType $clientType = this.getClientType();
        result = result * 59 + ($clientType == null ? 43 : ((Object)((Object)$clientType)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TpmCryptoRequestDto(value=" + this.getValue() + ", publicKey=" + this.getPublicKey() + ", isTpm=" + this.isTpm() + ", clientType=" + this.getClientType() + ")";
    }

    @Generated
    public TpmCryptoRequestDto(String value, String publicKey, boolean isTpm, ClientType clientType) {
        this.value = value;
        this.publicKey = publicKey;
        this.isTpm = isTpm;
        this.clientType = clientType;
    }

    @Generated
    public TpmCryptoRequestDto() {
    }
}

