/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.keymanagerservice.service.impl;

import io.mosip.kernel.core.crypto.exception.InvalidDataException;
import io.mosip.kernel.core.crypto.exception.InvalidKeyException;
import io.mosip.kernel.core.crypto.exception.NullDataException;
import io.mosip.kernel.core.crypto.exception.NullKeyException;
import io.mosip.kernel.core.crypto.exception.NullMethodException;
import io.mosip.kernel.core.crypto.spi.CryptoCoreSpec;
import io.mosip.kernel.core.keymanager.exception.KeystoreProcessingException;
import io.mosip.kernel.core.keymanager.exception.NoSuchSecurityProviderException;
import io.mosip.kernel.core.keymanager.model.CertificateEntry;
import io.mosip.kernel.core.keymanager.model.CertificateParameters;
import io.mosip.kernel.core.keymanager.spi.KeyStore;
import io.mosip.kernel.core.logger.spi.Logger;
import io.mosip.kernel.core.util.CryptoUtil;
import io.mosip.kernel.core.util.DateUtils;
import io.mosip.kernel.cryptomanager.util.CryptomanagerUtils;
import io.mosip.kernel.keygenerator.bouncycastle.KeyGenerator;
import io.mosip.kernel.keymanager.hsm.util.CertificateUtility;
import io.mosip.kernel.keymanagerservice.constant.KeymanagerErrorConstant;
import io.mosip.kernel.keymanagerservice.dto.CSRGenerateRequestDto;
import io.mosip.kernel.keymanagerservice.dto.CertificateInfo;
import io.mosip.kernel.keymanagerservice.dto.KeyPairGenerateRequestDto;
import io.mosip.kernel.keymanagerservice.dto.KeyPairGenerateResponseDto;
import io.mosip.kernel.keymanagerservice.dto.PublicKeyResponse;
import io.mosip.kernel.keymanagerservice.dto.SignatureCertificate;
import io.mosip.kernel.keymanagerservice.dto.SymmetricKeyGenerateRequestDto;
import io.mosip.kernel.keymanagerservice.dto.SymmetricKeyGenerateResponseDto;
import io.mosip.kernel.keymanagerservice.dto.SymmetricKeyRequestDto;
import io.mosip.kernel.keymanagerservice.dto.SymmetricKeyResponseDto;
import io.mosip.kernel.keymanagerservice.dto.UploadCertificateRequestDto;
import io.mosip.kernel.keymanagerservice.dto.UploadCertificateResponseDto;
import io.mosip.kernel.keymanagerservice.entity.KeyAlias;
import io.mosip.kernel.keymanagerservice.exception.CryptoException;
import io.mosip.kernel.keymanagerservice.exception.InvalidResponseObjectTypeException;
import io.mosip.kernel.keymanagerservice.exception.KeymanagerServiceException;
import io.mosip.kernel.keymanagerservice.exception.NoUniqueAliasException;
import io.mosip.kernel.keymanagerservice.helper.KeymanagerDBHelper;
import io.mosip.kernel.keymanagerservice.logger.KeymanagerLogger;
import io.mosip.kernel.keymanagerservice.service.KeymanagerService;
import io.mosip.kernel.keymanagerservice.util.KeymanagerUtil;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.crypto.SecretKey;
import javax.security.auth.x500.X500Principal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class KeymanagerServiceImpl
implements KeymanagerService {
    private static final String VALID_REFERENCE_ID_GETTING_KEY_ALIAS_WITH_REFERENCE_ID = "Valid reference Id. Getting key alias with referenceId";
    private static final String NOT_A_VALID_REFERENCE_ID_GETTING_KEY_ALIAS_WITHOUT_REFERENCE_ID = "Not a valid reference Id. Getting key alias without referenceId";
    private static final Logger LOGGER = KeymanagerLogger.getLogger(KeymanagerServiceImpl.class);
    @Value(value="${mosip.root.key.applicationid:ROOT}")
    private String rootKeyApplicationId;
    @Value(value="${mosip.sign-certificate-refid:SIGN}")
    private String certificateSignRefID;
    @Value(value="${mosip.sign.applicationid:KERNEL}")
    private String signApplicationid;
    @Value(value="${mosip.kernel.certificate.sign.algorithm:SHA256withRSA}")
    private String signAlgorithm;
    @Value(value="${mosip.kernel.keymanager.113nothumbprint.support:false}")
    private boolean noThumbprint;
    @Autowired
    private KeyStore keyStore;
    @Autowired
    private KeyGenerator keyGenerator;
    @Autowired
    private CryptoCoreSpec<byte[], byte[], SecretKey, PublicKey, PrivateKey, String> cryptoCore;
    @Autowired
    KeymanagerUtil keymanagerUtil;
    @Autowired
    private KeymanagerDBHelper dbHelper;
    @Autowired
    CryptomanagerUtils cryptomanagerUtil;

    private CertificateInfo<X509Certificate> getCertificateFromHSM(String applicationId, LocalDateTime timeStamp, String referenceId) {
        LOGGER.info("sessionId", "applicationId", applicationId, "Getting Certificate from KeyStore.");
        LOGGER.info("sessionId", "timestamp", timeStamp.toString(), "Getting Certificate from KeyStore.");
        String alias = null;
        Optional keyPolicy = this.dbHelper.getKeyPolicy(applicationId);
        Map keyAliasMap = this.dbHelper.getKeyAliases(applicationId, referenceId, timeStamp);
        List currentKeyAlias = (List)keyAliasMap.get("currentKeyAlias");
        List keyAlias = (List)keyAliasMap.get("keyAlias");
        if (keyAlias.isEmpty()) {
            LOGGER.error("sessionId", "keyAlias", String.valueOf(keyAlias.size()), "Initial Key generation process not completed.");
            throw new KeymanagerServiceException(KeymanagerErrorConstant.KEY_GENERATION_NOT_DONE.getErrorCode(), KeymanagerErrorConstant.KEY_GENERATION_NOT_DONE.getErrorMessage());
        }
        if (currentKeyAlias.size() > 1) {
            LOGGER.info("sessionId", "currentKeyAlias", String.valueOf(currentKeyAlias.size()), "CurrentKeyAlias size more than one Throwing exception");
            throw new NoUniqueAliasException(KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorCode(), KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorMessage());
        }
        if (currentKeyAlias.size() == 1) {
            LOGGER.info("sessionId", "currentKeyAlias", ((KeyAlias)currentKeyAlias.get(0)).getAlias(), "CurrentKeyAlias size is one fetching keypair using this alias");
            KeyAlias fetchedKeyAlias = (KeyAlias)currentKeyAlias.get(0);
            alias = fetchedKeyAlias.getAlias();
        } else if (currentKeyAlias.isEmpty()) {
            LOGGER.info("sessionId", "currentKeyAlias", String.valueOf(currentKeyAlias.size()), "CurrentKeyAlias size is zero. Will create new Keypair for this applicationId and timestamp");
            alias = UUID.randomUUID().toString();
            this.generateKeyPairInHSM(alias, applicationId, referenceId, timeStamp, keyAlias);
        }
        X509Certificate x509Cert = (X509Certificate)this.keyStore.getCertificate(alias);
        return new CertificateInfo(alias, (Object)x509Cert);
    }

    private void generateKeyPairInHSM(String alias, String applicationId, String referenceId, LocalDateTime timeStamp, List<KeyAlias> keyAlias) {
        LocalDateTime generationDateTime = timeStamp;
        LocalDateTime expiryDateTime = this.dbHelper.getExpiryPolicy(applicationId, generationDateTime, keyAlias);
        String rootKeyAlias = this.getRootKeyAlias(applicationId, timeStamp);
        X500Principal latestCertPrincipal = this.getLatestCertPrincipal(keyAlias);
        CertificateParameters certParams = this.keymanagerUtil.getCertificateParameters(latestCertPrincipal, generationDateTime, expiryDateTime);
        this.keyStore.generateAndStoreAsymmetricKey(alias, rootKeyAlias, certParams);
        this.dbHelper.storeKeyInAlias(applicationId, generationDateTime, referenceId, alias, expiryDateTime);
    }

    private X500Principal getLatestCertPrincipal(List<KeyAlias> keyAlias) {
        KeyAlias latestKeyAlias = keyAlias.get(0);
        String alias = latestKeyAlias.getAlias();
        X509Certificate signCert = (X509Certificate)this.keyStore.getCertificate(alias);
        return signCert.getSubjectX500Principal();
    }

    private CertificateInfo<X509Certificate> getCertificateFromDBStore(String applicationId, LocalDateTime timeStamp, String referenceId) {
        LOGGER.info("sessionId", "applicationId", applicationId, "Getting public key from DB Store");
        LOGGER.info("sessionId", "timestamp", timeStamp.toString(), "Getting public key from DB Store");
        LOGGER.info("sessionId", "referenceId", referenceId, "Getting public key from DB Store");
        String alias = null;
        X509Certificate x509Cert = null;
        Map keyAliasMap = this.dbHelper.getKeyAliases(applicationId, referenceId, timeStamp);
        List currentKeyAlias = (List)keyAliasMap.get("currentKeyAlias");
        if (currentKeyAlias.size() > 1) {
            LOGGER.info("sessionId", "currentKeyAlias", String.valueOf(currentKeyAlias.size()), "CurrentKeyAlias size more than one. Throwing exception");
            throw new NoUniqueAliasException(KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorCode(), KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorMessage());
        }
        if (currentKeyAlias.size() == 1) {
            LOGGER.info("sessionId", "currentKeyAlias", ((KeyAlias)currentKeyAlias.get(0)).getAlias(), "CurrentKeyAlias size is one. Will fetch keypair using this alias");
            Optional keyFromDBStore = this.dbHelper.getKeyStoreFromDB(((KeyAlias)currentKeyAlias.get(0)).getAlias());
            if (!keyFromDBStore.isPresent()) {
                LOGGER.info("sessionId", "keyFromDBStore", keyFromDBStore.toString(), "Key in DBStore does not exist for this alias. Throwing exception");
                throw new NoUniqueAliasException(KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorCode(), KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorMessage());
            }
            LOGGER.info("sessionId", "keyFromDBStore", ((KeyAlias)currentKeyAlias.get(0)).getAlias(), "Key in DBStore exists for this alias. Fetching Certificate.");
            KeyAlias fetchedKeyAlias = (KeyAlias)currentKeyAlias.get(0);
            alias = fetchedKeyAlias.getAlias();
            String certificateData = ((io.mosip.kernel.keymanagerservice.entity.KeyStore)keyFromDBStore.get()).getCertificateData();
            x509Cert = (X509Certificate)this.keymanagerUtil.convertToCertificate(certificateData);
        } else if (currentKeyAlias.isEmpty()) {
            String encryptedPrivateKey;
            LOGGER.info("sessionId", "currentKeyAlias", String.valueOf(currentKeyAlias.size()), "CurrentKeyAlias size is zero. Will create new Keypair for this applicationId, referenceId and timestamp");
            List keyAlias = (List)keyAliasMap.get("keyAlias");
            if (!keyAlias.isEmpty()) {
                keyAlias.forEach(innerAlias -> {
                    String ksAlias = innerAlias.getAlias();
                    Optional keyFromDBStore = this.dbHelper.getKeyStoreFromDB(ksAlias);
                    String masterKeyAlias = ((io.mosip.kernel.keymanagerservice.entity.KeyStore)keyFromDBStore.get()).getMasterAlias();
                    String privateKeyObj = ((io.mosip.kernel.keymanagerservice.entity.KeyStore)keyFromDBStore.get()).getPrivateKey();
                    if (ksAlias.equals(masterKeyAlias) || privateKeyObj.equals("NA")) {
                        LOGGER.error("sessionId", "applicationId", null, "Not Allowed to generate New Key Pair for other domains.");
                        throw new KeymanagerServiceException(KeymanagerErrorConstant.GENERATION_NOT_ALLOWED.getErrorCode(), KeymanagerErrorConstant.GENERATION_NOT_ALLOWED.getErrorMessage());
                    }
                });
            }
            if (applicationId.equalsIgnoreCase("ROOT")) {
                LOGGER.error("sessionId", "applicationId", null, "Not Allowed to generate Base Key for Root Key.");
                throw new KeymanagerServiceException(KeymanagerErrorConstant.GENERATION_NOT_ALLOWED.getErrorCode(), KeymanagerErrorConstant.GENERATION_NOT_ALLOWED.getErrorMessage());
            }
            Optional keyPolicy = this.dbHelper.getKeyPolicy(applicationId);
            alias = UUID.randomUUID().toString();
            KeyPair keypair = this.keyGenerator.getAsymmetricKey();
            PrivateKey privateKey = keypair.getPrivate();
            CertificateInfo certInfo = this.getCertificateFromHSM(applicationId, timeStamp, "");
            X509Certificate hsmX509Cert = (X509Certificate)certInfo.getCertificate();
            PublicKey masterPublicKey = hsmX509Cert.getPublicKey();
            String masterAlias = certInfo.getAlias();
            LocalDateTime generationDateTime = timeStamp;
            LocalDateTime expiryDateTime = this.dbHelper.getExpiryPolicy("BASE", generationDateTime, (List)keyAliasMap.get("keyAlias"));
            try {
                encryptedPrivateKey = CryptoUtil.encodeBase64((byte[])this.keymanagerUtil.encryptKey(privateKey, masterPublicKey));
            }
            catch (InvalidDataException | InvalidKeyException | NullDataException | NullKeyException | NullMethodException e) {
                throw new CryptoException(KeymanagerErrorConstant.CRYPTO_EXCEPTION.getErrorCode(), KeymanagerErrorConstant.CRYPTO_EXCEPTION.getErrorMessage() + e.getErrorText());
            }
            KeyStore.PrivateKeyEntry signKeyEntry = this.keyStore.getAsymmetricKey(masterAlias);
            PrivateKey signPrivateKey = signKeyEntry.getPrivateKey();
            X509Certificate signCert = (X509Certificate)signKeyEntry.getCertificate();
            X500Principal signerPrincipal = signCert.getSubjectX500Principal();
            CertificateParameters certParams = this.keymanagerUtil.getCertificateParameters(signerPrincipal, generationDateTime, expiryDateTime);
            certParams.setCommonName(applicationId + "-" + referenceId);
            x509Cert = CertificateUtility.generateX509Certificate((PrivateKey)signPrivateKey, (PublicKey)keypair.getPublic(), (CertificateParameters)certParams, (X500Principal)signerPrincipal, (String)this.signAlgorithm, (String)this.keyStore.getKeystoreProviderName());
            String certificateData = this.keymanagerUtil.getPEMFormatedData((Object)x509Cert);
            this.dbHelper.storeKeyInDBStore(alias, masterAlias, certificateData, encryptedPrivateKey);
            this.dbHelper.storeKeyInAlias(applicationId, generationDateTime, referenceId, alias, expiryDateTime);
            this.keymanagerUtil.destoryKey(privateKey);
        }
        return new CertificateInfo(alias, x509Cert);
    }

    public SymmetricKeyResponseDto decryptSymmetricKey(SymmetricKeyRequestDto symmetricKeyRequestDto) {
        LocalDateTime localDateTimeStamp = DateUtils.getUTCCurrentDateTime();
        String applicationId = symmetricKeyRequestDto.getApplicationId();
        String referenceId = symmetricKeyRequestDto.getReferenceId();
        LOGGER.info("sessionId", "symmetricKeyRequestDto", symmetricKeyRequestDto.getApplicationId(), "Request Application Id: " + applicationId);
        LOGGER.info("sessionId", "symmetricKeyRequestDto", symmetricKeyRequestDto.getApplicationId(), "Request Reference Id: " + referenceId);
        Boolean reqPrependThumbprint = symmetricKeyRequestDto.getPrependThumbprint();
        LOGGER.info("sessionId", "symmetricKeyRequestDto", symmetricKeyRequestDto.getApplicationId(), "prependThumbprint Value(Request): " + reqPrependThumbprint);
        boolean prependThumbprint = reqPrependThumbprint == null ? false : symmetricKeyRequestDto.getPrependThumbprint();
        LOGGER.info("sessionId", "symmetricKeyRequestDto", symmetricKeyRequestDto.getApplicationId(), "prependThumbprint Value: " + prependThumbprint);
        LOGGER.info("sessionId", "symmetricKeyRequestDto", symmetricKeyRequestDto.getApplicationId(), "1.1.3 Thumbprint support property flag: " + this.noThumbprint);
        byte[] encryptedData = CryptoUtil.decodeBase64((String)symmetricKeyRequestDto.getEncryptedSymmetricKey());
        if (this.noThumbprint) {
            return this.decryptSymmetricKeyNoKeyIdentifier(applicationId, referenceId, encryptedData, localDateTimeStamp);
        }
        return this.decryptSymmetricKeyWithKeyIdentifier(applicationId, referenceId, encryptedData, localDateTimeStamp);
    }

    private SymmetricKeyResponseDto decryptSymmetricKeyWithKeyIdentifier(String applicationId, String referenceId, byte[] encryptedData, LocalDateTime localDateTimeStamp) {
        byte[] certThumbprint = Arrays.copyOfRange(encryptedData, 0, 32);
        byte[] encryptedSymmetricKey = Arrays.copyOfRange(encryptedData, 32, encryptedData.length);
        SymmetricKeyResponseDto keyResponseDto = new SymmetricKeyResponseDto();
        byte[] decryptedSymmetricKey = this.decryptSessionKey(applicationId, referenceId, localDateTimeStamp, encryptedSymmetricKey, certThumbprint);
        keyResponseDto.setSymmetricKey(CryptoUtil.encodeBase64((byte[])decryptedSymmetricKey));
        return keyResponseDto;
    }

    private byte[] decryptSessionKey(String applicationId, String referenceId, LocalDateTime localDateTimeStamp, byte[] encryptedSymmetricKey, byte[] certThumbprint) {
        Map keyAliasMap;
        if (!this.keymanagerUtil.isValidReferenceId(referenceId)) {
            LOGGER.info("sessionId", "", "", NOT_A_VALID_REFERENCE_ID_GETTING_KEY_ALIAS_WITHOUT_REFERENCE_ID);
            keyAliasMap = this.dbHelper.getKeyAliases(applicationId, "", localDateTimeStamp);
        } else {
            LOGGER.info("sessionId", "", "", VALID_REFERENCE_ID_GETTING_KEY_ALIAS_WITH_REFERENCE_ID);
            keyAliasMap = this.dbHelper.getKeyAliases(applicationId, referenceId, localDateTimeStamp);
        }
        List keyAlias = (List)keyAliasMap.get("keyAlias");
        List currentKeyAlias = (List)keyAliasMap.get("currentKeyAlias");
        Object[] keys = this.getKeyObjects(keyAlias, currentKeyAlias, localDateTimeStamp, referenceId, certThumbprint);
        PrivateKey privateKey = (PrivateKey)keys[0];
        PublicKey publicKey = ((Certificate)keys[1]).getPublicKey();
        try {
            byte[] decryptedSessionKey = (byte[])this.cryptoCore.asymmetricDecrypt((Object)privateKey, (Object)publicKey, (Object)encryptedSymmetricKey);
            this.keymanagerUtil.destoryKey(privateKey);
            return decryptedSessionKey;
        }
        catch (InvalidKeyException keyExp) {
            LOGGER.error("sessionId", "applicationId", "referenceId", "Error occurred because of mismatch with keys. Try with keys for decryption.");
            throw new CryptoException(KeymanagerErrorConstant.SYMMETRIC_KEY_DECRYPTION_FAILED.getErrorCode(), KeymanagerErrorConstant.SYMMETRIC_KEY_DECRYPTION_FAILED.getErrorMessage() + keyExp.getMessage(), (Throwable)keyExp);
        }
    }

    private SymmetricKeyResponseDto decryptSymmetricKeyNoKeyIdentifier(String applicationId, String referenceId, byte[] encryptedData, LocalDateTime localDateTimeStamp) {
        byte[] certThumbprint = null;
        byte[] encryptedSymmetricKey = null;
        boolean prependThumbprint = false;
        if (encryptedData.length == 288) {
            certThumbprint = Arrays.copyOfRange(encryptedData, 0, 32);
            encryptedSymmetricKey = Arrays.copyOfRange(encryptedData, 32, encryptedData.length);
            prependThumbprint = true;
        } else {
            encryptedSymmetricKey = encryptedData;
        }
        SymmetricKeyResponseDto keyResponseDto = new SymmetricKeyResponseDto();
        byte[] decryptedSymmetricKey = this.decryptSessionKey(applicationId, referenceId, localDateTimeStamp, encryptedSymmetricKey, certThumbprint, prependThumbprint);
        keyResponseDto.setSymmetricKey(CryptoUtil.encodeBase64((byte[])decryptedSymmetricKey));
        return keyResponseDto;
    }

    private byte[] decryptSessionKey(String applicationId, String referenceId, LocalDateTime localDateTimeStamp, byte[] encryptedSymmetricKey, byte[] certThumbprint, boolean packetTPFlag) {
        Map keyAliasMap;
        if (!this.keymanagerUtil.isValidReferenceId(referenceId)) {
            LOGGER.info("sessionId", "", "", NOT_A_VALID_REFERENCE_ID_GETTING_KEY_ALIAS_WITHOUT_REFERENCE_ID);
            keyAliasMap = this.dbHelper.getKeyAliases(applicationId, "", localDateTimeStamp);
        } else {
            LOGGER.info("sessionId", "", "", VALID_REFERENCE_ID_GETTING_KEY_ALIAS_WITH_REFERENCE_ID);
            keyAliasMap = this.dbHelper.getKeyAliases(applicationId, referenceId, localDateTimeStamp);
        }
        List keyAlias = (List)keyAliasMap.get("keyAlias");
        List currentKeyAlias = (List)keyAliasMap.get("currentKeyAlias");
        InvalidKeyException keyException = null;
        InvalidDataException dataException = null;
        Object[] keys = this.getPrivateKeyNoKeyIdentifier(keyAlias, currentKeyAlias, localDateTimeStamp, referenceId, certThumbprint, packetTPFlag);
        PrivateKey privateKey = (PrivateKey)keys[0];
        PublicKey publicKey = ((Certificate)keys[1]).getPublicKey();
        try {
            byte[] decryptedSessionKey = (byte[])this.cryptoCore.asymmetricDecrypt((Object)privateKey, (Object)publicKey, (Object)encryptedSymmetricKey);
            this.keymanagerUtil.destoryKey(privateKey);
            return decryptedSessionKey;
        }
        catch (InvalidKeyException keyExp) {
            LOGGER.error("sessionId", "applicationId", "referenceId", "Error occurred because of mismatch with keys. Try with keys for decryption.");
            keyException = keyExp;
        }
        catch (InvalidDataException dataExp) {
            LOGGER.error("sessionId", "applicationId", "referenceId", "Error occurred because of mismatch with keys. Try with other current key for decryption.");
            dataException = dataExp;
        }
        LOGGER.info("sessionId", "applicationId", "referenceId", "Unable to decrypt session with all the other validations, trying the keys available for provided AppId & RefId.");
        for (KeyAlias alias : keyAlias) {
            Object[] dbKeys = this.getPrivateKey(referenceId, alias);
            PrivateKey dbPrivateKey = (PrivateKey)dbKeys[0];
            PublicKey dbPublicKey = ((Certificate)dbKeys[1]).getPublicKey();
            if (Arrays.equals(publicKey.getEncoded(), dbPublicKey.getEncoded())) continue;
            try {
                byte[] decryptedSessionKey = (byte[])this.cryptoCore.asymmetricDecrypt((Object)dbPrivateKey, (Object)dbPublicKey, (Object)encryptedSymmetricKey);
                this.keymanagerUtil.destoryKey(dbPrivateKey);
                return decryptedSessionKey;
            }
            catch (InvalidKeyException keyExp) {
                LOGGER.error("sessionId", "applicationId", "referenceId", "Error occurred because of mismatch with keys. Try with other current key for decryption. key Alias: " + alias);
                keyException = keyExp;
            }
            catch (InvalidDataException dataExp) {
                LOGGER.error("sessionId", "applicationId", "referenceId", "Error occurred because of mismatch with keys. Try with other current key for decryption. key Alias: " + alias);
                dataException = dataExp;
            }
        }
        if (keyException == null) {
            throw dataException;
        }
        throw keyException;
    }

    private Object[] getPrivateKeyNoKeyIdentifier(List<KeyAlias> keyAlias, List<KeyAlias> currentKeyAlias, LocalDateTime timeStamp, String referenceId, byte[] reqCertThumbprint, boolean packetTPFlag) {
        if (Objects.isNull(reqCertThumbprint) && !packetTPFlag) {
            LOGGER.info("sessionId", "currentKeyAlias", keyAlias.get(0).getAlias(), "Thumbprint is value is null and packet Thumbprint Flag is true.");
            KeyAlias fetchedKeyAlias = keyAlias.get(0);
            return this.getPrivateKey(referenceId, fetchedKeyAlias);
        }
        return this.getKeyObjects(keyAlias, currentKeyAlias, timeStamp, referenceId, reqCertThumbprint);
    }

    private Object[] getKeyObjects(List<KeyAlias> keyAlias, List<KeyAlias> currentKeyAlias, LocalDateTime timeStamp, String referenceId, byte[] reqCertThumbprint) {
        if (currentKeyAlias.size() == 1) {
            LOGGER.info("sessionId", "currentKeyAlias", currentKeyAlias.get(0).getAlias(), "CurrentKeyAlias size is one. Will decrypt symmetric key with this alias after thumbprint matches.");
            KeyAlias fetchedKeyAlias = currentKeyAlias.get(0);
            Object[] keys = this.getPrivateKey(referenceId, fetchedKeyAlias);
            if (reqCertThumbprint == null) {
                return keys;
            }
            Certificate certificate = (Certificate)keys[1];
            byte[] certThumbprint = this.cryptomanagerUtil.getCertificateThumbprint(certificate);
            if (Arrays.equals(reqCertThumbprint, certThumbprint)) {
                return keys;
            }
        }
        if ((currentKeyAlias.isEmpty() || currentKeyAlias.size() > 1) && reqCertThumbprint == null) {
            LOGGER.error("sessionId", "currentKeyAlias", String.valueOf(currentKeyAlias.size()), "CurrentKeyAlias is empty or not unique & certificate thumbprint is null. Throwing exception");
            throw new NoUniqueAliasException(KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorCode(), KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorMessage());
        }
        LOGGER.info("sessionId", "keyAlias", "", "CurrentKeyAlias size is zero or thumbprint not matched now checking other expired key aliases to compare thumbprint.");
        for (KeyAlias otherAlias : keyAlias) {
            Object[] keys = this.getPrivateKey(referenceId, otherAlias);
            Certificate certificate = (Certificate)keys[1];
            byte[] certThumbprint = this.cryptomanagerUtil.getCertificateThumbprint(certificate);
            if (!Arrays.equals(reqCertThumbprint, certThumbprint)) continue;
            return keys;
        }
        LOGGER.error("sessionId", "keyAlias", "", "No Key Alias for the thumbprint provided, Throwing exception");
        throw new NoUniqueAliasException(KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorCode(), KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorMessage());
    }

    private Object[] getPrivateKey(String referenceId, KeyAlias fetchedKeyAlias) {
        LOGGER.info("sessionId", "referenceId", referenceId, "Getting private key");
        LOGGER.info("sessionId", "fetchedKeyAlias", fetchedKeyAlias.getAlias(), "Getting private key");
        if (!this.keymanagerUtil.isValidReferenceId(referenceId)) {
            LOGGER.info("sessionId", "", "", "Not valid reference Id. Getting private key from HSM.");
            KeyStore.PrivateKeyEntry masterKeyEntry = this.keyStore.getAsymmetricKey(fetchedKeyAlias.getAlias());
            PrivateKey masterPrivateKey = masterKeyEntry.getPrivateKey();
            Certificate masterCert = masterKeyEntry.getCertificate();
            return new Object[]{masterPrivateKey, masterCert};
        }
        LOGGER.info("sessionId", "", "", "Valid reference Id. Getting private key from DB Store");
        String ksAlias = fetchedKeyAlias.getAlias();
        Optional dbKeyStore = this.dbHelper.getKeyStoreFromDB(ksAlias);
        if (!dbKeyStore.isPresent()) {
            LOGGER.info("sessionId", "keyFromDBStore", dbKeyStore.toString(), "Key in DBStore does not exist for this alias. Throwing exception");
            throw new NoUniqueAliasException(KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorCode(), KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorMessage());
        }
        String masterKeyAlias = ((io.mosip.kernel.keymanagerservice.entity.KeyStore)dbKeyStore.get()).getMasterAlias();
        String privateKeyObj = ((io.mosip.kernel.keymanagerservice.entity.KeyStore)dbKeyStore.get()).getPrivateKey();
        if (ksAlias.equals(masterKeyAlias) || privateKeyObj.equals("NA")) {
            LOGGER.error("sessionId", "applicationId", null, "Not Allowed to perform decryption with other domain key.");
            throw new KeymanagerServiceException(KeymanagerErrorConstant.DECRYPTION_NOT_ALLOWED.getErrorCode(), KeymanagerErrorConstant.DECRYPTION_NOT_ALLOWED.getErrorMessage());
        }
        KeyStore.PrivateKeyEntry masterKeyEntry = this.keyStore.getAsymmetricKey(((io.mosip.kernel.keymanagerservice.entity.KeyStore)dbKeyStore.get()).getMasterAlias());
        PrivateKey masterPrivateKey = masterKeyEntry.getPrivateKey();
        PublicKey masterPublicKey = masterKeyEntry.getCertificate().getPublicKey();
        try {
            byte[] decryptedPrivateKey = this.keymanagerUtil.decryptKey(CryptoUtil.decodeBase64((String)((io.mosip.kernel.keymanagerservice.entity.KeyStore)dbKeyStore.get()).getPrivateKey()), masterPrivateKey, masterPublicKey);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(decryptedPrivateKey));
            Certificate certificate = this.keymanagerUtil.convertToCertificate(((io.mosip.kernel.keymanagerservice.entity.KeyStore)dbKeyStore.get()).getCertificateData());
            return new Object[]{privateKey, certificate};
        }
        catch (InvalidDataException | InvalidKeyException | NullDataException | NullKeyException | NullMethodException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new CryptoException(KeymanagerErrorConstant.CRYPTO_EXCEPTION.getErrorCode(), KeymanagerErrorConstant.CRYPTO_EXCEPTION.getErrorMessage() + e.getMessage(), e);
        }
    }

    public SignatureCertificate getSignatureCertificate(String applicationId, Optional<String> referenceId, String timestamp) {
        return this.getSigningCertificate(applicationId, referenceId, timestamp, true);
    }

    private SignatureCertificate getSigningCertificate(String applicationId, Optional<String> referenceId, String timestamp, boolean isPrivateRequired) {
        String alias = null;
        List currentKeyAlias = null;
        Map keyAliasMap = null;
        LocalDateTime generationDateTime = null;
        LocalDateTime expiryDateTime = null;
        CertificateEntry certificateEntry = null;
        LocalDateTime localDateTimeStamp = DateUtils.getUTCCurrentDateTime();
        String refId = null;
        if (!referenceId.isPresent() || referenceId.get().trim().isEmpty()) {
            LOGGER.info("sessionId", "", "", NOT_A_VALID_REFERENCE_ID_GETTING_KEY_ALIAS_WITHOUT_REFERENCE_ID);
            keyAliasMap = this.dbHelper.getKeyAliases(applicationId, "", localDateTimeStamp);
            refId = "";
        } else if (applicationId.equalsIgnoreCase(this.signApplicationid) && referenceId.isPresent() && referenceId.get().equals(this.certificateSignRefID)) {
            LOGGER.info("sessionId", applicationId, referenceId.get(), VALID_REFERENCE_ID_GETTING_KEY_ALIAS_WITH_REFERENCE_ID);
            keyAliasMap = this.dbHelper.getKeyAliases(applicationId, referenceId.get(), localDateTimeStamp);
            refId = referenceId.get();
        } else {
            LOGGER.error("sessionId", applicationId, referenceId.get(), "Signing operation not allowed for the provided application Id & reference Id.");
            throw new KeymanagerServiceException(KeymanagerErrorConstant.NOT_VALID_SIGNATURE_KEY.getErrorCode(), KeymanagerErrorConstant.NOT_VALID_SIGNATURE_KEY.getErrorMessage());
        }
        List keyAlias = (List)keyAliasMap.get("keyAlias");
        currentKeyAlias = (List)keyAliasMap.get("currentKeyAlias");
        if (currentKeyAlias.size() > 1) {
            LOGGER.info("sessionId", "currentKeyAlias", String.valueOf(currentKeyAlias.size()), "CurrentKeyAlias size more than one. Throwing exception");
            throw new NoUniqueAliasException(KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorCode(), KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorMessage());
        }
        if (currentKeyAlias.size() == 1) {
            LOGGER.info("sessionId", "currentKeyAlias", ((KeyAlias)currentKeyAlias.get(0)).getAlias(), "CurrentKeyAlias size is one. Will fetch keypair using this alias");
            KeyAlias fetchedKeyAlias = (KeyAlias)currentKeyAlias.get(0);
            alias = fetchedKeyAlias.getAlias();
            certificateEntry = this.getCertificateEntry(alias, isPrivateRequired);
            generationDateTime = fetchedKeyAlias.getKeyGenerationTime();
            expiryDateTime = fetchedKeyAlias.getKeyExpiryTime();
        } else if (currentKeyAlias.isEmpty() && keyAlias.size() > 0) {
            LOGGER.info("sessionId", "keyAlias", ((KeyAlias)keyAlias.get(0)).getAlias(), "CurrentKeyAlias size is zero. Key got expired, generating new keypair using this App Id & Ref Id");
            alias = UUID.randomUUID().toString();
            this.generateKeyPairInHSM(alias, applicationId, refId, localDateTimeStamp, keyAlias);
            certificateEntry = this.getCertificateEntry(alias, isPrivateRequired);
            generationDateTime = localDateTimeStamp;
            expiryDateTime = this.dbHelper.getExpiryPolicy(applicationId, generationDateTime, keyAlias);
        } else {
            LOGGER.error("sessionId", "keyAlias", String.valueOf(keyAlias.size()), "Initial Key generation process not completed.");
            throw new KeymanagerServiceException(KeymanagerErrorConstant.KEY_GENERATION_NOT_DONE.getErrorCode(), KeymanagerErrorConstant.KEY_GENERATION_NOT_DONE.getErrorMessage());
        }
        String providerName = this.keyStore.getKeystoreProviderName();
        return new SignatureCertificate(alias, certificateEntry, generationDateTime, expiryDateTime, providerName);
    }

    private CertificateEntry<X509Certificate, PrivateKey> getCertificateEntry(String alias, boolean isPrivateRequired) {
        Throwable exception = null;
        try {
            KeyStore.PrivateKeyEntry privateKeyEntry = this.keyStore.getAsymmetricKey(alias);
            return new CertificateEntry((Object[])((X509Certificate[])privateKeyEntry.getCertificateChain()), (Object)privateKeyEntry.getPrivateKey());
        }
        catch (KeystoreProcessingException | NoSuchSecurityProviderException kpe) {
            LOGGER.error("sessionId", "currentKeyAlias", "Error", "Key Not found in HSM, keystore might have loaded as offline." + kpe.getMessage());
            exception = kpe;
            if (!isPrivateRequired) {
                Optional keyFromDBStore = this.dbHelper.getKeyStoreFromDB(alias);
                if (!keyFromDBStore.isPresent()) {
                    LOGGER.error("sessionId", "currentKeyAlias", "", "Certificate Not found in keystore table.");
                    throw new KeymanagerServiceException(KeymanagerErrorConstant.CERTIFICATE_NOT_FOUND.getErrorCode(), KeymanagerErrorConstant.CERTIFICATE_NOT_FOUND.getErrorMessage());
                }
                String certificateData = ((io.mosip.kernel.keymanagerservice.entity.KeyStore)keyFromDBStore.get()).getCertificateData();
                X509Certificate reqX509Cert = (X509Certificate)this.keymanagerUtil.convertToCertificate(certificateData);
                return new CertificateEntry((Object[])new X509Certificate[]{reqX509Cert}, null);
            }
            throw exception;
        }
    }

    public PublicKeyResponse<String> getSignPublicKey(String applicationId, String timestamp, Optional<String> referenceId) {
        String localDateTimeStamp = DateUtils.getUTCCurrentDateTimeString();
        SignatureCertificate certificateResponse = this.getSigningCertificate(applicationId, referenceId, localDateTimeStamp, false);
        return new PublicKeyResponse(certificateResponse.getAlias(), (Object)CryptoUtil.encodeBase64((byte[])((X509Certificate[])certificateResponse.getCertificateEntry().getChain())[0].getPublicKey().getEncoded()), certificateResponse.getIssuedAt(), certificateResponse.getExpiryAt());
    }

    public KeyPairGenerateResponseDto generateMasterKey(String responseObjectType, KeyPairGenerateRequestDto request) {
        String applicationId = request.getApplicationId();
        String refId = request.getReferenceId();
        Boolean forceFlag = request.getForce();
        Optional keyPolicy = this.dbHelper.getKeyPolicy(applicationId);
        if (this.keymanagerUtil.isValidReferenceId(refId) && (refId.equals(this.certificateSignRefID) && !applicationId.equals(this.signApplicationid) || !refId.equals(this.certificateSignRefID))) {
            LOGGER.error("sessionId", "keyPolicy", keyPolicy.toString(), "Reference Id not supported for the provided application Id.");
            throw new KeymanagerServiceException(KeymanagerErrorConstant.REFERENCE_ID_NOT_SUPPORTED.getErrorCode(), KeymanagerErrorConstant.REFERENCE_ID_NOT_SUPPORTED.getErrorMessage());
        }
        if (!this.keymanagerUtil.isValidResponseType(responseObjectType)) {
            LOGGER.error("sessionId", "Response Object Type", null, "Invalid Response Object type provided for the key generation request.");
            throw new KeymanagerServiceException(KeymanagerErrorConstant.INVALID_REQUEST.getErrorCode(), KeymanagerErrorConstant.INVALID_REQUEST.getErrorMessage());
        }
        LOGGER.info("sessionId", "applicationId", "", "Request for Master Key Generation");
        return this.generateKey(responseObjectType, applicationId, refId, forceFlag, request);
    }

    private KeyPairGenerateResponseDto generateKey(String responseObjectType, String appId, String refId, Boolean forceFlag, KeyPairGenerateRequestDto request) {
        LOGGER.info("sessionId", "applicationId", appId, "Generate Key for application ID: " + appId + ", RefId: " + refId + ", force flag: " + forceFlag.toString());
        LocalDateTime timestamp = DateUtils.getUTCCurrentDateTime();
        Map keyAliasMap = this.dbHelper.getKeyAliases(appId, refId, timestamp);
        List currentKeyAlias = (List)keyAliasMap.get("currentKeyAlias");
        if (forceFlag.booleanValue()) {
            LOGGER.debug("sessionId", "applicationId", appId, "Force Flag is True, invalidating all the existing keys and generating new key pair.");
            LocalDateTime expireTime = timestamp.minusMinutes(1L);
            currentKeyAlias.forEach(alias -> this.dbHelper.storeKeyInAlias(appId, alias.getKeyGenerationTime(), refId, alias.getAlias(), expireTime));
            return this.generateAndBuildResponse(responseObjectType, appId, refId, timestamp, keyAliasMap, request);
        }
        if (currentKeyAlias.size() > 1) {
            LOGGER.error("sessionId", "currentKeyAlias", String.valueOf(currentKeyAlias.size()), "CurrentKeyAlias size more than one");
            throw new NoUniqueAliasException(KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorCode(), KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorMessage());
        }
        if (currentKeyAlias.isEmpty()) {
            LOGGER.info("sessionId", "currentKeyAlias", String.valueOf(currentKeyAlias.size()), "CurrentKeyAlias size is zero. Will create new Keypair for this applicationId and timestamp");
            return this.generateAndBuildResponse(responseObjectType, appId, refId, timestamp, keyAliasMap, request);
        }
        LOGGER.info("sessionId", "currentKeyAlias", String.valueOf(currentKeyAlias.size()), "key details present in DB" + currentKeyAlias.get(0));
        KeyAlias fetchedKeyAlias = (KeyAlias)currentKeyAlias.get(0);
        return this.buildResponseObject(responseObjectType, appId, refId, timestamp, fetchedKeyAlias.getAlias(), fetchedKeyAlias.getKeyGenerationTime(), fetchedKeyAlias.getKeyExpiryTime(), request);
    }

    private KeyPairGenerateResponseDto generateAndBuildResponse(String responseObjectType, String appId, String refId, LocalDateTime timestamp, Map<String, List<KeyAlias>> keyAliasMap, KeyPairGenerateRequestDto request) {
        String alias = UUID.randomUUID().toString();
        LocalDateTime generationDateTime = timestamp;
        LocalDateTime expiryDateTime = this.dbHelper.getExpiryPolicy(appId, generationDateTime, keyAliasMap.get("keyAlias"));
        String rootKeyAlias = this.getRootKeyAlias(appId, timestamp);
        CertificateParameters certParams = this.keymanagerUtil.getCertificateParameters(request, generationDateTime, expiryDateTime);
        this.keyStore.generateAndStoreAsymmetricKey(alias, rootKeyAlias, certParams);
        this.dbHelper.storeKeyInAlias(appId, generationDateTime, refId, alias, expiryDateTime);
        return this.buildResponseObject(responseObjectType, appId, refId, timestamp, alias, generationDateTime, expiryDateTime, request);
    }

    private String getRootKeyAlias(String appId, LocalDateTime timestamp) {
        Map rootKeyAliasMap = this.dbHelper.getKeyAliases(this.rootKeyApplicationId, "", timestamp);
        List rootCurrentKeyAlias = (List)rootKeyAliasMap.get("currentKeyAlias");
        String rootKeyAlias = null;
        if (rootCurrentKeyAlias.size() > 1) {
            LOGGER.error("sessionId", "currentKeyAlias", String.valueOf(rootCurrentKeyAlias.size()), "CurrentKeyAlias size more than one for ROOT Key");
            throw new NoUniqueAliasException(KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorCode(), KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorMessage());
        }
        if (rootCurrentKeyAlias.size() == 1) {
            LOGGER.info("sessionId", "currentKeyAlias", String.valueOf(rootCurrentKeyAlias.size()), "CurrentKeyAlias size is one. Use the current root key alias as key to sign the key.");
            rootKeyAlias = ((KeyAlias)rootCurrentKeyAlias.get(0)).getAlias();
        }
        LOGGER.info("sessionId", "Root Key", "Found Root Key.", "Root Key for signing the new generated key: " + rootKeyAlias);
        if (Objects.isNull(rootKeyAlias) && !appId.equals(this.rootKeyApplicationId)) {
            LOGGER.error("sessionId", "Root Key", "Root Key Error", "ROOT Key not available to sign the new generated key.");
            throw new KeymanagerServiceException(KeymanagerErrorConstant.ROOT_KEY_NOT_FOUND.getErrorCode(), KeymanagerErrorConstant.ROOT_KEY_NOT_FOUND.getErrorMessage());
        }
        return rootKeyAlias;
    }

    private KeyPairGenerateResponseDto buildResponseObject(String responseObjectType, String appId, String refId, LocalDateTime timestamp, String keyAlias, LocalDateTime generationDateTime, LocalDateTime expiryDateTime, KeyPairGenerateRequestDto request) {
        if (responseObjectType.toUpperCase().equals("CERTIFICATE")) {
            LOGGER.info("sessionId", "applicationId", appId, "Getting Key Certificate for application ID: " + appId + ", RefId: " + refId);
            X509Certificate x509Cert = (X509Certificate)this.keyStore.getCertificate(keyAlias);
            KeyPairGenerateResponseDto responseDto = new KeyPairGenerateResponseDto();
            responseDto.setCertificate(this.keymanagerUtil.getPEMFormatedData((Object)x509Cert));
            responseDto.setExpiryAt(DateUtils.parseDateToLocalDateTime((Date)x509Cert.getNotAfter()));
            responseDto.setIssuedAt(DateUtils.parseDateToLocalDateTime((Date)x509Cert.getNotBefore()));
            responseDto.setTimestamp(timestamp);
            return responseDto;
        }
        if (responseObjectType.toUpperCase().equals("CSR")) {
            LOGGER.info("sessionId", "applicationId", appId, "Getting Key CSR for application ID: " + appId + ", RefId: " + refId);
            PublicKey publicKey = ((X509Certificate)this.keyStore.getCertificate(keyAlias)).getPublicKey();
            PrivateKey privateKey = this.keyStore.getPrivateKey(keyAlias);
            KeyPairGenerateResponseDto responseDto = new KeyPairGenerateResponseDto();
            CertificateParameters certParams = this.keymanagerUtil.getCertificateParameters(request, generationDateTime, expiryDateTime);
            responseDto.setCertSignRequest(this.keymanagerUtil.getCSR(privateKey, publicKey, certParams));
            responseDto.setExpiryAt(expiryDateTime);
            responseDto.setIssuedAt(generationDateTime);
            responseDto.setTimestamp(timestamp);
            return responseDto;
        }
        LOGGER.error("sessionId", "Response Object Type", null, "Invalid Response Object type provided for the key pair");
        throw new InvalidResponseObjectTypeException(KeymanagerErrorConstant.INVALID_RESPONSE_TYPE.getErrorCode(), KeymanagerErrorConstant.INVALID_RESPONSE_TYPE.getErrorMessage());
    }

    public KeyPairGenerateResponseDto getCertificate(String appId, Optional<String> refId) {
        LOGGER.info("sessionId", "applicationId", appId, "Request received to getCertificate");
        LOGGER.info("sessionId", "referenceId", refId.toString(), "Request received to getCertificate");
        LocalDateTime localDateTimeStamp = DateUtils.getUTCCurrentDateTime();
        CertificateInfo certificateData = null;
        if (!refId.isPresent() || refId.get().trim().isEmpty()) {
            LOGGER.info("sessionId", "", "", "Reference Id is not present. Will get Certificate from HSM");
            certificateData = this.getCertificateFromHSM(appId, localDateTimeStamp, "");
        } else if (appId.equalsIgnoreCase(this.signApplicationid) && refId.isPresent() && refId.get().equals(this.certificateSignRefID)) {
            LOGGER.info("sessionId", "", "", "Reference Id is present and it is SIGN reference. Will get Certificate from HSM");
            certificateData = this.getCertificateFromHSM(appId, localDateTimeStamp, refId.get());
        } else {
            LOGGER.info("sessionId", "", "", "Reference Id is present. Will get Certificate from DB store");
            certificateData = this.getCertificateFromDBStore(appId, localDateTimeStamp, refId.get());
        }
        X509Certificate x509Cert = (X509Certificate)certificateData.getCertificate();
        KeyPairGenerateResponseDto responseDto = new KeyPairGenerateResponseDto();
        responseDto.setCertificate(this.keymanagerUtil.getPEMFormatedData((Object)x509Cert));
        responseDto.setExpiryAt(DateUtils.parseDateToLocalDateTime((Date)x509Cert.getNotAfter()));
        responseDto.setIssuedAt(DateUtils.parseDateToLocalDateTime((Date)x509Cert.getNotBefore()));
        responseDto.setTimestamp(localDateTimeStamp);
        return responseDto;
    }

    public KeyPairGenerateResponseDto generateCSR(CSRGenerateRequestDto csrGenRequestDto) {
        String appId = csrGenRequestDto.getApplicationId();
        Optional<String> refId = Optional.ofNullable(csrGenRequestDto.getReferenceId());
        LocalDateTime localDateTimeStamp = DateUtils.getUTCCurrentDateTime();
        CertificateInfo certificateData = null;
        if (!refId.isPresent() || refId.get().trim().isEmpty()) {
            LOGGER.info("sessionId", "", "", "Reference Id is not present. Will get Certificate from HSM");
            certificateData = this.getCertificateFromHSM(appId, localDateTimeStamp, "");
        } else if (appId.equalsIgnoreCase(this.signApplicationid) && refId.isPresent() && refId.get().equals(this.certificateSignRefID)) {
            LOGGER.info("sessionId", "", "", "Reference Id is present and it is SIGN reference. Will get Certificate from HSM");
            certificateData = this.getCertificateFromHSM(appId, localDateTimeStamp, refId.get());
        } else {
            LOGGER.info("sessionId", "", "", "Reference Id is present. Will get Certificate from DB store");
            certificateData = this.getCertificateFromDBStore(appId, localDateTimeStamp, refId.get());
        }
        String keyAlias = certificateData.getAlias();
        Optional keyFromDBStore = this.dbHelper.getKeyStoreFromDB(keyAlias);
        Object[] keyDetailsArr = this.getKeyDetails(keyFromDBStore, keyAlias);
        PrivateKey signPrivateKey = (PrivateKey)keyDetailsArr[0];
        X509Certificate x509Cert = (X509Certificate)keyDetailsArr[1];
        LocalDateTime generationDateTime = DateUtils.parseDateToLocalDateTime((Date)x509Cert.getNotBefore());
        LocalDateTime expiryDateTime = DateUtils.parseDateToLocalDateTime((Date)x509Cert.getNotAfter());
        CertificateParameters certParams = this.keymanagerUtil.getCertificateParameters(csrGenRequestDto, generationDateTime, expiryDateTime);
        KeyPairGenerateResponseDto responseDto = new KeyPairGenerateResponseDto();
        responseDto.setCertSignRequest(this.keymanagerUtil.getCSR(signPrivateKey, x509Cert.getPublicKey(), certParams));
        responseDto.setExpiryAt(expiryDateTime);
        responseDto.setIssuedAt(generationDateTime);
        responseDto.setTimestamp(localDateTimeStamp);
        if (refId.isPresent() || !refId.get().trim().isEmpty()) {
            this.keymanagerUtil.destoryKey(signPrivateKey);
        }
        return responseDto;
    }

    private KeyAlias getKeyAlias(String appId, String refId) {
        if (!this.keymanagerUtil.isValidApplicationId(appId)) {
            LOGGER.error("sessionId", "applicationId", null, "Invalid application ID provided to get Object details.");
            throw new KeymanagerServiceException(KeymanagerErrorConstant.INVALID_REQUEST.getErrorCode(), KeymanagerErrorConstant.INVALID_REQUEST.getErrorMessage());
        }
        LOGGER.info("sessionId", "applicationId", appId, "to get KeyInfo for application ID: " + appId + ", RefId: " + refId);
        Optional keyPolicy = this.dbHelper.getKeyPolicy(appId);
        LocalDateTime timestamp = DateUtils.getUTCCurrentDateTime();
        Map keyAliasMap = this.dbHelper.getKeyAliases(appId, refId, timestamp);
        List currentKeyAlias = (List)keyAliasMap.get("currentKeyAlias");
        if (currentKeyAlias.size() > 1) {
            LOGGER.error("sessionId", "currentKeyAlias", String.valueOf(currentKeyAlias.size()), "CurrentKeyAlias size more than one");
            throw new NoUniqueAliasException(KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorCode(), KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorMessage());
        }
        if (currentKeyAlias.isEmpty()) {
            LOGGER.info("sessionId", "currentKeyAlias", String.valueOf(currentKeyAlias.size()), "CurrentKeyAlias size is zero for this applicationId and timestamp");
            throw new NoUniqueAliasException(KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorCode(), KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorMessage());
        }
        LOGGER.info("sessionId", "currentKeyAlias", String.valueOf(currentKeyAlias.size()), "key details present in DB: " + currentKeyAlias.get(0));
        KeyAlias fetchedKeyAlias = (KeyAlias)currentKeyAlias.get(0);
        return fetchedKeyAlias;
    }

    private Object[] getKeyDetails(Optional<io.mosip.kernel.keymanagerservice.entity.KeyStore> keyFromDBStore, String keyAlias) {
        if (!keyFromDBStore.isPresent()) {
            LOGGER.info("sessionId", "keyFromDBStore", keyFromDBStore.toString(), "Key in DBStore does not exist for this alias. So fetching the certificate from HSM.");
            KeyStore.PrivateKeyEntry signKeyEntry = this.keyStore.getAsymmetricKey(keyAlias);
            PrivateKey signPrivateKey = signKeyEntry.getPrivateKey();
            X509Certificate x509Cert = (X509Certificate)signKeyEntry.getCertificate();
            return new Object[]{signPrivateKey, x509Cert};
        }
        KeyStore.PrivateKeyEntry masterKeyEntry = this.keyStore.getAsymmetricKey(keyFromDBStore.get().getMasterAlias());
        PrivateKey masterPrivateKey = masterKeyEntry.getPrivateKey();
        PublicKey masterPublicKey = masterKeyEntry.getCertificate().getPublicKey();
        try {
            byte[] decryptedPrivateKey = this.keymanagerUtil.decryptKey(CryptoUtil.decodeBase64((String)keyFromDBStore.get().getPrivateKey()), masterPrivateKey, masterPublicKey);
            PrivateKey signPrivateKey = KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(decryptedPrivateKey));
            X509Certificate x509Cert = (X509Certificate)this.keymanagerUtil.convertToCertificate(keyFromDBStore.get().getCertificateData());
            return new Object[]{signPrivateKey, x509Cert};
        }
        catch (InvalidDataException | InvalidKeyException | NullDataException | NullKeyException | NullMethodException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new CryptoException(KeymanagerErrorConstant.CRYPTO_EXCEPTION.getErrorCode(), KeymanagerErrorConstant.CRYPTO_EXCEPTION.getErrorMessage() + e.getMessage(), e);
        }
    }

    public UploadCertificateResponseDto uploadCertificate(UploadCertificateRequestDto uploadCertRequestDto) {
        String appId = uploadCertRequestDto.getApplicationId();
        String refId = uploadCertRequestDto.getReferenceId();
        String certificateData = uploadCertRequestDto.getCertificateData();
        if (!this.keymanagerUtil.isValidCertificateData(certificateData)) {
            LOGGER.error("sessionId", "applicationId", null, "Invalid Certificate Data provided to upload the certificate.");
            throw new KeymanagerServiceException(KeymanagerErrorConstant.INVALID_REQUEST.getErrorCode(), KeymanagerErrorConstant.INVALID_REQUEST.getErrorMessage());
        }
        LocalDateTime timestamp = DateUtils.getUTCCurrentDateTime();
        KeyAlias currentKeyAlias = this.getKeyAlias(appId, refId);
        String keyAlias = currentKeyAlias.getAlias();
        Optional keyFromDBStore = this.dbHelper.getKeyStoreFromDB(keyAlias);
        Object[] keyDetailsArr = this.getKeyDetails(keyFromDBStore, keyAlias);
        PrivateKey privateKey = (PrivateKey)keyDetailsArr[0];
        X509Certificate x509Cert = (X509Certificate)keyDetailsArr[1];
        X509Certificate reqX509Cert = (X509Certificate)this.keymanagerUtil.convertToCertificate(certificateData);
        if (!Arrays.equals(x509Cert.getPublicKey().getEncoded(), reqX509Cert.getPublicKey().getEncoded())) {
            LOGGER.error("sessionId", "applicationId", null, "Certificate Key is not matching with the available key.");
            throw new KeymanagerServiceException(KeymanagerErrorConstant.KEY_NOT_MATCHING.getErrorCode(), KeymanagerErrorConstant.KEY_NOT_MATCHING.getErrorMessage());
        }
        LocalDateTime notBeforeDate = this.keymanagerUtil.convertToUTC(reqX509Cert.getNotBefore());
        LocalDateTime notAfterDate = this.keymanagerUtil.convertToUTC(reqX509Cert.getNotAfter());
        if (!keyFromDBStore.isPresent()) {
            this.keyStore.storeCertificate(keyAlias, privateKey, (Certificate)reqX509Cert);
        } else {
            this.dbHelper.storeKeyInDBStore(keyAlias, ((io.mosip.kernel.keymanagerservice.entity.KeyStore)keyFromDBStore.get()).getMasterAlias(), this.keymanagerUtil.getPEMFormatedData((Object)reqX509Cert), ((io.mosip.kernel.keymanagerservice.entity.KeyStore)keyFromDBStore.get()).getPrivateKey());
        }
        this.dbHelper.storeKeyInAlias(appId, notBeforeDate, refId, keyAlias, notAfterDate);
        UploadCertificateResponseDto responseDto = new UploadCertificateResponseDto();
        responseDto.setStatus("Upload Success");
        responseDto.setTimestamp(timestamp);
        return responseDto;
    }

    public UploadCertificateResponseDto uploadOtherDomainCertificate(UploadCertificateRequestDto uploadCertRequestDto) {
        String appId = uploadCertRequestDto.getApplicationId();
        String refId = uploadCertRequestDto.getReferenceId();
        String certificateData = uploadCertRequestDto.getCertificateData();
        if (!(this.keymanagerUtil.isValidCertificateData(certificateData) && this.keymanagerUtil.isValidReferenceId(refId) && this.keymanagerUtil.isValidApplicationId(appId))) {
            LOGGER.error("sessionId", "applicationId", null, "Invalid Data provided to upload other domain certificate.");
            throw new KeymanagerServiceException(KeymanagerErrorConstant.INVALID_REQUEST.getErrorCode(), KeymanagerErrorConstant.INVALID_REQUEST.getErrorMessage());
        }
        if (appId.equalsIgnoreCase(this.signApplicationid) && refId.equalsIgnoreCase(this.certificateSignRefID)) {
            LOGGER.error("sessionId", "applicationId", null, "Not allowed to uploaded AppId: KERNEL & RefId: SIGN.");
            throw new KeymanagerServiceException(KeymanagerErrorConstant.UPLOAD_NOT_ALLOWED.getErrorCode(), KeymanagerErrorConstant.UPLOAD_NOT_ALLOWED.getErrorMessage());
        }
        LOGGER.info("sessionId", "applicationId", appId, "to get KeyInfo for application ID: " + appId + ", RefId: " + refId);
        LocalDateTime timestamp = DateUtils.getUTCCurrentDateTime();
        Map keyAliasMap = this.dbHelper.getKeyAliases(appId, refId, timestamp);
        List currentKeyAlias = (List)keyAliasMap.get("currentKeyAlias");
        if (currentKeyAlias.size() > 1) {
            LOGGER.error("sessionId", "currentKeyAlias", String.valueOf(currentKeyAlias.size()), "CurrentKeyAlias size more than one");
            throw new NoUniqueAliasException(KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorCode(), KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorMessage());
        }
        List keyAliasList = (List)keyAliasMap.get("keyAlias");
        X509Certificate reqX509Cert = (X509Certificate)this.keymanagerUtil.convertToCertificate(certificateData);
        LocalDateTime notBeforeDate = this.keymanagerUtil.convertToUTC(reqX509Cert.getNotBefore());
        LocalDateTime notAfterDate = this.keymanagerUtil.convertToUTC(reqX509Cert.getNotAfter());
        if (currentKeyAlias.isEmpty() && keyAliasList.isEmpty()) {
            return this.storeAndBuildResponse(appId, refId, reqX509Cert, notBeforeDate, notAfterDate);
        }
        if (currentKeyAlias.isEmpty() && keyAliasList.size() > 0) {
            String keyAlias = ((KeyAlias)keyAliasList.get(0)).getAlias();
            Optional keyFromDBStore = this.dbHelper.getKeyStoreFromDB(keyAlias);
            if (!keyFromDBStore.isPresent()) {
                LOGGER.error("sessionId", "", "", "Other valid key is available, so not allowed to upload certificate.");
                throw new KeymanagerServiceException(KeymanagerErrorConstant.UPLOAD_NOT_ALLOWED.getErrorCode(), KeymanagerErrorConstant.UPLOAD_NOT_ALLOWED.getErrorMessage());
            }
            return this.storeAndBuildResponse(appId, refId, reqX509Cert, notBeforeDate, notAfterDate);
        }
        String keyAlias = ((KeyAlias)currentKeyAlias.get(0)).getAlias();
        Optional keyFromDBStore = this.dbHelper.getKeyStoreFromDB(keyAlias);
        if (!keyFromDBStore.isPresent() && currentKeyAlias.size() == 1) {
            LOGGER.error("sessionId", "", "", "Other valid key is available, so not allowed to upload certificate.");
            throw new KeymanagerServiceException(KeymanagerErrorConstant.UPLOAD_NOT_ALLOWED.getErrorCode(), KeymanagerErrorConstant.UPLOAD_NOT_ALLOWED.getErrorMessage());
        }
        String masterKeyAlias = ((io.mosip.kernel.keymanagerservice.entity.KeyStore)keyFromDBStore.get()).getMasterAlias();
        String privateKeyObj = ((io.mosip.kernel.keymanagerservice.entity.KeyStore)keyFromDBStore.get()).getPrivateKey();
        if (!keyAlias.equals(masterKeyAlias) || !privateKeyObj.equals("NA")) {
            LOGGER.error("sessionId", "applicationId", null, "Not Allowed to update certificate for other domains.");
            throw new KeymanagerServiceException(KeymanagerErrorConstant.UPLOAD_NOT_ALLOWED.getErrorCode(), KeymanagerErrorConstant.UPLOAD_NOT_ALLOWED.getErrorMessage());
        }
        LocalDateTime expireTime = timestamp.minusMinutes(1L);
        this.dbHelper.storeKeyInAlias(appId, ((KeyAlias)currentKeyAlias.get(0)).getKeyGenerationTime(), refId, keyAlias, expireTime);
        return this.storeAndBuildResponse(appId, refId, reqX509Cert, notBeforeDate, notAfterDate);
    }

    private UploadCertificateResponseDto storeAndBuildResponse(String appId, String refId, X509Certificate reqX509Cert, LocalDateTime notBeforeDate, LocalDateTime notAfterDate) {
        String alias = UUID.randomUUID().toString();
        this.dbHelper.storeKeyInDBStore(alias, alias, this.keymanagerUtil.getPEMFormatedData((Object)reqX509Cert), "NA");
        this.dbHelper.storeKeyInAlias(appId, notBeforeDate, refId, alias, notAfterDate);
        UploadCertificateResponseDto responseDto = new UploadCertificateResponseDto();
        responseDto.setStatus("Upload Success");
        responseDto.setTimestamp(DateUtils.getUTCCurrentDateTime());
        return responseDto;
    }

    public SymmetricKeyGenerateResponseDto generateSymmetricKey(SymmetricKeyGenerateRequestDto symGenRequestDto) {
        String appId = symGenRequestDto.getApplicationId();
        String refId = symGenRequestDto.getReferenceId();
        LOGGER.info("sessionId", "applicationId", appId, "Request for Symmetric Key Generation.");
        if (!this.keymanagerUtil.isValidReferenceId(refId) || !this.keymanagerUtil.isValidApplicationId(appId)) {
            LOGGER.error("sessionId", "applicationId", null, "Invalid Data provided to generate symmetric key.");
            throw new KeymanagerServiceException(KeymanagerErrorConstant.INVALID_REQUEST.getErrorCode(), KeymanagerErrorConstant.INVALID_REQUEST.getErrorMessage());
        }
        LOGGER.info("sessionId", "applicationId", appId, "to get KeyInfo for application ID: " + appId + ", RefId: " + refId);
        LocalDateTime timestamp = DateUtils.getUTCCurrentDateTime();
        Map keyAliasMap = this.dbHelper.getKeyAliases(appId, refId, timestamp);
        List currentKeyAlias = (List)keyAliasMap.get("currentKeyAlias");
        if (currentKeyAlias.size() > 1) {
            LOGGER.error("sessionId", "currentKeyAlias", String.valueOf(currentKeyAlias.size()), "CurrentKeyAlias size more than one");
            throw new NoUniqueAliasException(KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorCode(), KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorMessage());
        }
        Boolean forceFlag = symGenRequestDto.getForce();
        if (forceFlag.booleanValue()) {
            LOGGER.debug("sessionId", "applicationId", appId, "Force Flag is True, Invalidating the existing key and generating new key.");
            LocalDateTime expireTime = timestamp.minusMinutes(1L);
            currentKeyAlias.forEach(alias -> this.dbHelper.storeKeyInAlias(appId, alias.getKeyGenerationTime(), refId, alias.getAlias(), expireTime));
            return this.generateAndBuildResponse(appId, refId, timestamp);
        }
        if (currentKeyAlias.size() == 1) {
            return this.buildSymGenKeyRespObject(timestamp, "Key Exists.");
        }
        return this.generateAndBuildResponse(appId, refId, timestamp);
    }

    private SymmetricKeyGenerateResponseDto generateAndBuildResponse(String appId, String refId, LocalDateTime timestamp) {
        String alias = UUID.randomUUID().toString();
        LocalDateTime expiryDateTime = timestamp.plusDays(3650L);
        this.keyStore.generateAndStoreSymmetricKey(alias);
        this.dbHelper.storeKeyInAlias(appId, timestamp, refId, alias, expiryDateTime);
        return this.buildSymGenKeyRespObject(timestamp, "Generation Success");
    }

    private SymmetricKeyGenerateResponseDto buildSymGenKeyRespObject(LocalDateTime timestamp, String status) {
        SymmetricKeyGenerateResponseDto responseDto = new SymmetricKeyGenerateResponseDto();
        responseDto.setStatus(status);
        responseDto.setTimestamp(timestamp);
        return responseDto;
    }
}

