/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.partnercertservice.helper;

import io.mosip.kernel.core.logger.spi.Logger;
import io.mosip.kernel.core.util.DateUtils;
import io.mosip.kernel.keymanagerservice.entity.BaseEntity;
import io.mosip.kernel.keymanagerservice.entity.CACertificateStore;
import io.mosip.kernel.keymanagerservice.entity.PartnerCertificateStore;
import io.mosip.kernel.keymanagerservice.logger.KeymanagerLogger;
import io.mosip.kernel.keymanagerservice.repository.CACertificateStoreRepository;
import io.mosip.kernel.keymanagerservice.repository.PartnerCertificateStoreRepository;
import io.mosip.kernel.keymanagerservice.util.KeymanagerUtil;
import io.mosip.kernel.partnercertservice.util.PartnerCertificateManagerUtil;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PartnerCertManagerDBHelper {
    private static final Logger LOGGER = KeymanagerLogger.getLogger(PartnerCertManagerDBHelper.class);
    @Autowired
    CACertificateStoreRepository caCertificateStoreRepository;
    @Autowired
    PartnerCertificateStoreRepository partnerCertificateStoreRepository;
    @Autowired
    KeymanagerUtil keymanagerUtil;

    public boolean isCertificateExist(String certThumbprint, String partnerDomain) {
        CACertificateStore caCertificate = this.caCertificateStoreRepository.findByCertThumbprintAndPartnerDomain(certThumbprint, partnerDomain);
        return Objects.nonNull(caCertificate);
    }

    public boolean isPartnerCertificateExist(String certThumbprint, String partnerDomain) {
        PartnerCertificateStore partnerCertificate = this.partnerCertificateStoreRepository.findByCertThumbprintAndPartnerDomain(certThumbprint, partnerDomain);
        return Objects.nonNull(partnerCertificate);
    }

    public void storeCACertificate(String certId, String certSubject, String certIssuer, String issuerId, X509Certificate reqX509Cert, String certThumbprint, String partnerDomain) {
        String certSerialNo = reqX509Cert.getSerialNumber().toString();
        LocalDateTime notBeforeDate = DateUtils.parseDateToLocalDateTime((Date)reqX509Cert.getNotBefore());
        LocalDateTime notAfterDate = DateUtils.parseDateToLocalDateTime((Date)reqX509Cert.getNotAfter());
        String certData = this.keymanagerUtil.getPEMFormatedData((Object)reqX509Cert);
        CACertificateStore certStoreObj = new CACertificateStore();
        certStoreObj.setCertId(certId);
        certStoreObj.setCertSubject(certSubject);
        certStoreObj.setCertIssuer(certIssuer);
        certStoreObj.setIssuerId(issuerId);
        certStoreObj.setCertNotBefore(notBeforeDate);
        certStoreObj.setCertNotAfter(notAfterDate);
        certStoreObj.setCertData(certData);
        certStoreObj.setCertThumbprint(certThumbprint);
        certStoreObj.setCertSerialNo(certSerialNo);
        certStoreObj.setPartnerDomain(partnerDomain);
        this.caCertificateStoreRepository.saveAndFlush((Object)((CACertificateStore)this.keymanagerUtil.setMetaData((BaseEntity)certStoreObj)));
    }

    public Map<String, Set<?>> getTrustAnchors(String partnerDomain) {
        HashSet rootTrust = new HashSet();
        HashSet intermediateCerts = new HashSet();
        this.caCertificateStoreRepository.findByPartnerDomain(partnerDomain).stream().forEach(trustCert -> {
            String certificateData = trustCert.getCertData();
            X509Certificate x509Cert = (X509Certificate)this.keymanagerUtil.convertToCertificate(certificateData);
            if (PartnerCertificateManagerUtil.isSelfSignedCertificate((X509Certificate)x509Cert)) {
                rootTrust.add(new TrustAnchor(x509Cert, null));
            } else {
                intermediateCerts.add(x509Cert);
            }
        });
        HashMap hashMap = new HashMap();
        hashMap.put("TrustRoot", rootTrust);
        hashMap.put("TrustInter", intermediateCerts);
        return hashMap;
    }

    public String getIssuerCertId(String certIssuerDn) {
        LocalDateTime currentDateTime = DateUtils.getUTCCurrentDateTime();
        List certificates = this.caCertificateStoreRepository.findByCertSubject(certIssuerDn).stream().filter(cert -> PartnerCertificateManagerUtil.isValidTimestamp((LocalDateTime)currentDateTime, (CACertificateStore)cert)).collect(Collectors.toList());
        if (certificates.size() == 1) {
            return ((CACertificateStore)certificates.get(0)).getCertId();
        }
        List sortedCerts = certificates.stream().sorted((cert1, cert2) -> cert1.getCertNotBefore().compareTo(cert2.getCertNotBefore())).collect(Collectors.toList());
        return ((CACertificateStore)sortedCerts.get(0)).getCertId();
    }

    public void storePartnerCertificate(String certId, String certSubject, String certIssuer, String issuerId, X509Certificate reqX509Cert, String certThumbprint, String orgName, String partnerDomain, String signedCertData) {
        String certSerialNo = reqX509Cert.getSerialNumber().toString();
        LocalDateTime notBeforeDate = DateUtils.parseDateToLocalDateTime((Date)reqX509Cert.getNotBefore());
        LocalDateTime notAfterDate = DateUtils.parseDateToLocalDateTime((Date)reqX509Cert.getNotAfter());
        String certData = this.keymanagerUtil.getPEMFormatedData((Object)reqX509Cert);
        PartnerCertificateStore partnerStoreObj = new PartnerCertificateStore();
        partnerStoreObj.setCertId(certId);
        partnerStoreObj.setCertSubject(certSubject);
        partnerStoreObj.setCertIssuer(certIssuer);
        partnerStoreObj.setIssuerId(issuerId);
        partnerStoreObj.setCertNotBefore(notBeforeDate);
        partnerStoreObj.setCertNotAfter(notAfterDate);
        partnerStoreObj.setCertData(certData);
        partnerStoreObj.setCertThumbprint(certThumbprint);
        partnerStoreObj.setCertSerialNo(certSerialNo);
        partnerStoreObj.setOrganizationName(orgName);
        partnerStoreObj.setPartnerDomain(partnerDomain);
        partnerStoreObj.setKeyUsage("");
        partnerStoreObj.setSignedCertData(signedCertData);
        this.partnerCertificateStoreRepository.saveAndFlush((Object)((PartnerCertificateStore)this.keymanagerUtil.setMetaData((BaseEntity)partnerStoreObj)));
    }

    public PartnerCertificateStore getPartnetCert(String certId) {
        return this.partnerCertificateStoreRepository.findByCertId(certId);
    }
}

