/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.partnercertservice.controller;

import io.mosip.kernel.core.http.RequestWrapper;
import io.mosip.kernel.core.http.ResponseFilter;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.mosip.kernel.partnercertservice.dto.CACertificateRequestDto;
import io.mosip.kernel.partnercertservice.dto.CACertificateResponseDto;
import io.mosip.kernel.partnercertservice.dto.CertificateTrustRequestDto;
import io.mosip.kernel.partnercertservice.dto.CertificateTrustResponeDto;
import io.mosip.kernel.partnercertservice.dto.PartnerCertDownloadRequestDto;
import io.mosip.kernel.partnercertservice.dto.PartnerCertDownloadResponeDto;
import io.mosip.kernel.partnercertservice.dto.PartnerCertificateRequestDto;
import io.mosip.kernel.partnercertservice.dto.PartnerCertificateResponseDto;
import io.mosip.kernel.partnercertservice.service.spi.PartnerCertificateManagerService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiParam;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
@Api(value="Operation related to partner certificate management.", tags={"partnercertmanager"})
public class PartnerCertManagerController {
    @Autowired
    PartnerCertificateManagerService partnerCertManagerService;

    @ResponseFilter
    @PostMapping(value={"/uploadCACertificate"}, produces={"application/json"})
    public ResponseWrapper<CACertificateResponseDto> uploadCACertificate(@ApiParam(value="Upload CA/Sub-CA certificates.") @RequestBody @Valid RequestWrapper<CACertificateRequestDto> caCertRequestDto) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.partnerCertManagerService.uploadCACertificate((CACertificateRequestDto)caCertRequestDto.getRequest()));
        return response;
    }

    @ResponseFilter
    @PostMapping(value={"/uploadPartnerCertificate"}, produces={"application/json"})
    public ResponseWrapper<PartnerCertificateResponseDto> uploadPartnerCertificate(@ApiParam(value="Upload Partner Certificates.") @RequestBody @Valid RequestWrapper<PartnerCertificateRequestDto> partnerCertRequestDto) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.partnerCertManagerService.uploadPartnerCertificate((PartnerCertificateRequestDto)partnerCertRequestDto.getRequest()));
        return response;
    }

    @ResponseFilter
    @GetMapping(value={"/getPartnerCertificate/{partnerCertId}"})
    public ResponseWrapper<PartnerCertDownloadResponeDto> getPartnerCertificate(@ApiParam(value="To download re-signed partner certificate.") @PathVariable(value="partnerCertId") String partnerCertId) {
        PartnerCertDownloadRequestDto certDownloadRequestDto = new PartnerCertDownloadRequestDto();
        certDownloadRequestDto.setPartnerCertId(partnerCertId);
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.partnerCertManagerService.getPartnerCertificate(certDownloadRequestDto));
        return response;
    }

    @ResponseFilter
    @PostMapping(value={"/verifyCertificateTrust"}, produces={"application/json"})
    public ResponseWrapper<CertificateTrustResponeDto> verifyCertificateTrust(@ApiParam(value="Upload Partner Certificates.") @RequestBody @Valid RequestWrapper<CertificateTrustRequestDto> certificateTrustRequestDto) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.partnerCertManagerService.verifyCertificateTrust((CertificateTrustRequestDto)certificateTrustRequestDto.getRequest()));
        return response;
    }
}

