/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.keymanager.hsm.util;

import io.mosip.kernel.core.keymanager.exception.KeystoreProcessingException;
import io.mosip.kernel.core.keymanager.model.CertificateParameters;
import io.mosip.kernel.keymanager.hsm.constant.KeymanagerErrorCode;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.Objects;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.RFC4519Style;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
public class CertificateUtility {
    private CertificateUtility() {
    }

    public static X509Certificate generateX509Certificate(PrivateKey signPrivateKey, PublicKey publicKey, String commonName, String organizationalUnit, String organization, String country, LocalDateTime validityFrom, LocalDateTime validityTo, String signAlgorithm, String providerName) {
        X500Name rootCertIssuer;
        X500Name rootCertSubject = rootCertIssuer = new X500Name(CertificateUtility.getCertificateAttributes((String)commonName, (String)organizationalUnit, (String)organization, (String)country));
        return CertificateUtility.generateX509Certificate((PrivateKey)signPrivateKey, (PublicKey)publicKey, (X500Name)rootCertIssuer, (X500Name)rootCertSubject, (String)signAlgorithm, (String)providerName, (LocalDateTime)validityFrom, (LocalDateTime)validityTo);
    }

    public static X509Certificate generateX509Certificate(PrivateKey signPrivateKey, PublicKey publicKey, CertificateParameters certParams, X500Principal signerPrincipal, String signAlgorithm, String providerName) {
        X500Name certSubject = CertificateUtility.getCertificateAttributes((CertificateParameters)certParams);
        X500Name certIssuer = Objects.nonNull(signerPrincipal) ? new X500Name(RFC4519Style.INSTANCE, signerPrincipal.getName()) : certSubject;
        return CertificateUtility.generateX509Certificate((PrivateKey)signPrivateKey, (PublicKey)publicKey, (X500Name)certIssuer, (X500Name)certSubject, (String)signAlgorithm, (String)providerName, (LocalDateTime)certParams.getNotBefore(), (LocalDateTime)certParams.getNotAfter());
    }

    private static X509Certificate generateX509Certificate(PrivateKey signPrivateKey, PublicKey publicKey, X500Name certIssuer, X500Name certSubject, String signAlgorithm, String providerName, LocalDateTime notBefore, LocalDateTime notAfter) {
        try {
            BigInteger certSerialNum = new BigInteger(Long.toString(new SecureRandom().nextLong()));
            ContentSigner certContentSigner = new JcaContentSignerBuilder(signAlgorithm).setProvider(providerName).build(signPrivateKey);
            JcaX509v3CertificateBuilder certBuilder = new JcaX509v3CertificateBuilder(certIssuer, certSerialNum, CertificateUtility.getDateFromLocalDateTime((LocalDateTime)notBefore), CertificateUtility.getDateFromLocalDateTime((LocalDateTime)notAfter), certSubject, publicKey);
            JcaX509ExtensionUtils certExtUtils = new JcaX509ExtensionUtils();
            certBuilder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(true));
            certBuilder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)certExtUtils.createSubjectKeyIdentifier(publicKey));
            X509CertificateHolder certHolder = certBuilder.build(certContentSigner);
            return new JcaX509CertificateConverter().getCertificate(certHolder);
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException | OperatorCreationException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.CERTIFICATE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.CERTIFICATE_PROCESSING_ERROR.getErrorMessage() + e.getMessage(), e);
        }
    }

    private static Date getDateFromLocalDateTime(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    private static String getCertificateAttributes(String commonName, String organizationalUnit, String organization, String country) {
        return "CN=" + commonName + ", OU =" + organizationalUnit + ",O=" + organization + ", C=" + country;
    }

    private static X500Name getCertificateAttributes(CertificateParameters certParams) {
        X500NameBuilder builder = new X500NameBuilder(RFC4519Style.INSTANCE);
        CertificateUtility.addRDN((String)certParams.getCountry(), (X500NameBuilder)builder, (ASN1ObjectIdentifier)BCStyle.C);
        CertificateUtility.addRDN((String)certParams.getState(), (X500NameBuilder)builder, (ASN1ObjectIdentifier)BCStyle.ST);
        CertificateUtility.addRDN((String)certParams.getLocation(), (X500NameBuilder)builder, (ASN1ObjectIdentifier)BCStyle.L);
        CertificateUtility.addRDN((String)certParams.getOrganization(), (X500NameBuilder)builder, (ASN1ObjectIdentifier)BCStyle.O);
        CertificateUtility.addRDN((String)certParams.getOrganizationUnit(), (X500NameBuilder)builder, (ASN1ObjectIdentifier)BCStyle.OU);
        CertificateUtility.addRDN((String)certParams.getCommonName(), (X500NameBuilder)builder, (ASN1ObjectIdentifier)BCStyle.CN);
        return builder.build();
    }

    private static void addRDN(String dnValue, X500NameBuilder builder, ASN1ObjectIdentifier identifier) {
        if (dnValue != null && !dnValue.isEmpty()) {
            builder.addRDN(identifier, dnValue);
        }
    }
}

