/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.cryptomanager.service.impl;

import io.mosip.kernel.core.crypto.spi.CryptoCoreSpec;
import io.mosip.kernel.core.util.CryptoUtil;
import io.mosip.kernel.cryptomanager.dto.CryptoWithPinRequestDto;
import io.mosip.kernel.cryptomanager.dto.CryptoWithPinResponseDto;
import io.mosip.kernel.cryptomanager.dto.CryptomanagerRequestDto;
import io.mosip.kernel.cryptomanager.dto.CryptomanagerResponseDto;
import io.mosip.kernel.cryptomanager.service.CryptomanagerService;
import io.mosip.kernel.cryptomanager.util.CryptomanagerUtils;
import io.mosip.kernel.keygenerator.bouncycastle.KeyGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CryptomanagerServiceImpl
implements CryptomanagerService {
    private static final int GCM_NONCE_LENGTH = 12;
    private static final int PBE_SALT_LENGTH = 32;
    private static final String AES_KEY_TYPE = "AES";
    @Value(value="${mosip.kernel.data-key-splitter}")
    private String keySplitter;
    @Autowired
    KeyGenerator keyGenerator;
    @Autowired
    CryptomanagerUtils cryptomanagerUtil;
    @Autowired
    private CryptoCoreSpec<byte[], byte[], SecretKey, PublicKey, PrivateKey, String> cryptoCore;

    public CryptomanagerResponseDto encrypt(CryptomanagerRequestDto cryptoRequestDto) {
        SecretKey secretKey = this.keyGenerator.getSymmetricKey();
        byte[] encryptedData = this.cryptomanagerUtil.isValidSalt(CryptomanagerUtils.nullOrTrim((String)cryptoRequestDto.getSalt())) ? (byte[])this.cryptoCore.symmetricEncrypt((Object)secretKey, (Object)CryptoUtil.decodeBase64((String)cryptoRequestDto.getData()), (Object)CryptoUtil.decodeBase64((String)CryptomanagerUtils.nullOrTrim((String)cryptoRequestDto.getSalt())), (Object)CryptoUtil.decodeBase64((String)CryptomanagerUtils.nullOrTrim((String)cryptoRequestDto.getAad()))) : (byte[])this.cryptoCore.symmetricEncrypt((Object)secretKey, (Object)CryptoUtil.decodeBase64((String)cryptoRequestDto.getData()), (Object)CryptoUtil.decodeBase64((String)CryptomanagerUtils.nullOrTrim((String)cryptoRequestDto.getAad())));
        Certificate certificate = this.cryptomanagerUtil.getCertificate(cryptoRequestDto);
        PublicKey publicKey = certificate.getPublicKey();
        byte[] encryptedSymmetricKey = (byte[])this.cryptoCore.asymmetricEncrypt((Object)publicKey, (Object)secretKey.getEncoded());
        Boolean prependThumbprint = cryptoRequestDto.getPrependThumbprint() == null ? false : cryptoRequestDto.getPrependThumbprint();
        CryptomanagerResponseDto cryptoResponseDto = new CryptomanagerResponseDto();
        if (prependThumbprint.booleanValue()) {
            byte[] certThumbprint = this.cryptomanagerUtil.getCertificateThumbprint(certificate);
            byte[] concatedData = this.cryptomanagerUtil.concatCertThumbprint(certThumbprint, encryptedSymmetricKey);
            cryptoResponseDto.setData(CryptoUtil.encodeBase64((byte[])CryptoUtil.combineByteArray((byte[])encryptedData, (byte[])concatedData, (String)this.keySplitter)));
            return cryptoResponseDto;
        }
        cryptoResponseDto.setData(CryptoUtil.encodeBase64((byte[])CryptoUtil.combineByteArray((byte[])encryptedData, (byte[])encryptedSymmetricKey, (String)this.keySplitter)));
        return cryptoResponseDto;
    }

    public CryptomanagerResponseDto decrypt(CryptomanagerRequestDto cryptoRequestDto) {
        int keyDemiliterIndex = 0;
        byte[] encryptedHybridData = CryptoUtil.decodeBase64((String)cryptoRequestDto.getData());
        keyDemiliterIndex = CryptoUtil.getSplitterIndex((byte[])encryptedHybridData, (int)keyDemiliterIndex, (String)this.keySplitter);
        byte[] encryptedKey = Arrays.copyOfRange(encryptedHybridData, 0, keyDemiliterIndex);
        byte[] encryptedData = Arrays.copyOfRange(encryptedHybridData, keyDemiliterIndex + this.keySplitter.length(), encryptedHybridData.length);
        cryptoRequestDto.setData(CryptoUtil.encodeBase64((byte[])encryptedKey));
        SecretKey decryptedSymmetricKey = this.cryptomanagerUtil.getDecryptedSymmetricKey(cryptoRequestDto);
        byte[] decryptedData = this.cryptomanagerUtil.isValidSalt(CryptomanagerUtils.nullOrTrim((String)cryptoRequestDto.getSalt())) ? (byte[])this.cryptoCore.symmetricDecrypt((Object)decryptedSymmetricKey, (Object)encryptedData, (Object)CryptoUtil.decodeBase64((String)CryptomanagerUtils.nullOrTrim((String)cryptoRequestDto.getSalt())), (Object)CryptoUtil.decodeBase64((String)CryptomanagerUtils.nullOrTrim((String)cryptoRequestDto.getAad()))) : (byte[])this.cryptoCore.symmetricDecrypt((Object)decryptedSymmetricKey, (Object)encryptedData, (Object)CryptoUtil.decodeBase64((String)CryptomanagerUtils.nullOrTrim((String)cryptoRequestDto.getAad())));
        CryptomanagerResponseDto cryptoResponseDto = new CryptomanagerResponseDto();
        cryptoResponseDto.setData(CryptoUtil.encodeBase64((byte[])decryptedData));
        return cryptoResponseDto;
    }

    public CryptoWithPinResponseDto encryptWithPin(CryptoWithPinRequestDto requestDto) {
        String dataToEnc = requestDto.getData();
        String userPin = requestDto.getUserPin();
        SecureRandom sRandom = new SecureRandom();
        byte[] pbeSalt = new byte[32];
        sRandom.nextBytes(pbeSalt);
        SecretKey derivedKey = this.getDerivedKey(userPin, pbeSalt);
        byte[] gcmNonce = new byte[12];
        sRandom.nextBytes(gcmNonce);
        byte[] encryptedData = (byte[])this.cryptoCore.symmetricEncrypt((Object)derivedKey, (Object)dataToEnc.getBytes(), (Object)gcmNonce, (Object)pbeSalt);
        byte[] finalEncryptedData = new byte[encryptedData.length + 32 + 12];
        System.arraycopy(pbeSalt, 0, finalEncryptedData, 0, pbeSalt.length);
        System.arraycopy(gcmNonce, 0, finalEncryptedData, pbeSalt.length, gcmNonce.length);
        System.arraycopy(encryptedData, 0, finalEncryptedData, pbeSalt.length + gcmNonce.length, encryptedData.length);
        CryptoWithPinResponseDto responseDto = new CryptoWithPinResponseDto();
        responseDto.setData(CryptoUtil.encodeBase64((byte[])finalEncryptedData));
        return responseDto;
    }

    public CryptoWithPinResponseDto decryptWithPin(CryptoWithPinRequestDto requestDto) {
        String dataToDec = requestDto.getData();
        String userPin = requestDto.getUserPin();
        byte[] decodedEncryptedData = CryptoUtil.decodeBase64((String)dataToDec);
        byte[] pbeSalt = Arrays.copyOfRange(decodedEncryptedData, 0, 32);
        byte[] gcmNonce = Arrays.copyOfRange(decodedEncryptedData, 32, 44);
        byte[] encryptedData = Arrays.copyOfRange(decodedEncryptedData, 44, decodedEncryptedData.length);
        SecretKey derivedKey = this.getDerivedKey(userPin, pbeSalt);
        byte[] decryptedData = (byte[])this.cryptoCore.symmetricDecrypt((Object)derivedKey, (Object)encryptedData, (Object)gcmNonce, (Object)pbeSalt);
        CryptoWithPinResponseDto responseDto = new CryptoWithPinResponseDto();
        responseDto.setData(new String(decryptedData));
        return responseDto;
    }

    private SecretKey getDerivedKey(String userPin, byte[] salt) {
        String derivedKeyHex = (String)this.cryptoCore.hash((Object)userPin.getBytes(), (Object)salt);
        byte[] derivedKey = this.cryptomanagerUtil.hexDecode(derivedKeyHex);
        return new SecretKeySpec(derivedKey, AES_KEY_TYPE);
    }
}

