/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.cryptomanager.constant;

public enum CryptomanagerErrorCode {
    NO_SUCH_ALGORITHM_EXCEPTION("KER-CRY-001", "No Such algorithm is supported"),
    INVALID_SPEC_PUBLIC_KEY("KER-CRY-002", "public key is invalid"),
    INVALID_DATA_WITHOUT_KEY_BREAKER("KER-CRY-003", "data sent to decrypt is without key splitter or invalid"),
    INVALID_DATA("KER-CRY-003", " or not base64 encoded"),
    INVALID_REQUEST("KER-CRY-004", "should not be null or empty"),
    CANNOT_CONNECT_TO_KEYMANAGER_SERVICE("KER-CRY-005", "cannot connect to keymanager service or response is null"),
    KEYMANAGER_SERVICE_ERROR("KER-CRY-006", "Keymanager Service has replied with following error"),
    RESPONSE_PARSE_ERROR("KER-CRY-008", "Error occur while parsing response "),
    DATE_TIME_PARSE_EXCEPTION("KER-CRY-007", "timestamp should be in ISO 8601 format yyyy-MM-ddTHH::mm:ss.SZ"),
    HEX_DATA_PARSE_EXCEPTION("KER-CRY-009", "Invalid Hex Data"),
    CERTIFICATE_THUMBPRINT_ERROR("KER-CRY-010", "Error in generating Certificate Thumbprint."),
    INTERNAL_SERVER_ERROR("KER-CRY-500", "Internal server error");

    private final String errorCode;
    private final String errorMessage;

    private CryptomanagerErrorCode(String errorCode, String errorMessage) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

