/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.clientcrypto.service.impl;

import io.mosip.kernel.clientcrypto.dto.PublicKeyRequestDto;
import io.mosip.kernel.clientcrypto.dto.PublicKeyResponseDto;
import io.mosip.kernel.clientcrypto.dto.TpmCryptoRequestDto;
import io.mosip.kernel.clientcrypto.dto.TpmCryptoResponseDto;
import io.mosip.kernel.clientcrypto.dto.TpmSignRequestDto;
import io.mosip.kernel.clientcrypto.dto.TpmSignResponseDto;
import io.mosip.kernel.clientcrypto.dto.TpmSignVerifyRequestDto;
import io.mosip.kernel.clientcrypto.dto.TpmSignVerifyResponseDto;
import io.mosip.kernel.clientcrypto.service.impl.ClientCryptoFacade;
import io.mosip.kernel.clientcrypto.service.spi.ClientCryptoManagerService;
import io.mosip.kernel.core.logger.spi.Logger;
import io.mosip.kernel.core.util.CryptoUtil;
import io.mosip.kernel.keymanagerservice.logger.KeymanagerLogger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClientCryptoManagerServiceImpl
implements ClientCryptoManagerService {
    private static final Logger LOGGER = KeymanagerLogger.getLogger(ClientCryptoManagerServiceImpl.class);
    @Autowired
    private ClientCryptoFacade clientCryptoFacade;

    public TpmSignResponseDto csSign(TpmSignRequestDto tpmSignRequestDto) {
        byte[] signedData = this.clientCryptoFacade.getClientSecurity().signData(CryptoUtil.decodeBase64((String)tpmSignRequestDto.getData()));
        TpmSignResponseDto tpmSignResponseDto = new TpmSignResponseDto();
        tpmSignResponseDto.setData(CryptoUtil.encodeBase64((byte[])signedData));
        return tpmSignResponseDto;
    }

    public TpmSignVerifyResponseDto csVerify(TpmSignVerifyRequestDto tpmSignVerifyRequestDto) {
        boolean result = this.clientCryptoFacade.validateSignature(CryptoUtil.decodeBase64((String)tpmSignVerifyRequestDto.getPublicKey()), CryptoUtil.decodeBase64((String)tpmSignVerifyRequestDto.getSignature()), CryptoUtil.decodeBase64((String)tpmSignVerifyRequestDto.getData()));
        TpmSignVerifyResponseDto tpmSignVerifyResponseDto = new TpmSignVerifyResponseDto();
        tpmSignVerifyResponseDto.setVerified(result);
        return tpmSignVerifyResponseDto;
    }

    public TpmCryptoResponseDto csEncrypt(TpmCryptoRequestDto tpmCryptoRequestDto) {
        byte[] cipher = this.clientCryptoFacade.encrypt(CryptoUtil.decodeBase64((String)tpmCryptoRequestDto.getPublicKey()), CryptoUtil.decodeBase64((String)tpmCryptoRequestDto.getValue()));
        TpmCryptoResponseDto tpmCryptoResponseDto = new TpmCryptoResponseDto();
        tpmCryptoResponseDto.setValue(CryptoUtil.encodeBase64((byte[])cipher));
        return tpmCryptoResponseDto;
    }

    public TpmCryptoResponseDto csDecrypt(TpmCryptoRequestDto tpmCryptoRequestDto) {
        byte[] plainData = this.clientCryptoFacade.decrypt(CryptoUtil.decodeBase64((String)tpmCryptoRequestDto.getValue()));
        TpmCryptoResponseDto tpmCryptoResponseDto = new TpmCryptoResponseDto();
        tpmCryptoResponseDto.setValue(CryptoUtil.encodeBase64((byte[])plainData));
        return tpmCryptoResponseDto;
    }

    public PublicKeyResponseDto getSigningPublicKey(PublicKeyRequestDto publicKeyRequestDto) {
        PublicKeyResponseDto publicKeyResponseDto = new PublicKeyResponseDto();
        publicKeyResponseDto.setPublicKey(CryptoUtil.encodeBase64((byte[])this.clientCryptoFacade.getClientSecurity().getSigningPublicPart()));
        return publicKeyResponseDto;
    }

    public PublicKeyResponseDto getEncPublicKey(PublicKeyRequestDto publicKeyRequestDto) {
        PublicKeyResponseDto publicKeyResponseDto = new PublicKeyResponseDto();
        publicKeyResponseDto.setPublicKey(CryptoUtil.encodeBase64((byte[])this.clientCryptoFacade.getClientSecurity().getEncryptionPublicPart()));
        return publicKeyResponseDto;
    }
}

