/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.zkcryptoservice.service.impl;

import io.mosip.kernel.core.crypto.spi.CryptoCoreSpec;
import io.mosip.kernel.core.keymanager.spi.KeyStore;
import io.mosip.kernel.core.logger.spi.Logger;
import io.mosip.kernel.core.util.CryptoUtil;
import io.mosip.kernel.core.util.DateUtils;
import io.mosip.kernel.cryptomanager.util.CryptomanagerUtils;
import io.mosip.kernel.keymanagerservice.dto.SymmetricKeyRequestDto;
import io.mosip.kernel.keymanagerservice.entity.KeyAlias;
import io.mosip.kernel.keymanagerservice.exception.NoUniqueAliasException;
import io.mosip.kernel.keymanagerservice.helper.KeymanagerDBHelper;
import io.mosip.kernel.keymanagerservice.logger.KeymanagerLogger;
import io.mosip.kernel.keymanagerservice.repository.DataEncryptKeystoreRepository;
import io.mosip.kernel.keymanagerservice.repository.KeyStoreRepository;
import io.mosip.kernel.keymanagerservice.service.KeymanagerService;
import io.mosip.kernel.keymanagerservice.util.KeymanagerUtil;
import io.mosip.kernel.zkcryptoservice.constant.ZKCryptoErrorConstants;
import io.mosip.kernel.zkcryptoservice.dto.CryptoDataDto;
import io.mosip.kernel.zkcryptoservice.dto.ReEncryptRandomKeyResponseDto;
import io.mosip.kernel.zkcryptoservice.dto.ZKCryptoRequestDto;
import io.mosip.kernel.zkcryptoservice.dto.ZKCryptoResponseDto;
import io.mosip.kernel.zkcryptoservice.exception.ZKCryptoException;
import io.mosip.kernel.zkcryptoservice.exception.ZKKeyDerivationException;
import io.mosip.kernel.zkcryptoservice.exception.ZKRandomKeyDecryptionException;
import io.mosip.kernel.zkcryptoservice.service.spi.ZKCryptoManagerService;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Stream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ZKCryptoManagerServiceImpl
implements ZKCryptoManagerService,
InitializingBean {
    private static final Logger LOGGER = KeymanagerLogger.getLogger(ZKCryptoManagerServiceImpl.class);
    @Value(value="${mosip.kernel.crypto.symmetric-algorithm-name}")
    private String aesGCMTransformation;
    @Value(value="${mosip.kernel.zkcrypto.masterkey.application.id}")
    private String masterKeyAppId;
    @Value(value="${mosip.kernel.zkcrypto.masterkey.reference.id}")
    private String masterKeyRefId;
    @Value(value="${mosip.kernel.zkcrypto.publickey.application.id}")
    private String pubKeyApplicationId;
    @Value(value="${mosip.kernel.zkcrypto.publickey.reference.id}")
    private String pubKeyReferenceId;
    @Value(value="${mosip.kernel.zkcrypto.wrap.algorithm-name}")
    private String aesECBTransformation;
    @Value(value="${mosip.kernel.zkcrypto.derive.encrypt.algorithm-name}")
    private String aesECBPKCS5Transformation;
    @Autowired
    private DataEncryptKeystoreRepository dataEncryptKeystoreRepository;
    @Autowired
    private KeymanagerDBHelper dbHelper;
    @Autowired
    private KeyStoreRepository keyStoreRepository;
    @Autowired
    private KeyStore keyStore;
    @Autowired
    KeymanagerUtil keymanagerUtil;
    @Autowired
    private KeymanagerService keyManagerService;
    @Autowired
    CryptomanagerUtils cryptomanagerUtil;
    @Autowired
    private CryptoCoreSpec<byte[], byte[], SecretKey, PublicKey, PrivateKey, String> cryptoCore;

    public void afterPropertiesSet() throws Exception {
        for (int i = 0; i < 3; ++i) {
            try {
                LOGGER.info("zkSessionID", "zkEncrypt", "", "Temporary solution to handle the first time decryption failure.");
                this.getDecryptedRandomKey("Tk8tU0VDRVJULUFWQUlMQUJMRS1URU1QLUZJWElORy0=");
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public ZKCryptoResponseDto zkEncrypt(ZKCryptoRequestDto cryptoRequestDto) {
        LOGGER.info("zkSessionID", "zkEncrypt", "", "Zero Knowledge Encryption.");
        String id = cryptoRequestDto.getId();
        Stream cryptoDataList = cryptoRequestDto.getZkDataAttributes().stream();
        int randomKeyIndex = this.getRandomKeyIndex();
        String encryptedKeyData = this.dataEncryptKeystoreRepository.findKeyById(randomKeyIndex);
        Key secretRandomKey = this.getDecryptedRandomKey(encryptedKeyData);
        Key derivedKey = this.getDerivedKey(id, secretRandomKey);
        SecureRandom sRandom = new SecureRandom();
        ArrayList<CryptoDataDto> responseCryptoData = new ArrayList<CryptoDataDto>();
        cryptoDataList.forEach(reqCryptoData -> {
            String identifier = reqCryptoData.getIdentifier();
            byte[] dataToEncrypt = reqCryptoData.getValue().getBytes();
            byte[] nonce = new byte[12];
            byte[] aad = new byte[32];
            sRandom.nextBytes(nonce);
            sRandom.nextBytes(aad);
            byte[] encryptedData = this.doCipherOps(derivedKey, dataToEncrypt, 1, nonce, aad);
            byte[] dbIndexBytes = this.getIndexBytes(randomKeyIndex);
            responseCryptoData.add(this.getResponseCryptoData(encryptedData, dbIndexBytes, nonce, aad, identifier));
        });
        ZKCryptoResponseDto cryptoResponseDto = new ZKCryptoResponseDto();
        cryptoResponseDto.setRankomKeyIndex(Integer.toString(randomKeyIndex));
        cryptoResponseDto.setZkDataAttributes(responseCryptoData);
        cryptoResponseDto.setEncryptedRandomKey(this.encryptRandomKey(secretRandomKey));
        this.keymanagerUtil.destoryKey((SecretKey)secretRandomKey);
        return cryptoResponseDto;
    }

    @Override
    public ZKCryptoResponseDto zkDecrypt(ZKCryptoRequestDto cryptoRequestDto) {
        LOGGER.info("zkSessionID", "zkDecrypt", "", "Zero Knowledge Decryption.");
        String id = cryptoRequestDto.getId();
        Stream cryptoDataList = cryptoRequestDto.getZkDataAttributes().stream();
        ArrayList<CryptoDataDto> responseCryptoData = new ArrayList<CryptoDataDto>();
        cryptoDataList.forEach(reqCryptoData -> {
            String identifier = reqCryptoData.getIdentifier();
            String dataToDecrypt = reqCryptoData.getValue();
            byte[] decodedData = CryptoUtil.decodeBase64((String)dataToDecrypt);
            byte[] dbIndexBytes = Arrays.copyOfRange(decodedData, 0, 4);
            byte[] nonce = Arrays.copyOfRange(decodedData, 4, 16);
            byte[] aad = Arrays.copyOfRange(decodedData, 16, 48);
            byte[] encryptedData = Arrays.copyOfRange(decodedData, 48, decodedData.length);
            int randomKeyIndex = this.getIndexInt(dbIndexBytes);
            String encryptedKeyData = this.dataEncryptKeystoreRepository.findKeyById(randomKeyIndex);
            Key secretRandomKey = this.getDecryptedRandomKey(encryptedKeyData);
            Key derivedKey = this.getDerivedKey(id, secretRandomKey);
            byte[] decryptedData = this.doCipherOps(derivedKey, encryptedData, 2, nonce, aad);
            responseCryptoData.add(this.getResponseCryptoData(decryptedData, identifier));
            this.keymanagerUtil.destoryKey((SecretKey)secretRandomKey);
        });
        ZKCryptoResponseDto cryptoResponseDto = new ZKCryptoResponseDto();
        cryptoResponseDto.setZkDataAttributes(responseCryptoData);
        return cryptoResponseDto;
    }

    private int getRandomKeyIndex() {
        List<Integer> indexes = this.dataEncryptKeystoreRepository.getIdsByKeyStatus("Active");
        int randomNum = ThreadLocalRandom.current().nextInt(0, indexes.size() + 1);
        return indexes.get(randomNum);
    }

    private int getIndexInt(byte[] indexBytes) {
        ByteBuffer bBuff = ByteBuffer.wrap(indexBytes);
        return bBuff.getInt();
    }

    private Key getDecryptedRandomKey(String encryptedKey) {
        LOGGER.info("zkSessionID", "RandomKey", "RandomKey", "Random Key Decryption.");
        byte[] unwrappedKey = this.doFinal(encryptedKey, 2);
        return new SecretKeySpec(unwrappedKey, 0, unwrappedKey.length, "AES");
    }

    private String getEncryptedRandomKey(String randomKey) {
        LOGGER.info("zkSessionID", "RandomKey", "RandomKey", "Random Key Encryption.");
        byte[] wrappedKey = this.doFinal(randomKey, 1);
        return Base64.getEncoder().encodeToString(wrappedKey);
    }

    private byte[] doFinal(String secretData, int mode) {
        try {
            Cipher cipher = Cipher.getInstance(this.aesECBTransformation);
            byte[] secretDataBytes = Base64.getDecoder().decode(secretData);
            cipher.init(mode, this.getMasterKeyFromHSM());
            return cipher.doFinal(secretDataBytes, 0, secretDataBytes.length);
        }
        catch (IllegalArgumentException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            LOGGER.error("zkSessionID", "RandomKey", "", "Error Cipher Operations of Random Key.");
            throw new ZKKeyDerivationException(ZKCryptoErrorConstants.RANDOM_KEY_CIPHER_FAILED.getErrorCode(), ZKCryptoErrorConstants.RANDOM_KEY_CIPHER_FAILED.getErrorMessage());
        }
    }

    private Key getDerivedKey(String id, Key key) {
        try {
            LOGGER.info("zkSessionID", "DeriveKey", "DeriveKey", "Derive key with Random Key.");
            byte[] idBytes = id.getBytes();
            MessageDigest mDigest = MessageDigest.getInstance("SHA-256");
            mDigest.update(idBytes, 0, idBytes.length);
            byte[] hashBytes = mDigest.digest();
            Cipher cipher = Cipher.getInstance(this.aesECBTransformation);
            cipher.init(1, key);
            byte[] encryptedData = cipher.doFinal(hashBytes, 0, hashBytes.length);
            return new SecretKeySpec(encryptedData, 0, encryptedData.length, "AES");
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            LOGGER.error("zkSessionID", "DeriveKey", "", "Error Deriving Key with Random Key." + e.getMessage());
            throw new ZKRandomKeyDecryptionException(ZKCryptoErrorConstants.KEY_DERIVATION_ERROR.getErrorCode(), ZKCryptoErrorConstants.KEY_DERIVATION_ERROR.getErrorMessage());
        }
    }

    private Key getMasterKeyFromHSM() {
        LOGGER.info("zkSessionID", "MasterKey", "RandomKey", "Retrieve Master Key from HSM.");
        String keyAlias = this.getKeyAlias(this.masterKeyAppId, this.masterKeyRefId);
        if (Objects.nonNull(keyAlias)) {
            return this.keyStore.getSymmetricKey(keyAlias);
        }
        LOGGER.error("zkSessionID", "MasterKey", "MasterKey", "No Key Alias found.");
        throw new NoUniqueAliasException(ZKCryptoErrorConstants.NO_UNIQUE_ALIAS.getErrorCode(), ZKCryptoErrorConstants.NO_UNIQUE_ALIAS.getErrorMessage());
    }

    private String getKeyAlias(String keyAppId, String keyRefId) {
        LOGGER.info("zkSessionID", "MasterKey", "RandomKey", "Retrieve Master Key Alias from DB.");
        Map<String, List<KeyAlias>> keyAliasMap = this.dbHelper.getKeyAliases(keyAppId, keyRefId, DateUtils.getUTCCurrentDateTime());
        List<KeyAlias> currentKeyAliases = keyAliasMap.get("currentKeyAlias");
        if (!currentKeyAliases.isEmpty() && currentKeyAliases.size() == 1) {
            LOGGER.info("zkSessionID", "ZKMasterKeyAlias", "getKeyAlias", "CurrentKeyAlias size is one. Will decrypt random symmetric key for this alias");
            return currentKeyAliases.get(0).getAlias();
        }
        LOGGER.error("zkSessionID", "MasterKey", "RandomKey", "CurrentKeyAlias is not unique. KeyAlias count: " + currentKeyAliases.size());
        throw new NoUniqueAliasException(ZKCryptoErrorConstants.NO_UNIQUE_ALIAS.getErrorCode(), ZKCryptoErrorConstants.NO_UNIQUE_ALIAS.getErrorMessage());
    }

    private byte[] doCipherOps(Key key, byte[] data, int mode, byte[] nonce, byte[] aad) {
        LOGGER.info("zkSessionID", "DataCipher", "", "Data Encryption/Decryption Process");
        try {
            Cipher cipher = Cipher.getInstance(this.aesGCMTransformation);
            GCMParameterSpec gcmSpec = new GCMParameterSpec(128, nonce);
            cipher.init(mode, key, gcmSpec);
            cipher.updateAAD(aad);
            return cipher.doFinal(data, 0, data.length);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            LOGGER.error("zkSessionID", "DataCipher", "DataCipher", "Error Ciphering inputed data." + ex.getMessage());
            throw new ZKCryptoException(ZKCryptoErrorConstants.DATA_CIPHER_OPS_ERROR.getErrorCode(), ZKCryptoErrorConstants.DATA_CIPHER_OPS_ERROR.getErrorMessage());
        }
    }

    private byte[] getIndexBytes(int randomIndex) {
        ByteBuffer byteBuff = ByteBuffer.allocate(4);
        byteBuff.putInt(randomIndex);
        return byteBuff.array();
    }

    private CryptoDataDto getResponseCryptoData(byte[] encryptedData, byte[] dbIndexBytes, byte[] nonce, byte[] aad, String identifier) {
        byte[] finalEncData = new byte[encryptedData.length + dbIndexBytes.length + 32 + 12];
        System.arraycopy(dbIndexBytes, 0, finalEncData, 0, dbIndexBytes.length);
        System.arraycopy(nonce, 0, finalEncData, dbIndexBytes.length, nonce.length);
        System.arraycopy(aad, 0, finalEncData, dbIndexBytes.length + nonce.length, aad.length);
        System.arraycopy(encryptedData, 0, finalEncData, dbIndexBytes.length + nonce.length + aad.length, encryptedData.length);
        String concatEncryptedData = CryptoUtil.encodeBase64((byte[])finalEncData);
        CryptoDataDto resCryptoData = new CryptoDataDto();
        resCryptoData.setIdentifier(identifier);
        resCryptoData.setValue(concatEncryptedData);
        return resCryptoData;
    }

    private CryptoDataDto getResponseCryptoData(byte[] decryptedData, String identifier) {
        String decryptedDataStr = new String(decryptedData);
        CryptoDataDto resCryptoData = new CryptoDataDto();
        resCryptoData.setIdentifier(identifier);
        resCryptoData.setValue(decryptedDataStr);
        return resCryptoData;
    }

    private String encryptRandomKey(Key secretRandomKey) {
        LOGGER.info("zkSessionID", "EncryptRandomKey", "", "Encrypting Random Key with Public Key.");
        String keyAlias = this.getKeyAlias(this.pubKeyApplicationId, this.pubKeyReferenceId);
        Optional<io.mosip.kernel.keymanagerservice.entity.KeyStore> dbKeyStore = this.keyStoreRepository.findByAlias(keyAlias);
        if (!dbKeyStore.isPresent()) {
            LOGGER.info("zkSessionID", "EncryptRandomKey", "EncryptRandomKey", "Key in DBStore does not exist for this alias. Throwing exception");
            throw new NoUniqueAliasException(ZKCryptoErrorConstants.NO_UNIQUE_ALIAS.getErrorCode(), ZKCryptoErrorConstants.NO_UNIQUE_ALIAS.getErrorMessage());
        }
        String certificateData = dbKeyStore.get().getCertificateData();
        X509Certificate x509Cert = (X509Certificate)this.keymanagerUtil.convertToCertificate(certificateData);
        PublicKey publicKey = x509Cert.getPublicKey();
        byte[] encryptedRandomKey = (byte[])this.cryptoCore.asymmetricEncrypt((Object)publicKey, (Object)secretRandomKey.getEncoded());
        byte[] certThumbprint = this.cryptomanagerUtil.getCertificateThumbprint(x509Cert);
        byte[] concatedData = this.cryptomanagerUtil.concatCertThumbprint(certThumbprint, encryptedRandomKey);
        return CryptoUtil.encodeBase64((byte[])concatedData);
    }

    @Override
    public ReEncryptRandomKeyResponseDto zkReEncryptRandomKey(String encryptedKey) {
        LOGGER.info("zkSessionID", "Re-EncryptRandomKey", "", "Re-Encrypt Random Key.");
        if (encryptedKey == null || encryptedKey.trim().isEmpty()) {
            LOGGER.error("zkSessionID", "Re-EncryptRandomKey", "Re-EncryptRandomKey", "Invalid Encrypted Key input.");
            throw new ZKCryptoException(ZKCryptoErrorConstants.INVALID_ENCRYPTED_RANDOM_KEY.getErrorCode(), ZKCryptoErrorConstants.INVALID_ENCRYPTED_RANDOM_KEY.getErrorMessage());
        }
        LocalDateTime localDateTimeStamp = DateUtils.getUTCCurrentDateTime();
        SymmetricKeyRequestDto symmetricKeyRequestDto = new SymmetricKeyRequestDto(this.pubKeyApplicationId, localDateTimeStamp, this.pubKeyReferenceId, encryptedKey, true);
        String randomKey = this.keyManagerService.decryptSymmetricKey(symmetricKeyRequestDto).getSymmetricKey();
        String encryptedRandomKey = this.getEncryptedRandomKey(Base64.getEncoder().encodeToString(CryptoUtil.decodeBase64((String)randomKey)));
        ReEncryptRandomKeyResponseDto responseDto = new ReEncryptRandomKeyResponseDto();
        responseDto.setEncryptedKey(encryptedRandomKey);
        return responseDto;
    }
}

