/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.signature.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.mosip.kernel.core.logger.spi.Logger;
import io.mosip.kernel.keymanagerservice.logger.KeymanagerLogger;
import io.mosip.kernel.signature.constant.SignatureConstant;
import java.io.IOException;
import java.util.Objects;

public class SignatureUtil {
    private static final Logger LOGGER = KeymanagerLogger.getLogger(SignatureUtil.class);

    public static boolean isDataValid(String anyData) {
        return anyData != null && !anyData.trim().isEmpty();
    }

    public static boolean isJsonValid(String jsonInString) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.readTree(jsonInString);
            return true;
        }
        catch (IOException e) {
            LOGGER.error("SignatureSessionId", "JWTSignature", "", "Provided JSON Data to sign value is invalid.");
            return false;
        }
    }

    public static boolean isIncludeAttrsValid(Boolean includes) {
        if (Objects.isNull(includes)) {
            return SignatureConstant.DEFAULT_INCLUDES;
        }
        return includes;
    }
}

