/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.clientcrypto.service.impl;

import io.mosip.kernel.clientcrypto.constant.ClientCryptoErrorConstants;
import io.mosip.kernel.clientcrypto.exception.ClientCryptoException;
import io.mosip.kernel.clientcrypto.service.spi.ClientCryptoService;
import io.mosip.kernel.core.exception.ExceptionUtils;
import io.mosip.kernel.core.logger.spi.Logger;
import io.mosip.kernel.keymanagerservice.logger.KeymanagerLogger;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.junit.Assert;
import tss.Helpers;
import tss.Tpm;
import tss.TpmDeviceLinux;
import tss.TpmDeviceTbs;
import tss.TpmFactory;
import tss.tpm.CreatePrimaryResponse;
import tss.tpm.TPM2B_PUBLIC_KEY_RSA;
import tss.tpm.TPMA_OBJECT;
import tss.tpm.TPMS_ENC_SCHEME_OAEP;
import tss.tpm.TPMS_NULL_ASYM_SCHEME;
import tss.tpm.TPMS_NULL_SIG_SCHEME;
import tss.tpm.TPMS_PCR_SELECTION;
import tss.tpm.TPMS_RSA_PARMS;
import tss.tpm.TPMS_SENSITIVE_CREATE;
import tss.tpm.TPMS_SIGNATURE_RSASSA;
import tss.tpm.TPMS_SIG_SCHEME_RSASSA;
import tss.tpm.TPMT_HA;
import tss.tpm.TPMT_PUBLIC;
import tss.tpm.TPMT_SYM_DEF_OBJECT;
import tss.tpm.TPMT_TK_HASHCHECK;
import tss.tpm.TPMU_ASYM_SCHEME;
import tss.tpm.TPMU_PUBLIC_ID;
import tss.tpm.TPMU_PUBLIC_PARMS;
import tss.tpm.TPMU_SIGNATURE;
import tss.tpm.TPMU_SIG_SCHEME;
import tss.tpm.TPM_ALG_ID;
import tss.tpm.TPM_HANDLE;
import tss.tpm.TPM_RH;

class TPMClientCryptoServiceImpl
implements ClientCryptoService {
    private static final Logger LOGGER = KeymanagerLogger.getLogger(TPMClientCryptoServiceImpl.class);
    private static final byte[] NULL_VECTOR = new byte[0];
    private static byte[] label = Helpers.concatenate((byte[])Charset.forName("UTF-8").encode(new String(NULL_VECTOR)).array(), (byte[])new byte[]{0});
    private static Tpm tpm;
    private static CreatePrimaryResponse signingPrimaryResponse;
    private static CreatePrimaryResponse encPrimaryResponse;

    TPMClientCryptoServiceImpl() throws Throwable {
        LOGGER.debug("ccSessionID", "TPM", "", "TPMClientCryptoServiceImpl constructor invoked");
        if (tpm == null) {
            LOGGER.info("ccSessionID", "TPM", "", "Instantiating Platform TPM");
            tpm = TpmFactory.platformTpm();
            if (!this.isKernelModeTRM()) {
                LOGGER.warn("ccSessionID", "TPM", "", "UNABLE TO CONNECT TO KERNEL/SYSTEM TPM RESOURCE MANAGER");
                tpm = null;
            }
            LOGGER.info("ccSessionID", "TPM", "", "Completed getting the instance of Platform TPM");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] signData(byte[] dataToSign) throws ClientCryptoException {
        try {
            Assert.assertNotNull((Object)tpm);
            CreatePrimaryResponse signingKey = this.createSigningKey();
            TPMU_SIGNATURE signedData = null;
            Tpm tpm = TPMClientCryptoServiceImpl.tpm;
            synchronized (tpm) {
                signedData = TPMClientCryptoServiceImpl.tpm.Sign(signingKey.handle, TPMT_HA.fromHashOf((TPM_ALG_ID)TPM_ALG_ID.SHA256, (byte[])dataToSign).digest, (TPMU_SIG_SCHEME)new TPMS_NULL_SIG_SCHEME(), TPMT_TK_HASHCHECK.nullTicket());
            }
            Assert.assertNotNull((Object)signedData);
            LOGGER.info("ccSessionID", "TPM", "", "Completed Signing data using TPM");
            return ((TPMS_SIGNATURE_RSASSA)signedData).sig;
        }
        catch (Exception ex) {
            throw new ClientCryptoException(ClientCryptoErrorConstants.CRYPTO_FAILED.getErrorCode(), ClientCryptoErrorConstants.CRYPTO_FAILED.getErrorMessage(), ex);
        }
    }

    @Override
    public boolean validateSignature(byte[] signature, byte[] actualData) throws ClientCryptoException {
        return TPMClientCryptoServiceImpl.validateSignature(this.getSigningPublicPart(), signature, actualData);
    }

    @Override
    public byte[] asymmetricEncrypt(byte[] plainData) throws ClientCryptoException {
        try {
            CreatePrimaryResponse primaryResponse = this.createRSAKey();
            return TPMClientCryptoServiceImpl.asymmetricEncrypt(primaryResponse.outPublic.toTpm(), plainData);
        }
        catch (Exception ex) {
            throw new ClientCryptoException(ClientCryptoErrorConstants.CRYPTO_FAILED.getErrorCode(), ClientCryptoErrorConstants.CRYPTO_FAILED.getErrorMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] asymmetricDecrypt(byte[] dataToDecrypt) throws ClientCryptoException {
        try {
            Assert.assertNotNull((Object)tpm);
            CreatePrimaryResponse primaryResponse = this.createRSAKey();
            Tpm tpm = TPMClientCryptoServiceImpl.tpm;
            synchronized (tpm) {
                return TPMClientCryptoServiceImpl.tpm.RSA_Decrypt(primaryResponse.handle, dataToDecrypt, (TPMU_ASYM_SCHEME)new TPMS_NULL_ASYM_SCHEME(), label);
            }
        }
        catch (Exception ex) {
            throw new ClientCryptoException(ClientCryptoErrorConstants.CRYPTO_FAILED.getErrorCode(), ClientCryptoErrorConstants.CRYPTO_FAILED.getErrorMessage(), ex);
        }
    }

    @Override
    public byte[] getSigningPublicPart() throws ClientCryptoException {
        try {
            return this.createSigningKey().outPublic.toTpm();
        }
        catch (Exception ex) {
            throw new ClientCryptoException(ClientCryptoErrorConstants.CRYPTO_FAILED.getErrorCode(), ClientCryptoErrorConstants.CRYPTO_FAILED.getErrorMessage(), ex);
        }
    }

    @Override
    public synchronized void closeSecurityInstance() {
        try {
            if (tpm != null) {
                tpm.close();
            }
        }
        catch (IOException e) {
            LOGGER.error("ccSessionID", "TPM", "", ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public static synchronized byte[] generateRandomBytes(int length) {
        return tpm.GetRandom(length);
    }

    @Override
    public byte[] getEncryptionPublicPart() {
        try {
            return this.createRSAKey().outPublic.toTpm();
        }
        catch (Exception ex) {
            throw new ClientCryptoException(ClientCryptoErrorConstants.CRYPTO_FAILED.getErrorCode(), ClientCryptoErrorConstants.CRYPTO_FAILED.getErrorMessage(), ex);
        }
    }

    public static boolean validateSignature(byte[] publicKey, byte[] signature, byte[] actualData) throws ClientCryptoException {
        TPMT_PUBLIC tpmPublic = TPMT_PUBLIC.fromTpm((byte[])publicKey);
        TPMS_SIGNATURE_RSASSA rsaSignature = new TPMS_SIGNATURE_RSASSA(TPM_ALG_ID.SHA256, signature);
        return tpmPublic.validateSignature(actualData, (TPMU_SIGNATURE)rsaSignature);
    }

    public static byte[] asymmetricEncrypt(byte[] publicKey, byte[] dataToEncrypt) throws ClientCryptoException {
        LOGGER.info("ccSessionID", "TPM", "", "TpmClientSecurity Asymmetric encrypt");
        TPMT_PUBLIC tpmPublic = TPMT_PUBLIC.fromTpm((byte[])publicKey);
        return tpmPublic.encrypt(dataToEncrypt, new String(NULL_VECTOR));
    }

    @Override
    public boolean isTPMInstance() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CreatePrimaryResponse createSigningKey() {
        LOGGER.info("ccSessionID", "TPM", "", "Creating the Key from Platform TPM");
        if (signingPrimaryResponse != null) {
            return signingPrimaryResponse;
        }
        TPMT_PUBLIC template = new TPMT_PUBLIC(TPM_ALG_ID.SHA1, new TPMA_OBJECT(new TPMA_OBJECT[]{TPMA_OBJECT.fixedTPM, TPMA_OBJECT.fixedParent, TPMA_OBJECT.sign, TPMA_OBJECT.sensitiveDataOrigin, TPMA_OBJECT.userWithAuth}), new byte[0], (TPMU_PUBLIC_PARMS)new TPMS_RSA_PARMS(new TPMT_SYM_DEF_OBJECT(TPM_ALG_ID.NULL, 0, TPM_ALG_ID.NULL), (TPMU_ASYM_SCHEME)new TPMS_SIG_SCHEME_RSASSA(TPM_ALG_ID.SHA256), 2048, 65537), (TPMU_PUBLIC_ID)new TPM2B_PUBLIC_KEY_RSA());
        TPM_HANDLE primaryHandle = TPM_HANDLE.from((TPM_RH)TPM_RH.ENDORSEMENT);
        TPMS_SENSITIVE_CREATE dataToBeSealedWithAuth = new TPMS_SENSITIVE_CREATE(NULL_VECTOR, NULL_VECTOR);
        Tpm tpm = TPMClientCryptoServiceImpl.tpm;
        synchronized (tpm) {
            signingPrimaryResponse = TPMClientCryptoServiceImpl.tpm.CreatePrimary(primaryHandle, dataToBeSealedWithAuth, template, NULL_VECTOR, new TPMS_PCR_SELECTION[0]);
        }
        LOGGER.info("ccSessionID", "TPM", "", "Completed creating the Signing Key from Platform TPM");
        return signingPrimaryResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CreatePrimaryResponse createRSAKey() {
        LOGGER.info("ccSessionID", "TPM", "", "Getting Asymmetric Key Creation from tpm");
        if (encPrimaryResponse != null) {
            return encPrimaryResponse;
        }
        LocalDateTime localDateTime = LocalDateTime.now();
        byte[] standardEKPolicy = new byte[]{-125, 113, -105, 103, 68, -124, -77, -8, 26, -112, -52, -115, 70, -91, -41, 36, -3, 82, -41, 110, 6, 82, 11, 100, -14, -95, -38, 27, 51, 20, 105, -86};
        TPMT_PUBLIC template = new TPMT_PUBLIC(TPM_ALG_ID.SHA256, new TPMA_OBJECT(new TPMA_OBJECT[]{TPMA_OBJECT.fixedTPM, TPMA_OBJECT.fixedParent, TPMA_OBJECT.decrypt, TPMA_OBJECT.sensitiveDataOrigin, TPMA_OBJECT.userWithAuth}), standardEKPolicy, (TPMU_PUBLIC_PARMS)new TPMS_RSA_PARMS(new TPMT_SYM_DEF_OBJECT(TPM_ALG_ID.NULL, 0, TPM_ALG_ID.NULL), (TPMU_ASYM_SCHEME)new TPMS_ENC_SCHEME_OAEP(TPM_ALG_ID.SHA256), 2048, 65537), (TPMU_PUBLIC_ID)new TPM2B_PUBLIC_KEY_RSA());
        TPMS_SENSITIVE_CREATE dataToBeSealedWithAuth = new TPMS_SENSITIVE_CREATE(NULL_VECTOR, NULL_VECTOR);
        TPM_HANDLE primaryHandle = TPM_HANDLE.from((TPM_RH)TPM_RH.ENDORSEMENT);
        Tpm tpm = TPMClientCryptoServiceImpl.tpm;
        synchronized (tpm) {
            encPrimaryResponse = TPMClientCryptoServiceImpl.tpm.CreatePrimary(primaryHandle, dataToBeSealedWithAuth, template, null, null);
        }
        long secondsTaken = localDateTime.until(LocalDateTime.now(), ChronoUnit.SECONDS);
        LOGGER.info("ccSessionID", "TPM", "", String.format("Completed Asymmetric Key Creation using tpm. Time taken is %s seconds", String.valueOf(secondsTaken)));
        return encPrimaryResponse;
    }

    private static SecretKey getSecretKey() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(256);
            return keyGenerator.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.info("ccSessionID", "TPM", "", "Failed to generate secret key " + ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isKernelModeTRM() {
        Tpm tpm = TPMClientCryptoServiceImpl.tpm;
        synchronized (tpm) {
            if (TPMClientCryptoServiceImpl.tpm != null && TPMClientCryptoServiceImpl.tpm._getDevice() != null && (TPMClientCryptoServiceImpl.tpm._getDevice() instanceof TpmDeviceTbs || TPMClientCryptoServiceImpl.tpm._getDevice() instanceof TpmDeviceLinux)) {
                return true;
            }
        }
        return false;
    }
}

