/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.tokenidgenerator.generator;

import io.mosip.kernel.core.util.HMACUtils;
import java.math.BigInteger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class TokenIDGenerator {
    @Value(value="${mosip.kernel.tokenid.uin.salt}")
    private String uinSalt;
    @Value(value="${mosip.kernel.tokenid.length}")
    private int tokenIDLength;
    @Value(value="${mosip.kernel.tokenid.partnercode.salt}")
    private String partnerCodeSalt;

    public String generateTokenID(String uin, String partnerCode) {
        String uinHash = HMACUtils.digestAsPlainText((byte[])HMACUtils.generateHash((byte[])(uin + this.uinSalt).getBytes()));
        String hash = HMACUtils.digestAsPlainText((byte[])HMACUtils.generateHash((byte[])(this.partnerCodeSalt + partnerCode + uinHash).getBytes()));
        return new BigInteger(hash.getBytes()).toString().substring(0, this.tokenIDLength);
    }
}

