/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.lkeymanager.util;

import io.mosip.kernel.core.exception.ServiceError;
import io.mosip.kernel.lkeymanager.constant.LicenseKeyManagerExceptionConstants;
import io.mosip.kernel.lkeymanager.constant.LicenseKeyManagerPropertyConstants;
import io.mosip.kernel.lkeymanager.exception.InvalidArgumentsException;
import io.mosip.kernel.lkeymanager.exception.LicenseKeyServiceException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

@RefreshScope
@Component
public class LicenseKeyManagerUtil {
    @Value(value="#{'${mosip.kernel.licensekey.permissions}'.split(',')}")
    private List<String> validPermissions;
    @Value(value="${mosip.kernel.licensekey.length}")
    private int licenseKeyLength;

    public String concatPermissionsIntoASingleRow(List<String> permissionsList) {
        StringBuilder permissionString = new StringBuilder();
        int permissionsListCount = 0;
        for (String permission : permissionsList) {
            if (++permissionsListCount <= permissionsList.size() - 1) {
                permissionString.append(permission + ",");
                continue;
            }
            permissionString.append(permission);
        }
        return permissionString.toString();
    }

    public boolean areValidPermissions(List<String> inputPermissions) {
        ArrayList<ServiceError> errorList = new ArrayList<ServiceError>();
        if (!inputPermissions.stream().allMatch(permission -> this.validPermissions.stream().anyMatch(permission::contains))) {
            errorList.add(new ServiceError(LicenseKeyManagerExceptionConstants.NOT_ACCEPTABLE_PERMISSION.getErrorCode(), LicenseKeyManagerExceptionConstants.NOT_ACCEPTABLE_PERMISSION.getErrorMessage()));
            throw new LicenseKeyServiceException(errorList);
        }
        return true;
    }

    public LocalDateTime getCurrentTimeInUTCTimeZone() {
        return LocalDateTime.now(ZoneId.of(LicenseKeyManagerPropertyConstants.TIME_ZONE.getValue()));
    }

    public String generateLicense() {
        ArrayList<ServiceError> errorList = new ArrayList<ServiceError>();
        String licenseKey = RandomStringUtils.randomAlphanumeric((int)this.licenseKeyLength);
        if (licenseKey.length() != this.licenseKeyLength) {
            errorList.add(new ServiceError(LicenseKeyManagerExceptionConstants.INVALID_GENERATED_LICENSEKEY.getErrorCode(), LicenseKeyManagerExceptionConstants.INVALID_GENERATED_LICENSEKEY.getErrorMessage()));
            throw new LicenseKeyServiceException(errorList);
        }
        return licenseKey;
    }

    public void validateTSP(String tspID) {
        ArrayList<ServiceError> errorList = new ArrayList<ServiceError>();
        if (tspID == null || tspID.trim().isEmpty()) {
            errorList.add(new ServiceError(LicenseKeyManagerExceptionConstants.ILLEGAL_TSP.getErrorCode(), LicenseKeyManagerExceptionConstants.ILLEGAL_TSP.getErrorMessage()));
        }
        if (!errorList.isEmpty()) {
            throw new InvalidArgumentsException(errorList);
        }
    }

    public void validateTSPAndLicenseKey(String tspID, String licenseKey) {
        ArrayList<ServiceError> errorList = new ArrayList<ServiceError>();
        if (tspID == null || tspID.trim().isEmpty()) {
            errorList.add(new ServiceError(LicenseKeyManagerExceptionConstants.ILLEGAL_TSP.getErrorCode(), LicenseKeyManagerExceptionConstants.ILLEGAL_TSP.getErrorMessage()));
        }
        if (licenseKey == null || licenseKey.trim().isEmpty()) {
            errorList.add(new ServiceError(LicenseKeyManagerExceptionConstants.ILLEGAL_LICENSE_KEY.getErrorCode(), LicenseKeyManagerExceptionConstants.ILLEGAL_LICENSE_KEY.getErrorMessage()));
        }
        if (!errorList.isEmpty()) {
            throw new InvalidArgumentsException(errorList);
        }
    }

    public void validateRequestParameters(String tspID, String licenseKey, List<String> permissions) {
        ArrayList<ServiceError> errorList = new ArrayList<ServiceError>();
        if (tspID == null || tspID.trim().isEmpty()) {
            errorList.add(new ServiceError(LicenseKeyManagerExceptionConstants.ILLEGAL_TSP.getErrorCode(), LicenseKeyManagerExceptionConstants.ILLEGAL_TSP.getErrorMessage()));
        }
        if (licenseKey == null || licenseKey.trim().isEmpty()) {
            errorList.add(new ServiceError(LicenseKeyManagerExceptionConstants.ILLEGAL_LICENSE_KEY.getErrorCode(), LicenseKeyManagerExceptionConstants.ILLEGAL_LICENSE_KEY.getErrorMessage()));
        }
        for (String permission : permissions) {
            if (!permission.trim().isEmpty()) continue;
            errorList.add(new ServiceError(LicenseKeyManagerExceptionConstants.ILLEGAL_PERMISSION.getErrorCode(), LicenseKeyManagerExceptionConstants.ILLEGAL_PERMISSION.getErrorMessage()));
            break;
        }
        if (!errorList.isEmpty()) {
            throw new InvalidArgumentsException(errorList);
        }
    }
}

