/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.keymanagerservice.controller;

import io.mosip.kernel.core.http.RequestWrapper;
import io.mosip.kernel.core.http.ResponseFilter;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.mosip.kernel.keymanagerservice.dto.CSRGenerateRequestDto;
import io.mosip.kernel.keymanagerservice.dto.KeyPairGenerateRequestDto;
import io.mosip.kernel.keymanagerservice.dto.KeyPairGenerateResponseDto;
import io.mosip.kernel.keymanagerservice.dto.UploadCertificateRequestDto;
import io.mosip.kernel.keymanagerservice.dto.UploadCertificateResponseDto;
import io.mosip.kernel.keymanagerservice.service.KeymanagerService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiParam;
import java.util.Optional;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
@Api(tags={"keymanager"}, value="Operation related to Keymanagement")
public class KeymanagerController {
    @Value(value="${mosip.sign.refid:SIGN}")
    private String certificateSignRefID;
    @Value(value="${mosip.sign.applicationid:KERNEL}")
    private String signApplicationid;
    @Autowired
    KeymanagerService keymanagerService;

    @PreAuthorize(value="hasAnyRole('KEY_MAKER', 'INDIVIDUAL','REGISTRATION_PROCESSOR','REGISTRATION_ADMIN','REGISTRATION_SUPERVISOR','REGISTRATION_OFFICER','ID_AUTHENTICATION','TEST','PRE_REGISTRATION_ADMIN','RESIDENT')")
    @ResponseFilter
    @PostMapping(value={"/generateMasterKey/{objectType}"})
    public ResponseWrapper<KeyPairGenerateResponseDto> generateMasterKey(@ApiParam(value="Response Type Certificate/CSR") @PathVariable(value="objectType") String objectType, @RequestBody @Valid RequestWrapper<KeyPairGenerateRequestDto> keyPairGenRequestDto) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.keymanagerService.generateMasterKey(objectType, (KeyPairGenerateRequestDto)keyPairGenRequestDto.getRequest()));
        return response;
    }

    @PreAuthorize(value="hasAnyRole('INDIVIDUAL','REGISTRATION_PROCESSOR','REGISTRATION_ADMIN','REGISTRATION_SUPERVISOR','REGISTRATION_OFFICER','ID_AUTHENTICATION','TEST','PRE_REGISTRATION_ADMIN','RESIDENT')")
    @ResponseFilter
    @GetMapping(value={"/getCertificate"})
    public ResponseWrapper<KeyPairGenerateResponseDto> getCertificate(@ApiParam(value="Id of application") @RequestParam(value="applicationId") String applicationId, @ApiParam(value="Refrence Id as metadata") @RequestParam(value="referenceId") Optional<String> referenceId) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.keymanagerService.getCertificate(applicationId, referenceId));
        return response;
    }

    @PreAuthorize(value="hasAnyRole('INDIVIDUAL','REGISTRATION_PROCESSOR','REGISTRATION_ADMIN','REGISTRATION_SUPERVISOR','REGISTRATION_OFFICER','ID_AUTHENTICATION','TEST','PRE_REGISTRATION_ADMIN','RESIDENT')")
    @ResponseFilter
    @PostMapping(value={"/generateCSR"})
    public ResponseWrapper<KeyPairGenerateResponseDto> generateCSR(@RequestBody @Valid RequestWrapper<CSRGenerateRequestDto> csrGenRequestDto) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.keymanagerService.generateCSR((CSRGenerateRequestDto)csrGenRequestDto.getRequest()));
        return response;
    }

    @PreAuthorize(value="hasAnyRole('INDIVIDUAL','REGISTRATION_PROCESSOR','REGISTRATION_ADMIN','REGISTRATION_SUPERVISOR','REGISTRATION_OFFICER','ID_AUTHENTICATION','TEST','PRE_REGISTRATION_ADMIN','RESIDENT')")
    @ResponseFilter
    @PostMapping(value={"/uploadCertificate"})
    public ResponseWrapper<UploadCertificateResponseDto> uploadCertificate(@RequestBody @Valid RequestWrapper<UploadCertificateRequestDto> uploadCertRequestDto) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.keymanagerService.uploadCertificate((UploadCertificateRequestDto)uploadCertRequestDto.getRequest()));
        return response;
    }

    @PreAuthorize(value="hasAnyRole('INDIVIDUAL','REGISTRATION_PROCESSOR','REGISTRATION_ADMIN','REGISTRATION_SUPERVISOR','REGISTRATION_OFFICER','ID_AUTHENTICATION','TEST','PRE_REGISTRATION_ADMIN','RESIDENT')")
    @ResponseFilter
    @PostMapping(value={"/uploadOtherDomainCertificate"})
    public ResponseWrapper<UploadCertificateResponseDto> uploadOtherDomainCertificate(@RequestBody @Valid RequestWrapper<UploadCertificateRequestDto> uploadCertRequestDto) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.keymanagerService.uploadOtherDomainCertificate((UploadCertificateRequestDto)uploadCertRequestDto.getRequest()));
        return response;
    }
}

