/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.clientcrypto.service.impl;

import io.mosip.kernel.clientcrypto.constant.ClientCryptoErrorConstants;
import io.mosip.kernel.clientcrypto.exception.ClientCryptoException;
import io.mosip.kernel.clientcrypto.service.impl.LocalClientCryptoServiceImpl;
import io.mosip.kernel.clientcrypto.service.impl.TPMClientCryptoServiceImpl;
import io.mosip.kernel.clientcrypto.service.spi.ClientCryptoService;
import io.mosip.kernel.core.crypto.spi.CryptoCoreSpec;
import io.mosip.kernel.core.exception.ExceptionUtils;
import io.mosip.kernel.core.logger.spi.Logger;
import io.mosip.kernel.keymanagerservice.logger.KeymanagerLogger;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.junit.Assert;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class ClientCryptoFacade {
    private static final int ENC_SYM_KEY_LENGTH = 256;
    private static final int IV_LENGTH = 16;
    private static final int AAD_LENGTH = 12;
    private static final Logger LOGGER = KeymanagerLogger.getLogger(ClientCryptoFacade.class);
    private static ClientCryptoService clientCryptoService = null;
    private static Boolean isTPMRequired = null;
    private static SecureRandom secureRandom = null;
    @Autowired
    private CryptoCoreSpec<byte[], byte[], SecretKey, PublicKey, PrivateKey, String> cryptoCore;
    @Autowired
    private Environment environment;

    public static void setIsTPMRequired(boolean flag) {
        if (isTPMRequired == null) {
            isTPMRequired = flag;
        }
    }

    private void initializeClientSecurity() {
        LOGGER.debug("ccSessionID", "INITIALIZATION", "", "initializeClientSecurity >>> started");
        if (isTPMRequired.booleanValue()) {
            try {
                clientCryptoService = new TPMClientCryptoServiceImpl();
            }
            catch (Throwable e) {
                LOGGER.debug("ccSessionID", "INITIALIZATION", "", ExceptionUtils.getStackTrace((Throwable)e));
            }
        } else {
            try {
                clientCryptoService = new LocalClientCryptoServiceImpl(this.cryptoCore);
            }
            catch (Throwable ex) {
                LOGGER.error("ccSessionID", "INITIALIZATION", "", ExceptionUtils.getStackTrace((Throwable)ex));
            }
        }
        if (clientCryptoService == null) {
            LOGGER.error("ccSessionID", "INITIALIZATION", "", "Failed to get client security instance.");
            throw new ClientCryptoException(ClientCryptoErrorConstants.INITIALIZATION_ERROR.getErrorCode(), ClientCryptoErrorConstants.INITIALIZATION_ERROR.getErrorMessage());
        }
        LOGGER.debug("ccSessionID", "INITIALIZATION", "", "initializeClientSecurity >>> Completed");
    }

    public ClientCryptoService getClientSecurity() {
        if (isTPMRequired == null) {
            throw new ClientCryptoException(ClientCryptoErrorConstants.TPM_REQUIRED_FLAG_NOT_SET.getErrorCode(), ClientCryptoErrorConstants.TPM_REQUIRED_FLAG_NOT_SET.getErrorMessage());
        }
        if (clientCryptoService == null) {
            this.initializeClientSecurity();
        }
        return clientCryptoService;
    }

    public boolean validateSignature(byte[] publicKey, byte[] signature, byte[] actualData, boolean isTPM) {
        if (!isTPM) {
            return LocalClientCryptoServiceImpl.validateSignature((byte[])publicKey, (byte[])signature, (byte[])actualData);
        }
        return TPMClientCryptoServiceImpl.validateSignature((byte[])publicKey, (byte[])signature, (byte[])actualData);
    }

    public byte[] encrypt(byte[] publicKey, byte[] dataToEncrypt, boolean isTPM) {
        SecretKey secretKey = ClientCryptoFacade.getSecretKey();
        byte[] iv = ClientCryptoFacade.generateRandomBytes((int)16);
        byte[] aad = ClientCryptoFacade.generateRandomBytes((int)12);
        byte[] cipher = (byte[])this.cryptoCore.symmetricEncrypt((Object)secretKey, (Object)dataToEncrypt, (Object)iv, (Object)aad);
        LocalClientCryptoServiceImpl.cryptoCore = this.cryptoCore;
        byte[] encryptedSecretKey = isTPM ? TPMClientCryptoServiceImpl.asymmetricEncrypt((byte[])publicKey, (byte[])secretKey.getEncoded()) : LocalClientCryptoServiceImpl.asymmetricEncrypt((byte[])publicKey, (byte[])secretKey.getEncoded());
        byte[] processedData = new byte[cipher.length + encryptedSecretKey.length + iv.length + aad.length];
        System.arraycopy(encryptedSecretKey, 0, processedData, 0, encryptedSecretKey.length);
        System.arraycopy(iv, 0, processedData, encryptedSecretKey.length, iv.length);
        System.arraycopy(aad, 0, processedData, encryptedSecretKey.length + iv.length, aad.length);
        System.arraycopy(cipher, 0, processedData, encryptedSecretKey.length + iv.length + aad.length, cipher.length);
        return processedData;
    }

    public byte[] decrypt(byte[] dataToDecrypt) {
        Assert.assertNotNull((Object)this.getClientSecurity());
        byte[] encryptedSecretKey = Arrays.copyOfRange(dataToDecrypt, 0, 256);
        byte[] secretKeyBytes = this.getClientSecurity().asymmetricDecrypt(encryptedSecretKey);
        byte[] iv = Arrays.copyOfRange(dataToDecrypt, 256, 272);
        byte[] aad = Arrays.copyOfRange(dataToDecrypt, 272, 284);
        byte[] cipher = Arrays.copyOfRange(dataToDecrypt, 284, dataToDecrypt.length);
        SecretKeySpec secretKey = new SecretKeySpec(secretKeyBytes, "AES");
        return (byte[])this.cryptoCore.symmetricDecrypt((Object)secretKey, (Object)cipher, (Object)iv, (Object)aad);
    }

    public static byte[] generateRandomBytes(int length) {
        if (secureRandom == null) {
            secureRandom = new SecureRandom();
        }
        byte[] bytes = new byte[length];
        secureRandom.nextBytes(bytes);
        return bytes;
    }

    private static SecretKey getSecretKey() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(256);
            return keyGenerator.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.info("ccSessionID", "Client Security FACADE", "", "Failed to generate secret key " + ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }
}

