/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.tokenidgenerator.service.impl;

import io.mosip.kernel.core.idgenerator.exception.TokenIdGeneratorException;
import io.mosip.kernel.tokenidgenerator.constant.TokenIDGeneratorErrorCode;
import io.mosip.kernel.tokenidgenerator.dto.TokenIDResponseDto;
import io.mosip.kernel.tokenidgenerator.generator.TokenIDGenerator;
import io.mosip.kernel.tokenidgenerator.service.TokenIDGeneratorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TokenIDGeneratorServiceImpl
implements TokenIDGeneratorService {
    @Autowired
    private TokenIDGenerator tokenIDGenerator;

    public TokenIDResponseDto generateTokenID(String uin, String partnerCode) {
        if (uin.isEmpty() || partnerCode.isEmpty()) {
            throw new TokenIdGeneratorException(TokenIDGeneratorErrorCode.EMPTY_UIN_OR_PARTNERCODE_EXCEPTION.getErrorCode(), TokenIDGeneratorErrorCode.EMPTY_UIN_OR_PARTNERCODE_EXCEPTION.getErrorMessage());
        }
        TokenIDResponseDto tokenIDResponseDto = new TokenIDResponseDto();
        tokenIDResponseDto.setTokenID(this.tokenIDGenerator.generateTokenID(uin, partnerCode));
        return tokenIDResponseDto;
    }
}

