/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.signature.service.impl;

import io.mosip.kernel.core.crypto.spi.CryptoCoreSpec;
import io.mosip.kernel.core.logger.spi.Logger;
import io.mosip.kernel.core.pdfgenerator.model.Rectangle;
import io.mosip.kernel.core.pdfgenerator.spi.PDFGenerator;
import io.mosip.kernel.core.signatureutil.model.SignatureResponse;
import io.mosip.kernel.core.util.CryptoUtil;
import io.mosip.kernel.core.util.DateUtils;
import io.mosip.kernel.keymanagerservice.constant.KeymanagerErrorConstant;
import io.mosip.kernel.keymanagerservice.dto.PublicKeyResponse;
import io.mosip.kernel.keymanagerservice.dto.SignatureCertificate;
import io.mosip.kernel.keymanagerservice.exception.KeymanagerServiceException;
import io.mosip.kernel.keymanagerservice.logger.KeymanagerLogger;
import io.mosip.kernel.keymanagerservice.service.KeymanagerService;
import io.mosip.kernel.keymanagerservice.util.KeymanagerUtil;
import io.mosip.kernel.signature.constant.SignatureErrorCode;
import io.mosip.kernel.signature.dto.PDFSignatureRequestDto;
import io.mosip.kernel.signature.dto.SignRequestDto;
import io.mosip.kernel.signature.dto.SignatureRequestDto;
import io.mosip.kernel.signature.dto.SignatureResponseDto;
import io.mosip.kernel.signature.dto.TimestampRequestDto;
import io.mosip.kernel.signature.dto.ValidatorResponseDto;
import io.mosip.kernel.signature.exception.PublicKeyParseException;
import io.mosip.kernel.signature.exception.SignatureFailureException;
import io.mosip.kernel.signature.service.SignatureService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Optional;
import javax.crypto.SecretKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SignatureServiceImpl
implements SignatureService {
    private static final Logger LOGGER = KeymanagerLogger.getLogger(SignatureServiceImpl.class);
    @Autowired
    private KeymanagerService keymanagerService;
    @Autowired
    private CryptoCoreSpec<byte[], byte[], SecretKey, PublicKey, PrivateKey, String> cryptoCore;
    @Value(value="${mosip.kernel.keygenerator.asymmetric-algorithm-name}")
    private String asymmetricAlgorithmName;
    @Value(value="${mosip.sign.applicationid:KERNEL}")
    private String signApplicationid;
    @Value(value="${mosip.sign.refid:SIGN}")
    private String signRefid;
    @Autowired
    KeymanagerUtil keymanagerUtil;
    @Autowired
    private PDFGenerator pdfGenerator;

    public SignatureResponse sign(SignRequestDto signRequestDto) {
        SignatureRequestDto signatureRequestDto = new SignatureRequestDto();
        signatureRequestDto.setApplicationId(this.signApplicationid);
        signatureRequestDto.setReferenceId(this.signRefid);
        signatureRequestDto.setData(signRequestDto.getData());
        String timestamp = DateUtils.getUTCCurrentDateTimeString();
        signatureRequestDto.setTimeStamp(timestamp);
        SignatureResponseDto signatureResponseDTO = this.sign(signatureRequestDto);
        return new SignatureResponse(signatureResponseDTO.getData(), DateUtils.convertUTCToLocalDateTime((String)timestamp));
    }

    private SignatureResponseDto sign(SignatureRequestDto signatureRequestDto) {
        SignatureCertificate certificateResponse = this.keymanagerService.getSignatureCertificate(signatureRequestDto.getApplicationId(), Optional.of(signatureRequestDto.getReferenceId()), signatureRequestDto.getTimeStamp());
        this.keymanagerUtil.isCertificateValid(certificateResponse.getCertificateEntry(), DateUtils.parseUTCToDate((String)signatureRequestDto.getTimeStamp()));
        String encryptedSignedData = null;
        if (certificateResponse.getCertificateEntry() != null) {
            encryptedSignedData = (String)this.cryptoCore.sign((Object)signatureRequestDto.getData().getBytes(), (Object)((PrivateKey)certificateResponse.getCertificateEntry().getPrivateKey()));
        }
        return new SignatureResponseDto(encryptedSignedData);
    }

    public ValidatorResponseDto validate(TimestampRequestDto timestampRequestDto) {
        boolean status;
        PublicKeyResponse publicKeyResponse = this.keymanagerService.getSignPublicKey(this.signApplicationid, DateUtils.formatToISOString((LocalDateTime)timestampRequestDto.getTimestamp()), Optional.of(this.signRefid));
        try {
            PublicKey publicKey = KeyFactory.getInstance(this.asymmetricAlgorithmName).generatePublic(new X509EncodedKeySpec(CryptoUtil.decodeBase64((String)((String)publicKeyResponse.getPublicKey()))));
            status = this.cryptoCore.verifySignature((Object)timestampRequestDto.getData().getBytes(), (Object)timestampRequestDto.getSignature(), (Object)publicKey);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException exception) {
            throw new PublicKeyParseException(SignatureErrorCode.INTERNAL_SERVER_ERROR.getErrorCode(), exception.getMessage(), (Throwable)exception);
        }
        if (status) {
            ValidatorResponseDto response = new ValidatorResponseDto();
            response.setMessage("Validation Successful");
            response.setStatus("success");
            return response;
        }
        throw new SignatureFailureException(SignatureErrorCode.NOT_VALID.getErrorCode(), SignatureErrorCode.NOT_VALID.getErrorMessage(), null);
    }

    public SignatureResponseDto signPDF(PDFSignatureRequestDto request) {
        OutputStream outputStream;
        SignatureCertificate signatureCertificate = this.keymanagerService.getSignatureCertificate(request.getApplicationId(), Optional.of(request.getReferenceId()), request.getTimeStamp());
        LOGGER.debug("sessionId", "sessionId", "sessionId", "Signature fetched from hsm " + signatureCertificate);
        Rectangle rectangle = new Rectangle((float)request.getLowerLeftX(), (float)request.getLowerLeftY(), (float)request.getUpperRightX(), (float)request.getUpperRightY());
        try {
            String providerName = signatureCertificate.getProviderName();
            LOGGER.info("sessionId", "sessionId", "sessionId", " Keystore Provider Name found: " + providerName);
            Arrays.stream(Security.getProviders()).forEach(x -> {
                LOGGER.info("sessionId", "sessionId", "sessionId", "provider name " + x.getName());
                LOGGER.info("sessionId", "sessionId", "sessionId", "provider info " + x.getInfo());
            });
            LOGGER.info("sessionId", "sessionId", "sessionId", "all providers ");
            outputStream = this.pdfGenerator.signAndEncryptPDF(CryptoUtil.decodeBase64((String)request.getData()), rectangle, request.getReason(), request.getPageNumber(), Security.getProvider(providerName), signatureCertificate.getCertificateEntry(), request.getPassword());
        }
        catch (IOException | GeneralSecurityException e) {
            throw new KeymanagerServiceException(KeymanagerErrorConstant.INTERNAL_SERVER_ERROR.getErrorCode(), KeymanagerErrorConstant.INTERNAL_SERVER_ERROR.getErrorMessage() + " " + e.getMessage());
        }
        SignatureResponseDto signatureResponseDto = new SignatureResponseDto();
        signatureResponseDto.setData(CryptoUtil.encodeBase64((byte[])((ByteArrayOutputStream)outputStream).toByteArray()));
        return signatureResponseDto;
    }
}

