/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.partnercertservice.util;

import io.mosip.kernel.core.keymanager.model.CertificateParameters;
import io.mosip.kernel.core.logger.spi.Logger;
import io.mosip.kernel.core.util.DateUtils;
import io.mosip.kernel.keymanagerservice.entity.CACertificateStore;
import io.mosip.kernel.keymanagerservice.logger.KeymanagerLogger;
import io.mosip.kernel.partnercertservice.constant.PartnerCertManagerErrorConstants;
import io.mosip.kernel.partnercertservice.exception.PartnerCertManagerException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.codec.digest.DigestUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class PartnerCertificateManagerUtil {
    private static final Logger LOGGER = KeymanagerLogger.getLogger(PartnerCertificateManagerUtil.class);

    public static boolean isSelfSignedCertificate(X509Certificate x509Cert) {
        try {
            x509Cert.verify(x509Cert.getPublicKey());
            return true;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException exp) {
            LOGGER.info("pcSessionId", "UploadCACertificate", "pcmUtil", "Ignore this exception, the exception thrown when signature validation failed.");
            return false;
        }
    }

    public static String formatCertificateDN(String certPrincipal) {
        X500Name x500Name = new X500Name(certPrincipal);
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(PartnerCertificateManagerUtil.getAttributeIfExist((X500Name)x500Name, (ASN1ObjectIdentifier)BCStyle.CN));
        strBuilder.append(PartnerCertificateManagerUtil.getAttributeIfExist((X500Name)x500Name, (ASN1ObjectIdentifier)BCStyle.OU));
        strBuilder.append(PartnerCertificateManagerUtil.getAttributeIfExist((X500Name)x500Name, (ASN1ObjectIdentifier)BCStyle.O));
        strBuilder.append(PartnerCertificateManagerUtil.getAttributeIfExist((X500Name)x500Name, (ASN1ObjectIdentifier)BCStyle.L));
        strBuilder.append(PartnerCertificateManagerUtil.getAttributeIfExist((X500Name)x500Name, (ASN1ObjectIdentifier)BCStyle.ST));
        strBuilder.append(PartnerCertificateManagerUtil.getAttributeIfExist((X500Name)x500Name, (ASN1ObjectIdentifier)BCStyle.C));
        if (strBuilder.length() > 0 && strBuilder.toString().endsWith(",")) {
            return strBuilder.substring(0, strBuilder.length() - 1);
        }
        return strBuilder.toString();
    }

    private static String getAttributeIfExist(X500Name x500Name, ASN1ObjectIdentifier identifier) {
        RDN[] rdns = x500Name.getRDNs(identifier);
        if (rdns.length == 0) {
            return "";
        }
        return BCStyle.INSTANCE.oidToDisplayName(identifier) + "=" + IETFUtils.valueToString((ASN1Encodable)rdns[0].getFirst().getValue()) + ",";
    }

    public static String getCertificateThumbprint(X509Certificate x509Cert) {
        try {
            return DigestUtils.sha1Hex((byte[])x509Cert.getEncoded());
        }
        catch (CertificateEncodingException e) {
            LOGGER.error("pcSessionId", "UploadCACertificate", "pcmUtil", "Error generating certificate thumbprint.");
            throw new PartnerCertManagerException(PartnerCertManagerErrorConstants.CERTIFICATE_THUMBPRINT_ERROR.getErrorCode(), PartnerCertManagerErrorConstants.CERTIFICATE_THUMBPRINT_ERROR.getErrorMessage());
        }
    }

    public static boolean isCertificateDatesValid(X509Certificate x509Cert) {
        try {
            Date currentDate = Date.from(DateUtils.getUTCCurrentDateTime().atZone(ZoneId.systemDefault()).toInstant());
            x509Cert.checkValidity(currentDate);
            return true;
        }
        catch (CertificateExpiredException | CertificateNotYetValidException exp) {
            LOGGER.info("pcSessionId", "UploadCACertificate", "pcmUtil", "Ignore this exception, the exception thrown when signature validation failed.");
            return false;
        }
    }

    public static boolean isValidTimestamp(LocalDateTime timeStamp, CACertificateStore certStore) {
        return timeStamp.isEqual(certStore.getCertNotBefore()) || timeStamp.isEqual(certStore.getCertNotAfter()) || timeStamp.isAfter(certStore.getCertNotBefore()) && timeStamp.isBefore(certStore.getCertNotAfter());
    }

    public static String getCertificateOrgName(X500Principal x500CertPrincipal) {
        X500Name x500Name = new X500Name(x500CertPrincipal.getName());
        RDN[] rdns = x500Name.getRDNs(BCStyle.O);
        if (rdns.length == 0) {
            return "";
        }
        return IETFUtils.valueToString((ASN1Encodable)rdns[0].getFirst().getValue());
    }

    public static boolean isValidCertificateID(String certID) {
        return certID != null && !certID.trim().isEmpty();
    }

    public static CertificateParameters getCertificateParameters(X500Principal latestCertPrincipal, LocalDateTime notBefore, LocalDateTime notAfter) {
        CertificateParameters certParams = new CertificateParameters();
        X500Name x500Name = new X500Name(latestCertPrincipal.getName());
        certParams.setCommonName(IETFUtils.valueToString((ASN1Encodable)x500Name.getRDNs(BCStyle.CN)[0].getFirst().getValue()));
        certParams.setOrganizationUnit(PartnerCertificateManagerUtil.getAttributeValueIfExist((X500Name)x500Name, (ASN1ObjectIdentifier)BCStyle.OU));
        certParams.setOrganization(PartnerCertificateManagerUtil.getAttributeValueIfExist((X500Name)x500Name, (ASN1ObjectIdentifier)BCStyle.O));
        certParams.setLocation(PartnerCertificateManagerUtil.getAttributeValueIfExist((X500Name)x500Name, (ASN1ObjectIdentifier)BCStyle.L));
        certParams.setState(PartnerCertificateManagerUtil.getAttributeValueIfExist((X500Name)x500Name, (ASN1ObjectIdentifier)BCStyle.ST));
        certParams.setCountry(PartnerCertificateManagerUtil.getAttributeValueIfExist((X500Name)x500Name, (ASN1ObjectIdentifier)BCStyle.C));
        certParams.setNotBefore(notBefore);
        certParams.setNotAfter(notAfter);
        return certParams;
    }

    private static String getAttributeValueIfExist(X500Name x500Name, ASN1ObjectIdentifier identifier) {
        RDN[] rdns = x500Name.getRDNs(identifier);
        if (rdns.length == 0) {
            return "";
        }
        return IETFUtils.valueToString((ASN1Encodable)rdns[0].getFirst().getValue());
    }
}

