/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.keymanager.hsm.impl;

import io.mosip.kernel.core.exception.NoSuchAlgorithmException;
import io.mosip.kernel.core.keymanager.exception.KeystoreProcessingException;
import io.mosip.kernel.core.keymanager.exception.NoSuchSecurityProviderException;
import io.mosip.kernel.core.keymanager.model.CertificateParameters;
import io.mosip.kernel.core.logger.spi.Logger;
import io.mosip.kernel.keygenerator.bouncycastle.constant.KeyGeneratorExceptionConstant;
import io.mosip.kernel.keymanager.hsm.constant.KeymanagerErrorCode;
import io.mosip.kernel.keymanager.hsm.util.CertificateUtility;
import io.mosip.kernel.keymanagerservice.logger.KeymanagerLogger;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class KeyStoreImpl
implements io.mosip.kernel.core.keymanager.spi.KeyStore,
InitializingBean {
    private static final Logger LOGGER = KeymanagerLogger.getLogger(KeyStoreImpl.class);
    private static final String KEYSTORE_TYPE_PKCS12 = "PKCS12";
    @Value(value="${mosip.kernel.keymanager.softhsm.certificate.common-name}")
    private String commonName;
    @Value(value="${mosip.kernel.keymanager.softhsm.certificate.organizational-unit}")
    private String organizationalUnit;
    @Value(value="${mosip.kernel.keymanager.softhsm.certificate.organization}")
    private String organization;
    @Value(value="${mosip.kernel.keymanager.softhsm.certificate.country}")
    private String country;
    @Value(value="${mosip.kernel.keymanager.softhsm.config-path}")
    private String configPath;
    @Value(value="${mosip.kernel.keymanager.softhsm.keystore-type:PKCS11}")
    private String keystoreType;
    @Value(value="${mosip.kernel.keymanager.softhsm.keystore-pass}")
    private String keystorePass;
    @Value(value="${mosip.kernel.keygenerator.symmetric-algorithm-name}")
    private String symmetricKeyAlgorithm;
    @Value(value="${mosip.kernel.keygenerator.symmetric-key-length}")
    private int symmetricKeyLength;
    @Value(value="${mosip.kernel.keygenerator.asymmetric-algorithm-name}")
    private String asymmetricKeyAlgorithm;
    @Value(value="${mosip.kernel.keygenerator.asymmetric-key-length}")
    private int asymmetricKeyLength;
    @Value(value="${mosip.kernel.certificate.sign.algorithm:SHA256withRSA}")
    private String signAlgorithm;
    private KeyStore keyStore;
    private Provider provider = null;
    private static final int NO_OF_RETRIES = 3;

    public void afterPropertiesSet() throws Exception {
        if (!this.isConfigFileValid()) {
            LOGGER.info("sessionId", "KeyStoreImpl", "Creation", "Config File path is not valid or contents invalid entries. So, Loading keystore as offline encryption.");
            BouncyCastleProvider bouncyCastleProvider = new BouncyCastleProvider();
            Security.addProvider((Provider)bouncyCastleProvider);
            this.keyStore = this.getKeystoreInstance(KEYSTORE_TYPE_PKCS12, (Provider)bouncyCastleProvider);
            this.loadKeystore();
            return;
        }
        this.provider = this.setupProvider(this.configPath);
        Security.removeProvider(this.provider.getName());
        this.addProvider(this.provider);
        BouncyCastleProvider bouncyCastleProvider = new BouncyCastleProvider();
        Security.addProvider((Provider)bouncyCastleProvider);
        this.keyStore = this.getKeystoreInstance(this.keystoreType, this.provider);
        this.loadKeystore();
    }

    private boolean isConfigFileValid() {
        if (this.configPath.trim().length() == 0) {
            return false;
        }
        try {
            return Files.readString(Paths.get(this.configPath, new String[0])).trim().length() != 0;
        }
        catch (IOException e) {
            LOGGER.error("sessionId", "KeyStoreImpl", "configFile", "Error reading pkcs11 config file.");
            return true;
        }
    }

    private Provider setupProvider(String configPath) {
        try {
            switch (this.keystoreType) {
                case "PKCS11": {
                    this.provider = Security.getProvider("SunPKCS11");
                    this.provider = this.provider.configure(configPath);
                    break;
                }
                case "BouncyCastleProvider": {
                    this.provider = new BouncyCastleProvider();
                    break;
                }
                default: {
                    this.provider = Security.getProvider("SunPKCS11");
                    this.provider = this.provider.configure(configPath);
                    break;
                }
            }
        }
        catch (InvalidParameterException | ProviderException providerException) {
            throw new NoSuchSecurityProviderException(KeymanagerErrorCode.INVALID_CONFIG_FILE.getErrorCode(), KeymanagerErrorCode.INVALID_CONFIG_FILE.getErrorMessage(), (Throwable)providerException);
        }
        return this.provider;
    }

    private void addProvider(Provider provider) {
        if (-1 == Security.addProvider(provider)) {
            throw new NoSuchSecurityProviderException(KeymanagerErrorCode.NO_SUCH_SECURITY_PROVIDER.getErrorCode(), KeymanagerErrorCode.NO_SUCH_SECURITY_PROVIDER.getErrorMessage());
        }
    }

    private KeyStore getKeystoreInstance(String keystoreType, Provider provider) {
        KeyStore mosipKeyStore = null;
        try {
            mosipKeyStore = KeyStore.getInstance(keystoreType, provider);
        }
        catch (KeyStoreException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + e.getMessage(), (Throwable)e);
        }
        return mosipKeyStore;
    }

    private void loadKeystore() {
        try {
            switch (this.keystoreType) {
                case "PKCS11": {
                    this.keyStore.load(null, this.keystorePass.toCharArray());
                    break;
                }
                case "BouncyCastleProvider": {
                    try (FileInputStream fis = new FileInputStream(this.configPath);){
                        this.keyStore.load(fis, this.keystorePass.toCharArray());
                        break;
                    }
                }
                default: {
                    this.keyStore.load(null, this.keystorePass.toCharArray());
                }
            }
        }
        catch (IOException | java.security.NoSuchAlgorithmException | CertificateException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + e.getMessage(), (Throwable)e);
        }
    }

    public List<String> getAllAlias() {
        Enumeration<String> enumeration = null;
        try {
            enumeration = this.keyStore.aliases();
        }
        catch (KeyStoreException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + e.getMessage(), (Throwable)e);
        }
        return Collections.list(enumeration);
    }

    public Key getKey(String alias) {
        Key key = null;
        try {
            key = this.keyStore.getKey(alias, this.keystorePass.toCharArray());
        }
        catch (KeyStoreException | java.security.NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + e.getMessage(), (Throwable)e);
        }
        return key;
    }

    public KeyStore.PrivateKeyEntry getAsymmetricKey(String alias) {
        this.validatePKCS11KeyStore();
        KeyStore.PrivateKeyEntry privateKeyEntry = null;
        int i = 0;
        boolean isException = false;
        String expMessage = "";
        KeyStoreException exp = null;
        do {
            block7: {
                try {
                    if (this.keyStore.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class)) {
                        LOGGER.debug("sessionId", "KeyStoreImpl", "getAsymmetricKey", "alias is instanceof keystore");
                        KeyStore.PasswordProtection password = new KeyStore.PasswordProtection(this.keystorePass.toCharArray());
                        privateKeyEntry = (KeyStore.PrivateKeyEntry)this.keyStore.getEntry(alias, password);
                        if (privateKeyEntry != null) {
                            LOGGER.debug("sessionId", "KeyStoreImpl", "getAsymmetricKey", "privateKeyEntry is not null");
                            break;
                        }
                        break block7;
                    }
                    throw new NoSuchSecurityProviderException(KeymanagerErrorCode.NO_SUCH_ALIAS.getErrorCode(), KeymanagerErrorCode.NO_SUCH_ALIAS.getErrorMessage() + alias);
                }
                catch (java.security.NoSuchAlgorithmException | UnrecoverableEntryException e) {
                    throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + e.getMessage(), (Throwable)e);
                }
                catch (KeyStoreException kse) {
                    isException = true;
                    expMessage = kse.getMessage();
                    exp = kse;
                    LOGGER.debug("sessionId", "KeyStoreImpl", "getAsymmetricKey", expMessage);
                }
            }
            if (!isException) continue;
            this.reloadProvider();
            isException = false;
        } while (i++ < 3);
        if (Objects.isNull(privateKeyEntry)) {
            LOGGER.debug("sessionId", "KeyStoreImpl", "getAsymmetricKey", "privateKeyEntry is null");
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + expMessage, (Throwable)exp);
        }
        return privateKeyEntry;
    }

    private void reloadProvider() {
        LOGGER.info("sessionId", "KeyStoreImpl", "KeyStoreImpl", "reloading provider");
        if (Objects.nonNull(this.provider)) {
            Security.removeProvider(this.provider.getName());
        }
        Provider provider = this.setupProvider(this.configPath);
        this.addProvider(provider);
        this.keyStore = this.getKeystoreInstance(this.keystoreType, provider);
        this.loadKeystore();
    }

    private void validatePKCS11KeyStore() {
        if (KEYSTORE_TYPE_PKCS12.equals(this.keyStore.getType())) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.NOT_VALID_PKCS11_STORE_TYPE.getErrorCode(), KeymanagerErrorCode.NOT_VALID_PKCS11_STORE_TYPE.getErrorMessage());
        }
    }

    public PrivateKey getPrivateKey(String alias) {
        KeyStore.PrivateKeyEntry privateKeyEntry = this.getAsymmetricKey(alias);
        return privateKeyEntry.getPrivateKey();
    }

    public PublicKey getPublicKey(String alias) {
        KeyStore.PrivateKeyEntry privateKeyEntry = this.getAsymmetricKey(alias);
        Certificate[] certificates = privateKeyEntry.getCertificateChain();
        return certificates[0].getPublicKey();
    }

    public X509Certificate getCertificate(String alias) {
        KeyStore.PrivateKeyEntry privateKeyEntry = this.getAsymmetricKey(alias);
        X509Certificate[] certificates = (X509Certificate[])privateKeyEntry.getCertificateChain();
        return certificates[0];
    }

    public void storeAsymmetricKey(KeyPair keyPair, String alias, LocalDateTime validityFrom, LocalDateTime validityTo) {
        Certificate[] chain = new X509Certificate[]{CertificateUtility.generateX509Certificate((PrivateKey)keyPair.getPrivate(), (PublicKey)keyPair.getPublic(), (String)this.commonName, (String)this.organizationalUnit, (String)this.organization, (String)this.country, (LocalDateTime)validityFrom, (LocalDateTime)validityTo, (String)(this.signAlgorithm == null ? "SHA256withRSA" : this.signAlgorithm), (String)(this.provider == null ? "BC" : this.provider.getName()))};
        this.storeCertificate(alias, chain, keyPair.getPrivate());
    }

    public SecretKey getSymmetricKey(String alias) {
        this.validatePKCS11KeyStore();
        SecretKey secretKey = null;
        int i = 0;
        boolean isException = false;
        String expMessage = "";
        KeyStoreException exp = null;
        do {
            block7: {
                try {
                    if (this.keyStore.entryInstanceOf(alias, KeyStore.SecretKeyEntry.class)) {
                        KeyStore.PasswordProtection password = new KeyStore.PasswordProtection(this.keystorePass.toCharArray());
                        KeyStore.SecretKeyEntry retrivedSecret = (KeyStore.SecretKeyEntry)this.keyStore.getEntry(alias, password);
                        secretKey = retrivedSecret.getSecretKey();
                        if (secretKey != null) {
                            LOGGER.debug("sessionId", "KeyStoreImpl", "getSymmetricKey", "secretKey is not null");
                            break;
                        }
                        break block7;
                    }
                    throw new NoSuchSecurityProviderException(KeymanagerErrorCode.NO_SUCH_ALIAS.getErrorCode(), KeymanagerErrorCode.NO_SUCH_ALIAS.getErrorMessage() + alias);
                }
                catch (java.security.NoSuchAlgorithmException | UnrecoverableEntryException e) {
                    throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + e.getMessage(), (Throwable)e);
                }
                catch (KeyStoreException kse) {
                    isException = true;
                    expMessage = kse.getMessage();
                    exp = kse;
                    LOGGER.debug("sessionId", "KeyStoreImpl", "getSymmetricKey", expMessage);
                }
            }
            if (!isException) continue;
            this.reloadProvider();
            isException = false;
        } while (i++ < 3);
        if (Objects.isNull(secretKey)) {
            LOGGER.debug("sessionId", "KeyStoreImpl", "getSymmetricKey", "secretKey is null");
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + expMessage, (Throwable)exp);
        }
        return secretKey;
    }

    public void storeSymmetricKey(SecretKey secretKey, String alias) {
        KeyStore.SecretKeyEntry secret = new KeyStore.SecretKeyEntry(secretKey);
        KeyStore.PasswordProtection password = new KeyStore.PasswordProtection(this.keystorePass.toCharArray());
        try {
            this.keyStore.setEntry(alias, secret, password);
            this.keyStore.store(null, this.keystorePass.toCharArray());
        }
        catch (IOException | KeyStoreException | java.security.NoSuchAlgorithmException | CertificateException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + e.getMessage(), (Throwable)e);
        }
    }

    public void deleteKey(String alias) {
        this.validatePKCS11KeyStore();
        try {
            this.keyStore.deleteEntry(alias);
        }
        catch (KeyStoreException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + e.getMessage(), (Throwable)e);
        }
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    private void storeCertificate(String alias, Certificate[] chain, PrivateKey privateKey) {
        KeyStore.PrivateKeyEntry privateKeyEntry = new KeyStore.PrivateKeyEntry(privateKey, chain);
        KeyStore.PasswordProtection password = new KeyStore.PasswordProtection(this.keystorePass.toCharArray());
        try {
            this.keyStore.setEntry(alias, privateKeyEntry, password);
            this.keyStore.store(null, this.keystorePass.toCharArray());
        }
        catch (IOException | KeyStoreException | java.security.NoSuchAlgorithmException | CertificateException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + e.getMessage());
        }
    }

    public void generateAndStoreAsymmetricKey(String alias, String signKeyAlias, CertificateParameters certParams) {
        this.validatePKCS11KeyStore();
        KeyPair keyPair = null;
        PrivateKey signPrivateKey = null;
        X500Principal signerPrincipal = null;
        if (Objects.nonNull(signKeyAlias)) {
            KeyStore.PrivateKeyEntry signKeyEntry = this.getAsymmetricKey(signKeyAlias);
            signPrivateKey = signKeyEntry.getPrivateKey();
            X509Certificate signCert = (X509Certificate)signKeyEntry.getCertificate();
            signerPrincipal = signCert.getSubjectX500Principal();
            keyPair = this.generateKeyPair();
        } else {
            keyPair = this.generateKeyPair();
            signPrivateKey = keyPair.getPrivate();
        }
        X509Certificate x509Cert = CertificateUtility.generateX509Certificate((PrivateKey)signPrivateKey, (PublicKey)keyPair.getPublic(), (CertificateParameters)certParams, (X500Principal)signerPrincipal, (String)this.signAlgorithm, (String)this.provider.getName());
        Certificate[] chain = new X509Certificate[]{x509Cert};
        this.storeCertificate(alias, chain, keyPair.getPrivate());
    }

    public void generateAndStoreSymmetricKey(String alias) {
        this.validatePKCS11KeyStore();
        SecretKey secretKey = this.generateSymmetricKey();
        KeyStore.SecretKeyEntry secret = new KeyStore.SecretKeyEntry(secretKey);
        KeyStore.PasswordProtection password = new KeyStore.PasswordProtection(this.keystorePass.toCharArray());
        try {
            this.keyStore.setEntry(alias, secret, password);
            this.keyStore.store(null, this.keystorePass.toCharArray());
        }
        catch (IOException | KeyStoreException | java.security.NoSuchAlgorithmException | CertificateException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + e.getMessage(), (Throwable)e);
        }
    }

    private KeyPair generateKeyPair() {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance(this.asymmetricKeyAlgorithm, this.provider);
            SecureRandom random = new SecureRandom();
            generator.initialize(this.asymmetricKeyLength, random);
            return generator.generateKeyPair();
        }
        catch (java.security.NoSuchAlgorithmException e) {
            throw new NoSuchAlgorithmException(KeyGeneratorExceptionConstant.MOSIP_NO_SUCH_ALGORITHM_EXCEPTION.getErrorCode(), KeyGeneratorExceptionConstant.MOSIP_NO_SUCH_ALGORITHM_EXCEPTION.getErrorMessage(), (Throwable)e);
        }
    }

    private SecretKey generateSymmetricKey() {
        try {
            KeyGenerator generator = KeyGenerator.getInstance(this.symmetricKeyAlgorithm, this.provider);
            SecureRandom random = new SecureRandom();
            generator.init(this.symmetricKeyLength, random);
            return generator.generateKey();
        }
        catch (java.security.NoSuchAlgorithmException e) {
            throw new NoSuchAlgorithmException(KeyGeneratorExceptionConstant.MOSIP_NO_SUCH_ALGORITHM_EXCEPTION.getErrorCode(), KeyGeneratorExceptionConstant.MOSIP_NO_SUCH_ALGORITHM_EXCEPTION.getErrorMessage(), (Throwable)e);
        }
    }

    public void storeCertificate(String alias, PrivateKey privateKey, Certificate certificate) {
        try {
            KeyStore.PrivateKeyEntry privateKeyEntry = new KeyStore.PrivateKeyEntry(privateKey, new Certificate[]{certificate});
            KeyStore.PasswordProtection password = new KeyStore.PasswordProtection(this.keystorePass.toCharArray());
            this.keyStore.setEntry(alias, privateKeyEntry, password);
            this.keyStore.store(null, this.keystorePass.toCharArray());
        }
        catch (IOException | KeyStoreException | java.security.NoSuchAlgorithmException | CertificateException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + e.getMessage(), (Throwable)e);
        }
    }

    public Certificate generateCertificate(PrivateKey signPrivateKey, PublicKey publicKey, CertificateParameters certParams, X500Principal signerPrincipal) {
        return CertificateUtility.generateX509Certificate((PrivateKey)signPrivateKey, (PublicKey)publicKey, (CertificateParameters)certParams, (X500Principal)signerPrincipal, (String)this.signAlgorithm, (String)this.provider.getName());
    }

    public String getKeystoreProviderName() {
        if (Objects.nonNull(this.keyStore)) {
            return this.keyStore.getProvider().getName();
        }
        throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_NOT_INSTANTIATED.getErrorCode(), KeymanagerErrorCode.KEYSTORE_NOT_INSTANTIATED.getErrorMessage());
    }
}

