/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.cryptomanager.util;

import io.mosip.kernel.core.exception.ParseException;
import io.mosip.kernel.core.logger.spi.Logger;
import io.mosip.kernel.core.util.CryptoUtil;
import io.mosip.kernel.cryptomanager.constant.CryptomanagerErrorCode;
import io.mosip.kernel.cryptomanager.dto.CryptomanagerRequestDto;
import io.mosip.kernel.cryptomanager.exception.CryptoManagerSerivceException;
import io.mosip.kernel.keymanagerservice.dto.SymmetricKeyRequestDto;
import io.mosip.kernel.keymanagerservice.logger.KeymanagerLogger;
import io.mosip.kernel.keymanagerservice.service.KeymanagerService;
import io.mosip.kernel.keymanagerservice.util.KeymanagerUtil;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

@RefreshScope
@Component
public class CryptomanagerUtils {
    private static final Logger LOGGER = KeymanagerLogger.getLogger(CryptomanagerUtils.class);
    private static final String UTC_DATETIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    @Value(value="${mosip.kernel.keygenerator.asymmetric-algorithm-name}")
    private String asymmetricAlgorithmName;
    @Value(value="${mosip.kernel.keygenerator.symmetric-algorithm-name}")
    private String symmetricAlgorithmName;
    @Value(value="${mosip.kernel.data-key-splitter}")
    private String keySplitter;
    @Autowired
    private KeymanagerService keyManager;
    @Autowired
    private KeymanagerUtil keymanagerUtil;

    public Certificate getCertificate(CryptomanagerRequestDto cryptomanagerRequestDto) {
        String certData = this.getCertificateFromKeyManager(cryptomanagerRequestDto.getApplicationId(), cryptomanagerRequestDto.getReferenceId());
        return this.keymanagerUtil.convertToCertificate(certData);
    }

    private String getCertificateFromKeyManager(String appId, String refId) {
        return this.keyManager.getCertificate(appId, Optional.ofNullable(refId)).getCertificate();
    }

    public SecretKey getDecryptedSymmetricKey(CryptomanagerRequestDto cryptomanagerRequestDto) {
        byte[] symmetricKey = CryptoUtil.decodeBase64((String)this.decryptSymmetricKeyUsingKeyManager(cryptomanagerRequestDto));
        return new SecretKeySpec(symmetricKey, 0, symmetricKey.length, this.symmetricAlgorithmName);
    }

    private String decryptSymmetricKeyUsingKeyManager(CryptomanagerRequestDto cryptomanagerRequestDto) {
        SymmetricKeyRequestDto symmetricKeyRequestDto = new SymmetricKeyRequestDto(cryptomanagerRequestDto.getApplicationId(), cryptomanagerRequestDto.getTimeStamp(), cryptomanagerRequestDto.getReferenceId(), cryptomanagerRequestDto.getData());
        return this.keyManager.decryptSymmetricKey(symmetricKeyRequestDto).getSymmetricKey();
    }

    public static String nullOrTrim(String parameter) {
        return parameter == null ? null : parameter.trim();
    }

    public boolean isValidSalt(String salt) {
        return salt != null && !salt.trim().isEmpty();
    }

    public LocalDateTime parseToLocalDateTime(String dateTime) {
        return LocalDateTime.parse(dateTime, DateTimeFormatter.ofPattern(UTC_DATETIME_PATTERN));
    }

    public byte[] hexDecode(String hexData) {
        char[] hexDataCharArr = hexData.toCharArray();
        int dataLength = hexDataCharArr.length;
        if ((dataLength & 1) != 0) {
            throw new ParseException(CryptomanagerErrorCode.HEX_DATA_PARSE_EXCEPTION.getErrorCode(), CryptomanagerErrorCode.HEX_DATA_PARSE_EXCEPTION.getErrorMessage());
        }
        byte[] decodedBytes = new byte[dataLength >> 1];
        int i = 0;
        int j = 0;
        while (j < dataLength) {
            int f = Character.digit(hexDataCharArr[j], 16) << 4;
            f |= Character.digit(hexDataCharArr[++j], 16);
            ++j;
            decodedBytes[i] = (byte)(f & 0xFF);
            ++i;
        }
        return decodedBytes;
    }

    public byte[] getCertificateThumbprint(Certificate cert) {
        try {
            return DigestUtils.sha1((byte[])cert.getEncoded());
        }
        catch (CertificateEncodingException e) {
            LOGGER.error("CryptoManagerSession", "CryptoManagerEncrypt", "", "Error generating certificate thumbprint.");
            throw new CryptoManagerSerivceException(CryptomanagerErrorCode.CERTIFICATE_THUMBPRINT_ERROR.getErrorCode(), CryptomanagerErrorCode.CERTIFICATE_THUMBPRINT_ERROR.getErrorMessage());
        }
    }

    public byte[] concatCertThumbprint(byte[] certThumbprint, byte[] encryptedKey) {
        byte[] finalData = new byte[20 + encryptedKey.length];
        System.arraycopy(certThumbprint, 0, finalData, 0, certThumbprint.length);
        System.arraycopy(encryptedKey, 0, finalData, certThumbprint.length, encryptedKey.length);
        return finalData;
    }
}

