/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.cryptomanager.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDateTime;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import lombok.Generated;

@ApiModel(description="Model representing a Crypto-Manager-Service Request")
public class CryptomanagerRequestDto {
    @ApiModelProperty(notes="Application id of decrypting module", example="REGISTRATION", required=true)
    @NotBlank(message="should not be null or empty")
    private @NotBlank(message="should not be null or empty") String applicationId;
    @ApiModelProperty(notes="Refrence Id", example="REF01")
    private String referenceId;
    @ApiModelProperty(notes="Timestamp as metadata", example="2018-12-10T06:12:52.994Z", required=true)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    @NotNull
    private LocalDateTime timeStamp;
    @ApiModelProperty(notes="Data in BASE64 encoding to encrypt/decrypt", required=true)
    @NotBlank(message="should not be null or empty")
    private @NotBlank(message="should not be null or empty") String data;
    @Pattern(regexp=".+\\S.*", message="should not be empty")
    @ApiModelProperty(notes=" Base64 Encoded Salt to be send as IV", example="LA7YcvP9DdLIVI5CwFt1SQ")
    private @Pattern(regexp=".+\\S.*", message="should not be empty") String salt;
    @Pattern(regexp=".+\\S.*", message="should not be empty")
    @ApiModelProperty(notes=" Base64 Encoded AAD(Advance Authentication Data)", example="VGhpcyBpcyBzYW1wbGUgYWFk")
    private @Pattern(regexp=".+\\S.*", message="should not be empty") String aad;

    public String toString() {
        return "CryptomanagerRequestDto [applicationId=" + this.applicationId + ", referenceId=" + this.referenceId + ", timeStamp=" + this.timeStamp + ", data=" + this.data + ", salt=" + this.salt + "]";
    }

    @Generated
    public String getApplicationId() {
        return this.applicationId;
    }

    @Generated
    public String getReferenceId() {
        return this.referenceId;
    }

    @Generated
    public LocalDateTime getTimeStamp() {
        return this.timeStamp;
    }

    @Generated
    public String getData() {
        return this.data;
    }

    @Generated
    public String getSalt() {
        return this.salt;
    }

    @Generated
    public String getAad() {
        return this.aad;
    }

    @Generated
    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    @Generated
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    @Generated
    public void setTimeStamp(LocalDateTime timeStamp) {
        this.timeStamp = timeStamp;
    }

    @Generated
    public void setData(String data) {
        this.data = data;
    }

    @Generated
    public void setSalt(String salt) {
        this.salt = salt;
    }

    @Generated
    public void setAad(String aad) {
        this.aad = aad;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CryptomanagerRequestDto)) {
            return false;
        }
        CryptomanagerRequestDto other = (CryptomanagerRequestDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$applicationId = this.getApplicationId();
        String other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) {
            return false;
        }
        String this$referenceId = this.getReferenceId();
        String other$referenceId = other.getReferenceId();
        if (this$referenceId == null ? other$referenceId != null : !this$referenceId.equals(other$referenceId)) {
            return false;
        }
        LocalDateTime this$timeStamp = this.getTimeStamp();
        LocalDateTime other$timeStamp = other.getTimeStamp();
        if (this$timeStamp == null ? other$timeStamp != null : !((Object)this$timeStamp).equals(other$timeStamp)) {
            return false;
        }
        String this$data = this.getData();
        String other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$salt = this.getSalt();
        String other$salt = other.getSalt();
        if (this$salt == null ? other$salt != null : !this$salt.equals(other$salt)) {
            return false;
        }
        String this$aad = this.getAad();
        String other$aad = other.getAad();
        return !(this$aad == null ? other$aad != null : !this$aad.equals(other$aad));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CryptomanagerRequestDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $applicationId = this.getApplicationId();
        result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
        String $referenceId = this.getReferenceId();
        result = result * 59 + ($referenceId == null ? 43 : $referenceId.hashCode());
        LocalDateTime $timeStamp = this.getTimeStamp();
        result = result * 59 + ($timeStamp == null ? 43 : ((Object)$timeStamp).hashCode());
        String $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $salt = this.getSalt();
        result = result * 59 + ($salt == null ? 43 : $salt.hashCode());
        String $aad = this.getAad();
        result = result * 59 + ($aad == null ? 43 : $aad.hashCode());
        return result;
    }

    @Generated
    public CryptomanagerRequestDto(String applicationId, String referenceId, LocalDateTime timeStamp, String data, String salt, String aad) {
        this.applicationId = applicationId;
        this.referenceId = referenceId;
        this.timeStamp = timeStamp;
        this.data = data;
        this.salt = salt;
        this.aad = aad;
    }

    @Generated
    public CryptomanagerRequestDto() {
    }
}

