/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.lkeymanager.controller;

import io.mosip.kernel.core.http.RequestWrapper;
import io.mosip.kernel.core.http.ResponseFilter;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.mosip.kernel.core.licensekeymanager.spi.LicenseKeyManagerService;
import io.mosip.kernel.lkeymanager.dto.LicenseKeyFetchResponseDto;
import io.mosip.kernel.lkeymanager.dto.LicenseKeyGenerationDto;
import io.mosip.kernel.lkeymanager.dto.LicenseKeyGenerationResponseDto;
import io.mosip.kernel.lkeymanager.dto.LicenseKeyMappingDto;
import io.mosip.kernel.lkeymanager.dto.LicenseKeyMappingResponseDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class LicenseKeyController {
    @Autowired
    LicenseKeyManagerService<String, LicenseKeyGenerationDto, LicenseKeyMappingDto> licenseKeyManagerService;

    @ResponseFilter
    @PostMapping(value={"/license/generate"})
    public ResponseWrapper<LicenseKeyGenerationResponseDto> generateLicenseKey(@RequestBody RequestWrapper<LicenseKeyGenerationDto> licenseKeyGenerationDto) {
        LicenseKeyGenerationResponseDto licenseKeyGenerationResponseDto = new LicenseKeyGenerationResponseDto();
        ResponseWrapper responseWrapper = new ResponseWrapper();
        licenseKeyGenerationResponseDto.setLicenseKey((String)this.licenseKeyManagerService.generateLicenseKey((Object)((LicenseKeyGenerationDto)licenseKeyGenerationDto.getRequest())));
        responseWrapper.setResponse((Object)licenseKeyGenerationResponseDto);
        return responseWrapper;
    }

    @ResponseFilter
    @PostMapping(value={"/license/permission"})
    public ResponseWrapper<LicenseKeyMappingResponseDto> mapLicenseKey(@RequestBody RequestWrapper<LicenseKeyMappingDto> licenseKeyMappingDto) {
        LicenseKeyMappingResponseDto licenseKeyMappingResponseDto = new LicenseKeyMappingResponseDto();
        ResponseWrapper responseWrapper = new ResponseWrapper();
        licenseKeyMappingResponseDto.setStatus((String)this.licenseKeyManagerService.mapLicenseKey((Object)((LicenseKeyMappingDto)licenseKeyMappingDto.getRequest())));
        responseWrapper.setResponse((Object)licenseKeyMappingResponseDto);
        return responseWrapper;
    }

    @ResponseFilter
    @GetMapping(value={"/license/permission"})
    public ResponseWrapper<LicenseKeyFetchResponseDto> fetchLicenseKeyPermissions(@RequestParam(value="tspId") String tspId, @RequestParam(value="licenseKey") String licenseKey) {
        LicenseKeyFetchResponseDto licenseKeyFetchResponseDto = new LicenseKeyFetchResponseDto();
        ResponseWrapper responseWrapper = new ResponseWrapper();
        licenseKeyFetchResponseDto.setPermissions(this.licenseKeyManagerService.fetchLicenseKeyPermissions((Object)tspId, (Object)licenseKey));
        responseWrapper.setResponse((Object)licenseKeyFetchResponseDto);
        return responseWrapper;
    }
}

