/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.keymanagerservice.helper;

import io.mosip.kernel.core.logger.spi.Logger;
import io.mosip.kernel.keymanagerservice.constant.KeymanagerErrorConstant;
import io.mosip.kernel.keymanagerservice.entity.BaseEntity;
import io.mosip.kernel.keymanagerservice.entity.KeyAlias;
import io.mosip.kernel.keymanagerservice.entity.KeyPolicy;
import io.mosip.kernel.keymanagerservice.entity.KeyStore;
import io.mosip.kernel.keymanagerservice.exception.InvalidApplicationIdException;
import io.mosip.kernel.keymanagerservice.logger.KeymanagerLogger;
import io.mosip.kernel.keymanagerservice.repository.KeyAliasRepository;
import io.mosip.kernel.keymanagerservice.repository.KeyPolicyRepository;
import io.mosip.kernel.keymanagerservice.repository.KeyStoreRepository;
import io.mosip.kernel.keymanagerservice.util.KeymanagerUtil;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KeymanagerDBHelper {
    private static final Logger LOGGER = KeymanagerLogger.getLogger(KeymanagerDBHelper.class);
    @Autowired
    KeyAliasRepository keyAliasRepository;
    @Autowired
    KeyPolicyRepository keyPolicyRepository;
    @Autowired
    KeyStoreRepository keyStoreRepository;
    @Autowired
    KeymanagerUtil keymanagerUtil;

    public void storeKeyInAlias(String applicationId, LocalDateTime timeStamp, String referenceId, String alias, LocalDateTime expiryDateTime) {
        LOGGER.info("sessionId", "", "", "Storing key in KeyAlias");
        KeyAlias keyAlias = new KeyAlias();
        keyAlias.setAlias(alias);
        keyAlias.setApplicationId(applicationId);
        keyAlias.setReferenceId(referenceId);
        keyAlias.setKeyGenerationTime(timeStamp);
        keyAlias.setKeyExpiryTime(expiryDateTime);
        this.keyAliasRepository.saveAndFlush((Object)((KeyAlias)this.keymanagerUtil.setMetaData((BaseEntity)keyAlias)));
    }

    public void storeKeyInDBStore(String alias, String masterAlias, String certificateData, String encryptedPrivateKey) {
        KeyStore dbKeyStore = new KeyStore();
        LOGGER.info("sessionId", "", "", "Storing key in dbKeyStore");
        dbKeyStore.setAlias(alias);
        dbKeyStore.setMasterAlias(masterAlias);
        dbKeyStore.setCertificateData(certificateData);
        dbKeyStore.setPrivateKey(encryptedPrivateKey);
        this.keyStoreRepository.saveAndFlush((Object)((KeyStore)this.keymanagerUtil.setMetaData((BaseEntity)dbKeyStore)));
    }

    public Map<String, List<KeyAlias>> getKeyAliases(String applicationId, String referenceId, LocalDateTime timeStamp) {
        LOGGER.info("sessionId", "", "", "Getting key alias");
        HashMap<String, List<KeyAlias>> hashmap = new HashMap<String, List<KeyAlias>>();
        List keyAliases = this.keyAliasRepository.findByApplicationIdAndReferenceId(applicationId, referenceId).stream().sorted((alias1, alias2) -> alias1.getKeyGenerationTime().compareTo(alias2.getKeyGenerationTime())).collect(Collectors.toList());
        List currentKeyAliases = keyAliases.stream().filter(keyAlias -> this.keymanagerUtil.isValidTimestamp(timeStamp, keyAlias)).collect(Collectors.toList());
        LOGGER.info("sessionId", "keyAlias", Arrays.toString(keyAliases.toArray()), "keyAlias");
        LOGGER.info("sessionId", "currentKeyAlias", Arrays.toString(currentKeyAliases.toArray()), "currentKeyAlias");
        hashmap.put("keyAlias", keyAliases);
        hashmap.put("currentKeyAlias", currentKeyAliases);
        return hashmap;
    }

    public LocalDateTime getExpiryPolicy(String applicationId, LocalDateTime timeStamp, List<KeyAlias> keyAlias) {
        LOGGER.info("sessionId", "applicationId", applicationId, "Getting expiry policy");
        Optional keyPolicy = this.keyPolicyRepository.findByApplicationId(applicationId);
        if (!keyPolicy.isPresent()) {
            LOGGER.info("sessionId", "keyPolicy", keyPolicy.toString(), "Key Policy not found for this application Id. Throwing exception");
            throw new InvalidApplicationIdException(KeymanagerErrorConstant.APPLICATIONID_NOT_VALID.getErrorCode(), KeymanagerErrorConstant.APPLICATIONID_NOT_VALID.getErrorMessage());
        }
        LocalDateTime policyExpiryTime = timeStamp.plusDays(((KeyPolicy)keyPolicy.get()).getValidityInDays());
        if (!keyAlias.isEmpty()) {
            LOGGER.info("sessionId", "keyAlias", String.valueOf(keyAlias.size()), "Getting expiry policy. KeyAlias exists");
            for (KeyAlias alias : keyAlias) {
                if (!this.keymanagerUtil.isOverlapping(timeStamp, policyExpiryTime, alias.getKeyGenerationTime(), alias.getKeyExpiryTime())) continue;
                LOGGER.info("sessionId", "", "", "Overlapping timestamp found. Changing policyExpiryTime");
                policyExpiryTime = alias.getKeyGenerationTime().minusSeconds(1L);
                break;
            }
        }
        return policyExpiryTime;
    }

    public Optional<KeyStore> getKeyStoreFromDB(String keyAlias) {
        Optional dbKeyStore = this.keyStoreRepository.findByAlias(keyAlias);
        return dbKeyStore;
    }

    public Optional<KeyPolicy> getKeyPolicy(String applicationId) {
        Optional keyPolicy = this.keyPolicyRepository.findByApplicationIdAndIsActive(applicationId, true);
        if (!keyPolicy.isPresent()) {
            LOGGER.error("sessionId", "keyPolicy", keyPolicy.toString(), "Key Policy not found for this application Id.");
            throw new InvalidApplicationIdException(KeymanagerErrorConstant.APPLICATIONID_NOT_VALID.getErrorCode(), KeymanagerErrorConstant.APPLICATIONID_NOT_VALID.getErrorMessage());
        }
        return keyPolicy;
    }
}

