/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.clientcrypto.controller;

import io.mosip.kernel.clientcrypto.dto.PublicKeyRequestDto;
import io.mosip.kernel.clientcrypto.dto.PublicKeyResponseDto;
import io.mosip.kernel.clientcrypto.dto.TpmCryptoRequestDto;
import io.mosip.kernel.clientcrypto.dto.TpmCryptoResponseDto;
import io.mosip.kernel.clientcrypto.dto.TpmSignRequestDto;
import io.mosip.kernel.clientcrypto.dto.TpmSignResponseDto;
import io.mosip.kernel.clientcrypto.dto.TpmSignVerifyRequestDto;
import io.mosip.kernel.clientcrypto.dto.TpmSignVerifyResponseDto;
import io.mosip.kernel.clientcrypto.service.spi.ClientCryptoManagerService;
import io.mosip.kernel.core.http.RequestWrapper;
import io.mosip.kernel.core.http.ResponseFilter;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.swagger.annotations.Api;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
@Api(value="Operation related to offline Encryption and Decryption", tags={"clientcrypto"})
public class ClientCryptoController {
    @Autowired
    private ClientCryptoManagerService clientCryptoManagerService;

    @PreAuthorize(value="hasAnyRole('INDIVIDUAL','ID_AUTHENTICATION','TEST', 'REGISTRATION_ADMIN', 'REGISTRATION_SUPERVISOR', 'REGISTRATION_OFFICER', 'REGISTRATION_PROCESSOR','PRE_REGISTRATION_ADMIN','RESIDENT')")
    @ResponseFilter
    @PostMapping(value={"/cssign"}, produces={"application/json"})
    public ResponseWrapper<TpmSignResponseDto> signData(@RequestBody @Valid RequestWrapper<TpmSignRequestDto> tpmSignRequestDtoRequestWrapper) {
        ResponseWrapper responseDtoResponseWrapper = new ResponseWrapper();
        responseDtoResponseWrapper.setResponse((Object)this.clientCryptoManagerService.csSign((TpmSignRequestDto)tpmSignRequestDtoRequestWrapper.getRequest()));
        return responseDtoResponseWrapper;
    }

    @PreAuthorize(value="hasAnyRole('INDIVIDUAL','ID_AUTHENTICATION','TEST', 'REGISTRATION_ADMIN', 'REGISTRATION_SUPERVISOR', 'REGISTRATION_OFFICER', 'REGISTRATION_PROCESSOR','PRE_REGISTRATION_ADMIN','RESIDENT')")
    @ResponseFilter
    @PostMapping(value={"/csverifysign"}, produces={"application/json"})
    public ResponseWrapper<TpmSignVerifyResponseDto> verifySignature(@RequestBody @Valid RequestWrapper<TpmSignVerifyRequestDto> tpmSignVerifyRequestDtoRequestWrapper) {
        ResponseWrapper responseDtoResponseWrapper = new ResponseWrapper();
        responseDtoResponseWrapper.setResponse((Object)this.clientCryptoManagerService.csVerify((TpmSignVerifyRequestDto)tpmSignVerifyRequestDtoRequestWrapper.getRequest()));
        return responseDtoResponseWrapper;
    }

    @PreAuthorize(value="hasAnyRole('INDIVIDUAL','ID_AUTHENTICATION','TEST', 'REGISTRATION_ADMIN', 'REGISTRATION_SUPERVISOR', 'REGISTRATION_OFFICER', 'REGISTRATION_PROCESSOR','PRE_REGISTRATION_ADMIN','RESIDENT')")
    @ResponseFilter
    @PostMapping(value={"/tpmencrypt"}, produces={"application/json"})
    public ResponseWrapper<TpmCryptoResponseDto> tpmEncrypt(@RequestBody @Valid RequestWrapper<TpmCryptoRequestDto> tpmCryptoRequestDtoRequestWrapper) {
        ResponseWrapper responseDtoResponseWrapper = new ResponseWrapper();
        responseDtoResponseWrapper.setResponse((Object)this.clientCryptoManagerService.csEncrypt((TpmCryptoRequestDto)tpmCryptoRequestDtoRequestWrapper.getRequest()));
        return responseDtoResponseWrapper;
    }

    @PreAuthorize(value="hasAnyRole('INDIVIDUAL','ID_AUTHENTICATION','TEST', 'REGISTRATION_ADMIN', 'REGISTRATION_SUPERVISOR', 'REGISTRATION_OFFICER', 'REGISTRATION_PROCESSOR','PRE_REGISTRATION_ADMIN','RESIDENT')")
    @ResponseFilter
    @PostMapping(value={"/tpmdecrypt"}, produces={"application/json"})
    public ResponseWrapper<TpmCryptoResponseDto> tpmDecrypt(@RequestBody @Valid RequestWrapper<TpmCryptoRequestDto> tpmCryptoRequestDtoRequestWrapper) {
        ResponseWrapper responseDtoResponseWrapper = new ResponseWrapper();
        responseDtoResponseWrapper.setResponse((Object)this.clientCryptoManagerService.csDecrypt((TpmCryptoRequestDto)tpmCryptoRequestDtoRequestWrapper.getRequest()));
        return responseDtoResponseWrapper;
    }

    @PreAuthorize(value="hasAnyRole('INDIVIDUAL','ID_AUTHENTICATION','TEST', 'REGISTRATION_ADMIN', 'REGISTRATION_SUPERVISOR', 'REGISTRATION_OFFICER', 'REGISTRATION_PROCESSOR','PRE_REGISTRATION_ADMIN','RESIDENT')")
    @ResponseFilter
    @PostMapping(value={"/tpmsigning/publickey"}, produces={"application/json"})
    public ResponseWrapper<PublicKeyResponseDto> getSigningPublicKey(@RequestBody @Valid RequestWrapper<PublicKeyRequestDto> publicKeyRequestDtoRequestWrapper) {
        ResponseWrapper responseDtoResponseWrapper = new ResponseWrapper();
        responseDtoResponseWrapper.setResponse((Object)this.clientCryptoManagerService.getSigningPublicKey((PublicKeyRequestDto)publicKeyRequestDtoRequestWrapper.getRequest()));
        return responseDtoResponseWrapper;
    }

    @PreAuthorize(value="hasAnyRole('INDIVIDUAL','ID_AUTHENTICATION','TEST', 'REGISTRATION_ADMIN', 'REGISTRATION_SUPERVISOR', 'REGISTRATION_OFFICER', 'REGISTRATION_PROCESSOR','PRE_REGISTRATION_ADMIN','RESIDENT')")
    @ResponseFilter
    @PostMapping(value={"/tpmencryption/publickey"}, produces={"application/json"})
    public ResponseWrapper<PublicKeyResponseDto> getEncPublicKey(@RequestBody @Valid RequestWrapper<PublicKeyRequestDto> publicKeyRequestDtoRequestWrapper) {
        ResponseWrapper responseDtoResponseWrapper = new ResponseWrapper();
        responseDtoResponseWrapper.setResponse((Object)this.clientCryptoManagerService.getEncPublicKey((PublicKeyRequestDto)publicKeyRequestDtoRequestWrapper.getRequest()));
        return responseDtoResponseWrapper;
    }
}

