/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.zkcryptoservice.controller;

import io.mosip.kernel.core.http.RequestWrapper;
import io.mosip.kernel.core.http.ResponseFilter;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.mosip.kernel.zkcryptoservice.dto.ReEncryptRandomKeyResponseDto;
import io.mosip.kernel.zkcryptoservice.dto.ZKCryptoRequestDto;
import io.mosip.kernel.zkcryptoservice.dto.ZKCryptoResponseDto;
import io.mosip.kernel.zkcryptoservice.service.spi.ZKCryptoManagerService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiParam;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
@Api(value="Operation related to Zero Knowledge Encryption and Decryption", tags={"zkcryptomanager"})
public class ZKCryptoManagerController {
    @Autowired
    ZKCryptoManagerService zkCryptoManagerService;

    @PreAuthorize(value="hasAnyRole('INDIVIDUAL','ID_AUTHENTICATION','TEST', 'REGISTRATION_ADMIN', 'REGISTRATION_SUPERVISOR', 'REGISTRATION_OFFICER', 'REGISTRATION_PROCESSOR','PRE_REGISTRATION_ADMIN','RESIDENT')")
    @ResponseFilter
    @PostMapping(value={"/zkEncrypt"}, produces={"application/json"})
    public ResponseWrapper<ZKCryptoResponseDto> zkEncrypt(@ApiParam(value="List of ZK Data Attributes to Encrypt.") @RequestBody @Valid RequestWrapper<ZKCryptoRequestDto> zkCryptoRequestDto) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.zkCryptoManagerService.zkEncrypt((ZKCryptoRequestDto)zkCryptoRequestDto.getRequest()));
        return response;
    }

    @PreAuthorize(value="hasAnyRole('INDIVIDUAL','ID_AUTHENTICATION', 'TEST', 'REGISTRATION_ADMIN', 'REGISTRATION_SUPERVISOR', 'REGISTRATION_OFFICER', 'REGISTRATION_PROCESSOR','PRE_REGISTRATION_ADMIN','RESIDENT')")
    @ResponseFilter
    @PostMapping(value={"/zkDecrypt"}, produces={"application/json"})
    public ResponseWrapper<ZKCryptoResponseDto> zkDecrypt(@ApiParam(value="List of ZK Data Attributes to Decrypt.") @RequestBody @Valid RequestWrapper<ZKCryptoRequestDto> zkCryptoRequestDto) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.zkCryptoManagerService.zkDecrypt((ZKCryptoRequestDto)zkCryptoRequestDto.getRequest()));
        return response;
    }

    @PreAuthorize(value="hasAnyRole('INDIVIDUAL','ID_AUTHENTICATION', 'TEST', 'REGISTRATION_ADMIN', 'REGISTRATION_SUPERVISOR', 'REGISTRATION_OFFICER', 'REGISTRATION_PROCESSOR','PRE_REGISTRATION_ADMIN','RESIDENT')")
    @ResponseFilter
    @PostMapping(value={"/zkReEncryptRandomKey"}, produces={"application/json"})
    public ResponseWrapper<ReEncryptRandomKeyResponseDto> zkReEncryptRandomKey(@ApiParam(value="Random key to re-encrypt") @RequestParam(value="encryptedKey") String encryptedKey) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.zkCryptoManagerService.zkReEncryptRandomKey(encryptedKey));
        return response;
    }
}

