/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.signature.service.impl;

import io.mosip.kernel.core.crypto.spi.CryptoCoreSpec;
import io.mosip.kernel.core.signatureutil.model.SignatureResponse;
import io.mosip.kernel.core.util.CryptoUtil;
import io.mosip.kernel.core.util.DateUtils;
import io.mosip.kernel.keymanagerservice.dto.PublicKeyResponse;
import io.mosip.kernel.keymanagerservice.dto.SignatureRequestDto;
import io.mosip.kernel.keymanagerservice.dto.SignatureResponseDto;
import io.mosip.kernel.keymanagerservice.service.KeymanagerService;
import io.mosip.kernel.signature.constant.SignatureErrorCode;
import io.mosip.kernel.signature.dto.SignRequestDto;
import io.mosip.kernel.signature.dto.TimestampRequestDto;
import io.mosip.kernel.signature.dto.ValidatorResponseDto;
import io.mosip.kernel.signature.exception.PublicKeyParseException;
import io.mosip.kernel.signature.exception.SignatureFailureException;
import io.mosip.kernel.signature.service.SignatureService;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.time.LocalDateTime;
import java.util.Optional;
import javax.crypto.SecretKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SignatureServiceImpl
implements SignatureService {
    @Autowired
    private KeymanagerService keymanagerService;
    @Autowired
    private CryptoCoreSpec<byte[], byte[], SecretKey, PublicKey, PrivateKey, String> cryptoCore;
    @Value(value="${mosip.kernel.keygenerator.asymmetric-algorithm-name}")
    private String asymmetricAlgorithmName;
    @Value(value="${mosip.sign.applicationid:KERNEL}")
    private String signApplicationid;
    @Value(value="${mosip.sign.refid:SIGN}")
    private String signRefid;

    public SignatureResponse sign(SignRequestDto signRequestDto) {
        SignatureRequestDto signatureRequestDto = new SignatureRequestDto();
        signatureRequestDto.setApplicationId(this.signApplicationid);
        signatureRequestDto.setReferenceId(this.signRefid);
        signatureRequestDto.setData(signRequestDto.getData());
        String timestamp = DateUtils.getUTCCurrentDateTimeString();
        signatureRequestDto.setTimeStamp(timestamp);
        SignatureResponseDto signatureResponseDTO = this.keymanagerService.sign(signatureRequestDto);
        return new SignatureResponse(signatureResponseDTO.getData(), DateUtils.convertUTCToLocalDateTime((String)timestamp));
    }

    public ValidatorResponseDto validate(TimestampRequestDto timestampRequestDto) {
        boolean status;
        PublicKeyResponse publicKeyResponse = this.keymanagerService.getSignPublicKey(this.signApplicationid, DateUtils.formatToISOString((LocalDateTime)timestampRequestDto.getTimestamp()), Optional.of(this.signRefid));
        try {
            PublicKey publicKey = KeyFactory.getInstance(this.asymmetricAlgorithmName).generatePublic(new X509EncodedKeySpec(CryptoUtil.decodeBase64((String)((String)publicKeyResponse.getPublicKey()))));
            status = this.cryptoCore.verifySignature((Object)timestampRequestDto.getData().getBytes(), (Object)timestampRequestDto.getSignature(), (Object)publicKey);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException exception) {
            throw new PublicKeyParseException(SignatureErrorCode.INTERNAL_SERVER_ERROR.getErrorCode(), exception.getMessage(), (Throwable)exception);
        }
        if (status) {
            ValidatorResponseDto response = new ValidatorResponseDto();
            response.setMessage("Validation Successful");
            response.setStatus("success");
            return response;
        }
        throw new SignatureFailureException(SignatureErrorCode.NOT_VALID.getErrorCode(), SignatureErrorCode.NOT_VALID.getErrorMessage(), null);
    }
}

