/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.lkeymanager.config;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaDialect;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaDialect;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
@EnableJpaRepositories(basePackages={"io.mosip.kernel.lkeymanager.repository"}, entityManagerFactoryRef="lKeymanagerEntityManagerFactory", transactionManagerRef="lKeymanagerTransactionManager")
public class LicenseKeymanagerConfig {
    @Autowired
    private Environment environment;
    private static final Logger LOGGER = LoggerFactory.getLogger(LicenseKeymanagerConfig.class);
    @Value(value="${lkeymanager.hikari.maximumPoolSize:25}")
    private int maximumPoolSize;
    @Value(value="${lkeymanager.hikari.validationTimeout:3000}")
    private int validationTimeout;
    @Value(value="${lkeymanager.hikari.connectionTimeout:60000}")
    private int connectionTimeout;
    @Value(value="${lkeymanager.hikari.idleTimeout:200000}")
    private int idleTimeout;
    @Value(value="${lkeymanager.hikari.minimumIdle:0}")
    private int minimumIdle;

    @Bean
    public DataSource lKeymanagerDataSource() {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setDriverClassName(this.environment.getProperty("licensekeymanager.persistence.jdbc.driver"));
        hikariConfig.setJdbcUrl(this.environment.getProperty("licensekeymanager_database_url"));
        hikariConfig.setUsername(this.environment.getProperty("licensekeymanager_database_username"));
        hikariConfig.setPassword(this.environment.getProperty("licensekeymanager_database_password"));
        if (this.environment.containsProperty("licensekeymanager.persistence.jdbc.schema")) {
            hikariConfig.setSchema(this.environment.getProperty("licensekeymanager.persistence.jdbc.schema"));
        }
        hikariConfig.setMaximumPoolSize(this.maximumPoolSize);
        hikariConfig.setValidationTimeout((long)this.validationTimeout);
        hikariConfig.setConnectionTimeout((long)this.connectionTimeout);
        hikariConfig.setIdleTimeout((long)this.idleTimeout);
        hikariConfig.setMinimumIdle(this.minimumIdle);
        return new HikariDataSource(hikariConfig);
    }

    @Bean
    public LocalContainerEntityManagerFactoryBean lKeymanagerEntityManagerFactory() {
        LocalContainerEntityManagerFactoryBean entityManagerFactory = new LocalContainerEntityManagerFactoryBean();
        entityManagerFactory.setDataSource(this.lKeymanagerDataSource());
        entityManagerFactory.setPackagesToScan(new String[]{"io.mosip.kernel.lkeymanager.entity"});
        entityManagerFactory.setPersistenceUnitName("hibernate");
        entityManagerFactory.setJpaPropertyMap(this.jpaProperties());
        entityManagerFactory.setJpaVendorAdapter(this.lKeymanagerJpaVendorAdapter());
        entityManagerFactory.setJpaDialect(this.lKeymanagerJpaDialect());
        return entityManagerFactory;
    }

    @Bean
    public JpaVendorAdapter lKeymanagerJpaVendorAdapter() {
        HibernateJpaVendorAdapter vendorAdapter = new HibernateJpaVendorAdapter();
        vendorAdapter.setGenerateDdl(true);
        vendorAdapter.setShowSql(true);
        return vendorAdapter;
    }

    @Bean
    public JpaDialect lKeymanagerJpaDialect() {
        return new HibernateJpaDialect();
    }

    @Bean
    public PlatformTransactionManager lKeymanagerTransactionManager() {
        JpaTransactionManager jpaTransactionManager = new JpaTransactionManager();
        jpaTransactionManager.setEntityManagerFactory(this.lKeymanagerEntityManagerFactory().getObject());
        jpaTransactionManager.setDataSource(this.lKeymanagerDataSource());
        jpaTransactionManager.setJpaDialect(this.lKeymanagerJpaDialect());
        return jpaTransactionManager;
    }

    public Map<String, Object> jpaProperties() {
        HashMap<String, Object> jpaProperties = new HashMap<String, Object>();
        this.getProperty(jpaProperties, "hibernate.hbm2ddl.auto", "update");
        this.getProperty(jpaProperties, "hibernate.dialect", "org.hibernate.dialect.MySQL5Dialect");
        this.getProperty(jpaProperties, "hibernate.show_sql", "true");
        this.getProperty(jpaProperties, "hibernate.format_sql", "true");
        this.getProperty(jpaProperties, "hibernate.connection.charSet", "utf8");
        this.getProperty(jpaProperties, "hibernate.cache.use_second_level_cache", "false");
        this.getProperty(jpaProperties, "hibernate.cache.use_query_cache", "false");
        this.getProperty(jpaProperties, "hibernate.cache.use_structured_entries", "false");
        this.getProperty(jpaProperties, "hibernate.generate_statistics", "false");
        this.getProperty(jpaProperties, "hibernate.jdbc.lob.non_contextual_creation", "false");
        this.getProperty(jpaProperties, "hibernate.current_session_context_class", "jta");
        this.getProperty(jpaProperties, "hibernate.ejb.interceptor", "hibernate.empty.interceptor");
        return jpaProperties;
    }

    private HashMap<String, Object> getProperty(HashMap<String, Object> jpaProperties, String property, String defaultValue) {
        if (property.equals("hibernate.ejb.interceptor")) {
            try {
                if (this.environment.containsProperty(property)) {
                    jpaProperties.put(property, BeanUtils.instantiateClass(Class.forName(this.environment.getProperty(property))));
                }
            }
            catch (ClassNotFoundException | BeanInstantiationException e) {
                LOGGER.error("Error while configuring Interceptor.");
            }
        } else {
            jpaProperties.put(property, this.environment.containsProperty(property) ? this.environment.getProperty(property) : defaultValue);
        }
        return jpaProperties;
    }
}

