/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.keymanagerservice.util;

import io.mosip.kernel.core.crypto.spi.CryptoCoreSpec;
import io.mosip.kernel.core.keymanager.exception.KeystoreProcessingException;
import io.mosip.kernel.core.keymanager.model.CertificateEntry;
import io.mosip.kernel.core.util.CryptoUtil;
import io.mosip.kernel.keygenerator.bouncycastle.KeyGenerator;
import io.mosip.kernel.keymanager.softhsm.constant.KeymanagerErrorCode;
import io.mosip.kernel.keymanagerservice.entity.BaseEntity;
import io.mosip.kernel.keymanagerservice.entity.KeyAlias;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class KeymanagerUtil {
    private static final String UTC_DATETIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    @Value(value="${mosip.kernel.keygenerator.asymmetric-algorithm-name}")
    private String asymmetricAlgorithmName;
    @Value(value="${mosip.kernel.data-key-splitter}")
    private String keySplitter;
    @Autowired
    KeyGenerator keyGenerator;
    @Autowired
    private CryptoCoreSpec<byte[], byte[], SecretKey, PublicKey, PrivateKey, String> cryptoCore;
    @Value(value="${mosip.kernel.crypto.symmetric-algorithm-name}")
    private String symmetricAlgorithmName;

    public boolean isValidTimestamp(LocalDateTime timeStamp, KeyAlias keyAlias) {
        return timeStamp.isEqual(keyAlias.getKeyGenerationTime()) || timeStamp.isEqual(keyAlias.getKeyExpiryTime()) || timeStamp.isAfter(keyAlias.getKeyGenerationTime()) && timeStamp.isBefore(keyAlias.getKeyExpiryTime());
    }

    public boolean isOverlapping(LocalDateTime timeStamp, LocalDateTime policyExpiryTime, LocalDateTime keyGenerationTime, LocalDateTime keyExpiryTime) {
        return !timeStamp.isAfter(keyExpiryTime) && !keyGenerationTime.isAfter(policyExpiryTime);
    }

    public boolean isValidReferenceId(String referenceId) {
        return referenceId != null && !referenceId.trim().isEmpty();
    }

    public <T extends BaseEntity> T setMetaData(T entity) {
        String contextUser = "SYSTEM";
        LocalDateTime time = LocalDateTime.now(ZoneId.of("UTC"));
        entity.setCreatedBy(contextUser);
        entity.setCreatedtimes(time);
        entity.setIsDeleted(Boolean.valueOf(false));
        return entity;
    }

    public byte[] encryptKey(PrivateKey privateKey, PublicKey masterKey) {
        SecretKey symmetricKey = this.keyGenerator.getSymmetricKey();
        byte[] encryptedPrivateKey = (byte[])this.cryptoCore.symmetricEncrypt((Object)symmetricKey, (Object)privateKey.getEncoded(), null);
        byte[] encryptedSymmetricKey = (byte[])this.cryptoCore.asymmetricEncrypt((Object)masterKey, (Object)symmetricKey.getEncoded());
        return CryptoUtil.combineByteArray((byte[])encryptedPrivateKey, (byte[])encryptedSymmetricKey, (String)this.keySplitter);
    }

    public byte[] decryptKey(byte[] key, PrivateKey privateKey) {
        int keyDemiliterIndex = 0;
        int cipherKeyandDataLength = key.length;
        int keySplitterLength = this.keySplitter.length();
        keyDemiliterIndex = CryptoUtil.getSplitterIndex((byte[])key, (int)keyDemiliterIndex, (String)this.keySplitter);
        byte[] encryptedKey = Arrays.copyOfRange(key, 0, keyDemiliterIndex);
        byte[] encryptedData = Arrays.copyOfRange(key, keyDemiliterIndex + keySplitterLength, cipherKeyandDataLength);
        byte[] decryptedSymmetricKey = (byte[])this.cryptoCore.asymmetricDecrypt((Object)privateKey, (Object)encryptedKey);
        SecretKeySpec symmetricKey = new SecretKeySpec(decryptedSymmetricKey, 0, decryptedSymmetricKey.length, this.symmetricAlgorithmName);
        return (byte[])this.cryptoCore.symmetricDecrypt((Object)symmetricKey, (Object)encryptedData, null);
    }

    public LocalDateTime parseToLocalDateTime(String dateTime) {
        return LocalDateTime.parse(dateTime, DateTimeFormatter.ofPattern(UTC_DATETIME_PATTERN));
    }

    public void isCertificateValid(CertificateEntry<X509Certificate, PrivateKey> certificateEntry, Date inputDate) {
        try {
            ((X509Certificate[])certificateEntry.getChain())[0].checkValidity(inputDate);
        }
        catch (CertificateExpiredException | CertificateNotYetValidException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.CERTIFICATE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.CERTIFICATE_PROCESSING_ERROR.getErrorMessage() + e.getMessage());
        }
    }

    public PrivateKey privateKeyExtractor(InputStream privateKeyInputStream) {
        KeyFactory kf = null;
        PKCS8EncodedKeySpec keySpec = null;
        PrivateKey privateKey = null;
        try {
            StringWriter stringWriter = new StringWriter();
            IOUtils.copy((InputStream)privateKeyInputStream, (Writer)stringWriter, (Charset)StandardCharsets.UTF_8);
            String privateKeyPEMString = stringWriter.toString();
            byte[] decodedKey = Base64.decodeBase64((String)privateKeyPEMString);
            kf = KeyFactory.getInstance(this.asymmetricAlgorithmName);
            keySpec = new PKCS8EncodedKeySpec(decodedKey);
            privateKey = kf.generatePrivate(keySpec);
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + e.getMessage());
        }
        return privateKey;
    }
}

