/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.keymanagerservice.service.impl;

import io.mosip.kernel.core.crypto.exception.InvalidDataException;
import io.mosip.kernel.core.crypto.exception.InvalidKeyException;
import io.mosip.kernel.core.crypto.exception.NullDataException;
import io.mosip.kernel.core.crypto.exception.NullKeyException;
import io.mosip.kernel.core.crypto.exception.NullMethodException;
import io.mosip.kernel.core.crypto.spi.CryptoCoreSpec;
import io.mosip.kernel.core.keymanager.exception.KeystoreProcessingException;
import io.mosip.kernel.core.keymanager.model.CertificateEntry;
import io.mosip.kernel.core.keymanager.spi.KeyStore;
import io.mosip.kernel.core.logger.spi.Logger;
import io.mosip.kernel.core.pdfgenerator.model.Rectangle;
import io.mosip.kernel.core.pdfgenerator.spi.PDFGenerator;
import io.mosip.kernel.core.util.CryptoUtil;
import io.mosip.kernel.core.util.DateUtils;
import io.mosip.kernel.keygenerator.bouncycastle.KeyGenerator;
import io.mosip.kernel.keymanager.softhsm.constant.KeymanagerErrorCode;
import io.mosip.kernel.keymanagerservice.constant.KeymanagerErrorConstant;
import io.mosip.kernel.keymanagerservice.dto.PDFSignatureRequestDto;
import io.mosip.kernel.keymanagerservice.dto.PublicKeyResponse;
import io.mosip.kernel.keymanagerservice.dto.SignatureCertificate;
import io.mosip.kernel.keymanagerservice.dto.SignatureRequestDto;
import io.mosip.kernel.keymanagerservice.dto.SignatureResponseDto;
import io.mosip.kernel.keymanagerservice.dto.SymmetricKeyRequestDto;
import io.mosip.kernel.keymanagerservice.dto.SymmetricKeyResponseDto;
import io.mosip.kernel.keymanagerservice.entity.BaseEntity;
import io.mosip.kernel.keymanagerservice.entity.KeyAlias;
import io.mosip.kernel.keymanagerservice.entity.KeyPolicy;
import io.mosip.kernel.keymanagerservice.exception.CryptoException;
import io.mosip.kernel.keymanagerservice.exception.InvalidApplicationIdException;
import io.mosip.kernel.keymanagerservice.exception.KeyStoreException;
import io.mosip.kernel.keymanagerservice.exception.KeymanagerServiceException;
import io.mosip.kernel.keymanagerservice.exception.NoUniqueAliasException;
import io.mosip.kernel.keymanagerservice.logger.KeymanagerLogger;
import io.mosip.kernel.keymanagerservice.repository.KeyAliasRepository;
import io.mosip.kernel.keymanagerservice.repository.KeyPolicyRepository;
import io.mosip.kernel.keymanagerservice.repository.KeyStoreRepository;
import io.mosip.kernel.keymanagerservice.service.KeymanagerService;
import io.mosip.kernel.keymanagerservice.util.KeymanagerUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.crypto.SecretKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class KeymanagerServiceImpl
implements KeymanagerService {
    private static final String VALID_REFERENCE_ID_GETTING_KEY_ALIAS_WITH_REFERENCE_ID = "Valid reference Id. Getting key alias with referenceId";
    private static final String NOT_A_VALID_REFERENCE_ID_GETTING_KEY_ALIAS_WITHOUT_REFERENCE_ID = "Not a valid reference Id. Getting key alias without referenceId";
    private static final Logger LOGGER = KeymanagerLogger.getLogger(KeymanagerServiceImpl.class);
    private static final int MAX_TRIES = 3;
    @Value(value="${mosip.sign-certificate-refid:SIGN}")
    private String certificateSignRefID;
    @Value(value="${mosip.sign.applicationid:KERNEL}")
    private String signApplicationid;
    @Value(value="${mosip.security.provider.name:SunPKCS11-SoftHSM2}")
    private String providerName;
    @Autowired
    private ResourceLoader resourceLoader;
    @Autowired
    private KeyStore keyStore;
    @Autowired
    private KeyGenerator keyGenerator;
    @Autowired
    private CryptoCoreSpec<byte[], byte[], SecretKey, PublicKey, PrivateKey, String> cryptoCore;
    @Autowired
    KeyAliasRepository keyAliasRepository;
    @Autowired
    KeyPolicyRepository keyPolicyRepository;
    @Autowired
    KeyStoreRepository keyStoreRepository;
    @Autowired
    KeymanagerUtil keymanagerUtil;
    @Autowired
    private PDFGenerator pdfGenerator;
    @Value(value="${mosip.kernel.keymanager.certificate-file-path}")
    private String certificateFilePath;
    @Value(value="${mosip.kernel.keymanager.privatekey-file-path}")
    private String privateKeyFilePath;
    @Value(value="${mosip.kernel.keymanager.certificate-type}")
    private String certificateType;

    public PublicKeyResponse<String> getPublicKey(String applicationId, String timeStamp, Optional<String> referenceId) {
        LOGGER.info("sessionId", "applicationId", applicationId, "Request received to getPublicKey");
        LOGGER.info("sessionId", "timestamp", timeStamp.toString(), "Request received to getPublicKey");
        LOGGER.info("sessionId", "referenceId", referenceId.toString(), "Request received to getPublicKey");
        LocalDateTime localDateTimeStamp = this.keymanagerUtil.parseToLocalDateTime(timeStamp);
        PublicKeyResponse publicKeyResponse = new PublicKeyResponse();
        if (!referenceId.isPresent() || referenceId.get().trim().isEmpty()) {
            LOGGER.info("sessionId", "", "", "Reference Id is not present. Will get public key from SoftHSM");
            PublicKeyResponse hsmPublicKey = this.getPublicKeyFromHSM(applicationId, localDateTimeStamp);
            publicKeyResponse.setPublicKey((Object)CryptoUtil.encodeBase64((byte[])((PublicKey)hsmPublicKey.getPublicKey()).getEncoded()));
            publicKeyResponse.setIssuedAt(hsmPublicKey.getIssuedAt());
            publicKeyResponse.setExpiryAt(hsmPublicKey.getExpiryAt());
        } else {
            LOGGER.info("sessionId", "", "", "Reference Id is present. Will get public key from DB store");
            PublicKeyResponse dbPublicKey = this.getPublicKeyFromDBStore(applicationId, localDateTimeStamp, referenceId.get());
            publicKeyResponse.setPublicKey((Object)CryptoUtil.encodeBase64((byte[])((byte[])dbPublicKey.getPublicKey())));
            publicKeyResponse.setIssuedAt(dbPublicKey.getIssuedAt());
            publicKeyResponse.setExpiryAt(dbPublicKey.getExpiryAt());
        }
        return publicKeyResponse;
    }

    private PublicKeyResponse<PublicKey> getPublicKeyFromHSM(String applicationId, LocalDateTime timeStamp) {
        LOGGER.info("sessionId", "applicationId", applicationId, "Getting public key from SoftHSM");
        LOGGER.info("sessionId", "timestamp", timeStamp.toString(), "Getting public key from SoftHSM");
        String alias = null;
        LocalDateTime generationDateTime = null;
        LocalDateTime expiryDateTime = null;
        Map keyAliasMap = this.getKeyAliases(applicationId, null, timeStamp);
        List currentKeyAlias = (List)keyAliasMap.get("currentKeyAlias");
        if (currentKeyAlias.size() > 1) {
            LOGGER.info("sessionId", "currentKeyAlias", String.valueOf(currentKeyAlias.size()), "CurrentKeyAlias size more than one Throwing exception");
            throw new NoUniqueAliasException(KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorCode(), KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorMessage());
        }
        if (currentKeyAlias.size() == 1) {
            LOGGER.info("sessionId", "currentKeyAlias", ((KeyAlias)currentKeyAlias.get(0)).getAlias(), "CurrentKeyAlias size is one fetching keypair using this alias");
            KeyAlias fetchedKeyAlias = (KeyAlias)currentKeyAlias.get(0);
            alias = fetchedKeyAlias.getAlias();
            generationDateTime = fetchedKeyAlias.getKeyGenerationTime();
            expiryDateTime = fetchedKeyAlias.getKeyExpiryTime();
        } else if (currentKeyAlias.isEmpty()) {
            LOGGER.info("sessionId", "currentKeyAlias", String.valueOf(currentKeyAlias.size()), "CurrentKeyAlias size is zero. Will create new Keypair for this applicationId and timestamp");
            alias = UUID.randomUUID().toString();
            generationDateTime = timeStamp;
            expiryDateTime = this.getExpiryPolicy(applicationId, generationDateTime, (List)keyAliasMap.get("keyAlias"));
            this.keyStore.storeAsymmetricKey(this.keyGenerator.getAsymmetricKey(), alias, generationDateTime, expiryDateTime);
            this.storeKeyInAlias(applicationId, generationDateTime, null, alias, expiryDateTime);
        }
        return new PublicKeyResponse(alias, (Object)this.keyStore.getPublicKey(alias), generationDateTime, expiryDateTime);
    }

    private PublicKeyResponse<byte[]> getPublicKeyFromDBStore(String applicationId, LocalDateTime timeStamp, String referenceId) {
        LOGGER.info("sessionId", "applicationId", applicationId, "Getting public key from DB Store");
        LOGGER.info("sessionId", "timestamp", timeStamp.toString(), "Getting public key from DB Store");
        LOGGER.info("sessionId", "referenceId", referenceId, "Getting public key from DB Store");
        String alias = null;
        byte[] publicKey = null;
        LocalDateTime generationDateTime = null;
        LocalDateTime expiryDateTime = null;
        Map keyAliasMap = this.getKeyAliases(applicationId, referenceId, timeStamp);
        List currentKeyAlias = (List)keyAliasMap.get("currentKeyAlias");
        if (currentKeyAlias.size() > 1) {
            LOGGER.info("sessionId", "currentKeyAlias", String.valueOf(currentKeyAlias.size()), "CurrentKeyAlias size more than one. Throwing exception");
            throw new NoUniqueAliasException(KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorCode(), KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorMessage());
        }
        if (currentKeyAlias.size() == 1) {
            LOGGER.info("sessionId", "currentKeyAlias", ((KeyAlias)currentKeyAlias.get(0)).getAlias(), "CurrentKeyAlias size is one. Will fetch keypair using this alias");
            Optional keyFromDBStore = this.keyStoreRepository.findByAlias(((KeyAlias)currentKeyAlias.get(0)).getAlias());
            if (!keyFromDBStore.isPresent()) {
                LOGGER.info("sessionId", "keyFromDBStore", keyFromDBStore.toString(), "Key in DBStore does not exist for this alias. Throwing exception");
                throw new NoUniqueAliasException(KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorCode(), KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorMessage());
            }
            LOGGER.info("sessionId", "keyFromDBStore", ((KeyAlias)currentKeyAlias.get(0)).getAlias(), "Key in DBStore exists for this alias. Fetching public key");
            KeyAlias fetchedKeyAlias = (KeyAlias)currentKeyAlias.get(0);
            publicKey = ((io.mosip.kernel.keymanagerservice.entity.KeyStore)keyFromDBStore.get()).getPublicKey();
            generationDateTime = fetchedKeyAlias.getKeyGenerationTime();
            expiryDateTime = fetchedKeyAlias.getKeyExpiryTime();
        } else if (currentKeyAlias.isEmpty()) {
            byte[] encryptedPrivateKey;
            LOGGER.info("sessionId", "currentKeyAlias", String.valueOf(currentKeyAlias.size()), "CurrentKeyAlias size is zero. Will create new Keypair for this applicationId, referenceId and timestamp");
            alias = UUID.randomUUID().toString();
            KeyPair keypair = this.keyGenerator.getAsymmetricKey();
            PublicKeyResponse hsmPublicKey = this.getPublicKeyFromHSM(applicationId, timeStamp);
            PublicKey masterPublicKey = (PublicKey)hsmPublicKey.getPublicKey();
            String masterAlias = hsmPublicKey.getAlias();
            publicKey = keypair.getPublic().getEncoded();
            generationDateTime = timeStamp;
            expiryDateTime = this.getExpiryPolicy(applicationId, generationDateTime, (List)keyAliasMap.get("keyAlias"));
            try {
                encryptedPrivateKey = this.keymanagerUtil.encryptKey(keypair.getPrivate(), masterPublicKey);
            }
            catch (InvalidDataException | InvalidKeyException | NullDataException | NullKeyException | NullMethodException e) {
                throw new CryptoException(KeymanagerErrorConstant.CRYPTO_EXCEPTION.getErrorCode(), KeymanagerErrorConstant.CRYPTO_EXCEPTION.getErrorMessage() + e.getErrorText());
            }
            this.storeKeyInDBStore(alias, masterAlias, keypair.getPublic().getEncoded(), encryptedPrivateKey);
            this.storeKeyInAlias(applicationId, generationDateTime, referenceId, alias, expiryDateTime);
        }
        return new PublicKeyResponse(alias, publicKey, generationDateTime, expiryDateTime);
    }

    private Map<String, List<KeyAlias>> getKeyAliases(String applicationId, String referenceId, LocalDateTime timeStamp) {
        LOGGER.info("sessionId", "", "", "Getting key alias");
        HashMap<String, List<KeyAlias>> hashmap = new HashMap<String, List<KeyAlias>>();
        List keyAliases = this.keyAliasRepository.findByApplicationIdAndReferenceId(applicationId, referenceId).stream().sorted((alias1, alias2) -> alias1.getKeyGenerationTime().compareTo(alias2.getKeyGenerationTime())).collect(Collectors.toList());
        List currentKeyAliases = keyAliases.stream().filter(keyAlias -> this.keymanagerUtil.isValidTimestamp(timeStamp, keyAlias)).collect(Collectors.toList());
        LOGGER.info("sessionId", "keyAlias", Arrays.toString(keyAliases.toArray()), "keyAlias");
        LOGGER.info("sessionId", "currentKeyAlias", Arrays.toString(currentKeyAliases.toArray()), "currentKeyAlias");
        hashmap.put("keyAlias", keyAliases);
        hashmap.put("currentKeyAlias", currentKeyAliases);
        return hashmap;
    }

    private LocalDateTime getExpiryPolicy(String applicationId, LocalDateTime timeStamp, List<KeyAlias> keyAlias) {
        LOGGER.info("sessionId", "applicationId", applicationId, "Getting expiry policy");
        Optional keyPolicy = this.keyPolicyRepository.findByApplicationId(applicationId);
        if (!keyPolicy.isPresent()) {
            LOGGER.info("sessionId", "keyPolicy", keyPolicy.toString(), "Key Policy not found for this application Id. Throwing exception");
            throw new InvalidApplicationIdException(KeymanagerErrorConstant.APPLICATIONID_NOT_VALID.getErrorCode(), KeymanagerErrorConstant.APPLICATIONID_NOT_VALID.getErrorMessage());
        }
        LocalDateTime policyExpiryTime = timeStamp.plusDays(((KeyPolicy)keyPolicy.get()).getValidityInDays());
        if (!keyAlias.isEmpty()) {
            LOGGER.info("sessionId", "keyAlias", String.valueOf(keyAlias.size()), "Getting expiry policy. KeyAlias exists");
            for (KeyAlias alias : keyAlias) {
                if (!this.keymanagerUtil.isOverlapping(timeStamp, policyExpiryTime, alias.getKeyGenerationTime(), alias.getKeyExpiryTime())) continue;
                LOGGER.info("sessionId", "", "", "Overlapping timestamp found. Changing policyExpiryTime");
                policyExpiryTime = alias.getKeyGenerationTime().minusSeconds(1L);
                break;
            }
        }
        return policyExpiryTime;
    }

    public SymmetricKeyResponseDto decryptSymmetricKey(SymmetricKeyRequestDto symmetricKeyRequestDto) {
        LOGGER.info("sessionId", "symmetricKeyRequestDto", symmetricKeyRequestDto.toString(), "Request received to decryptSymmetricKey");
        SymmetricKeyResponseDto keyResponseDto = new SymmetricKeyResponseDto();
        PrivateKey privateKey = this.getPrivateKeyFromRequestData(symmetricKeyRequestDto.getApplicationId(), symmetricKeyRequestDto.getReferenceId(), symmetricKeyRequestDto.getTimeStamp());
        byte[] decryptedSymmetricKey = (byte[])this.cryptoCore.asymmetricDecrypt((Object)privateKey, (Object)CryptoUtil.decodeBase64((String)symmetricKeyRequestDto.getEncryptedSymmetricKey()));
        keyResponseDto.setSymmetricKey(CryptoUtil.encodeBase64((byte[])decryptedSymmetricKey));
        return keyResponseDto;
    }

    private PrivateKey getPrivateKey(String referenceId, KeyAlias fetchedKeyAlias) {
        LOGGER.info("sessionId", "referenceId", referenceId, "Getting private key");
        LOGGER.info("sessionId", "fetchedKeyAlias", fetchedKeyAlias.getAlias(), "Getting private key");
        if (!this.keymanagerUtil.isValidReferenceId(referenceId)) {
            LOGGER.info("sessionId", "", "", "Not valid reference Id. Getting private key from Keystore");
            return this.keyStore.getPrivateKey(fetchedKeyAlias.getAlias());
        }
        LOGGER.info("sessionId", "", "", "Valid reference Id. Getting private key from DB Store");
        Optional dbKeyStore = this.keyStoreRepository.findByAlias(fetchedKeyAlias.getAlias());
        if (!dbKeyStore.isPresent()) {
            LOGGER.info("sessionId", "dbKeyStore", dbKeyStore.toString(), "Key in DB Store does not exists. Throwing exception");
            throw new NoUniqueAliasException(KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorCode(), KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorMessage());
        }
        PrivateKey masterPrivateKey = this.keyStore.getPrivateKey(((io.mosip.kernel.keymanagerservice.entity.KeyStore)dbKeyStore.get()).getMasterAlias());
        try {
            byte[] decryptedPrivateKey = this.keymanagerUtil.decryptKey(((io.mosip.kernel.keymanagerservice.entity.KeyStore)dbKeyStore.get()).getPrivateKey(), masterPrivateKey);
            return KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(decryptedPrivateKey));
        }
        catch (InvalidDataException | InvalidKeyException | NullDataException | NullKeyException | NullMethodException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new CryptoException(KeymanagerErrorConstant.CRYPTO_EXCEPTION.getErrorCode(), KeymanagerErrorConstant.CRYPTO_EXCEPTION.getErrorMessage() + e.getMessage());
        }
    }

    private void storeKeyInAlias(String applicationId, LocalDateTime timeStamp, String referenceId, String alias, LocalDateTime expiryDateTime) {
        LOGGER.info("sessionId", "", "", "Storing key in KeyAlias");
        KeyAlias keyAlias = new KeyAlias();
        keyAlias.setAlias(alias);
        keyAlias.setApplicationId(applicationId);
        keyAlias.setReferenceId(referenceId);
        keyAlias.setKeyGenerationTime(timeStamp);
        keyAlias.setKeyExpiryTime(expiryDateTime);
        this.keyAliasRepository.saveAndFlush((Object)this.keymanagerUtil.setMetaData((BaseEntity)keyAlias));
    }

    private void storeKeyInDBStore(String alias, String masterAlias, byte[] publicKey, byte[] encryptedPrivateKey) {
        io.mosip.kernel.keymanagerservice.entity.KeyStore dbKeyStore = new io.mosip.kernel.keymanagerservice.entity.KeyStore();
        LOGGER.info("sessionId", "", "", "Storing key in dbKeyStore");
        dbKeyStore.setAlias(alias);
        dbKeyStore.setMasterAlias(masterAlias);
        dbKeyStore.setPublicKey(publicKey);
        dbKeyStore.setPrivateKey(encryptedPrivateKey);
        this.keyStoreRepository.saveAndFlush((Object)this.keymanagerUtil.setMetaData((BaseEntity)dbKeyStore));
    }

    private PrivateKey getPrivateKeyFromRequestData(String applicationId, String referenceId, LocalDateTime timeStamp) {
        List currentKeyAlias;
        PrivateKey privateKey = null;
        if (!this.keymanagerUtil.isValidReferenceId(referenceId)) {
            LOGGER.info("sessionId", "", "", NOT_A_VALID_REFERENCE_ID_GETTING_KEY_ALIAS_WITHOUT_REFERENCE_ID);
            currentKeyAlias = (List)this.getKeyAliases(applicationId, null, timeStamp).get("currentKeyAlias");
        } else {
            LOGGER.info("sessionId", "", "", VALID_REFERENCE_ID_GETTING_KEY_ALIAS_WITH_REFERENCE_ID);
            currentKeyAlias = (List)this.getKeyAliases(applicationId, referenceId, timeStamp).get("currentKeyAlias");
        }
        if (currentKeyAlias.isEmpty() || currentKeyAlias.size() > 1) {
            LOGGER.info("sessionId", "currentKeyAlias", String.valueOf(currentKeyAlias.size()), "CurrentKeyAlias is not unique. Throwing exception");
            throw new NoUniqueAliasException(KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorCode(), KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorMessage());
        }
        if (currentKeyAlias.size() == 1) {
            LOGGER.info("sessionId", "currentKeyAlias", ((KeyAlias)currentKeyAlias.get(0)).getAlias(), "CurrentKeyAlias size is one. Will decrypt symmetric key for this alias");
            KeyAlias fetchedKeyAlias = (KeyAlias)currentKeyAlias.get(0);
            privateKey = this.getPrivateKey(referenceId, fetchedKeyAlias);
        }
        return privateKey;
    }

    private CertificateEntry<X509Certificate, PrivateKey> createCertificateEntry() {
        CertificateFactory cf = null;
        X509Certificate cert = null;
        PrivateKey privateKey = null;
        try {
            cf = CertificateFactory.getInstance(this.certificateType);
            cert = (X509Certificate)cf.generateCertificate(this.resourceLoader.getResource(this.certificateFilePath).getInputStream());
            privateKey = this.keymanagerUtil.privateKeyExtractor(this.resourceLoader.getResource(this.privateKeyFilePath).getInputStream());
        }
        catch (IOException | CertificateException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.CERTIFICATE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.CERTIFICATE_PROCESSING_ERROR.getErrorMessage() + e.getMessage());
        }
        Object[] certificates = new X509Certificate[]{cert};
        return new CertificateEntry(certificates, (Object)privateKey);
    }

    public SignatureResponseDto sign(SignatureRequestDto signatureRequestDto) {
        SignatureCertificate certificateResponse = this.getSigningCertificate(signatureRequestDto.getApplicationId(), Optional.of(signatureRequestDto.getReferenceId()), signatureRequestDto.getTimeStamp());
        this.keymanagerUtil.isCertificateValid(certificateResponse.getCertificateEntry(), DateUtils.parseUTCToDate((String)signatureRequestDto.getTimeStamp()));
        String encryptedSignedData = null;
        if (certificateResponse.getCertificateEntry() != null) {
            encryptedSignedData = (String)this.cryptoCore.sign((Object)signatureRequestDto.getData().getBytes(), certificateResponse.getCertificateEntry().getPrivateKey());
        }
        return new SignatureResponseDto(encryptedSignedData);
    }

    @PostConstruct
    private void loadCertificateIfNotExist() {
        LocalDateTime timestamp = DateUtils.getUTCCurrentDateTime();
        List currentKeyAlias = null;
        Map keyAliasMap = null;
        if (!this.keymanagerUtil.isValidReferenceId(this.certificateSignRefID)) {
            LOGGER.info("sessionId", "", "", NOT_A_VALID_REFERENCE_ID_GETTING_KEY_ALIAS_WITHOUT_REFERENCE_ID);
            keyAliasMap = this.getKeyAliases(this.signApplicationid, null, timestamp);
        } else {
            LOGGER.info("sessionId", "", "", VALID_REFERENCE_ID_GETTING_KEY_ALIAS_WITH_REFERENCE_ID);
            keyAliasMap = this.getKeyAliases(this.signApplicationid, this.certificateSignRefID, timestamp);
        }
        currentKeyAlias = (List)keyAliasMap.get("currentKeyAlias");
        if (currentKeyAlias.size() > 1) {
            LOGGER.error("sessionId", "currentKeyAlias", String.valueOf(currentKeyAlias.size()), "CurrentKeyAlias size more than one");
        } else if (currentKeyAlias.isEmpty()) {
            LOGGER.info("sessionId", "currentKeyAlias", String.valueOf(currentKeyAlias.size()), "CurrentKeyAlias size is zero. Will create new Keypair for this applicationId and timestamp");
            this.storeCertificate(timestamp, keyAliasMap);
        } else if (currentKeyAlias.size() == 1) {
            LOGGER.info("sessionId", "currentKeyAlias", String.valueOf(currentKeyAlias.size()), "Signature key details present in DB" + currentKeyAlias.get(0));
        }
    }

    private void storeCertificate(LocalDateTime timestamp, Map<String, List<KeyAlias>> keyAliasMap) {
        String alias = "NA";
        CertificateEntry certificateEntry = this.createCertificateEntry();
        LocalDateTime generationDateTime = DateUtils.parseToLocalDateTime((String)DateUtils.getUTCTimeFromDate((Date)((X509Certificate[])certificateEntry.getChain())[0].getNotBefore()));
        LocalDateTime expiryDateTime = this.getCertficateExpiryPolicy(this.signApplicationid, timestamp, keyAliasMap.get("keyAlias"), certificateEntry);
        int tries = 0;
        while (tries < 3) {
            try {
                alias = UUID.randomUUID().toString();
                this.keyStore.storeCertificate(alias, (Certificate[])certificateEntry.getChain(), (PrivateKey)certificateEntry.getPrivateKey());
                Thread.sleep(1000L);
                if (this.keyStore.getPrivateKey(alias) != null) {
                    System.out.println("\n Signature key details storing in DB - " + alias + "\n");
                    break;
                }
                this.logStoreSignCertificateError(++tries);
            }
            catch (Exception exception) {
                this.logStoreSignCertificateError(++tries);
                throw new KeyStoreException(KeymanagerErrorConstant.KEY_STORE_EXCEPTION.getErrorCode(), KeymanagerErrorConstant.KEY_STORE_EXCEPTION.getErrorMessage());
            }
        }
        if (!this.keymanagerUtil.isValidReferenceId(this.certificateSignRefID)) {
            this.storeKeyInAlias(this.signApplicationid, generationDateTime, null, alias, expiryDateTime);
        } else {
            this.storeKeyInAlias(this.signApplicationid, generationDateTime, this.certificateSignRefID, alias, expiryDateTime);
        }
    }

    private void logStoreSignCertificateError(int tries) {
        if (tries < 3) {
            System.out.println("\n Signature Key not found in keystore. Trying again =" + tries + "\n");
        } else {
            System.out.println("\n Signature Key not found in keystore. Try limit reached =" + tries + "\n");
        }
    }

    private LocalDateTime getCertficateExpiryPolicy(String applicationId, LocalDateTime timeStamp, List<KeyAlias> keyAlias, CertificateEntry<X509Certificate, PrivateKey> certificateEntry) {
        LOGGER.info("sessionId", "applicationId", applicationId, "Getting expiry policy");
        LocalDateTime policyExpiryTime = DateUtils.parseToLocalDateTime((String)DateUtils.getUTCTimeFromDate((Date)((X509Certificate[])certificateEntry.getChain())[0].getNotAfter()));
        if (!keyAlias.isEmpty()) {
            LOGGER.info("sessionId", "keyAlias", String.valueOf(keyAlias.size()), "Getting expiry policy. KeyAlias exists");
            for (KeyAlias alias : keyAlias) {
                if (!this.keymanagerUtil.isOverlapping(timeStamp, policyExpiryTime, alias.getKeyGenerationTime(), alias.getKeyExpiryTime())) continue;
                LOGGER.info("sessionId", "", "", "Overlapping timestamp found. Changing policyExpiryTime");
                policyExpiryTime = alias.getKeyGenerationTime().minusSeconds(1L);
                break;
            }
        }
        return policyExpiryTime;
    }

    private SignatureCertificate getSigningCertificate(String applicationId, Optional<String> referenceId, String timestamp) {
        String alias = null;
        List currentKeyAlias = null;
        Map keyAliasMap = null;
        LocalDateTime generationDateTime = null;
        LocalDateTime expiryDateTime = null;
        CertificateEntry certificateEntry = null;
        LocalDateTime localDateTimeStamp = this.keymanagerUtil.parseToLocalDateTime(timestamp);
        if (!referenceId.isPresent() || referenceId.get().trim().isEmpty()) {
            LOGGER.info("sessionId", "", "", NOT_A_VALID_REFERENCE_ID_GETTING_KEY_ALIAS_WITHOUT_REFERENCE_ID);
            keyAliasMap = this.getKeyAliases(applicationId, null, localDateTimeStamp);
        } else {
            LOGGER.info("sessionId", "", "", VALID_REFERENCE_ID_GETTING_KEY_ALIAS_WITH_REFERENCE_ID);
            keyAliasMap = this.getKeyAliases(applicationId, referenceId.get(), localDateTimeStamp);
        }
        currentKeyAlias = (List)keyAliasMap.get("currentKeyAlias");
        if (currentKeyAlias.size() > 1) {
            LOGGER.info("sessionId", "currentKeyAlias", String.valueOf(currentKeyAlias.size()), "CurrentKeyAlias size more than one. Throwing exception");
            throw new NoUniqueAliasException(KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorCode(), KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorMessage());
        }
        if (currentKeyAlias.size() == 1) {
            LOGGER.info("sessionId", "currentKeyAlias", ((KeyAlias)currentKeyAlias.get(0)).getAlias(), "CurrentKeyAlias size is one. Will fetch keypair using this alias");
            KeyAlias fetchedKeyAlias = (KeyAlias)currentKeyAlias.get(0);
            alias = fetchedKeyAlias.getAlias();
            KeyStore.PrivateKeyEntry privateKeyEntry = this.keyStore.getAsymmetricKey(alias);
            certificateEntry = new CertificateEntry((Object[])((X509Certificate[])privateKeyEntry.getCertificateChain()), (Object)privateKeyEntry.getPrivateKey());
            generationDateTime = fetchedKeyAlias.getKeyGenerationTime();
            expiryDateTime = fetchedKeyAlias.getKeyExpiryTime();
        } else if (currentKeyAlias.isEmpty()) {
            throw new NoUniqueAliasException(KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorCode(), KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorMessage());
        }
        return new SignatureCertificate(alias, certificateEntry, generationDateTime, expiryDateTime);
    }

    public PublicKeyResponse<String> getSignPublicKey(String applicationId, String timestamp, Optional<String> referenceId) {
        SignatureCertificate certificateResponse = this.getSigningCertificate(applicationId, referenceId, timestamp);
        return new PublicKeyResponse(certificateResponse.getAlias(), (Object)CryptoUtil.encodeBase64((byte[])((X509Certificate[])certificateResponse.getCertificateEntry().getChain())[0].getPublicKey().getEncoded()), certificateResponse.getIssuedAt(), certificateResponse.getExpiryAt());
    }

    public SignatureResponseDto signPDF(PDFSignatureRequestDto request) {
        OutputStream outputStream;
        SignatureCertificate signatureCertificate = this.getSigningCertificate(request.getApplicationId(), Optional.of(request.getReferenceId()), request.getTimeStamp());
        LOGGER.debug("sessionId", "sessionId", "sessionId", "Signature fetched from hsm " + signatureCertificate);
        Rectangle rectangle = new Rectangle((float)request.getLowerLeftX(), (float)request.getLowerLeftY(), (float)request.getUpperRightX(), (float)request.getUpperRightY());
        try {
            LOGGER.info("sessionId", "sessionId", "sessionId", " mosip.security.provider.name property value" + this.providerName);
            Arrays.stream(Security.getProviders()).forEach(x -> {
                LOGGER.info("sessionId", "sessionId", "sessionId", "provider name " + x.getName());
                LOGGER.info("sessionId", "sessionId", "sessionId", "provider info " + x.getInfo());
            });
            LOGGER.info("sessionId", "sessionId", "sessionId", "all providers ");
            outputStream = this.pdfGenerator.signAndEncryptPDF(CryptoUtil.decodeBase64((String)request.getData()), rectangle, request.getReason(), request.getPageNumber(), Security.getProvider(this.providerName), signatureCertificate.getCertificateEntry(), request.getPassword());
        }
        catch (IOException | GeneralSecurityException e) {
            throw new KeymanagerServiceException(KeymanagerErrorConstant.INTERNAL_SERVER_ERROR.getErrorCode(), KeymanagerErrorConstant.INTERNAL_SERVER_ERROR.getErrorMessage() + " " + e.getMessage());
        }
        SignatureResponseDto signatureResponseDto = new SignatureResponseDto();
        signatureResponseDto.setData(CryptoUtil.encodeBase64((byte[])((ByteArrayOutputStream)outputStream).toByteArray()));
        return signatureResponseDto;
    }
}

