/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.keymanagerservice.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.mosip.kernel.core.keymanager.model.CertificateEntry;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.beans.ConstructorProperties;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import lombok.Generated;

@ApiModel(description="Class representing a Signature Response")
public class SignatureCertificate {
    @JsonIgnore
    private String alias;
    @ApiModelProperty(notes="Public key in BASE64 encoding format", required=true)
    private CertificateEntry<X509Certificate, PrivateKey> certificateEntry;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    @ApiModelProperty(notes="Timestamp of issuance of public key", required=true)
    private LocalDateTime issuedAt;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    @ApiModelProperty(notes="Timestamp of expiry of public key", required=true)
    private LocalDateTime expiryAt;

    public String toString() {
        return "SignatureCertificate [alias=" + this.alias + ", certificateEntry=" + this.certificateEntry + ", issuedAt=" + this.issuedAt + ", expiryAt=" + this.expiryAt + "]";
    }

    @Generated
    public String getAlias() {
        return this.alias;
    }

    @Generated
    public CertificateEntry<X509Certificate, PrivateKey> getCertificateEntry() {
        return this.certificateEntry;
    }

    @Generated
    public LocalDateTime getIssuedAt() {
        return this.issuedAt;
    }

    @Generated
    public LocalDateTime getExpiryAt() {
        return this.expiryAt;
    }

    @Generated
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Generated
    public void setCertificateEntry(CertificateEntry<X509Certificate, PrivateKey> certificateEntry) {
        this.certificateEntry = certificateEntry;
    }

    @Generated
    public void setIssuedAt(LocalDateTime issuedAt) {
        this.issuedAt = issuedAt;
    }

    @Generated
    public void setExpiryAt(LocalDateTime expiryAt) {
        this.expiryAt = expiryAt;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SignatureCertificate)) {
            return false;
        }
        SignatureCertificate other = (SignatureCertificate)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        CertificateEntry this$certificateEntry = this.getCertificateEntry();
        CertificateEntry other$certificateEntry = other.getCertificateEntry();
        if (this$certificateEntry == null ? other$certificateEntry != null : !this$certificateEntry.equals(other$certificateEntry)) {
            return false;
        }
        LocalDateTime this$issuedAt = this.getIssuedAt();
        LocalDateTime other$issuedAt = other.getIssuedAt();
        if (this$issuedAt == null ? other$issuedAt != null : !((Object)this$issuedAt).equals(other$issuedAt)) {
            return false;
        }
        LocalDateTime this$expiryAt = this.getExpiryAt();
        LocalDateTime other$expiryAt = other.getExpiryAt();
        return !(this$expiryAt == null ? other$expiryAt != null : !((Object)this$expiryAt).equals(other$expiryAt));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SignatureCertificate;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        CertificateEntry $certificateEntry = this.getCertificateEntry();
        result = result * 59 + ($certificateEntry == null ? 43 : $certificateEntry.hashCode());
        LocalDateTime $issuedAt = this.getIssuedAt();
        result = result * 59 + ($issuedAt == null ? 43 : ((Object)$issuedAt).hashCode());
        LocalDateTime $expiryAt = this.getExpiryAt();
        result = result * 59 + ($expiryAt == null ? 43 : ((Object)$expiryAt).hashCode());
        return result;
    }

    @ConstructorProperties(value={"alias", "certificateEntry", "issuedAt", "expiryAt"})
    @Generated
    public SignatureCertificate(String alias, CertificateEntry<X509Certificate, PrivateKey> certificateEntry, LocalDateTime issuedAt, LocalDateTime expiryAt) {
        this.alias = alias;
        this.certificateEntry = certificateEntry;
        this.issuedAt = issuedAt;
        this.expiryAt = expiryAt;
    }

    @Generated
    public SignatureCertificate() {
    }
}

